/*
 * Decompiled with CFR 0.152.
 */
package io.aleph0.yap.core.build;

import io.aleph0.yap.core.build.ConsumerTaskBuilder;
import io.aleph0.yap.core.build.QueueBuilder;
import io.aleph0.yap.core.build.TaskBuilder;
import io.aleph0.yap.core.build.TopicBuilder;
import io.aleph0.yap.core.task.DefaultProcessorTaskController;
import io.aleph0.yap.core.task.TaskController;
import io.aleph0.yap.core.transport.queue.DefaultQueue;
import io.aleph0.yap.core.transport.topic.DefaultTopic;
import io.aleph0.yap.core.worker.ProcessorWorkerFactory;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public final class ProcessorTaskBuilder<InputT, OutputT, MetricsT>
implements TaskBuilder {
    final String id;
    final ProcessorWorkerFactory<InputT, OutputT, MetricsT> workerFactory;
    final Set<String> subscribers = new LinkedHashSet<String>();
    TopicBuilder<OutputT> topic = DefaultTopic.builder();
    QueueBuilder<InputT> queue = DefaultQueue.builder();
    TaskController.ProcessorTaskControllerBuilder<InputT, OutputT> controller = DefaultProcessorTaskController.builder();

    ProcessorTaskBuilder(String id, ProcessorWorkerFactory<InputT, OutputT, MetricsT> bodyFactory) {
        this.id = Objects.requireNonNull(id);
        this.workerFactory = Objects.requireNonNull(bodyFactory);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public ProcessorTaskBuilder<InputT, OutputT, MetricsT> setTopic(TopicBuilder<OutputT> topic) {
        this.topic = Objects.requireNonNull(topic);
        return this;
    }

    public ProcessorTaskBuilder<InputT, OutputT, MetricsT> setQueue(QueueBuilder<InputT> queue) {
        this.queue = Objects.requireNonNull(queue);
        return this;
    }

    public <NextT> ProcessorTaskBuilder<InputT, OutputT, MetricsT> addSubscriber(ProcessorTaskBuilder<OutputT, NextT, ?> subscriber) {
        this.subscribers.add(subscriber.getId());
        return this;
    }

    public ProcessorTaskBuilder<InputT, OutputT, MetricsT> addSubscriber(ConsumerTaskBuilder<OutputT, ?> subscriber) {
        this.subscribers.add(subscriber.getId());
        return this;
    }
}

