/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.structured;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.HasTyperefInfo;
import com.linkedin.data.template.TyperefInfo;
import com.linkedin.data.template.UnionTemplate;
import java.util.List;

public class PrimitivePropertyValue
extends UnionTemplate
implements HasTyperefInfo {
    private static final UnionDataSchema SCHEMA = (UnionDataSchema)DataTemplateUtil.parseSchema("union[string,double]", SchemaFormatType.PDL);
    private String _stringMember = null;
    private Double _doubleMember = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final DataSchema MEMBER_String = SCHEMA.getTypeByMemberKey("string");
    public static final String MEMBERKEY_String = "string";
    private static final DataSchema MEMBER_Double = SCHEMA.getTypeByMemberKey("double");
    public static final String MEMBERKEY_Double = "double";
    private static final TyperefInfo TYPEREFINFO = new UnionTyperefInfo();

    public PrimitivePropertyValue() {
        super(new DataMap(2, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public PrimitivePropertyValue(Object data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static UnionDataSchema dataSchema() {
        return SCHEMA;
    }

    public static PrimitivePropertyValue create(String value) {
        PrimitivePropertyValue newUnion = new PrimitivePropertyValue();
        newUnion.setString(value);
        return newUnion;
    }

    public boolean isString() {
        return this.memberIs(MEMBERKEY_String);
    }

    public String getString() {
        this.checkNotNull();
        if (this._stringMember != null) {
            return this._stringMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_String);
        this._stringMember = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._stringMember;
    }

    public void setString(String value) {
        this.checkNotNull();
        this._map.clear();
        this._stringMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_String, value);
    }

    public static PrimitivePropertyValue create(Double value) {
        PrimitivePropertyValue newUnion = new PrimitivePropertyValue();
        newUnion.setDouble(value);
        return newUnion;
    }

    public boolean isDouble() {
        return this.memberIs(MEMBERKEY_Double);
    }

    public Double getDouble() {
        this.checkNotNull();
        if (this._doubleMember != null) {
            return this._doubleMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_Double);
        this._doubleMember = DataTemplateUtil.coerceDoubleOutput(__rawValue);
        return this._doubleMember;
    }

    public void setDouble(Double value) {
        this.checkNotNull();
        this._map.clear();
        this._doubleMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_Double, DataTemplateUtil.coerceDoubleInput(value));
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public PrimitivePropertyValue clone() throws CloneNotSupportedException {
        PrimitivePropertyValue __clone = (PrimitivePropertyValue)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public PrimitivePropertyValue copy() throws CloneNotSupportedException {
        PrimitivePropertyValue __copy = (PrimitivePropertyValue)super.copy();
        __copy._stringMember = null;
        __copy._doubleMember = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    @Override
    public TyperefInfo typerefInfo() {
        return TYPEREFINFO;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final PrimitivePropertyValue __objectRef;

        private ChangeListener(PrimitivePropertyValue reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "string": {
                    this.__objectRef._stringMember = null;
                    break;
                }
                case "double": {
                    this.__objectRef._doubleMember = null;
                }
            }
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withString() {
            this.getDataMap().put(PrimitivePropertyValue.MEMBERKEY_String, 1);
            return this;
        }

        public ProjectionMask withDouble() {
            this.getDataMap().put(PrimitivePropertyValue.MEMBERKEY_Double, 1);
            return this;
        }
    }

    private static final class UnionTyperefInfo
    extends TyperefInfo {
        private static final TyperefDataSchema SCHEMA = (TyperefDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.structured/**Represents a stored primitive property value\n*/typeref PrimitivePropertyValue=union[string,double]", SchemaFormatType.PDL);

        public UnionTyperefInfo() {
            super(SCHEMA);
        }

        public static TyperefDataSchema dataSchema() {
            return SCHEMA;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec String() {
            return new PathSpec(this.getPathComponents(), PrimitivePropertyValue.MEMBERKEY_String);
        }

        public PathSpec Double() {
            return new PathSpec(this.getPathComponents(), PrimitivePropertyValue.MEMBERKEY_Double);
        }
    }
}

