/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.schema;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class KafkaSchema
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.schema/**Schema holder for kafka schema.*/record KafkaSchema{/**The native kafka document schema. This is a human readable avro document schema.*/documentSchema:string/**The native kafka document schema type. This can be AVRO/PROTOBUF/JSON.*/documentSchemaType:optional string/**The native kafka key schema as retrieved from Schema Registry*/keySchema:optional string/**The native kafka key schema type. This can be AVRO/PROTOBUF/JSON.*/keySchemaType:optional string}", SchemaFormatType.PDL);
    private String _documentSchemaField = null;
    private String _documentSchemaTypeField = null;
    private String _keySchemaField = null;
    private String _keySchemaTypeField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_DocumentSchema = SCHEMA.getField("documentSchema");
    private static final RecordDataSchema.Field FIELD_DocumentSchemaType = SCHEMA.getField("documentSchemaType");
    private static final RecordDataSchema.Field FIELD_KeySchema = SCHEMA.getField("keySchema");
    private static final RecordDataSchema.Field FIELD_KeySchemaType = SCHEMA.getField("keySchemaType");

    public KafkaSchema() {
        super(new DataMap(6, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public KafkaSchema(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasDocumentSchema() {
        if (this._documentSchemaField != null) {
            return true;
        }
        return this._map.containsKey("documentSchema");
    }

    public void removeDocumentSchema() {
        this._map.remove("documentSchema");
    }

    @Nullable
    public String getDocumentSchema(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getDocumentSchema();
            }
            case DEFAULT: 
            case NULL: {
                if (this._documentSchemaField != null) {
                    return this._documentSchemaField;
                }
                Object __rawValue = this._map.get("documentSchema");
                this._documentSchemaField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._documentSchemaField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getDocumentSchema() {
        if (this._documentSchemaField != null) {
            return this._documentSchemaField;
        }
        Object __rawValue = this._map.get("documentSchema");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("documentSchema");
        }
        this._documentSchemaField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._documentSchemaField;
    }

    public KafkaSchema setDocumentSchema(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDocumentSchema(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field documentSchema of com.linkedin.schema.KafkaSchema");
                }
                CheckedUtil.putWithoutChecking(this._map, "documentSchema", value);
                this._documentSchemaField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDocumentSchema();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "documentSchema", value);
                this._documentSchemaField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "documentSchema", value);
                this._documentSchemaField = value;
            }
        }
        return this;
    }

    public KafkaSchema setDocumentSchema(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field documentSchema of com.linkedin.schema.KafkaSchema to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "documentSchema", value);
        this._documentSchemaField = value;
        return this;
    }

    public boolean hasDocumentSchemaType() {
        if (this._documentSchemaTypeField != null) {
            return true;
        }
        return this._map.containsKey("documentSchemaType");
    }

    public void removeDocumentSchemaType() {
        this._map.remove("documentSchemaType");
    }

    @Nullable
    public String getDocumentSchemaType(GetMode mode) {
        return this.getDocumentSchemaType();
    }

    @Nullable
    public String getDocumentSchemaType() {
        if (this._documentSchemaTypeField != null) {
            return this._documentSchemaTypeField;
        }
        Object __rawValue = this._map.get("documentSchemaType");
        this._documentSchemaTypeField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._documentSchemaTypeField;
    }

    public KafkaSchema setDocumentSchemaType(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDocumentSchemaType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDocumentSchemaType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "documentSchemaType", value);
                this._documentSchemaTypeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "documentSchemaType", value);
                this._documentSchemaTypeField = value;
            }
        }
        return this;
    }

    public KafkaSchema setDocumentSchemaType(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field documentSchemaType of com.linkedin.schema.KafkaSchema to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "documentSchemaType", value);
        this._documentSchemaTypeField = value;
        return this;
    }

    public boolean hasKeySchema() {
        if (this._keySchemaField != null) {
            return true;
        }
        return this._map.containsKey("keySchema");
    }

    public void removeKeySchema() {
        this._map.remove("keySchema");
    }

    @Nullable
    public String getKeySchema(GetMode mode) {
        return this.getKeySchema();
    }

    @Nullable
    public String getKeySchema() {
        if (this._keySchemaField != null) {
            return this._keySchemaField;
        }
        Object __rawValue = this._map.get("keySchema");
        this._keySchemaField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._keySchemaField;
    }

    public KafkaSchema setKeySchema(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setKeySchema(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeKeySchema();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "keySchema", value);
                this._keySchemaField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "keySchema", value);
                this._keySchemaField = value;
            }
        }
        return this;
    }

    public KafkaSchema setKeySchema(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field keySchema of com.linkedin.schema.KafkaSchema to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "keySchema", value);
        this._keySchemaField = value;
        return this;
    }

    public boolean hasKeySchemaType() {
        if (this._keySchemaTypeField != null) {
            return true;
        }
        return this._map.containsKey("keySchemaType");
    }

    public void removeKeySchemaType() {
        this._map.remove("keySchemaType");
    }

    @Nullable
    public String getKeySchemaType(GetMode mode) {
        return this.getKeySchemaType();
    }

    @Nullable
    public String getKeySchemaType() {
        if (this._keySchemaTypeField != null) {
            return this._keySchemaTypeField;
        }
        Object __rawValue = this._map.get("keySchemaType");
        this._keySchemaTypeField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._keySchemaTypeField;
    }

    public KafkaSchema setKeySchemaType(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setKeySchemaType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeKeySchemaType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "keySchemaType", value);
                this._keySchemaTypeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "keySchemaType", value);
                this._keySchemaTypeField = value;
            }
        }
        return this;
    }

    public KafkaSchema setKeySchemaType(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field keySchemaType of com.linkedin.schema.KafkaSchema to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "keySchemaType", value);
        this._keySchemaTypeField = value;
        return this;
    }

    @Override
    public KafkaSchema clone() throws CloneNotSupportedException {
        KafkaSchema __clone = (KafkaSchema)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public KafkaSchema copy() throws CloneNotSupportedException {
        KafkaSchema __copy = (KafkaSchema)super.copy();
        __copy._documentSchemaField = null;
        __copy._documentSchemaTypeField = null;
        __copy._keySchemaField = null;
        __copy._keySchemaTypeField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final KafkaSchema __objectRef;

        private ChangeListener(KafkaSchema reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "documentSchema": {
                    this.__objectRef._documentSchemaField = null;
                    break;
                }
                case "documentSchemaType": {
                    this.__objectRef._documentSchemaTypeField = null;
                    break;
                }
                case "keySchema": {
                    this.__objectRef._keySchemaField = null;
                    break;
                }
                case "keySchemaType": {
                    this.__objectRef._keySchemaTypeField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec documentSchema() {
            return new PathSpec(this.getPathComponents(), "documentSchema");
        }

        public PathSpec documentSchemaType() {
            return new PathSpec(this.getPathComponents(), "documentSchemaType");
        }

        public PathSpec keySchema() {
            return new PathSpec(this.getPathComponents(), "keySchema");
        }

        public PathSpec keySchemaType() {
            return new PathSpec(this.getPathComponents(), "keySchemaType");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(6);
        }

        public ProjectionMask withDocumentSchema() {
            this.getDataMap().put("documentSchema", 1);
            return this;
        }

        public ProjectionMask withDocumentSchemaType() {
            this.getDataMap().put("documentSchemaType", 1);
            return this;
        }

        public ProjectionMask withKeySchema() {
            this.getDataMap().put("keySchema", 1);
            return this;
        }

        public ProjectionMask withKeySchemaType() {
            this.getDataMap().put("keySchemaType", 1);
            return this;
        }
    }
}

