/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.mxe;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.mxe.SystemMetadata;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataHubUpgradeHistoryEvent
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.mxe/**Kafka event for recording a historical version upgrade. Used for backwards incompatible changes to infrastructure that requires infrastructure level blocking changes.*/record DataHubUpgradeHistoryEvent{/**Version of the upgrade*/version:string/**A string->string map of custom properties that one might want to attach to an event\n*/systemMetadata:optional/**Metadata associated with each metadata change that is processed by the system*/@Aspect.name=\"systemMetadata\"record SystemMetadata{/**The timestamp the metadata was observed at*/lastObserved:optional long=0/**The original run id that produced the metadata. Populated in case of batch-ingestion.*/runId:optional string=\"no-run-id-provided\"/**The last run id that produced the metadata. Populated in case of batch-ingestion.*/lastRunId:optional string=\"no-run-id-provided\"/**The ingestion pipeline id that produced the metadata. Populated in case of batch ingestion.*/pipelineName:optional string/**The model registry name that was used to process this event*/registryName:optional string/**The model registry version that was used to process this event*/registryVersion:optional string/**Additional properties*/properties:optional map[string,string]/**Aspect version\n   Initial implementation will use the aspect version's number, however stored as\n   a string in the case where a different aspect versioning scheme is later adopted.*/version:optional string/**When the aspect was initially created and who created it, detected by version 0 -> 1 change*/aspectCreated:optional{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}/**When the aspect was last modified and the actor that performed the modification*/aspectModified:optional com.linkedin.common.AuditStamp}}", SchemaFormatType.PDL);
    private String _versionField = null;
    private SystemMetadata _systemMetadataField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Version = SCHEMA.getField("version");
    private static final RecordDataSchema.Field FIELD_SystemMetadata = SCHEMA.getField("systemMetadata");

    public DataHubUpgradeHistoryEvent() {
        super(new DataMap(3, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public DataHubUpgradeHistoryEvent(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasVersion() {
        if (this._versionField != null) {
            return true;
        }
        return this._map.containsKey("version");
    }

    public void removeVersion() {
        this._map.remove("version");
    }

    @Nullable
    public String getVersion(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getVersion();
            }
            case DEFAULT: 
            case NULL: {
                if (this._versionField != null) {
                    return this._versionField;
                }
                Object __rawValue = this._map.get("version");
                this._versionField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._versionField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getVersion() {
        if (this._versionField != null) {
            return this._versionField;
        }
        Object __rawValue = this._map.get("version");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("version");
        }
        this._versionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._versionField;
    }

    public DataHubUpgradeHistoryEvent setVersion(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setVersion(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field version of com.linkedin.mxe.DataHubUpgradeHistoryEvent");
                }
                CheckedUtil.putWithoutChecking(this._map, "version", value);
                this._versionField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeVersion();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "version", value);
                this._versionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "version", value);
                this._versionField = value;
            }
        }
        return this;
    }

    public DataHubUpgradeHistoryEvent setVersion(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field version of com.linkedin.mxe.DataHubUpgradeHistoryEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "version", value);
        this._versionField = value;
        return this;
    }

    public boolean hasSystemMetadata() {
        if (this._systemMetadataField != null) {
            return true;
        }
        return this._map.containsKey("systemMetadata");
    }

    public void removeSystemMetadata() {
        this._map.remove("systemMetadata");
    }

    @Nullable
    public SystemMetadata getSystemMetadata(GetMode mode) {
        return this.getSystemMetadata();
    }

    @Nullable
    public SystemMetadata getSystemMetadata() {
        if (this._systemMetadataField != null) {
            return this._systemMetadataField;
        }
        Object __rawValue = this._map.get("systemMetadata");
        this._systemMetadataField = __rawValue == null ? null : new SystemMetadata(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._systemMetadataField;
    }

    public DataHubUpgradeHistoryEvent setSystemMetadata(@Nullable SystemMetadata value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSystemMetadata(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSystemMetadata();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "systemMetadata", value.data());
                this._systemMetadataField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "systemMetadata", value.data());
                this._systemMetadataField = value;
            }
        }
        return this;
    }

    public DataHubUpgradeHistoryEvent setSystemMetadata(@Nonnull SystemMetadata value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field systemMetadata of com.linkedin.mxe.DataHubUpgradeHistoryEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "systemMetadata", value.data());
        this._systemMetadataField = value;
        return this;
    }

    @Override
    public DataHubUpgradeHistoryEvent clone() throws CloneNotSupportedException {
        DataHubUpgradeHistoryEvent __clone = (DataHubUpgradeHistoryEvent)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataHubUpgradeHistoryEvent copy() throws CloneNotSupportedException {
        DataHubUpgradeHistoryEvent __copy = (DataHubUpgradeHistoryEvent)super.copy();
        __copy._systemMetadataField = null;
        __copy._versionField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataHubUpgradeHistoryEvent __objectRef;

        private ChangeListener(DataHubUpgradeHistoryEvent reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "systemMetadata": {
                    this.__objectRef._systemMetadataField = null;
                    break;
                }
                case "version": {
                    this.__objectRef._versionField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec version() {
            return new PathSpec(this.getPathComponents(), "version");
        }

        public SystemMetadata.Fields systemMetadata() {
            return new SystemMetadata.Fields(this.getPathComponents(), "systemMetadata");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private SystemMetadata.ProjectionMask _systemMetadataMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withVersion() {
            this.getDataMap().put("version", 1);
            return this;
        }

        public ProjectionMask withSystemMetadata(Function<SystemMetadata.ProjectionMask, SystemMetadata.ProjectionMask> nestedMask) {
            this._systemMetadataMask = nestedMask.apply(this._systemMetadataMask == null ? SystemMetadata.createMask() : this._systemMetadataMask);
            this.getDataMap().put("systemMetadata", this._systemMetadataMask.getDataMap());
            return this;
        }

        public ProjectionMask withSystemMetadata() {
            this._systemMetadataMask = null;
            this.getDataMap().put("systemMetadata", 1);
            return this;
        }
    }
}

