/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.ml.metadata;

import com.linkedin.common.MLFeatureDataType;
import com.linkedin.common.UrnArray;
import com.linkedin.common.VersionTag;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MLFeatureProperties
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.ml.metadata/**Properties associated with a MLFeature*/@Aspect.name=\"mlFeatureProperties\"record MLFeatureProperties includes{namespace com.linkedin.common/**Misc. properties about an entity.*/record CustomProperties{/**Custom property bag.*/@Searchable.`/*`={\"fieldType\":\"TEXT\",\"queryByDefault\":true}customProperties:map[string,string]={}}}{/**Documentation of the MLFeature*/@Searchable={\"fieldType\":\"TEXT\",\"hasValuesFieldName\":\"hasDescription\"}description:optional string/**Data Type of the MLFeature*/dataType:optional{namespace com.linkedin.common/**MLFeature Data Type*/enum MLFeatureDataType{/**Useless data is unique, discrete data with no potential relationship with the outcome variable.\nA useless feature has high cardinality. An example would be bank account numbers that were generated randomly.*/USELESS/**Nominal data is made of discrete values with no numerical relationship between the different categories - mean and median are meaningless.\nAnimal species is one example. For example, pig is not higher than bird and lower than fish.*/NOMINAL/**Ordinal data are discrete integers that can be ranked or sorted.\nFor example, the distance between first and second may not be the same as the distance between second and third.*/ORDINAL/**Binary data is discrete data that can be in only one of two categories - either yes or no, 1 or 0, off or on, etc*/BINARY/**Count data is discrete whole number data - no negative numbers here.\nCount data often has many small values, such as zero and one.*/COUNT/**Time data is a cyclical, repeating continuous form of data.\nThe relevant time features can be any period- daily, weekly, monthly, annual, etc.*/TIME/**Interval data has equal spaces between the numbers and does not represent a temporal pattern.\nExamples include percentages, temperatures, and income.*/INTERVAL/**Image Data*/IMAGE/**Video Data*/VIDEO/**Audio Data*/AUDIO/**Text Data*/TEXT/**Mapping Data Type ex: dict, map*/MAP/**Sequence Data Type ex: list, tuple, range*/SEQUENCE/**Set Data Type ex: set, frozenset*/SET/**Continuous data are made of uncountable values, often the result of a measurement such as height, weight, age etc.*/CONTINUOUS/**Bytes data are binary-encoded values that can represent complex objects.*/BYTE/**Unknown data are data that we don't know the type for.*/UNKNOWN}}/**Version of the MLFeature*/version:optional{namespace com.linkedin.common/**A resource-defined string representing the resource state for the purpose of concurrency control*/record VersionTag{versionTag:optional string,metadataAttribution:optional/**Information about who, why, and how this metadata was applied*/record MetadataAttribution{/**When this metadata was updated.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) responsible for applying the assocated metadata. This can\neither be a user (in case of UI edits) or the datahub system for automation.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The DataHub source responsible for applying the associated metadata. This will only be filled out\nwhen a DataHub source is responsible. This includes the specific metadata test urn, the automation urn.*/source:optional Urn/**The details associated with why this metadata was applied. For example, this could include\nthe actual regex rule, sql statement, ingestion pipeline ID, etc.*/sourceDetail:map[string,string]={}}}}/**Source of the MLFeature*/@Relationship.`/*`={\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"name\":\"DerivedFrom\"}sources:optional array[com.linkedin.common.Urn]}", SchemaFormatType.PDL);
    private StringMap _customPropertiesField = null;
    private String _descriptionField = null;
    private MLFeatureDataType _dataTypeField = null;
    private VersionTag _versionField = null;
    private UrnArray _sourcesField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_CustomProperties = SCHEMA.getField("customProperties");
    private static final StringMap DEFAULT_CustomProperties;
    private static final RecordDataSchema.Field FIELD_Description;
    private static final RecordDataSchema.Field FIELD_DataType;
    private static final RecordDataSchema.Field FIELD_Version;
    private static final RecordDataSchema.Field FIELD_Sources;

    public MLFeatureProperties() {
        super(new DataMap(7, 0.75f), SCHEMA, 4);
        this.addChangeListener(this.__changeListener);
    }

    public MLFeatureProperties(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasCustomProperties() {
        if (this._customPropertiesField != null) {
            return true;
        }
        return this._map.containsKey("customProperties");
    }

    public void removeCustomProperties() {
        this._map.remove("customProperties");
    }

    @Nullable
    public StringMap getCustomProperties(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getCustomProperties();
            }
            case NULL: {
                if (this._customPropertiesField != null) {
                    return this._customPropertiesField;
                }
                Object __rawValue = this._map.get("customProperties");
                this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._customPropertiesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringMap getCustomProperties() {
        if (this._customPropertiesField != null) {
            return this._customPropertiesField;
        }
        Object __rawValue = this._map.get("customProperties");
        if (__rawValue == null) {
            return DEFAULT_CustomProperties;
        }
        this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._customPropertiesField;
    }

    public MLFeatureProperties setCustomProperties(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCustomProperties(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field customProperties of com.linkedin.ml.metadata.MLFeatureProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCustomProperties();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
            }
        }
        return this;
    }

    public MLFeatureProperties setCustomProperties(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field customProperties of com.linkedin.ml.metadata.MLFeatureProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
        this._customPropertiesField = value;
        return this;
    }

    public boolean hasDescription() {
        if (this._descriptionField != null) {
            return true;
        }
        return this._map.containsKey("description");
    }

    public void removeDescription() {
        this._map.remove("description");
    }

    @Nullable
    public String getDescription(GetMode mode) {
        return this.getDescription();
    }

    @Nullable
    public String getDescription() {
        if (this._descriptionField != null) {
            return this._descriptionField;
        }
        Object __rawValue = this._map.get("description");
        this._descriptionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._descriptionField;
    }

    public MLFeatureProperties setDescription(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDescription(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDescription();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
            }
        }
        return this;
    }

    public MLFeatureProperties setDescription(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field description of com.linkedin.ml.metadata.MLFeatureProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "description", value);
        this._descriptionField = value;
        return this;
    }

    public boolean hasDataType() {
        if (this._dataTypeField != null) {
            return true;
        }
        return this._map.containsKey("dataType");
    }

    public void removeDataType() {
        this._map.remove("dataType");
    }

    @Nullable
    public MLFeatureDataType getDataType(GetMode mode) {
        return this.getDataType();
    }

    @Nullable
    public MLFeatureDataType getDataType() {
        if (this._dataTypeField != null) {
            return this._dataTypeField;
        }
        Object __rawValue = this._map.get("dataType");
        this._dataTypeField = DataTemplateUtil.coerceEnumOutput(__rawValue, MLFeatureDataType.class, MLFeatureDataType.$UNKNOWN);
        return this._dataTypeField;
    }

    public MLFeatureProperties setDataType(@Nullable MLFeatureDataType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDataType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDataType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "dataType", value.name());
                this._dataTypeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "dataType", value.name());
                this._dataTypeField = value;
            }
        }
        return this;
    }

    public MLFeatureProperties setDataType(@Nonnull MLFeatureDataType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field dataType of com.linkedin.ml.metadata.MLFeatureProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "dataType", value.name());
        this._dataTypeField = value;
        return this;
    }

    public boolean hasVersion() {
        if (this._versionField != null) {
            return true;
        }
        return this._map.containsKey("version");
    }

    public void removeVersion() {
        this._map.remove("version");
    }

    @Nullable
    public VersionTag getVersion(GetMode mode) {
        return this.getVersion();
    }

    @Nullable
    public VersionTag getVersion() {
        if (this._versionField != null) {
            return this._versionField;
        }
        Object __rawValue = this._map.get("version");
        this._versionField = __rawValue == null ? null : new VersionTag(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._versionField;
    }

    public MLFeatureProperties setVersion(@Nullable VersionTag value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setVersion(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeVersion();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "version", value.data());
                this._versionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "version", value.data());
                this._versionField = value;
            }
        }
        return this;
    }

    public MLFeatureProperties setVersion(@Nonnull VersionTag value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field version of com.linkedin.ml.metadata.MLFeatureProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "version", value.data());
        this._versionField = value;
        return this;
    }

    public boolean hasSources() {
        if (this._sourcesField != null) {
            return true;
        }
        return this._map.containsKey("sources");
    }

    public void removeSources() {
        this._map.remove("sources");
    }

    @Nullable
    public UrnArray getSources(GetMode mode) {
        return this.getSources();
    }

    @Nullable
    public UrnArray getSources() {
        if (this._sourcesField != null) {
            return this._sourcesField;
        }
        Object __rawValue = this._map.get("sources");
        this._sourcesField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._sourcesField;
    }

    public MLFeatureProperties setSources(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSources(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSources();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "sources", value.data());
                this._sourcesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "sources", value.data());
                this._sourcesField = value;
            }
        }
        return this;
    }

    public MLFeatureProperties setSources(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field sources of com.linkedin.ml.metadata.MLFeatureProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "sources", value.data());
        this._sourcesField = value;
        return this;
    }

    @Override
    public MLFeatureProperties clone() throws CloneNotSupportedException {
        MLFeatureProperties __clone = (MLFeatureProperties)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public MLFeatureProperties copy() throws CloneNotSupportedException {
        MLFeatureProperties __copy = (MLFeatureProperties)super.copy();
        __copy._customPropertiesField = null;
        __copy._sourcesField = null;
        __copy._dataTypeField = null;
        __copy._descriptionField = null;
        __copy._versionField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_Description = SCHEMA.getField("description");
        FIELD_DataType = SCHEMA.getField("dataType");
        FIELD_Version = SCHEMA.getField("version");
        FIELD_Sources = SCHEMA.getField("sources");
        DEFAULT_CustomProperties = FIELD_CustomProperties.getDefault() == null ? null : new StringMap(DataTemplateUtil.castOrThrow(FIELD_CustomProperties.getDefault(), DataMap.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final MLFeatureProperties __objectRef;

        private ChangeListener(MLFeatureProperties reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "customProperties": {
                    this.__objectRef._customPropertiesField = null;
                    break;
                }
                case "sources": {
                    this.__objectRef._sourcesField = null;
                    break;
                }
                case "dataType": {
                    this.__objectRef._dataTypeField = null;
                    break;
                }
                case "description": {
                    this.__objectRef._descriptionField = null;
                    break;
                }
                case "version": {
                    this.__objectRef._versionField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec customProperties() {
            return new PathSpec(this.getPathComponents(), "customProperties");
        }

        public PathSpec description() {
            return new PathSpec(this.getPathComponents(), "description");
        }

        public PathSpec dataType() {
            return new PathSpec(this.getPathComponents(), "dataType");
        }

        public VersionTag.Fields version() {
            return new VersionTag.Fields(this.getPathComponents(), "version");
        }

        public PathSpec sources() {
            return new PathSpec(this.getPathComponents(), "sources");
        }

        public PathSpec sources(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "sources");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private VersionTag.ProjectionMask _versionMask;

        ProjectionMask() {
            super(7);
        }

        public ProjectionMask withCustomProperties() {
            this.getDataMap().put("customProperties", 1);
            return this;
        }

        public ProjectionMask withDescription() {
            this.getDataMap().put("description", 1);
            return this;
        }

        public ProjectionMask withDataType() {
            this.getDataMap().put("dataType", 1);
            return this;
        }

        public ProjectionMask withVersion(Function<VersionTag.ProjectionMask, VersionTag.ProjectionMask> nestedMask) {
            this._versionMask = nestedMask.apply(this._versionMask == null ? VersionTag.createMask() : this._versionMask);
            this.getDataMap().put("version", this._versionMask.getDataMap());
            return this;
        }

        public ProjectionMask withVersion() {
            this._versionMask = null;
            this.getDataMap().put("version", 1);
            return this;
        }

        public ProjectionMask withSources() {
            this.getDataMap().put("sources", 1);
            return this;
        }

        public ProjectionMask withSources(Integer start, Integer count) {
            this.getDataMap().put("sources", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("sources").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("sources").put("$count", count);
            }
            return this;
        }
    }
}

