/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.utils.elasticsearch;

import com.linkedin.metadata.utils.elasticsearch.responses.GetIndexResponse;
import com.linkedin.metadata.utils.elasticsearch.responses.RawResponse;
import com.linkedin.metadata.utils.metrics.MetricUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLContext;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.admin.cluster.health.ClusterHealthRequest;
import org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.opensearch.action.admin.cluster.node.tasks.list.ListTasksRequest;
import org.opensearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.opensearch.action.admin.cluster.settings.ClusterGetSettingsRequest;
import org.opensearch.action.admin.cluster.settings.ClusterGetSettingsResponse;
import org.opensearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.opensearch.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import org.opensearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.opensearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.admin.indices.refresh.RefreshRequest;
import org.opensearch.action.admin.indices.refresh.RefreshResponse;
import org.opensearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.opensearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.opensearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.explain.ExplainRequest;
import org.opensearch.action.explain.ExplainResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.ClearScrollRequest;
import org.opensearch.action.search.ClearScrollResponse;
import org.opensearch.action.search.CreatePitRequest;
import org.opensearch.action.search.CreatePitResponse;
import org.opensearch.action.search.DeletePitRequest;
import org.opensearch.action.search.DeletePitResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.GetAliasesResponse;
import org.opensearch.client.Request;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.core.CountRequest;
import org.opensearch.client.core.CountResponse;
import org.opensearch.client.indices.AnalyzeRequest;
import org.opensearch.client.indices.AnalyzeResponse;
import org.opensearch.client.indices.CreateIndexRequest;
import org.opensearch.client.indices.CreateIndexResponse;
import org.opensearch.client.indices.GetIndexRequest;
import org.opensearch.client.indices.GetMappingsRequest;
import org.opensearch.client.indices.GetMappingsResponse;
import org.opensearch.client.indices.PutMappingRequest;
import org.opensearch.client.indices.ResizeRequest;
import org.opensearch.client.indices.ResizeResponse;
import org.opensearch.client.tasks.GetTaskRequest;
import org.opensearch.client.tasks.GetTaskResponse;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.DeleteByQueryRequest;
import org.opensearch.index.reindex.ReindexRequest;
import org.opensearch.index.reindex.UpdateByQueryRequest;

public interface SearchClientShim<T>
extends Closeable {
    public ShimConfiguration getShimConfiguration();

    @Nonnull
    public SearchResponse search(@Nonnull SearchRequest var1, @Nonnull RequestOptions var2) throws IOException;

    @Nonnull
    public SearchResponse scroll(@Nonnull SearchScrollRequest var1, @Nonnull RequestOptions var2) throws IOException;

    @Nonnull
    public ClearScrollResponse clearScroll(@Nonnull ClearScrollRequest var1, @Nonnull RequestOptions var2) throws IOException;

    @Nonnull
    public CountResponse count(@Nonnull CountRequest var1, @Nonnull RequestOptions var2) throws IOException;

    @Nonnull
    public ExplainResponse explain(@Nonnull ExplainRequest var1, @Nonnull RequestOptions var2) throws IOException;

    @Nonnull
    public GetResponse getDocument(@Nonnull GetRequest var1, @Nonnull RequestOptions var2) throws IOException;

    @Nonnull
    public IndexResponse indexDocument(@Nonnull IndexRequest var1, @Nonnull RequestOptions var2) throws IOException;

    @Nonnull
    public DeleteResponse deleteDocument(@Nonnull DeleteRequest var1, @Nonnull RequestOptions var2) throws IOException;

    @Nonnull
    public BulkByScrollResponse deleteByQuery(@Nonnull DeleteByQueryRequest var1, @Nonnull RequestOptions var2) throws IOException;

    @Nonnull
    public CreatePitResponse createPit(@Nonnull CreatePitRequest var1, @Nonnull RequestOptions var2) throws IOException;

    @Nonnull
    public DeletePitResponse deletePit(@Nonnull DeletePitRequest var1, @Nonnull RequestOptions var2) throws IOException;

    @Nonnull
    public CreateIndexResponse createIndex(@Nonnull CreateIndexRequest var1, @Nonnull RequestOptions var2) throws IOException;

    @Nonnull
    public GetIndexResponse getIndex(GetIndexRequest var1, RequestOptions var2) throws IOException;

    @Nonnull
    public ResizeResponse cloneIndex(ResizeRequest var1, RequestOptions var2) throws IOException;

    @Nonnull
    public AcknowledgedResponse deleteIndex(@Nonnull DeleteIndexRequest var1, @Nonnull RequestOptions var2) throws IOException;

    public boolean indexExists(@Nonnull GetIndexRequest var1, @Nonnull RequestOptions var2) throws IOException;

    @Nonnull
    public AcknowledgedResponse putIndexMapping(@Nonnull PutMappingRequest var1, @Nonnull RequestOptions var2) throws IOException;

    @Nonnull
    public GetMappingsResponse getIndexMapping(@Nonnull GetMappingsRequest var1, @Nonnull RequestOptions var2) throws IOException;

    @Nonnull
    public GetSettingsResponse getIndexSettings(@Nonnull GetSettingsRequest var1, @Nonnull RequestOptions var2) throws IOException;

    @Nonnull
    public AcknowledgedResponse updateIndexSettings(@Nonnull UpdateSettingsRequest var1, @Nonnull RequestOptions var2) throws IOException;

    @Nonnull
    public RefreshResponse refreshIndex(@Nonnull RefreshRequest var1, @Nonnull RequestOptions var2) throws IOException;

    @Nonnull
    public GetAliasesResponse getIndexAliases(@Nonnull GetAliasesRequest var1, @Nonnull RequestOptions var2) throws IOException;

    @Nonnull
    public AcknowledgedResponse updateIndexAliases(IndicesAliasesRequest var1, RequestOptions var2) throws IOException;

    @Nonnull
    public AnalyzeResponse analyzeIndex(AnalyzeRequest var1, RequestOptions var2) throws IOException;

    @Nonnull
    public ClusterGetSettingsResponse getClusterSettings(ClusterGetSettingsRequest var1, RequestOptions var2) throws IOException;

    @Nonnull
    public ClusterUpdateSettingsResponse putClusterSettings(ClusterUpdateSettingsRequest var1, RequestOptions var2) throws IOException;

    @Nonnull
    public ClusterHealthResponse clusterHealth(ClusterHealthRequest var1, RequestOptions var2) throws IOException;

    @Nonnull
    public ListTasksResponse listTasks(ListTasksRequest var1, RequestOptions var2) throws IOException;

    @Nonnull
    public Optional<GetTaskResponse> getTask(GetTaskRequest var1, RequestOptions var2) throws IOException;

    @Nonnull
    public SearchEngineType getEngineType();

    @Nonnull
    public String getEngineVersion() throws IOException;

    @Nonnull
    public Map<String, String> getClusterInfo() throws IOException;

    public boolean supportsFeature(@Nonnull String var1);

    @Nonnull
    public RawResponse performLowLevelRequest(Request var1) throws IOException;

    @Nonnull
    public BulkByScrollResponse updateByQuery(UpdateByQueryRequest var1, RequestOptions var2) throws IOException;

    @Nonnull
    public String submitDeleteByQueryTask(DeleteByQueryRequest var1, RequestOptions var2) throws IOException;

    @Nonnull
    public String submitReindexTask(ReindexRequest var1, RequestOptions var2) throws IOException;

    public void generateAsyncBulkProcessor(WriteRequest.RefreshPolicy var1, MetricUtils var2, int var3, long var4, long var6, int var8, int var9);

    public void generateBulkProcessor(WriteRequest.RefreshPolicy var1, MetricUtils var2, int var3, long var4, long var6, int var8, int var9);

    public void addBulk(DocWriteRequest<?> var1);

    public void addBulk(String var1, DocWriteRequest<?> var2);

    public void flushBulkProcessor();

    public void closeBulkProcessor();

    @Nonnull
    public T getNativeClient();

    public static interface ShimConfiguration {
        public SearchEngineType getEngineType();

        public String getHost();

        public Integer getPort();

        public String getUsername();

        public String getPassword();

        public boolean isUseSSL();

        public String getPathPrefix();

        public boolean isUseAwsIamAuth();

        public String getRegion();

        public Integer getThreadCount();

        public Integer getConnectionRequestTimeout();

        public SSLContext getSSLContext();
    }

    public static enum SearchEngineType {
        ELASTICSEARCH_7("elasticsearch", "7"),
        ELASTICSEARCH_8("elasticsearch", "8"),
        ELASTICSEARCH_9("elasticsearch", "9"),
        OPENSEARCH_2("opensearch", "2"),
        UNKNOWN("unsupported", "none");

        private final String engine;
        private final String majorVersion;

        private SearchEngineType(String engine, String majorVersion) {
            this.engine = engine;
            this.majorVersion = majorVersion;
        }

        public String getEngine() {
            return this.engine;
        }

        public String getMajorVersion() {
            return this.majorVersion;
        }

        public boolean isElasticsearch() {
            return "elasticsearch".equals(this.engine);
        }

        public boolean isOpenSearch() {
            return "opensearch".equals(this.engine);
        }

        public boolean supportsEs7HighLevelClient() {
            return this == ELASTICSEARCH_7 || this == OPENSEARCH_2;
        }

        public boolean requiresEs8JavaClient() {
            return this == ELASTICSEARCH_8 || this == ELASTICSEARCH_9;
        }

        public boolean requiresOpenSearchClient() {
            return false;
        }
    }
}

