/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class EnvironmentUtils {
    private static final String KEY_VALUE_DELIMITER = "=";

    private static String getValue(String key) {
        String value = System.getenv(key);
        if (value == null) {
            value = System.getProperty(key);
        }
        return value;
    }

    public static Map<String, Optional<String>> parseArgs(List<String> args) {
        if (args == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Optional<String>> parsedArgs = new HashMap<String, Optional<String>>();
        Iterator<String> iterator = args.iterator();
        while (iterator.hasNext()) {
            String arg;
            List<String> parsedArg;
            parsedArgs.put(parsedArg.get(0), (parsedArg = Arrays.asList((arg = iterator.next()).split(KEY_VALUE_DELIMITER, 2))).size() > 1 ? Optional.of(parsedArg.get(1)) : Optional.empty());
        }
        return parsedArgs;
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = EnvironmentUtils.getValue(key);
        if (value == null) {
            return defaultValue;
        }
        return "true".equalsIgnoreCase(value) || "1".equals(value);
    }

    public static String getString(String key, String defaultValue) {
        String value = EnvironmentUtils.getValue(key);
        return value != null ? value : defaultValue;
    }

    public static int getInt(String key, int defaultValue) {
        String value = EnvironmentUtils.getValue(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long getLong(String key, long defaultValue) {
        String value = EnvironmentUtils.getValue(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static boolean isSet(String key) {
        return EnvironmentUtils.getValue(key) != null;
    }

    public static String getString(String key) {
        return EnvironmentUtils.getString(key, null);
    }

    private EnvironmentUtils() {
    }
}

