/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.utils;

import javax.annotation.Nullable;

public class BasePathUtils {
    private BasePathUtils() {
    }

    public static String resolveBasePath(boolean basePathEnabled, String basePath) {
        return BasePathUtils.resolveBasePath(basePathEnabled, basePath, "");
    }

    public static String resolveBasePath(boolean basePathEnabled, String basePath, String defaultValue) {
        if (basePathEnabled && basePath != null && !basePath.isEmpty() && !"/".equals(basePath)) {
            return basePath;
        }
        return defaultValue;
    }

    public static String resolveBasePath(Boolean basePathEnabled, String basePath) {
        return BasePathUtils.resolveBasePath(basePathEnabled, basePath, "");
    }

    public static String resolveBasePath(Boolean basePathEnabled, String basePath, String defaultValue) {
        if (basePathEnabled != null && basePathEnabled.booleanValue() && basePath != null && !basePath.isEmpty() && !"/".equals(basePath)) {
            return basePath;
        }
        return defaultValue;
    }

    public static String normalizeBasePath(@Nullable String basePath) {
        Object normalized;
        if (basePath == null || basePath.isEmpty()) {
            return "";
        }
        Object object = normalized = basePath.endsWith("/") ? basePath.substring(0, basePath.length() - 1) : basePath;
        if (!((String)normalized).isEmpty() && !((String)normalized).startsWith("/")) {
            normalized = "/" + (String)normalized;
        }
        return normalized;
    }

    public static String addBasePath(String path, @Nullable String basePath) {
        if (basePath == null || basePath.isEmpty()) {
            return path;
        }
        String normalizedBasePath = BasePathUtils.normalizeBasePath(basePath);
        if (normalizedBasePath.isEmpty()) {
            return path;
        }
        Object normalizedPath = path.startsWith("/") ? path : "/" + path;
        return normalizedBasePath + (String)normalizedPath;
    }

    public static String stripBasePath(String path, @Nullable String basePath) {
        if (basePath == null || basePath.isEmpty()) {
            return path;
        }
        String normalizedBasePath = BasePathUtils.normalizeBasePath(basePath);
        if (normalizedBasePath.isEmpty()) {
            return path;
        }
        if (path.startsWith(normalizedBasePath)) {
            String stripped = path.substring(normalizedBasePath.length());
            return stripped.isEmpty() ? "/" : (stripped.startsWith("/") ? stripped : "/" + stripped);
        }
        return path;
    }
}

