/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models.registry;

import com.linkedin.metadata.graph.LineageDirection;
import com.linkedin.metadata.models.EntitySpec;
import com.linkedin.metadata.models.annotation.RelationshipAnnotation;
import com.linkedin.metadata.models.registry.EntityRegistry;
import com.linkedin.metadata.query.filter.RelationshipDirection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Triple;

public class LineageRegistry {
    private final Map<String, LineageSpec> _lineageSpecMap;
    private final EntityRegistry _entityRegistry;

    public LineageRegistry(EntityRegistry entityRegistry) {
        this._lineageSpecMap = this.buildLineageSpecs(entityRegistry);
        this._entityRegistry = entityRegistry;
    }

    private Map<String, LineageSpec> buildLineageSpecs(EntityRegistry entityRegistry) {
        Collection lineageEdges = entityRegistry.getEntitySpecs().entrySet().stream().flatMap(entry -> ((EntitySpec)entry.getValue()).getRelationshipFieldSpecs().stream().flatMap(spec -> this.getLineageEdgesFromRelationshipAnnotation((String)entry.getKey(), spec.getRelationshipAnnotation()))).collect(Collectors.toMap(edge -> Triple.of(edge.getSourceEntity(), edge.getDestEntity(), edge.getType()), Function.identity(), (x1, x2) -> x1)).values();
        HashMap<String, Set> upstreamPerEntity = new HashMap<String, Set>();
        HashMap<String, Set> downstreamPerEntity = new HashMap<String, Set>();
        for (LineageEdge edge2 : lineageEdges) {
            if (edge2.isUpstream()) {
                upstreamPerEntity.computeIfAbsent(edge2.sourceEntity.toLowerCase(), k -> new HashSet()).add(new EdgeInfo(edge2.type, RelationshipDirection.OUTGOING, edge2.destEntity));
                downstreamPerEntity.computeIfAbsent(edge2.destEntity.toLowerCase(), k -> new HashSet()).add(new EdgeInfo(edge2.type, RelationshipDirection.INCOMING, edge2.sourceEntity));
                continue;
            }
            downstreamPerEntity.computeIfAbsent(edge2.sourceEntity.toLowerCase(), k -> new HashSet()).add(new EdgeInfo(edge2.type, RelationshipDirection.OUTGOING, edge2.destEntity));
            upstreamPerEntity.computeIfAbsent(edge2.destEntity.toLowerCase(), k -> new HashSet()).add(new EdgeInfo(edge2.type, RelationshipDirection.INCOMING, edge2.sourceEntity));
        }
        return entityRegistry.getEntitySpecs().keySet().stream().collect(Collectors.toMap(String::toLowerCase, entityName -> new LineageSpec(new ArrayList<EdgeInfo>(upstreamPerEntity.getOrDefault(entityName.toLowerCase(), Collections.emptySet())), new ArrayList<EdgeInfo>(downstreamPerEntity.getOrDefault(entityName.toLowerCase(), Collections.emptySet())))));
    }

    private Stream<LineageEdge> getLineageEdgesFromRelationshipAnnotation(String sourceEntity, RelationshipAnnotation annotation) {
        if (!annotation.isLineage()) {
            return Stream.empty();
        }
        return annotation.getValidDestinationTypes().stream().map(destEntity -> new LineageEdge(sourceEntity, (String)destEntity, annotation.getName(), annotation.isUpstream()));
    }

    public Map<String, LineageSpec> getLineageSpecs() {
        return this._lineageSpecMap.entrySet().stream().filter(e -> !((LineageSpec)e.getValue()).getDownstreamEdges().isEmpty() || !((LineageSpec)e.getValue()).getUpstreamEdges().isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public LineageSpec getLineageSpec(String entityName) {
        return this._lineageSpecMap.get(entityName.toLowerCase());
    }

    public Set<String> getEntitiesWithLineageToEntityType(String entityType) {
        Map<String, EntitySpec> specs = this._entityRegistry.getEntitySpecs();
        HashSet<String> discoveredTypes = new HashSet<String>();
        HashSet<String> typesToProcess = new HashSet<String>();
        typesToProcess.add(entityType);
        while (!typesToProcess.isEmpty()) {
            HashSet nextBatch = new HashSet();
            for (String currentType : typesToProcess) {
                LineageSpec lineageSpec;
                if (!discoveredTypes.add(currentType) || (lineageSpec = this._lineageSpecMap.get(currentType.toLowerCase())) == null) continue;
                Stream.concat(lineageSpec.getDownstreamEdges().stream(), lineageSpec.getUpstreamEdges().stream()).map(EdgeInfo::getOpposingEntityType).map(entity -> ((EntitySpec)specs.get(entity.toLowerCase())).getName()).forEach(nextBatch::add);
            }
            typesToProcess = nextBatch;
        }
        return discoveredTypes;
    }

    public List<EdgeInfo> getLineageRelationships(String entityName, LineageDirection direction) {
        LineageSpec spec = this.getLineageSpec(entityName);
        if (spec == null) {
            return Collections.emptyList();
        }
        if (entityName.equals("schemaField")) {
            return this.getSchemaFieldRelationships(direction);
        }
        if (direction == LineageDirection.UPSTREAM) {
            return spec.getUpstreamEdges();
        }
        return spec.getDownstreamEdges();
    }

    private List<EdgeInfo> getSchemaFieldRelationships(LineageDirection direction) {
        ArrayList<EdgeInfo> schemaFieldEdges = new ArrayList<EdgeInfo>();
        if (direction == LineageDirection.UPSTREAM) {
            schemaFieldEdges.add(new EdgeInfo("DownstreamOf", RelationshipDirection.OUTGOING, "schemaField"));
        } else {
            schemaFieldEdges.add(new EdgeInfo("DownstreamOf", RelationshipDirection.INCOMING, "schemaField"));
        }
        return schemaFieldEdges;
    }

    public EntityRegistry getEntityRegistry() {
        return this._entityRegistry;
    }

    private static final class LineageEdge {
        private final String sourceEntity;
        private final String destEntity;
        private final String type;
        private final boolean isUpstream;

        @Generated
        public LineageEdge(String sourceEntity, String destEntity, String type, boolean isUpstream) {
            this.sourceEntity = sourceEntity;
            this.destEntity = destEntity;
            this.type = type;
            this.isUpstream = isUpstream;
        }

        @Generated
        public String getSourceEntity() {
            return this.sourceEntity;
        }

        @Generated
        public String getDestEntity() {
            return this.destEntity;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public boolean isUpstream() {
            return this.isUpstream;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LineageEdge)) {
                return false;
            }
            LineageEdge other = (LineageEdge)o;
            if (this.isUpstream() != other.isUpstream()) {
                return false;
            }
            String this$sourceEntity = this.getSourceEntity();
            String other$sourceEntity = other.getSourceEntity();
            if (this$sourceEntity == null ? other$sourceEntity != null : !this$sourceEntity.equals(other$sourceEntity)) {
                return false;
            }
            String this$destEntity = this.getDestEntity();
            String other$destEntity = other.getDestEntity();
            if (this$destEntity == null ? other$destEntity != null : !this$destEntity.equals(other$destEntity)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isUpstream() ? 79 : 97);
            String $sourceEntity = this.getSourceEntity();
            result = result * 59 + ($sourceEntity == null ? 43 : $sourceEntity.hashCode());
            String $destEntity = this.getDestEntity();
            result = result * 59 + ($destEntity == null ? 43 : $destEntity.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LineageRegistry.LineageEdge(sourceEntity=" + this.getSourceEntity() + ", destEntity=" + this.getDestEntity() + ", type=" + this.getType() + ", isUpstream=" + this.isUpstream() + ")";
        }
    }

    public static final class EdgeInfo {
        private final String type;
        private final RelationshipDirection direction;
        private final String opposingEntityType;

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof EdgeInfo) {
                return ((EdgeInfo)o).type.equalsIgnoreCase(this.type) && ((EdgeInfo)o).direction.equals((Object)this.direction) && ((EdgeInfo)o).opposingEntityType.equalsIgnoreCase(this.opposingEntityType);
            }
            return false;
        }

        public int hashCode() {
            return (this.type == null ? 0 : this.type.toLowerCase().hashCode()) ^ (this.direction == null ? 0 : this.direction.hashCode()) ^ (this.opposingEntityType == null ? 0 : this.opposingEntityType.toLowerCase().hashCode());
        }

        @Generated
        public EdgeInfo(String type, RelationshipDirection direction, String opposingEntityType) {
            this.type = type;
            this.direction = direction;
            this.opposingEntityType = opposingEntityType;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public RelationshipDirection getDirection() {
            return this.direction;
        }

        @Generated
        public String getOpposingEntityType() {
            return this.opposingEntityType;
        }

        @Generated
        public String toString() {
            return "LineageRegistry.EdgeInfo(type=" + this.getType() + ", direction=" + String.valueOf((Object)this.getDirection()) + ", opposingEntityType=" + this.getOpposingEntityType() + ")";
        }
    }

    public static final class LineageSpec {
        private final List<EdgeInfo> upstreamEdges;
        private final List<EdgeInfo> downstreamEdges;

        @Generated
        public LineageSpec(List<EdgeInfo> upstreamEdges, List<EdgeInfo> downstreamEdges) {
            this.upstreamEdges = upstreamEdges;
            this.downstreamEdges = downstreamEdges;
        }

        @Generated
        public List<EdgeInfo> getUpstreamEdges() {
            return this.upstreamEdges;
        }

        @Generated
        public List<EdgeInfo> getDownstreamEdges() {
            return this.downstreamEdges;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LineageSpec)) {
                return false;
            }
            LineageSpec other = (LineageSpec)o;
            List<EdgeInfo> this$upstreamEdges = this.getUpstreamEdges();
            List<EdgeInfo> other$upstreamEdges = other.getUpstreamEdges();
            if (this$upstreamEdges == null ? other$upstreamEdges != null : !((Object)this$upstreamEdges).equals(other$upstreamEdges)) {
                return false;
            }
            List<EdgeInfo> this$downstreamEdges = this.getDownstreamEdges();
            List<EdgeInfo> other$downstreamEdges = other.getDownstreamEdges();
            return !(this$downstreamEdges == null ? other$downstreamEdges != null : !((Object)this$downstreamEdges).equals(other$downstreamEdges));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<EdgeInfo> $upstreamEdges = this.getUpstreamEdges();
            result = result * 59 + ($upstreamEdges == null ? 43 : ((Object)$upstreamEdges).hashCode());
            List<EdgeInfo> $downstreamEdges = this.getDownstreamEdges();
            result = result * 59 + ($downstreamEdges == null ? 43 : ((Object)$downstreamEdges).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LineageRegistry.LineageSpec(upstreamEdges=" + String.valueOf(this.getUpstreamEdges()) + ", downstreamEdges=" + String.valueOf(this.getDownstreamEdges()) + ")";
        }
    }
}

