/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models.registry;

import com.linkedin.metadata.aspect.patch.template.AspectTemplateEngine;
import com.linkedin.metadata.aspect.plugins.PluginFactory;
import com.linkedin.metadata.aspect.plugins.config.PluginConfiguration;
import com.linkedin.metadata.aspect.plugins.hooks.MCLSideEffect;
import com.linkedin.metadata.aspect.plugins.hooks.MCPSideEffect;
import com.linkedin.metadata.aspect.plugins.hooks.MutationHook;
import com.linkedin.metadata.aspect.plugins.validation.AspectPayloadValidator;
import com.linkedin.metadata.models.AspectSpec;
import com.linkedin.metadata.models.EntitySpec;
import com.linkedin.metadata.models.EventSpec;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface EntityRegistry {
    default public String getIdentifier() {
        return "Unknown";
    }

    @Nullable
    public EntitySpec getEntitySpec(@Nonnull String var1);

    @Nullable
    public EventSpec getEventSpec(@Nonnull String var1);

    @Nonnull
    public Map<String, EntitySpec> getEntitySpecs();

    @Nonnull
    default public Map<String, EntitySpec> getEntitySpecsBySearchGroup(@Nonnull String searchGroup) {
        return this.getEntitySpecs().entrySet().stream().filter(entry -> searchGroup.equals(((EntitySpec)entry.getValue()).getSearchGroup())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Nonnull
    default public Set<String> getSearchGroups() {
        return this.getEntitySpecs().values().stream().map(EntitySpec::getSearchGroup).collect(Collectors.toSet());
    }

    @Nonnull
    public Map<String, AspectSpec> getAspectSpecs();

    @Nonnull
    public Map<String, EventSpec> getEventSpecs();

    @Nonnull
    public AspectTemplateEngine getAspectTemplateEngine();

    @Nonnull
    default public List<AspectPayloadValidator> getAllAspectPayloadValidators() {
        return this.getPluginFactory().getAspectPayloadValidators();
    }

    @Nonnull
    default public List<MutationHook> getAllMutationHooks() {
        return this.getPluginFactory().getMutationHooks();
    }

    @Nonnull
    default public List<MCPSideEffect> getAllMCPSideEffects() {
        return this.getPluginFactory().getMcpSideEffects();
    }

    @Nonnull
    default public List<MCLSideEffect> getAllMCLSideEffects() {
        return this.getPluginFactory().getMclSideEffects();
    }

    @Nonnull
    default public PluginFactory getPluginFactory() {
        return PluginFactory.empty();
    }

    @Nullable
    default public BiFunction<PluginConfiguration, List<ClassLoader>, PluginFactory> getPluginFactoryProvider() {
        return null;
    }
}

