/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models.registry;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.metadata.aspect.patch.template.AspectTemplateEngine;
import com.linkedin.metadata.aspect.plugins.PluginFactory;
import com.linkedin.metadata.aspect.plugins.config.PluginConfiguration;
import com.linkedin.metadata.models.AspectSpec;
import com.linkedin.metadata.models.DataSchemaFactory;
import com.linkedin.metadata.models.EntitySpec;
import com.linkedin.metadata.models.EntitySpecBuilder;
import com.linkedin.metadata.models.EventSpec;
import com.linkedin.metadata.models.EventSpecBuilder;
import com.linkedin.metadata.models.registry.EntityRegistry;
import com.linkedin.metadata.models.registry.EntityRegistryException;
import com.linkedin.metadata.models.registry.EntityRegistryUtils;
import com.linkedin.metadata.models.registry.config.Entities;
import com.linkedin.metadata.models.registry.config.Entity;
import com.linkedin.metadata.models.registry.config.Event;
import com.linkedin.util.Pair;
import datahub.shaded.jackson.core.StreamReadConstraints;
import datahub.shaded.jackson.databind.ObjectMapper;
import datahub.shaded.jackson.dataformat.yaml.YAMLFactory;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigEntityRegistry
implements EntityRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigEntityRegistry.class);
    private final DataSchemaFactory dataSchemaFactory;
    private final PluginFactory pluginFactory;
    @Nullable
    private BiFunction<PluginConfiguration, List<ClassLoader>, PluginFactory> pluginFactoryProvider;
    private final Map<String, EntitySpec> entityNameToSpec;
    private final Map<String, EventSpec> eventNameToSpec;
    private final List<EntitySpec> entitySpecs;
    private final String identifier;
    private final Map<String, AspectSpec> _aspectNameToSpec;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper(new YAMLFactory());

    public ConfigEntityRegistry(Pair<Path, Path> configFileClassPathPair, @Nullable BiFunction<PluginConfiguration, List<ClassLoader>, PluginFactory> pluginFactoryProvider) throws IOException {
        this(DataSchemaFactory.withCustomClasspath(configFileClassPathPair.getSecond()), DataSchemaFactory.getClassLoader(configFileClassPathPair.getSecond()).map(Stream::of).orElse(Stream.empty()).collect(Collectors.toList()), configFileClassPathPair.getFirst(), pluginFactoryProvider);
    }

    public ConfigEntityRegistry(String entityRegistryRoot, @Nullable BiFunction<PluginConfiguration, List<ClassLoader>, PluginFactory> pluginFactoryProvider) throws EntityRegistryException, IOException {
        this(ConfigEntityRegistry.getFileAndClassPath(entityRegistryRoot), pluginFactoryProvider);
    }

    private static Pair<Path, Path> getFileAndClassPath(String entityRegistryRoot) throws IOException, EntityRegistryException {
        Path entityRegistryRootLoc = Paths.get(entityRegistryRoot, new String[0]);
        if (Files.isDirectory(entityRegistryRootLoc, new LinkOption[0])) {
            List yamlFiles = Files.walk(entityRegistryRootLoc, 1, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(f -> f.endsWith("entity-registry.yml") || f.endsWith("entity-registry.yaml")).collect(Collectors.toList());
            if (yamlFiles.isEmpty()) {
                throw new EntityRegistryException(String.format("Did not find an entity registry (entity_registry.yaml/yml) under %s", entityRegistryRootLoc));
            }
            if (yamlFiles.size() > 1) {
                log.warn("Found more than one yaml file in the directory {}. Will pick the first {}", (Object)entityRegistryRootLoc, yamlFiles.get(0));
            }
            Path entityRegistryFile = (Path)yamlFiles.get(0);
            log.info("Loading custom config entity file: {}, dir: {}", (Object)entityRegistryFile, (Object)entityRegistryRootLoc);
            return new Pair<Path, Path>(entityRegistryFile, entityRegistryRootLoc);
        }
        log.info("Loading bare config entity registry file at {}", (Object)entityRegistryRootLoc);
        return new Pair<Path, Object>(entityRegistryRootLoc, null);
    }

    public ConfigEntityRegistry(InputStream configFileInputStream) {
        this(configFileInputStream, null);
    }

    public ConfigEntityRegistry(InputStream configFileInputStream, @Nullable BiFunction<PluginConfiguration, List<ClassLoader>, PluginFactory> pluginFactoryProvider) {
        this(DataSchemaFactory.getInstance(), Collections.emptyList(), configFileInputStream, pluginFactoryProvider);
    }

    public ConfigEntityRegistry(DataSchemaFactory dataSchemaFactory, List<ClassLoader> classLoaders, Path configFilePath, @Nullable BiFunction<PluginConfiguration, List<ClassLoader>, PluginFactory> pluginFactoryProvider) throws FileNotFoundException {
        this(dataSchemaFactory, classLoaders, new FileInputStream(configFilePath.toString()), pluginFactoryProvider);
    }

    public ConfigEntityRegistry(DataSchemaFactory dataSchemaFactory, List<ClassLoader> classLoaders, InputStream configFileStream) {
        this(dataSchemaFactory, classLoaders, configFileStream, null);
    }

    public ConfigEntityRegistry(DataSchemaFactory dataSchemaFactory, List<ClassLoader> classLoaders, InputStream configFileStream, @Nullable BiFunction<PluginConfiguration, List<ClassLoader>, PluginFactory> pluginFactoryProvider) {
        Entities entities;
        this.dataSchemaFactory = dataSchemaFactory;
        try {
            entities = OBJECT_MAPPER.readValue(configFileStream, Entities.class);
            this.pluginFactory = pluginFactoryProvider != null ? pluginFactoryProvider.apply(entities.getPlugins(), classLoaders) : PluginFactory.withCustomClasspath(entities.getPlugins(), classLoaders);
            this.pluginFactoryProvider = pluginFactoryProvider;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Error while reading config file in path %s: %s", configFileStream, e.getMessage()), e);
        }
        this.identifier = entities.getId() != null ? entities.getId() : "Unknown";
        this.entityNameToSpec = new HashMap<String, EntitySpec>();
        EntitySpecBuilder entitySpecBuilder = new EntitySpecBuilder();
        for (Entity entity : entities.getEntities()) {
            ArrayList<AspectSpec> aspectSpecs = new ArrayList<AspectSpec>();
            aspectSpecs.add(this.buildAspectSpec(entity.getKeyAspect(), entitySpecBuilder));
            entity.getAspects().forEach(aspect -> aspectSpecs.add(this.buildAspectSpec((String)aspect, entitySpecBuilder)));
            Optional<DataSchema> entitySchema = dataSchemaFactory.getEntitySchema(entity.getName());
            String searchGroup = entity.getSearchGroup() != null ? entity.getSearchGroup() : "default";
            EntitySpec entitySpec = !entitySchema.isPresent() ? entitySpecBuilder.buildConfigEntitySpec(entity.getName(), entity.getKeyAspect(), aspectSpecs, searchGroup) : entitySpecBuilder.buildEntitySpec(entitySchema.get(), aspectSpecs, searchGroup);
            this.entityNameToSpec.put(entity.getName().toLowerCase(), entitySpec);
        }
        this.eventNameToSpec = new HashMap<String, EventSpec>();
        if (entities.getEvents() != null) {
            for (Event event : entities.getEvents()) {
                EventSpec eventSpec = this.buildEventSpec(event.getName());
                this.eventNameToSpec.put(event.getName().toLowerCase(), eventSpec);
            }
        }
        this.entitySpecs = new ArrayList<EntitySpec>(this.entityNameToSpec.values());
        this._aspectNameToSpec = EntityRegistryUtils.populateAspectMap(this.entitySpecs);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    private AspectSpec buildAspectSpec(String aspectName, EntitySpecBuilder entitySpecBuilder) {
        Optional<DataSchema> aspectSchema = this.dataSchemaFactory.getAspectSchema(aspectName);
        Optional<Class> aspectClass = this.dataSchemaFactory.getAspectClass(aspectName);
        if (!aspectSchema.isPresent()) {
            throw new IllegalArgumentException(String.format("Aspect %s does not exist", aspectName));
        }
        return entitySpecBuilder.buildAspectSpec(aspectSchema.get(), aspectClass.get());
    }

    private EventSpec buildEventSpec(String eventName) {
        Optional<DataSchema> eventSchema = this.dataSchemaFactory.getEventSchema(eventName);
        if (!eventSchema.isPresent()) {
            throw new IllegalArgumentException(String.format("Event %s does not exist", eventName));
        }
        return new EventSpecBuilder().buildEventSpec(eventName, eventSchema.get());
    }

    @Override
    @Nonnull
    public EntitySpec getEntitySpec(@Nonnull String entityName) {
        String lowercaseEntityName = entityName.toLowerCase();
        if (!this.entityNameToSpec.containsKey(lowercaseEntityName)) {
            throw new IllegalArgumentException(String.format("Failed to find entity with name %s in EntityRegistry", entityName));
        }
        return this.entityNameToSpec.get(lowercaseEntityName);
    }

    @Override
    @Nonnull
    public EventSpec getEventSpec(@Nonnull String eventName) {
        String lowerEventName = eventName.toLowerCase();
        if (!this.eventNameToSpec.containsKey(lowerEventName)) {
            throw new IllegalArgumentException(String.format("Failed to find event with name %s in EntityRegistry", eventName));
        }
        return this.eventNameToSpec.get(lowerEventName);
    }

    @Override
    @Nonnull
    public Map<String, EntitySpec> getEntitySpecs() {
        return this.entityNameToSpec;
    }

    @Override
    @Nonnull
    public Map<String, AspectSpec> getAspectSpecs() {
        return this._aspectNameToSpec;
    }

    @Override
    @Nonnull
    public Map<String, EventSpec> getEventSpecs() {
        return this.eventNameToSpec;
    }

    @Override
    @Nonnull
    public AspectTemplateEngine getAspectTemplateEngine() {
        return new AspectTemplateEngine();
    }

    @Override
    @Generated
    public PluginFactory getPluginFactory() {
        return this.pluginFactory;
    }

    @Override
    @Nullable
    @Generated
    public BiFunction<PluginConfiguration, List<ClassLoader>, PluginFactory> getPluginFactoryProvider() {
        return this.pluginFactoryProvider;
    }

    static {
        int maxSize = Integer.parseInt(System.getenv().getOrDefault("INGESTION_MAX_SERIALIZED_STRING_LENGTH", "16000000"));
        OBJECT_MAPPER.getFactory().setStreamReadConstraints(StreamReadConstraints.builder().maxStringLength(maxSize).build());
    }
}

