/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models;

import com.google.common.collect.ImmutableList;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.metadata.models.AspectSpec;
import com.linkedin.metadata.models.RelationshipFieldSpec;
import com.linkedin.metadata.models.SearchScoreFieldSpec;
import com.linkedin.metadata.models.SearchableFieldSpec;
import com.linkedin.metadata.models.SearchableRefFieldSpec;
import com.linkedin.metadata.models.annotation.EntityAnnotation;
import com.linkedin.metadata.models.annotation.SearchableAnnotation;
import com.linkedin.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public interface EntitySpec {
    public static final String ARRAY_WILDCARD = "*";

    public String getName();

    public EntityAnnotation getEntityAnnotation();

    public String getKeyAspectName();

    public AspectSpec getKeyAspectSpec();

    public List<AspectSpec> getAspectSpecs();

    public Map<String, AspectSpec> getAspectSpecMap();

    public Boolean hasAspect(String var1);

    public AspectSpec getAspectSpec(String var1);

    public RecordDataSchema getSnapshotSchema();

    public TyperefDataSchema getAspectTyperefSchema();

    public String getSearchGroup();

    default public List<SearchableFieldSpec> getSearchableFieldSpecs() {
        return this.getAspectSpecs().stream().map(AspectSpec::getSearchableFieldSpecs).flatMap(Collection::stream).collect(Collectors.toList());
    }

    default public Map<String, Set<SearchableAnnotation.FieldType>> getSearchableFieldTypes() {
        BiFunction numValuesFn = (aspectSpec, searchableFieldSpec) -> {
            String fieldName = searchableFieldSpec.getSearchableAnnotation().getNumValuesFieldName().get();
            HashSet<SearchableAnnotation.FieldType> fieldTypes = new HashSet<SearchableAnnotation.FieldType>();
            fieldTypes.add(SearchableAnnotation.FieldType.COUNT);
            return new Pair(fieldName, fieldTypes);
        };
        BiFunction hasValuesFn = (aspectSpec, searchableFieldSpec) -> {
            String fieldName = searchableFieldSpec.getSearchableAnnotation().getHasValuesFieldName().get();
            HashSet<SearchableAnnotation.FieldType> fieldTypes = new HashSet<SearchableAnnotation.FieldType>();
            fieldTypes.add(SearchableAnnotation.FieldType.BOOLEAN);
            return new Pair(fieldName, fieldTypes);
        };
        BiFunction defaultKeyFn = (aspectSpec, searchableFieldSpec) -> {
            String fieldName = searchableFieldSpec.getSearchableAnnotation().getFieldName();
            HashSet<SearchableAnnotation.FieldType> fieldTypes = new HashSet<SearchableAnnotation.FieldType>(Collections.singleton(searchableFieldSpec.getSearchableAnnotation().getFieldType()));
            return new Pair<String, HashSet<SearchableAnnotation.FieldType>>(fieldName, fieldTypes);
        };
        BinaryOperator mergeFn = (set1, set2) -> {
            set1.addAll(set2);
            return set1;
        };
        return this.getFieldMap(numValuesFn, hasValuesFn, defaultKeyFn, mergeFn);
    }

    default public <T, R> Map<T, R> getFieldMap(BiFunction<AspectSpec, SearchableFieldSpec, Pair<T, R>> numValuesFieldMapKeyFn, BiFunction<AspectSpec, SearchableFieldSpec, Pair<T, R>> hasValuesFieldMapKeyFn, BiFunction<AspectSpec, SearchableFieldSpec, Pair<T, R>> defaultMapKeyFn, BinaryOperator<R> mergeFunction) {
        HashMap<Object, Object> fieldSpecMap = new HashMap<Object, Object>();
        for (AspectSpec aspectSpec : this.getAspectSpecs()) {
            for (SearchableFieldSpec fieldSpec : aspectSpec.getSearchableFieldSpecs()) {
                SearchableAnnotation searchableAnnotation = fieldSpec.getSearchableAnnotation();
                if (searchableAnnotation.getNumValuesFieldName().isPresent()) {
                    Pair<T, R> numValuesKeyValue = numValuesFieldMapKeyFn.apply(aspectSpec, fieldSpec);
                    fieldSpecMap.put(numValuesKeyValue.getKey(), numValuesKeyValue.getValue());
                }
                if (!searchableAnnotation.getHasValuesFieldName().isPresent()) continue;
                Pair<T, R> hasValuesKeyValue = hasValuesFieldMapKeyFn.apply(aspectSpec, fieldSpec);
                fieldSpecMap.put(hasValuesKeyValue.getKey(), hasValuesKeyValue.getValue());
            }
            fieldSpecMap.putAll(aspectSpec.getSearchableFieldSpecs().stream().map(searchableField -> (Pair)defaultMapKeyFn.apply(aspectSpec, (SearchableFieldSpec)searchableField)).collect(Collectors.toMap(Pair::getKey, Pair::getValue, mergeFunction)));
        }
        return fieldSpecMap;
    }

    default public Map<PathSpec, String> getSearchableFieldPathMap() {
        BiFunction numValuesFn = (aspectSpec, searchableFieldSpec) -> {
            ArrayList<String> fieldPaths = new ArrayList<String>();
            fieldPaths.add(aspectSpec.getName());
            fieldPaths.addAll(searchableFieldSpec.getPath().getPathComponents());
            fieldPaths.add(searchableFieldSpec.getSearchableAnnotation().getNumValuesFieldName().get());
            PathSpec pathSpec = new PathSpec(fieldPaths.stream().filter(str -> !ARRAY_WILDCARD.equals(str)).collect(Collectors.toList()));
            String fieldName = searchableFieldSpec.getSearchableAnnotation().getNumValuesFieldName().get();
            return new Pair<PathSpec, String>(pathSpec, fieldName);
        };
        BiFunction hasValuesFn = (aspectSpec, searchableFieldSpec) -> {
            String fieldName = searchableFieldSpec.getSearchableAnnotation().getHasValuesFieldName().get();
            ArrayList<String> fieldPaths = new ArrayList<String>();
            fieldPaths.add(aspectSpec.getName());
            fieldPaths.addAll(searchableFieldSpec.getPath().getPathComponents());
            fieldPaths.add(searchableFieldSpec.getSearchableAnnotation().getHasValuesFieldName().get());
            PathSpec pathSpec = new PathSpec(fieldPaths.stream().filter(str -> !ARRAY_WILDCARD.equals(str)).collect(Collectors.toList()));
            return new Pair<PathSpec, String>(pathSpec, fieldName);
        };
        BiFunction defaultKeyFn = (aspectSpec, searchableFieldSpec) -> {
            String fieldName = searchableFieldSpec.getSearchableAnnotation().getFieldName();
            ArrayList<String> paths = new ArrayList<String>();
            paths.add(aspectSpec.getName());
            paths.addAll(searchableFieldSpec.getPath().getPathComponents());
            PathSpec pathSpec = new PathSpec(paths.stream().filter(str -> !ARRAY_WILDCARD.equals(str)).collect(Collectors.toList()));
            return new Pair<PathSpec, String>(pathSpec, fieldName);
        };
        BinaryOperator mergeFn = (s1, s2) -> {
            if (!StringUtils.equals(s1, s2)) {
                throw new IllegalStateException(String.format("Path must be unique within an entity, unable to merge values: %s and %s", s1, s2));
            }
            return s1;
        };
        return this.getFieldMap(numValuesFn, hasValuesFn, defaultKeyFn, mergeFn);
    }

    default public List<SearchScoreFieldSpec> getSearchScoreFieldSpecs() {
        return this.getAspectSpecs().stream().map(AspectSpec::getSearchScoreFieldSpecs).flatMap(Collection::stream).collect(Collectors.toList());
    }

    default public List<RelationshipFieldSpec> getRelationshipFieldSpecs() {
        return this.getAspectSpecs().stream().map(AspectSpec::getRelationshipFieldSpecs).flatMap(Collection::stream).collect(Collectors.toList());
    }

    default public List<SearchableRefFieldSpec> getSearchableRefFieldSpecs() {
        return this.getAspectSpecs().stream().map(AspectSpec::getSearchableRefFieldSpecs).flatMap(Collection::stream).collect(Collectors.toList());
    }

    default public Map<String, List<PathSpec>> getSearchableFieldsToPathSpecsMap() {
        BiFunction numValuesFn = (aspectSpec, searchableFieldSpec) -> {
            ArrayList<String> fieldPaths = new ArrayList<String>();
            fieldPaths.add(aspectSpec.getName());
            fieldPaths.addAll(searchableFieldSpec.getPath().getPathComponents());
            fieldPaths.add(searchableFieldSpec.getSearchableAnnotation().getNumValuesFieldName().get());
            PathSpec pathSpec = new PathSpec(fieldPaths.stream().filter(str -> !ARRAY_WILDCARD.equals(str)).collect(Collectors.toList()));
            String fieldName = searchableFieldSpec.getSearchableAnnotation().getNumValuesFieldName().get();
            return new Pair<String, ImmutableList<PathSpec>>(fieldName, ImmutableList.of(pathSpec));
        };
        BiFunction hasValuesFn = (aspectSpec, searchableFieldSpec) -> {
            String fieldName = searchableFieldSpec.getSearchableAnnotation().getHasValuesFieldName().get();
            ArrayList<String> fieldPaths = new ArrayList<String>();
            fieldPaths.add(aspectSpec.getName());
            fieldPaths.addAll(searchableFieldSpec.getPath().getPathComponents());
            fieldPaths.add(searchableFieldSpec.getSearchableAnnotation().getHasValuesFieldName().get());
            PathSpec pathSpec = new PathSpec(fieldPaths.stream().filter(str -> !ARRAY_WILDCARD.equals(str)).collect(Collectors.toList()));
            return new Pair<String, ImmutableList<PathSpec>>(fieldName, ImmutableList.of(pathSpec));
        };
        BiFunction defaultKeyFn = (aspectSpec, searchableFieldSpec) -> {
            String fieldName = searchableFieldSpec.getSearchableAnnotation().getFieldName();
            ArrayList<String> paths = new ArrayList<String>();
            paths.add(aspectSpec.getName());
            paths.addAll(searchableFieldSpec.getPath().getPathComponents());
            PathSpec pathSpec = new PathSpec(paths.stream().filter(str -> !ARRAY_WILDCARD.equals(str)).collect(Collectors.toList()));
            return new Pair<String, ImmutableList<PathSpec>>(fieldName, ImmutableList.of(pathSpec));
        };
        BinaryOperator mergeFn = (s1, s2) -> {
            s1.addAll(s2);
            return s1;
        };
        return this.getFieldMap(numValuesFn, hasValuesFn, defaultKeyFn, mergeFn);
    }
}

