/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.plugins;

import com.linkedin.events.metadata.ChangeType;
import com.linkedin.metadata.aspect.plugins.PluginSpec;
import com.linkedin.metadata.aspect.plugins.config.AspectPluginConfig;
import com.linkedin.metadata.aspect.plugins.config.PluginConfiguration;
import com.linkedin.metadata.aspect.plugins.hooks.MCLSideEffect;
import com.linkedin.metadata.aspect.plugins.hooks.MCPSideEffect;
import com.linkedin.metadata.aspect.plugins.hooks.MutationHook;
import com.linkedin.metadata.aspect.plugins.validation.AspectPayloadValidator;
import com.linkedin.metadata.models.registry.config.EntityRegistryLoadResult;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.MethodInfo;
import io.github.classgraph.ScanResult;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PluginFactory.class);
    private final PluginConfiguration pluginConfiguration;
    @Nonnull
    private final List<ClassLoader> classLoaders;
    private List<AspectPayloadValidator> aspectPayloadValidators;
    private List<MutationHook> mutationHooks;
    private List<MCLSideEffect> mclSideEffects;
    private List<MCPSideEffect> mcpSideEffects;
    private static final Map<Long, List<PluginSpec>> pluginCache = new ConcurrentHashMap<Long, List<PluginSpec>>();

    public static PluginFactory withCustomClasspath(@Nullable PluginConfiguration pluginConfiguration, @Nonnull List<ClassLoader> classLoaders) {
        return new PluginFactory(pluginConfiguration, classLoaders).loadPlugins();
    }

    public static PluginFactory withConfig(@Nullable PluginConfiguration pluginConfiguration) {
        return PluginFactory.withCustomClasspath(pluginConfiguration, Collections.emptyList());
    }

    public static PluginFactory empty() {
        return PluginFactory.withConfig(PluginConfiguration.EMPTY);
    }

    public static PluginFactory merge(PluginFactory a, PluginFactory b, @Nullable BiFunction<PluginConfiguration, List<ClassLoader>, PluginFactory> pluginFactoryProvider) {
        if (b.isEmpty()) {
            return a;
        }
        if (a.isEmpty()) {
            return b;
        }
        PluginConfiguration mergedPluginConfig = PluginConfiguration.merge(a.pluginConfiguration, b.pluginConfiguration);
        List<ClassLoader> mergedClassLoaders = Stream.concat(a.getClassLoaders().stream(), b.getClassLoaders().stream()).collect(Collectors.toList());
        if (!a.hasLoadedPlugins() && !b.hasLoadedPlugins()) {
            if (pluginFactoryProvider != null) {
                return pluginFactoryProvider.apply(mergedPluginConfig, mergedClassLoaders);
            }
            if (mergedPluginConfig.streamAll().anyMatch(config -> config.getSpring() != null && config.getSpring().isEnabled())) {
                throw new IllegalStateException("Unexpected Spring configuration found without a provided Spring Plugin Factory");
            }
            return PluginFactory.withCustomClasspath(mergedPluginConfig, mergedClassLoaders);
        }
        PluginFactory loadedA = a.hasLoadedPlugins() ? a : a.loadPlugins();
        PluginFactory loadedB = b.hasLoadedPlugins() ? b : b.loadPlugins();
        return new PluginFactory(mergedPluginConfig, mergedClassLoaders, Stream.concat(loadedA.aspectPayloadValidators.stream().filter(aPlugin -> loadedB.pluginConfiguration.getAspectPayloadValidators().stream().noneMatch(bConfig -> aPlugin.getConfig().isDisabledBy((AspectPluginConfig)bConfig))), loadedB.aspectPayloadValidators.stream()).collect(Collectors.toList()), Stream.concat(loadedA.mutationHooks.stream().filter(aPlugin -> loadedB.pluginConfiguration.getMutationHooks().stream().noneMatch(bConfig -> aPlugin.getConfig().isDisabledBy((AspectPluginConfig)bConfig))), loadedB.mutationHooks.stream()).collect(Collectors.toList()), Stream.concat(loadedA.mclSideEffects.stream().filter(aPlugin -> loadedB.pluginConfiguration.getMclSideEffects().stream().noneMatch(bConfig -> aPlugin.getConfig().isDisabledBy((AspectPluginConfig)bConfig))), loadedB.mclSideEffects.stream()).collect(Collectors.toList()), Stream.concat(loadedA.mcpSideEffects.stream().filter(aPlugin -> loadedB.pluginConfiguration.getMcpSideEffects().stream().noneMatch(bConfig -> aPlugin.getConfig().isDisabledBy((AspectPluginConfig)bConfig))), loadedB.mcpSideEffects.stream()).collect(Collectors.toList()));
    }

    public PluginFactory(@Nullable PluginConfiguration pluginConfiguration, @Nonnull List<ClassLoader> classLoaders) {
        this.classLoaders = classLoaders;
        this.pluginConfiguration = pluginConfiguration == null ? PluginConfiguration.EMPTY : pluginConfiguration;
    }

    public PluginFactory(@Nullable PluginConfiguration pluginConfiguration, @Nonnull List<ClassLoader> classLoaders, @Nonnull List<AspectPayloadValidator> aspectPayloadValidators, @Nonnull List<MutationHook> mutationHooks, @Nonnull List<MCLSideEffect> mclSideEffects, @Nonnull List<MCPSideEffect> mcpSideEffects) {
        this.classLoaders = classLoaders;
        this.pluginConfiguration = pluginConfiguration == null ? PluginConfiguration.EMPTY : pluginConfiguration;
        this.aspectPayloadValidators = PluginFactory.applyDisable(aspectPayloadValidators);
        this.mutationHooks = PluginFactory.applyDisable(mutationHooks);
        this.mclSideEffects = PluginFactory.applyDisable(mclSideEffects);
        this.mcpSideEffects = PluginFactory.applyDisable(mcpSideEffects);
    }

    public PluginFactory loadPlugins() {
        if (this.aspectPayloadValidators != null || this.mutationHooks != null || this.mclSideEffects != null || this.mcpSideEffects != null) {
            log.error("Plugins are already loaded. Re-building plugins will be skipped.");
        } else {
            this.aspectPayloadValidators = this.buildAspectPayloadValidators(this.pluginConfiguration);
            this.mutationHooks = this.buildMutationHooks(this.pluginConfiguration);
            this.mclSideEffects = this.buildMCLSideEffects(this.pluginConfiguration);
            this.mcpSideEffects = this.buildMCPSideEffects(this.pluginConfiguration);
            this.logSummary(Stream.of(this.aspectPayloadValidators, this.mutationHooks, this.mclSideEffects, this.mcpSideEffects).flatMap(Collection::stream).collect(Collectors.toList()));
        }
        return this;
    }

    public boolean isEmpty() {
        return this.pluginConfiguration.isEmpty() && Optional.ofNullable(this.aspectPayloadValidators).map(List::isEmpty).orElse(true) != false && Optional.ofNullable(this.mutationHooks).map(List::isEmpty).orElse(true) != false && Optional.ofNullable(this.mclSideEffects).map(List::isEmpty).orElse(true) != false && Optional.ofNullable(this.mcpSideEffects).map(List::isEmpty).orElse(true) != false;
    }

    public boolean hasLoadedPlugins() {
        return Stream.of(this.aspectPayloadValidators, this.mutationHooks, this.mcpSideEffects, this.mcpSideEffects).anyMatch(Objects::nonNull);
    }

    private void logSummary(List<PluginSpec> pluginSpecs) {
        if (!pluginSpecs.isEmpty()) {
            log.info("Enabled {} plugins. {}", (Object)pluginSpecs.size(), (Object)pluginSpecs.stream().map(v -> String.join((CharSequence)", ", Collections.singletonList(String.format("%s", v.getConfig().getClassName())))).sorted().collect(Collectors.toList()));
        }
    }

    protected static <T extends PluginSpec> List<T> initPlugins(@Nonnull List<ClassLoader> classLoaders, @Nonnull Class<?> baseClazz, @Nonnull List<String> packageNames, @Nonnull List<AspectPluginConfig> configs) {
        List classNames = configs.stream().map(AspectPluginConfig::getClassName).collect(Collectors.toList());
        if (classNames.isEmpty()) {
            return Collections.emptyList();
        }
        long key = IntStream.concat(classLoaders.stream().mapToInt(Object::hashCode), IntStream.concat(IntStream.of(baseClazz.getName().hashCode()), configs.stream().mapToInt(AspectPluginConfig::hashCode))).sum();
        return pluginCache.computeIfAbsent(key, k -> {
            ClassGraph classGraph = new ClassGraph().acceptPackages((String[])packageNames.stream().distinct().toArray(String[]::new)).acceptClasses((String[])classNames.stream().distinct().toArray(String[]::new)).enableRemoteJarScanning().enableExternalClasses().enableClassInfo().enableMethodInfo();
            if (!classLoaders.isEmpty()) {
                classLoaders.forEach(classGraph::addClassLoader);
            }
            ScanResult scanResult = classGraph.scan();
            try {
                Map classMap = scanResult.getSubclasses(baseClazz).stream().collect(Collectors.toMap(ClassInfo::getName, Function.identity()));
                List list = configs.stream().map(config -> {
                    try {
                        ClassInfo classInfo = (ClassInfo)classMap.get(config.getClassName());
                        if (classInfo == null) {
                            throw new IllegalStateException(String.format("The following class cannot be loaded: %s", config.getClassName()));
                        }
                        MethodInfo constructorMethod = (MethodInfo)classInfo.getConstructorInfo().get(0);
                        return ((PluginSpec)constructorMethod.loadClassAndGetConstructor().newInstance(new Object[0])).setConfig((AspectPluginConfig)config);
                    }
                    catch (Exception e) {
                        log.error("Error constructing entity registry plugin class: {}", (Object)config.getClassName(), (Object)e);
                        return null;
                    }
                }).filter(Objects::nonNull).filter(PluginSpec::enabled).collect(Collectors.toList());
                if (scanResult != null) {
                    scanResult.close();
                }
                return list;
            }
            catch (Throwable throwable) {
                try {
                    if (scanResult != null) {
                        try {
                            scanResult.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("Failed to load entity registry plugins: %s.", baseClazz.getName()), e);
                }
            }
        });
    }

    @Nonnull
    public List<AspectPayloadValidator> getAspectPayloadValidators(@Nonnull ChangeType changeType, @Nonnull String entityName, @Nonnull String aspectName) {
        return this.aspectPayloadValidators.stream().filter(plugin -> plugin.shouldApply(changeType, entityName, aspectName)).collect(Collectors.toList());
    }

    @Nonnull
    public List<MutationHook> getMutationHooks(@Nonnull ChangeType changeType, @Nonnull String entityName, @Nonnull String aspectName) {
        return this.mutationHooks.stream().filter(plugin -> plugin.shouldApply(changeType, entityName, aspectName)).collect(Collectors.toList());
    }

    @Nonnull
    public List<MCPSideEffect> getMCPSideEffects(@Nonnull ChangeType changeType, @Nonnull String entityName, @Nonnull String aspectName) {
        return this.mcpSideEffects.stream().filter(plugin -> plugin.shouldApply(changeType, entityName, aspectName)).collect(Collectors.toList());
    }

    @Nonnull
    public List<MCLSideEffect> getMCLSideEffects(@Nonnull ChangeType changeType, @Nonnull String entityName, @Nonnull String aspectName) {
        return this.mclSideEffects.stream().filter(plugin -> plugin.shouldApply(changeType, entityName, aspectName)).collect(Collectors.toList());
    }

    @Nonnull
    public EntityRegistryLoadResult.PluginLoadResult getPluginLoadResult() {
        return EntityRegistryLoadResult.PluginLoadResult.builder().validatorCount(this.aspectPayloadValidators.size()).mutationHookCount(this.mutationHooks.size()).mcpSideEffectCount(this.mcpSideEffects.size()).mclSideEffectCount(this.mclSideEffects.size()).validatorClasses(this.aspectPayloadValidators.stream().map(cls -> cls.getClass().getName()).collect(Collectors.toSet())).mutationHookClasses(this.mutationHooks.stream().map(cls -> cls.getClass().getName()).collect(Collectors.toSet())).mcpSideEffectClasses(this.mcpSideEffects.stream().map(cls -> cls.getClass().getName()).collect(Collectors.toSet())).mclSideEffectClasses(this.mclSideEffects.stream().map(cls -> cls.getClass().getName()).collect(Collectors.toSet())).build();
    }

    private List<AspectPayloadValidator> buildAspectPayloadValidators(@Nullable PluginConfiguration pluginConfiguration) {
        return pluginConfiguration == null ? Collections.emptyList() : PluginFactory.applyDisable(this.build(AspectPayloadValidator.class, pluginConfiguration.validatorPackages(), pluginConfiguration.getAspectPayloadValidators()));
    }

    private List<MutationHook> buildMutationHooks(@Nullable PluginConfiguration pluginConfiguration) {
        return pluginConfiguration == null ? Collections.emptyList() : PluginFactory.applyDisable(this.build(MutationHook.class, pluginConfiguration.mutationPackages(), pluginConfiguration.getMutationHooks()));
    }

    private List<MCLSideEffect> buildMCLSideEffects(@Nullable PluginConfiguration pluginConfiguration) {
        return pluginConfiguration == null ? Collections.emptyList() : PluginFactory.applyDisable(this.build(MCLSideEffect.class, pluginConfiguration.mclSideEffectPackages(), pluginConfiguration.getMclSideEffects()));
    }

    private List<MCPSideEffect> buildMCPSideEffects(@Nullable PluginConfiguration pluginConfiguration) {
        return pluginConfiguration == null ? Collections.emptyList() : PluginFactory.applyDisable(this.build(MCPSideEffect.class, pluginConfiguration.mcpSideEffectPackages(), pluginConfiguration.getMcpSideEffects()));
    }

    protected <T extends PluginSpec> List<T> build(Class<?> baseClazz, List<String> packageNames, List<AspectPluginConfig> configs) {
        List<AspectPluginConfig> nonSpringConfigs = configs.stream().filter(config -> config.getSpring() == null || Boolean.FALSE.equals(config.getSpring().isEnabled())).collect(Collectors.toList());
        return PluginFactory.initPlugins(this.classLoaders, baseClazz, packageNames, nonSpringConfigs);
    }

    @Nonnull
    private static <T extends PluginSpec> List<T> applyDisable(@Nonnull List<T> plugins) {
        return IntStream.range(0, plugins.size()).mapToObj(idx -> {
            List subsequentPlugins = plugins.subList(idx + 1, plugins.size());
            PluginSpec thisPlugin = (PluginSpec)plugins.get(idx);
            AspectPluginConfig thisPluginConfig = thisPlugin.getConfig();
            if (subsequentPlugins.stream().anyMatch(otherPlugin -> thisPluginConfig.isDisabledBy(otherPlugin.getConfig()))) {
                return null;
            }
            return thisPlugin;
        }).filter(Objects::nonNull).filter(p -> p.getConfig().isEnabled()).collect(Collectors.toList());
    }

    @Generated
    public PluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    @Nonnull
    @Generated
    public List<ClassLoader> getClassLoaders() {
        return this.classLoaders;
    }

    @Generated
    public List<AspectPayloadValidator> getAspectPayloadValidators() {
        return this.aspectPayloadValidators;
    }

    @Generated
    public List<MutationHook> getMutationHooks() {
        return this.mutationHooks;
    }

    @Generated
    public List<MCLSideEffect> getMclSideEffects() {
        return this.mclSideEffects;
    }

    @Generated
    public List<MCPSideEffect> getMcpSideEffects() {
        return this.mcpSideEffects;
    }
}

