/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.patch.builder;

import com.linkedin.common.TimeStamp;
import com.linkedin.common.urn.DataFlowUrn;
import com.linkedin.metadata.aspect.patch.PatchOperationType;
import com.linkedin.metadata.aspect.patch.builder.AbstractMultiFieldPatchBuilder;
import com.linkedin.metadata.aspect.patch.builder.CustomPropertiesPatchBuilder;
import com.linkedin.metadata.aspect.patch.builder.subtypesupport.CustomPropertiesPatchBuilderSupport;
import datahub.shaded.jackson.databind.node.JsonNodeFactory;
import datahub.shaded.jackson.databind.node.ObjectNode;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public class DataJobInfoPatchBuilder
extends AbstractMultiFieldPatchBuilder<DataJobInfoPatchBuilder>
implements CustomPropertiesPatchBuilderSupport<DataJobInfoPatchBuilder> {
    public static final String BASE_PATH = "/";
    public static final String NAME_KEY = "name";
    public static final String DESCRIPTION_KEY = "description";
    public static final String FLOW_URN_KEY = "flowUrn";
    public static final String CREATED_KEY = "created";
    public static final String LAST_MODIFIED_KEY = "lastModified";
    public static final String TIME_KEY = "time";
    public static final String ACTOR_KEY = "actor";
    public static final String TYPE_KEY = "type";
    public static final String CUSTOM_PROPERTIES_KEY = "customProperties";
    private CustomPropertiesPatchBuilder<DataJobInfoPatchBuilder> customPropertiesPatchBuilder = new CustomPropertiesPatchBuilder<DataJobInfoPatchBuilder>(this);

    public DataJobInfoPatchBuilder setName(@Nonnull String name) {
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/name", JsonNodeFactory.instance.textNode(name)));
        return this;
    }

    public DataJobInfoPatchBuilder setDescription(@Nullable String description) {
        if (description == null) {
            this.pathValues.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), "/description", null));
        } else {
            this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/description", JsonNodeFactory.instance.textNode(description)));
        }
        return this;
    }

    public DataJobInfoPatchBuilder setType(@Nonnull String type) {
        ObjectNode union = JsonNodeFactory.instance.objectNode();
        union.set("string", JsonNodeFactory.instance.textNode(type));
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/type", union));
        return this;
    }

    public DataJobInfoPatchBuilder setFlowUrn(@Nullable DataFlowUrn flowUrn) {
        if (flowUrn == null) {
            this.pathValues.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), "/flowUrn", null));
        } else {
            this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/flowUrn", JsonNodeFactory.instance.textNode(flowUrn.toString())));
        }
        return this;
    }

    public DataJobInfoPatchBuilder setCreated(@Nullable TimeStamp created) {
        if (created == null) {
            this.pathValues.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), "/created", null));
        } else {
            ObjectNode createdNode = JsonNodeFactory.instance.objectNode();
            createdNode.put(TIME_KEY, created.getTime());
            if (created.getActor() != null) {
                createdNode.put(ACTOR_KEY, created.getActor().toString());
            }
            this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/created", createdNode));
        }
        return this;
    }

    public DataJobInfoPatchBuilder setLastModified(@Nullable TimeStamp lastModified) {
        if (lastModified == null) {
            this.pathValues.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), "/lastModified", null));
        } else {
            ObjectNode lastModifiedNode = JsonNodeFactory.instance.objectNode();
            lastModifiedNode.put(TIME_KEY, lastModified.getTime());
            if (lastModified.getActor() != null) {
                lastModifiedNode.put(ACTOR_KEY, lastModified.getActor().toString());
            }
            this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/lastModified", lastModifiedNode));
        }
        return this;
    }

    @Override
    protected String getAspectName() {
        return "dataJobInfo";
    }

    @Override
    protected String getEntityType() {
        return "dataJob";
    }

    @Override
    public DataJobInfoPatchBuilder addCustomProperty(@Nonnull String key, @Nonnull String value) {
        this.customPropertiesPatchBuilder.addProperty(key, value);
        return this;
    }

    @Override
    public DataJobInfoPatchBuilder removeCustomProperty(@Nonnull String key) {
        this.customPropertiesPatchBuilder.removeProperty(key);
        return this;
    }

    @Override
    public DataJobInfoPatchBuilder setCustomProperties(Map<String, String> properties) {
        this.customPropertiesPatchBuilder.setProperties(properties);
        return this;
    }
}

