/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.metadata.models.AspectSpec;
import com.linkedin.metadata.models.EntitySpec;
import com.linkedin.mxe.GenericAspect;
import com.linkedin.mxe.SystemMetadata;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ReadItem {
    @Nonnull
    public Urn getUrn();

    @Nonnull
    default public String getAspectName() {
        if (this.getAspectSpec() == null) {
            return GenericAspect.dataSchema().getName();
        }
        return this.getAspectSpec().getName();
    }

    @Nullable
    public RecordTemplate getRecordTemplate();

    @Nullable
    default public <T> T getAspect(Class<T> clazz) {
        return ReadItem.getAspect(clazz, this.getRecordTemplate());
    }

    public static <T> T getAspect(Class<T> clazz, @Nullable RecordTemplate recordTemplate) {
        if (recordTemplate != null) {
            try {
                return clazz.getConstructor(DataMap.class).newInstance(recordTemplate.data());
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Nullable
    public SystemMetadata getSystemMetadata();

    @Nonnull
    public EntitySpec getEntitySpec();

    @Nullable
    public AspectSpec getAspectSpec();
}

