/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.identity;

import com.linkedin.common.urn.CorpuserUrn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CorpUserInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.identity/**Linkedin corp user information*/@Aspect={\"EntityUrns\":[\"com.linkedin.common.CorpuserUrn\"],\"name\":\"corpUserInfo\"}record CorpUserInfo includes{namespace com.linkedin.common/**Misc. properties about an entity.*/record CustomProperties{/**Custom property bag.*/@Searchable.`/*`={\"fieldType\":\"TEXT\",\"queryByDefault\":true}customProperties:map[string,string]={}}}{/**Deprecated! Use CorpUserStatus instead. Whether the corpUser is active, ref: https://iwww.corp.linkedin.com/wiki/cf/display/GTSD/Accessing+Active+Directory+via+LDAP+tools*/@Searchable={\"fieldType\":\"BOOLEAN\",\"weightsPerFieldValue\":{\"true\":2.0}}active:boolean/**displayName of this user ,  e.g.  Hang Zhang(DataHQ)*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\",\"queryByDefault\":true,\"searchLabel\":\"entityName\",\"searchTier\":1}displayName:optional string/**email address of this user*/@Searchable={\"fieldType\":\"KEYWORD\",\"queryByDefault\":true,\"searchTier\":1}email:optional{namespace com.linkedin.common,typeref EmailAddress=string}/**title of this user*/@Searchable={\"fieldType\":\"KEYWORD\",\"queryByDefault\":true}title:optional string/**direct manager of this user*/@Relationship={\"entityTypes\":[\"corpuser\"],\"name\":\"ReportsTo\"}@Searchable={\"fieldName\":\"managerLdap\",\"fieldType\":\"URN\",\"queryByDefault\":false}managerUrn:optional{namespace com.linkedin.common/**Corporate user's AD/LDAP login*/@java.class=\"com.linkedin.common.urn.CorpuserUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Corporate user's AD/LDAP login\",\"entityType\":\"corpuser\",\"fields\":[{\"doc\":\"The name of the AD/LDAP user.\",\"maxLength\":20,\"name\":\"username\",\"type\":\"string\"}],\"maxLength\":36,\"name\":\"Corpuser\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:security\"}typeref CorpuserUrn=string}/**department id this user belong to*/departmentId:optional long/**department name this user belong to*/departmentName:optional string/**first name of this user*/firstName:optional string/**last name of this user*/lastName:optional string/**Common name of this user, format is firstName + lastName (split by a whitespace)*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldType\":\"WORD_GRAM\",\"queryByDefault\":true}fullName:optional string/**two uppercase letters country code. e.g.  US*/countryCode:optional string/**Whether the corpUser is a system user.*/@Searchable={\"fieldType\":\"BOOLEAN\",\"queryByDefault\":false}system:optional boolean=false}", SchemaFormatType.PDL);
    private StringMap _customPropertiesField = null;
    private Boolean _activeField = null;
    private String _displayNameField = null;
    private String _emailField = null;
    private String _titleField = null;
    private CorpuserUrn _managerUrnField = null;
    private Long _departmentIdField = null;
    private String _departmentNameField = null;
    private String _firstNameField = null;
    private String _lastNameField = null;
    private String _fullNameField = null;
    private String _countryCodeField = null;
    private Boolean _systemField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_CustomProperties = SCHEMA.getField("customProperties");
    private static final StringMap DEFAULT_CustomProperties;
    private static final RecordDataSchema.Field FIELD_Active;
    private static final RecordDataSchema.Field FIELD_DisplayName;
    private static final RecordDataSchema.Field FIELD_Email;
    private static final RecordDataSchema.Field FIELD_Title;
    private static final RecordDataSchema.Field FIELD_ManagerUrn;
    private static final RecordDataSchema.Field FIELD_DepartmentId;
    private static final RecordDataSchema.Field FIELD_DepartmentName;
    private static final RecordDataSchema.Field FIELD_FirstName;
    private static final RecordDataSchema.Field FIELD_LastName;
    private static final RecordDataSchema.Field FIELD_FullName;
    private static final RecordDataSchema.Field FIELD_CountryCode;
    private static final RecordDataSchema.Field FIELD_System;
    private static final Boolean DEFAULT_System;

    public CorpUserInfo() {
        super(new DataMap(), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public CorpUserInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasCustomProperties() {
        if (this._customPropertiesField != null) {
            return true;
        }
        return this._map.containsKey("customProperties");
    }

    public void removeCustomProperties() {
        this._map.remove("customProperties");
    }

    @Nullable
    public StringMap getCustomProperties(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getCustomProperties();
            }
            case NULL: {
                if (this._customPropertiesField != null) {
                    return this._customPropertiesField;
                }
                Object __rawValue = this._map.get("customProperties");
                this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._customPropertiesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringMap getCustomProperties() {
        if (this._customPropertiesField != null) {
            return this._customPropertiesField;
        }
        Object __rawValue = this._map.get("customProperties");
        if (__rawValue == null) {
            return DEFAULT_CustomProperties;
        }
        this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._customPropertiesField;
    }

    public CorpUserInfo setCustomProperties(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCustomProperties(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field customProperties of com.linkedin.identity.CorpUserInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCustomProperties();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
            }
        }
        return this;
    }

    public CorpUserInfo setCustomProperties(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field customProperties of com.linkedin.identity.CorpUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
        this._customPropertiesField = value;
        return this;
    }

    public boolean hasActive() {
        if (this._activeField != null) {
            return true;
        }
        return this._map.containsKey("active");
    }

    public void removeActive() {
        this._map.remove("active");
    }

    @Nullable
    public Boolean isActive(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.isActive();
            }
            case DEFAULT: 
            case NULL: {
                if (this._activeField != null) {
                    return this._activeField;
                }
                Object __rawValue = this._map.get("active");
                this._activeField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._activeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isActive() {
        if (this._activeField != null) {
            return this._activeField;
        }
        Object __rawValue = this._map.get("active");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("active");
        }
        this._activeField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._activeField;
    }

    public CorpUserInfo setActive(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setActive(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field active of com.linkedin.identity.CorpUserInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "active", value);
                this._activeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeActive();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "active", value);
                this._activeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "active", value);
                this._activeField = value;
            }
        }
        return this;
    }

    public CorpUserInfo setActive(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field active of com.linkedin.identity.CorpUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "active", value);
        this._activeField = value;
        return this;
    }

    public CorpUserInfo setActive(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "active", value);
        this._activeField = value;
        return this;
    }

    public boolean hasDisplayName() {
        if (this._displayNameField != null) {
            return true;
        }
        return this._map.containsKey("displayName");
    }

    public void removeDisplayName() {
        this._map.remove("displayName");
    }

    @Nullable
    public String getDisplayName(GetMode mode) {
        return this.getDisplayName();
    }

    @Nullable
    public String getDisplayName() {
        if (this._displayNameField != null) {
            return this._displayNameField;
        }
        Object __rawValue = this._map.get("displayName");
        this._displayNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._displayNameField;
    }

    public CorpUserInfo setDisplayName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDisplayName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDisplayName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "displayName", value);
                this._displayNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "displayName", value);
                this._displayNameField = value;
            }
        }
        return this;
    }

    public CorpUserInfo setDisplayName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field displayName of com.linkedin.identity.CorpUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "displayName", value);
        this._displayNameField = value;
        return this;
    }

    public boolean hasEmail() {
        if (this._emailField != null) {
            return true;
        }
        return this._map.containsKey("email");
    }

    public void removeEmail() {
        this._map.remove("email");
    }

    @Nullable
    public String getEmail(GetMode mode) {
        return this.getEmail();
    }

    @Nullable
    public String getEmail() {
        if (this._emailField != null) {
            return this._emailField;
        }
        Object __rawValue = this._map.get("email");
        this._emailField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._emailField;
    }

    public CorpUserInfo setEmail(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEmail(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEmail();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "email", value);
                this._emailField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "email", value);
                this._emailField = value;
            }
        }
        return this;
    }

    public CorpUserInfo setEmail(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field email of com.linkedin.identity.CorpUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "email", value);
        this._emailField = value;
        return this;
    }

    public boolean hasTitle() {
        if (this._titleField != null) {
            return true;
        }
        return this._map.containsKey("title");
    }

    public void removeTitle() {
        this._map.remove("title");
    }

    @Nullable
    public String getTitle(GetMode mode) {
        return this.getTitle();
    }

    @Nullable
    public String getTitle() {
        if (this._titleField != null) {
            return this._titleField;
        }
        Object __rawValue = this._map.get("title");
        this._titleField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._titleField;
    }

    public CorpUserInfo setTitle(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTitle(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTitle();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "title", value);
                this._titleField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "title", value);
                this._titleField = value;
            }
        }
        return this;
    }

    public CorpUserInfo setTitle(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field title of com.linkedin.identity.CorpUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "title", value);
        this._titleField = value;
        return this;
    }

    public boolean hasManagerUrn() {
        if (this._managerUrnField != null) {
            return true;
        }
        return this._map.containsKey("managerUrn");
    }

    public void removeManagerUrn() {
        this._map.remove("managerUrn");
    }

    @Nullable
    public CorpuserUrn getManagerUrn(GetMode mode) {
        return this.getManagerUrn();
    }

    @Nullable
    public CorpuserUrn getManagerUrn() {
        if (this._managerUrnField != null) {
            return this._managerUrnField;
        }
        Object __rawValue = this._map.get("managerUrn");
        this._managerUrnField = DataTemplateUtil.coerceCustomOutput(__rawValue, CorpuserUrn.class);
        return this._managerUrnField;
    }

    public CorpUserInfo setManagerUrn(@Nullable CorpuserUrn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setManagerUrn(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeManagerUrn();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "managerUrn", DataTemplateUtil.coerceCustomInput(value, CorpuserUrn.class));
                this._managerUrnField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "managerUrn", DataTemplateUtil.coerceCustomInput(value, CorpuserUrn.class));
                this._managerUrnField = value;
            }
        }
        return this;
    }

    public CorpUserInfo setManagerUrn(@Nonnull CorpuserUrn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field managerUrn of com.linkedin.identity.CorpUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "managerUrn", DataTemplateUtil.coerceCustomInput(value, CorpuserUrn.class));
        this._managerUrnField = value;
        return this;
    }

    public boolean hasDepartmentId() {
        if (this._departmentIdField != null) {
            return true;
        }
        return this._map.containsKey("departmentId");
    }

    public void removeDepartmentId() {
        this._map.remove("departmentId");
    }

    @Nullable
    public Long getDepartmentId(GetMode mode) {
        return this.getDepartmentId();
    }

    @Nullable
    public Long getDepartmentId() {
        if (this._departmentIdField != null) {
            return this._departmentIdField;
        }
        Object __rawValue = this._map.get("departmentId");
        this._departmentIdField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._departmentIdField;
    }

    public CorpUserInfo setDepartmentId(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDepartmentId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDepartmentId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "departmentId", DataTemplateUtil.coerceLongInput(value));
                this._departmentIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "departmentId", DataTemplateUtil.coerceLongInput(value));
                this._departmentIdField = value;
            }
        }
        return this;
    }

    public CorpUserInfo setDepartmentId(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field departmentId of com.linkedin.identity.CorpUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "departmentId", DataTemplateUtil.coerceLongInput(value));
        this._departmentIdField = value;
        return this;
    }

    public CorpUserInfo setDepartmentId(long value) {
        CheckedUtil.putWithoutChecking(this._map, "departmentId", DataTemplateUtil.coerceLongInput(value));
        this._departmentIdField = value;
        return this;
    }

    public boolean hasDepartmentName() {
        if (this._departmentNameField != null) {
            return true;
        }
        return this._map.containsKey("departmentName");
    }

    public void removeDepartmentName() {
        this._map.remove("departmentName");
    }

    @Nullable
    public String getDepartmentName(GetMode mode) {
        return this.getDepartmentName();
    }

    @Nullable
    public String getDepartmentName() {
        if (this._departmentNameField != null) {
            return this._departmentNameField;
        }
        Object __rawValue = this._map.get("departmentName");
        this._departmentNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._departmentNameField;
    }

    public CorpUserInfo setDepartmentName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDepartmentName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDepartmentName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "departmentName", value);
                this._departmentNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "departmentName", value);
                this._departmentNameField = value;
            }
        }
        return this;
    }

    public CorpUserInfo setDepartmentName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field departmentName of com.linkedin.identity.CorpUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "departmentName", value);
        this._departmentNameField = value;
        return this;
    }

    public boolean hasFirstName() {
        if (this._firstNameField != null) {
            return true;
        }
        return this._map.containsKey("firstName");
    }

    public void removeFirstName() {
        this._map.remove("firstName");
    }

    @Nullable
    public String getFirstName(GetMode mode) {
        return this.getFirstName();
    }

    @Nullable
    public String getFirstName() {
        if (this._firstNameField != null) {
            return this._firstNameField;
        }
        Object __rawValue = this._map.get("firstName");
        this._firstNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._firstNameField;
    }

    public CorpUserInfo setFirstName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFirstName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFirstName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "firstName", value);
                this._firstNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "firstName", value);
                this._firstNameField = value;
            }
        }
        return this;
    }

    public CorpUserInfo setFirstName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field firstName of com.linkedin.identity.CorpUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "firstName", value);
        this._firstNameField = value;
        return this;
    }

    public boolean hasLastName() {
        if (this._lastNameField != null) {
            return true;
        }
        return this._map.containsKey("lastName");
    }

    public void removeLastName() {
        this._map.remove("lastName");
    }

    @Nullable
    public String getLastName(GetMode mode) {
        return this.getLastName();
    }

    @Nullable
    public String getLastName() {
        if (this._lastNameField != null) {
            return this._lastNameField;
        }
        Object __rawValue = this._map.get("lastName");
        this._lastNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._lastNameField;
    }

    public CorpUserInfo setLastName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastName", value);
                this._lastNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastName", value);
                this._lastNameField = value;
            }
        }
        return this;
    }

    public CorpUserInfo setLastName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastName of com.linkedin.identity.CorpUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastName", value);
        this._lastNameField = value;
        return this;
    }

    public boolean hasFullName() {
        if (this._fullNameField != null) {
            return true;
        }
        return this._map.containsKey("fullName");
    }

    public void removeFullName() {
        this._map.remove("fullName");
    }

    @Nullable
    public String getFullName(GetMode mode) {
        return this.getFullName();
    }

    @Nullable
    public String getFullName() {
        if (this._fullNameField != null) {
            return this._fullNameField;
        }
        Object __rawValue = this._map.get("fullName");
        this._fullNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._fullNameField;
    }

    public CorpUserInfo setFullName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFullName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFullName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "fullName", value);
                this._fullNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "fullName", value);
                this._fullNameField = value;
            }
        }
        return this;
    }

    public CorpUserInfo setFullName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field fullName of com.linkedin.identity.CorpUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "fullName", value);
        this._fullNameField = value;
        return this;
    }

    public boolean hasCountryCode() {
        if (this._countryCodeField != null) {
            return true;
        }
        return this._map.containsKey("countryCode");
    }

    public void removeCountryCode() {
        this._map.remove("countryCode");
    }

    @Nullable
    public String getCountryCode(GetMode mode) {
        return this.getCountryCode();
    }

    @Nullable
    public String getCountryCode() {
        if (this._countryCodeField != null) {
            return this._countryCodeField;
        }
        Object __rawValue = this._map.get("countryCode");
        this._countryCodeField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._countryCodeField;
    }

    public CorpUserInfo setCountryCode(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCountryCode(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCountryCode();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "countryCode", value);
                this._countryCodeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "countryCode", value);
                this._countryCodeField = value;
            }
        }
        return this;
    }

    public CorpUserInfo setCountryCode(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field countryCode of com.linkedin.identity.CorpUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "countryCode", value);
        this._countryCodeField = value;
        return this;
    }

    public boolean hasSystem() {
        if (this._systemField != null) {
            return true;
        }
        return this._map.containsKey("system");
    }

    public void removeSystem() {
        this._map.remove("system");
    }

    @Nullable
    public Boolean isSystem(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isSystem();
            }
            case NULL: {
                if (this._systemField != null) {
                    return this._systemField;
                }
                Object __rawValue = this._map.get("system");
                this._systemField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._systemField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nullable
    public Boolean isSystem() {
        if (this._systemField != null) {
            return this._systemField;
        }
        Object __rawValue = this._map.get("system");
        if (__rawValue == null) {
            return DEFAULT_System;
        }
        this._systemField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._systemField;
    }

    public CorpUserInfo setSystem(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSystem(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSystem();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "system", value);
                this._systemField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "system", value);
                this._systemField = value;
            }
        }
        return this;
    }

    public CorpUserInfo setSystem(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field system of com.linkedin.identity.CorpUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "system", value);
        this._systemField = value;
        return this;
    }

    public CorpUserInfo setSystem(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "system", value);
        this._systemField = value;
        return this;
    }

    @Override
    public CorpUserInfo clone() throws CloneNotSupportedException {
        CorpUserInfo __clone = (CorpUserInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public CorpUserInfo copy() throws CloneNotSupportedException {
        CorpUserInfo __copy = (CorpUserInfo)super.copy();
        __copy._departmentNameField = null;
        __copy._lastNameField = null;
        __copy._displayNameField = null;
        __copy._departmentIdField = null;
        __copy._activeField = null;
        __copy._fullNameField = null;
        __copy._titleField = null;
        __copy._firstNameField = null;
        __copy._customPropertiesField = null;
        __copy._systemField = null;
        __copy._countryCodeField = null;
        __copy._managerUrnField = null;
        __copy._emailField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_Active = SCHEMA.getField("active");
        FIELD_DisplayName = SCHEMA.getField("displayName");
        FIELD_Email = SCHEMA.getField("email");
        FIELD_Title = SCHEMA.getField("title");
        FIELD_ManagerUrn = SCHEMA.getField("managerUrn");
        FIELD_DepartmentId = SCHEMA.getField("departmentId");
        FIELD_DepartmentName = SCHEMA.getField("departmentName");
        FIELD_FirstName = SCHEMA.getField("firstName");
        FIELD_LastName = SCHEMA.getField("lastName");
        FIELD_FullName = SCHEMA.getField("fullName");
        FIELD_CountryCode = SCHEMA.getField("countryCode");
        FIELD_System = SCHEMA.getField("system");
        Custom.initializeCustomClass(CorpuserUrn.class);
        DEFAULT_CustomProperties = FIELD_CustomProperties.getDefault() == null ? null : new StringMap(DataTemplateUtil.castOrThrow(FIELD_CustomProperties.getDefault(), DataMap.class));
        DEFAULT_System = DataTemplateUtil.coerceBooleanOutput(FIELD_System.getDefault());
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final CorpUserInfo __objectRef;

        private ChangeListener(CorpUserInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "departmentName": {
                    this.__objectRef._departmentNameField = null;
                    break;
                }
                case "lastName": {
                    this.__objectRef._lastNameField = null;
                    break;
                }
                case "displayName": {
                    this.__objectRef._displayNameField = null;
                    break;
                }
                case "departmentId": {
                    this.__objectRef._departmentIdField = null;
                    break;
                }
                case "active": {
                    this.__objectRef._activeField = null;
                    break;
                }
                case "fullName": {
                    this.__objectRef._fullNameField = null;
                    break;
                }
                case "title": {
                    this.__objectRef._titleField = null;
                    break;
                }
                case "firstName": {
                    this.__objectRef._firstNameField = null;
                    break;
                }
                case "customProperties": {
                    this.__objectRef._customPropertiesField = null;
                    break;
                }
                case "system": {
                    this.__objectRef._systemField = null;
                    break;
                }
                case "countryCode": {
                    this.__objectRef._countryCodeField = null;
                    break;
                }
                case "managerUrn": {
                    this.__objectRef._managerUrnField = null;
                    break;
                }
                case "email": {
                    this.__objectRef._emailField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec customProperties() {
            return new PathSpec(this.getPathComponents(), "customProperties");
        }

        public PathSpec active() {
            return new PathSpec(this.getPathComponents(), "active");
        }

        public PathSpec displayName() {
            return new PathSpec(this.getPathComponents(), "displayName");
        }

        public PathSpec email() {
            return new PathSpec(this.getPathComponents(), "email");
        }

        public PathSpec title() {
            return new PathSpec(this.getPathComponents(), "title");
        }

        public PathSpec managerUrn() {
            return new PathSpec(this.getPathComponents(), "managerUrn");
        }

        public PathSpec departmentId() {
            return new PathSpec(this.getPathComponents(), "departmentId");
        }

        public PathSpec departmentName() {
            return new PathSpec(this.getPathComponents(), "departmentName");
        }

        public PathSpec firstName() {
            return new PathSpec(this.getPathComponents(), "firstName");
        }

        public PathSpec lastName() {
            return new PathSpec(this.getPathComponents(), "lastName");
        }

        public PathSpec fullName() {
            return new PathSpec(this.getPathComponents(), "fullName");
        }

        public PathSpec countryCode() {
            return new PathSpec(this.getPathComponents(), "countryCode");
        }

        public PathSpec system() {
            return new PathSpec(this.getPathComponents(), "system");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
        }

        public ProjectionMask withCustomProperties() {
            this.getDataMap().put("customProperties", 1);
            return this;
        }

        public ProjectionMask withActive() {
            this.getDataMap().put("active", 1);
            return this;
        }

        public ProjectionMask withDisplayName() {
            this.getDataMap().put("displayName", 1);
            return this;
        }

        public ProjectionMask withEmail() {
            this.getDataMap().put("email", 1);
            return this;
        }

        public ProjectionMask withTitle() {
            this.getDataMap().put("title", 1);
            return this;
        }

        public ProjectionMask withManagerUrn() {
            this.getDataMap().put("managerUrn", 1);
            return this;
        }

        public ProjectionMask withDepartmentId() {
            this.getDataMap().put("departmentId", 1);
            return this;
        }

        public ProjectionMask withDepartmentName() {
            this.getDataMap().put("departmentName", 1);
            return this;
        }

        public ProjectionMask withFirstName() {
            this.getDataMap().put("firstName", 1);
            return this;
        }

        public ProjectionMask withLastName() {
            this.getDataMap().put("lastName", 1);
            return this;
        }

        public ProjectionMask withFullName() {
            this.getDataMap().put("fullName", 1);
            return this;
        }

        public ProjectionMask withCountryCode() {
            this.getDataMap().put("countryCode", 1);
            return this;
        }

        public ProjectionMask withSystem() {
            this.getDataMap().put("system", 1);
            return this;
        }
    }
}

