/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.file;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BucketStorageLocation
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.file/**Information where a file is stored*/record BucketStorageLocation{/**The storage bucket this file is stored in*/@Searchable.fieldType=\"KEYWORD\"storageBucket:string/**The key for where this file is stored inside of the given bucket*/@Searchable.fieldType=\"KEYWORD\"storageKey:string}", SchemaFormatType.PDL);
    private String _storageBucketField = null;
    private String _storageKeyField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_StorageBucket = SCHEMA.getField("storageBucket");
    private static final RecordDataSchema.Field FIELD_StorageKey = SCHEMA.getField("storageKey");

    public BucketStorageLocation() {
        super(new DataMap(3, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public BucketStorageLocation(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasStorageBucket() {
        if (this._storageBucketField != null) {
            return true;
        }
        return this._map.containsKey("storageBucket");
    }

    public void removeStorageBucket() {
        this._map.remove("storageBucket");
    }

    @Nullable
    public String getStorageBucket(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getStorageBucket();
            }
            case DEFAULT: 
            case NULL: {
                if (this._storageBucketField != null) {
                    return this._storageBucketField;
                }
                Object __rawValue = this._map.get("storageBucket");
                this._storageBucketField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._storageBucketField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getStorageBucket() {
        if (this._storageBucketField != null) {
            return this._storageBucketField;
        }
        Object __rawValue = this._map.get("storageBucket");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("storageBucket");
        }
        this._storageBucketField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._storageBucketField;
    }

    public BucketStorageLocation setStorageBucket(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setStorageBucket(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field storageBucket of com.linkedin.file.BucketStorageLocation");
                }
                CheckedUtil.putWithoutChecking(this._map, "storageBucket", value);
                this._storageBucketField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeStorageBucket();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "storageBucket", value);
                this._storageBucketField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "storageBucket", value);
                this._storageBucketField = value;
            }
        }
        return this;
    }

    public BucketStorageLocation setStorageBucket(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field storageBucket of com.linkedin.file.BucketStorageLocation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "storageBucket", value);
        this._storageBucketField = value;
        return this;
    }

    public boolean hasStorageKey() {
        if (this._storageKeyField != null) {
            return true;
        }
        return this._map.containsKey("storageKey");
    }

    public void removeStorageKey() {
        this._map.remove("storageKey");
    }

    @Nullable
    public String getStorageKey(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getStorageKey();
            }
            case DEFAULT: 
            case NULL: {
                if (this._storageKeyField != null) {
                    return this._storageKeyField;
                }
                Object __rawValue = this._map.get("storageKey");
                this._storageKeyField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._storageKeyField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getStorageKey() {
        if (this._storageKeyField != null) {
            return this._storageKeyField;
        }
        Object __rawValue = this._map.get("storageKey");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("storageKey");
        }
        this._storageKeyField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._storageKeyField;
    }

    public BucketStorageLocation setStorageKey(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setStorageKey(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field storageKey of com.linkedin.file.BucketStorageLocation");
                }
                CheckedUtil.putWithoutChecking(this._map, "storageKey", value);
                this._storageKeyField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeStorageKey();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "storageKey", value);
                this._storageKeyField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "storageKey", value);
                this._storageKeyField = value;
            }
        }
        return this;
    }

    public BucketStorageLocation setStorageKey(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field storageKey of com.linkedin.file.BucketStorageLocation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "storageKey", value);
        this._storageKeyField = value;
        return this;
    }

    @Override
    public BucketStorageLocation clone() throws CloneNotSupportedException {
        BucketStorageLocation __clone = (BucketStorageLocation)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public BucketStorageLocation copy() throws CloneNotSupportedException {
        BucketStorageLocation __copy = (BucketStorageLocation)super.copy();
        __copy._storageBucketField = null;
        __copy._storageKeyField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final BucketStorageLocation __objectRef;

        private ChangeListener(BucketStorageLocation reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "storageBucket": {
                    this.__objectRef._storageBucketField = null;
                    break;
                }
                case "storageKey": {
                    this.__objectRef._storageKeyField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec storageBucket() {
            return new PathSpec(this.getPathComponents(), "storageBucket");
        }

        public PathSpec storageKey() {
            return new PathSpec(this.getPathComponents(), "storageKey");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withStorageBucket() {
            this.getDataMap().put("storageBucket", 1);
            return this;
        }

        public ProjectionMask withStorageKey() {
            this.getDataMap().put("storageKey", 1);
            return this;
        }
    }
}

