/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataplatform.slack;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SlackUserInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.dataplatform.slack/**Information about a Slack user.*/@Aspect.name=\"slackUserInfo\"record SlackUserInfo{/**The dataplatform instance that this Slack member belongs to.*/@Relationship={\"entityTypes\":[\"dataPlatformInstance\"],\"name\":\"PartOfSlackWorkspace\"}slackInstance:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**The unique identifier for the Slack member.*/id:string/**The username of the Slack member.*/name:string/**The real name of the Slack member.*/realName:string/**The display name of the Slack member.*/displayName:string/**The email associated with the Slack member.*/email:optional string/**The ID associated with the Slack team.*/teamId:string/**Whether the member is deleted or not.*/isDeleted:boolean/**Whether the member is an admin.*/isAdmin:boolean/**Whether the member is an owner.*/isOwner:boolean/**Whether the member is a primary owner.*/isPrimaryOwner:boolean/**Whether the member is a bot.*/isBot:boolean/**The timezone of the Slack member.*/timezone:optional string/**The timezone offset of the Slack member.*/timezoneOffset:optional int/**The title of the Slack member.*/title:optional string/**The phone number of the Slack member.*/phone:optional string/**The URL of the member's profile picture.*/profilePictureUrl:optional string/**The status text of the Slack member.*/statusText:optional string/**The status emoji of the Slack member.*/statusEmoji:optional string/**The timestamp of when the member was last updated. (in seconds)*/lastUpdatedSeconds:optional long}", SchemaFormatType.PDL);
    private Urn _slackInstanceField = null;
    private String _idField = null;
    private String _nameField = null;
    private String _realNameField = null;
    private String _displayNameField = null;
    private String _emailField = null;
    private String _teamIdField = null;
    private Boolean _isDeletedField = null;
    private Boolean _isAdminField = null;
    private Boolean _isOwnerField = null;
    private Boolean _isPrimaryOwnerField = null;
    private Boolean _isBotField = null;
    private String _timezoneField = null;
    private Integer _timezoneOffsetField = null;
    private String _titleField = null;
    private String _phoneField = null;
    private String _profilePictureUrlField = null;
    private String _statusTextField = null;
    private String _statusEmojiField = null;
    private Long _lastUpdatedSecondsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_SlackInstance = SCHEMA.getField("slackInstance");
    private static final RecordDataSchema.Field FIELD_Id = SCHEMA.getField("id");
    private static final RecordDataSchema.Field FIELD_Name = SCHEMA.getField("name");
    private static final RecordDataSchema.Field FIELD_RealName = SCHEMA.getField("realName");
    private static final RecordDataSchema.Field FIELD_DisplayName = SCHEMA.getField("displayName");
    private static final RecordDataSchema.Field FIELD_Email = SCHEMA.getField("email");
    private static final RecordDataSchema.Field FIELD_TeamId = SCHEMA.getField("teamId");
    private static final RecordDataSchema.Field FIELD_IsDeleted = SCHEMA.getField("isDeleted");
    private static final RecordDataSchema.Field FIELD_IsAdmin = SCHEMA.getField("isAdmin");
    private static final RecordDataSchema.Field FIELD_IsOwner = SCHEMA.getField("isOwner");
    private static final RecordDataSchema.Field FIELD_IsPrimaryOwner = SCHEMA.getField("isPrimaryOwner");
    private static final RecordDataSchema.Field FIELD_IsBot = SCHEMA.getField("isBot");
    private static final RecordDataSchema.Field FIELD_Timezone = SCHEMA.getField("timezone");
    private static final RecordDataSchema.Field FIELD_TimezoneOffset = SCHEMA.getField("timezoneOffset");
    private static final RecordDataSchema.Field FIELD_Title = SCHEMA.getField("title");
    private static final RecordDataSchema.Field FIELD_Phone = SCHEMA.getField("phone");
    private static final RecordDataSchema.Field FIELD_ProfilePictureUrl = SCHEMA.getField("profilePictureUrl");
    private static final RecordDataSchema.Field FIELD_StatusText = SCHEMA.getField("statusText");
    private static final RecordDataSchema.Field FIELD_StatusEmoji = SCHEMA.getField("statusEmoji");
    private static final RecordDataSchema.Field FIELD_LastUpdatedSeconds = SCHEMA.getField("lastUpdatedSeconds");

    public SlackUserInfo() {
        super(new DataMap(), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public SlackUserInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasSlackInstance() {
        if (this._slackInstanceField != null) {
            return true;
        }
        return this._map.containsKey("slackInstance");
    }

    public void removeSlackInstance() {
        this._map.remove("slackInstance");
    }

    @Nullable
    public Urn getSlackInstance(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getSlackInstance();
            }
            case DEFAULT: 
            case NULL: {
                if (this._slackInstanceField != null) {
                    return this._slackInstanceField;
                }
                Object __rawValue = this._map.get("slackInstance");
                this._slackInstanceField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._slackInstanceField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getSlackInstance() {
        if (this._slackInstanceField != null) {
            return this._slackInstanceField;
        }
        Object __rawValue = this._map.get("slackInstance");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("slackInstance");
        }
        this._slackInstanceField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._slackInstanceField;
    }

    public SlackUserInfo setSlackInstance(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSlackInstance(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field slackInstance of com.linkedin.dataplatform.slack.SlackUserInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "slackInstance", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._slackInstanceField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSlackInstance();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "slackInstance", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._slackInstanceField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "slackInstance", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._slackInstanceField = value;
            }
        }
        return this;
    }

    public SlackUserInfo setSlackInstance(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field slackInstance of com.linkedin.dataplatform.slack.SlackUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "slackInstance", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._slackInstanceField = value;
        return this;
    }

    public boolean hasId() {
        if (this._idField != null) {
            return true;
        }
        return this._map.containsKey("id");
    }

    public void removeId() {
        this._map.remove("id");
    }

    @Nullable
    public String getId(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getId();
            }
            case DEFAULT: 
            case NULL: {
                if (this._idField != null) {
                    return this._idField;
                }
                Object __rawValue = this._map.get("id");
                this._idField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._idField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getId() {
        if (this._idField != null) {
            return this._idField;
        }
        Object __rawValue = this._map.get("id");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("id");
        }
        this._idField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._idField;
    }

    public SlackUserInfo setId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field id of com.linkedin.dataplatform.slack.SlackUserInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "id", value);
                this._idField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "id", value);
                this._idField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "id", value);
                this._idField = value;
            }
        }
        return this;
    }

    public SlackUserInfo setId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field id of com.linkedin.dataplatform.slack.SlackUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "id", value);
        this._idField = value;
        return this;
    }

    public boolean hasName() {
        if (this._nameField != null) {
            return true;
        }
        return this._map.containsKey("name");
    }

    public void removeName() {
        this._map.remove("name");
    }

    @Nullable
    public String getName(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getName();
            }
            case DEFAULT: 
            case NULL: {
                if (this._nameField != null) {
                    return this._nameField;
                }
                Object __rawValue = this._map.get("name");
                this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._nameField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getName() {
        if (this._nameField != null) {
            return this._nameField;
        }
        Object __rawValue = this._map.get("name");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("name");
        }
        this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._nameField;
    }

    public SlackUserInfo setName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field name of com.linkedin.dataplatform.slack.SlackUserInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
            }
        }
        return this;
    }

    public SlackUserInfo setName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field name of com.linkedin.dataplatform.slack.SlackUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "name", value);
        this._nameField = value;
        return this;
    }

    public boolean hasRealName() {
        if (this._realNameField != null) {
            return true;
        }
        return this._map.containsKey("realName");
    }

    public void removeRealName() {
        this._map.remove("realName");
    }

    @Nullable
    public String getRealName(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getRealName();
            }
            case DEFAULT: 
            case NULL: {
                if (this._realNameField != null) {
                    return this._realNameField;
                }
                Object __rawValue = this._map.get("realName");
                this._realNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._realNameField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getRealName() {
        if (this._realNameField != null) {
            return this._realNameField;
        }
        Object __rawValue = this._map.get("realName");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("realName");
        }
        this._realNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._realNameField;
    }

    public SlackUserInfo setRealName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRealName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field realName of com.linkedin.dataplatform.slack.SlackUserInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "realName", value);
                this._realNameField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRealName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "realName", value);
                this._realNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "realName", value);
                this._realNameField = value;
            }
        }
        return this;
    }

    public SlackUserInfo setRealName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field realName of com.linkedin.dataplatform.slack.SlackUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "realName", value);
        this._realNameField = value;
        return this;
    }

    public boolean hasDisplayName() {
        if (this._displayNameField != null) {
            return true;
        }
        return this._map.containsKey("displayName");
    }

    public void removeDisplayName() {
        this._map.remove("displayName");
    }

    @Nullable
    public String getDisplayName(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getDisplayName();
            }
            case DEFAULT: 
            case NULL: {
                if (this._displayNameField != null) {
                    return this._displayNameField;
                }
                Object __rawValue = this._map.get("displayName");
                this._displayNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._displayNameField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getDisplayName() {
        if (this._displayNameField != null) {
            return this._displayNameField;
        }
        Object __rawValue = this._map.get("displayName");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("displayName");
        }
        this._displayNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._displayNameField;
    }

    public SlackUserInfo setDisplayName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDisplayName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field displayName of com.linkedin.dataplatform.slack.SlackUserInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "displayName", value);
                this._displayNameField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDisplayName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "displayName", value);
                this._displayNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "displayName", value);
                this._displayNameField = value;
            }
        }
        return this;
    }

    public SlackUserInfo setDisplayName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field displayName of com.linkedin.dataplatform.slack.SlackUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "displayName", value);
        this._displayNameField = value;
        return this;
    }

    public boolean hasEmail() {
        if (this._emailField != null) {
            return true;
        }
        return this._map.containsKey("email");
    }

    public void removeEmail() {
        this._map.remove("email");
    }

    @Nullable
    public String getEmail(GetMode mode) {
        return this.getEmail();
    }

    @Nullable
    public String getEmail() {
        if (this._emailField != null) {
            return this._emailField;
        }
        Object __rawValue = this._map.get("email");
        this._emailField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._emailField;
    }

    public SlackUserInfo setEmail(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEmail(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEmail();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "email", value);
                this._emailField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "email", value);
                this._emailField = value;
            }
        }
        return this;
    }

    public SlackUserInfo setEmail(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field email of com.linkedin.dataplatform.slack.SlackUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "email", value);
        this._emailField = value;
        return this;
    }

    public boolean hasTeamId() {
        if (this._teamIdField != null) {
            return true;
        }
        return this._map.containsKey("teamId");
    }

    public void removeTeamId() {
        this._map.remove("teamId");
    }

    @Nullable
    public String getTeamId(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTeamId();
            }
            case DEFAULT: 
            case NULL: {
                if (this._teamIdField != null) {
                    return this._teamIdField;
                }
                Object __rawValue = this._map.get("teamId");
                this._teamIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._teamIdField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getTeamId() {
        if (this._teamIdField != null) {
            return this._teamIdField;
        }
        Object __rawValue = this._map.get("teamId");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("teamId");
        }
        this._teamIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._teamIdField;
    }

    public SlackUserInfo setTeamId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTeamId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field teamId of com.linkedin.dataplatform.slack.SlackUserInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "teamId", value);
                this._teamIdField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTeamId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "teamId", value);
                this._teamIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "teamId", value);
                this._teamIdField = value;
            }
        }
        return this;
    }

    public SlackUserInfo setTeamId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field teamId of com.linkedin.dataplatform.slack.SlackUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "teamId", value);
        this._teamIdField = value;
        return this;
    }

    public boolean hasIsDeleted() {
        if (this._isDeletedField != null) {
            return true;
        }
        return this._map.containsKey("isDeleted");
    }

    public void removeIsDeleted() {
        this._map.remove("isDeleted");
    }

    @Nullable
    public Boolean isIsDeleted(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.isIsDeleted();
            }
            case DEFAULT: 
            case NULL: {
                if (this._isDeletedField != null) {
                    return this._isDeletedField;
                }
                Object __rawValue = this._map.get("isDeleted");
                this._isDeletedField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._isDeletedField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isIsDeleted() {
        if (this._isDeletedField != null) {
            return this._isDeletedField;
        }
        Object __rawValue = this._map.get("isDeleted");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("isDeleted");
        }
        this._isDeletedField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._isDeletedField;
    }

    public SlackUserInfo setIsDeleted(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIsDeleted(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field isDeleted of com.linkedin.dataplatform.slack.SlackUserInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "isDeleted", value);
                this._isDeletedField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIsDeleted();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "isDeleted", value);
                this._isDeletedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "isDeleted", value);
                this._isDeletedField = value;
            }
        }
        return this;
    }

    public SlackUserInfo setIsDeleted(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field isDeleted of com.linkedin.dataplatform.slack.SlackUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "isDeleted", value);
        this._isDeletedField = value;
        return this;
    }

    public SlackUserInfo setIsDeleted(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "isDeleted", value);
        this._isDeletedField = value;
        return this;
    }

    public boolean hasIsAdmin() {
        if (this._isAdminField != null) {
            return true;
        }
        return this._map.containsKey("isAdmin");
    }

    public void removeIsAdmin() {
        this._map.remove("isAdmin");
    }

    @Nullable
    public Boolean isIsAdmin(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.isIsAdmin();
            }
            case DEFAULT: 
            case NULL: {
                if (this._isAdminField != null) {
                    return this._isAdminField;
                }
                Object __rawValue = this._map.get("isAdmin");
                this._isAdminField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._isAdminField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isIsAdmin() {
        if (this._isAdminField != null) {
            return this._isAdminField;
        }
        Object __rawValue = this._map.get("isAdmin");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("isAdmin");
        }
        this._isAdminField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._isAdminField;
    }

    public SlackUserInfo setIsAdmin(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIsAdmin(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field isAdmin of com.linkedin.dataplatform.slack.SlackUserInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "isAdmin", value);
                this._isAdminField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIsAdmin();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "isAdmin", value);
                this._isAdminField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "isAdmin", value);
                this._isAdminField = value;
            }
        }
        return this;
    }

    public SlackUserInfo setIsAdmin(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field isAdmin of com.linkedin.dataplatform.slack.SlackUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "isAdmin", value);
        this._isAdminField = value;
        return this;
    }

    public SlackUserInfo setIsAdmin(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "isAdmin", value);
        this._isAdminField = value;
        return this;
    }

    public boolean hasIsOwner() {
        if (this._isOwnerField != null) {
            return true;
        }
        return this._map.containsKey("isOwner");
    }

    public void removeIsOwner() {
        this._map.remove("isOwner");
    }

    @Nullable
    public Boolean isIsOwner(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.isIsOwner();
            }
            case DEFAULT: 
            case NULL: {
                if (this._isOwnerField != null) {
                    return this._isOwnerField;
                }
                Object __rawValue = this._map.get("isOwner");
                this._isOwnerField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._isOwnerField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isIsOwner() {
        if (this._isOwnerField != null) {
            return this._isOwnerField;
        }
        Object __rawValue = this._map.get("isOwner");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("isOwner");
        }
        this._isOwnerField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._isOwnerField;
    }

    public SlackUserInfo setIsOwner(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIsOwner(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field isOwner of com.linkedin.dataplatform.slack.SlackUserInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "isOwner", value);
                this._isOwnerField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIsOwner();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "isOwner", value);
                this._isOwnerField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "isOwner", value);
                this._isOwnerField = value;
            }
        }
        return this;
    }

    public SlackUserInfo setIsOwner(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field isOwner of com.linkedin.dataplatform.slack.SlackUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "isOwner", value);
        this._isOwnerField = value;
        return this;
    }

    public SlackUserInfo setIsOwner(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "isOwner", value);
        this._isOwnerField = value;
        return this;
    }

    public boolean hasIsPrimaryOwner() {
        if (this._isPrimaryOwnerField != null) {
            return true;
        }
        return this._map.containsKey("isPrimaryOwner");
    }

    public void removeIsPrimaryOwner() {
        this._map.remove("isPrimaryOwner");
    }

    @Nullable
    public Boolean isIsPrimaryOwner(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.isIsPrimaryOwner();
            }
            case DEFAULT: 
            case NULL: {
                if (this._isPrimaryOwnerField != null) {
                    return this._isPrimaryOwnerField;
                }
                Object __rawValue = this._map.get("isPrimaryOwner");
                this._isPrimaryOwnerField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._isPrimaryOwnerField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isIsPrimaryOwner() {
        if (this._isPrimaryOwnerField != null) {
            return this._isPrimaryOwnerField;
        }
        Object __rawValue = this._map.get("isPrimaryOwner");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("isPrimaryOwner");
        }
        this._isPrimaryOwnerField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._isPrimaryOwnerField;
    }

    public SlackUserInfo setIsPrimaryOwner(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIsPrimaryOwner(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field isPrimaryOwner of com.linkedin.dataplatform.slack.SlackUserInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "isPrimaryOwner", value);
                this._isPrimaryOwnerField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIsPrimaryOwner();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "isPrimaryOwner", value);
                this._isPrimaryOwnerField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "isPrimaryOwner", value);
                this._isPrimaryOwnerField = value;
            }
        }
        return this;
    }

    public SlackUserInfo setIsPrimaryOwner(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field isPrimaryOwner of com.linkedin.dataplatform.slack.SlackUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "isPrimaryOwner", value);
        this._isPrimaryOwnerField = value;
        return this;
    }

    public SlackUserInfo setIsPrimaryOwner(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "isPrimaryOwner", value);
        this._isPrimaryOwnerField = value;
        return this;
    }

    public boolean hasIsBot() {
        if (this._isBotField != null) {
            return true;
        }
        return this._map.containsKey("isBot");
    }

    public void removeIsBot() {
        this._map.remove("isBot");
    }

    @Nullable
    public Boolean isIsBot(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.isIsBot();
            }
            case DEFAULT: 
            case NULL: {
                if (this._isBotField != null) {
                    return this._isBotField;
                }
                Object __rawValue = this._map.get("isBot");
                this._isBotField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._isBotField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isIsBot() {
        if (this._isBotField != null) {
            return this._isBotField;
        }
        Object __rawValue = this._map.get("isBot");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("isBot");
        }
        this._isBotField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._isBotField;
    }

    public SlackUserInfo setIsBot(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIsBot(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field isBot of com.linkedin.dataplatform.slack.SlackUserInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "isBot", value);
                this._isBotField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIsBot();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "isBot", value);
                this._isBotField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "isBot", value);
                this._isBotField = value;
            }
        }
        return this;
    }

    public SlackUserInfo setIsBot(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field isBot of com.linkedin.dataplatform.slack.SlackUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "isBot", value);
        this._isBotField = value;
        return this;
    }

    public SlackUserInfo setIsBot(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "isBot", value);
        this._isBotField = value;
        return this;
    }

    public boolean hasTimezone() {
        if (this._timezoneField != null) {
            return true;
        }
        return this._map.containsKey("timezone");
    }

    public void removeTimezone() {
        this._map.remove("timezone");
    }

    @Nullable
    public String getTimezone(GetMode mode) {
        return this.getTimezone();
    }

    @Nullable
    public String getTimezone() {
        if (this._timezoneField != null) {
            return this._timezoneField;
        }
        Object __rawValue = this._map.get("timezone");
        this._timezoneField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._timezoneField;
    }

    public SlackUserInfo setTimezone(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTimezone(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTimezone();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "timezone", value);
                this._timezoneField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "timezone", value);
                this._timezoneField = value;
            }
        }
        return this;
    }

    public SlackUserInfo setTimezone(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field timezone of com.linkedin.dataplatform.slack.SlackUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "timezone", value);
        this._timezoneField = value;
        return this;
    }

    public boolean hasTimezoneOffset() {
        if (this._timezoneOffsetField != null) {
            return true;
        }
        return this._map.containsKey("timezoneOffset");
    }

    public void removeTimezoneOffset() {
        this._map.remove("timezoneOffset");
    }

    @Nullable
    public Integer getTimezoneOffset(GetMode mode) {
        return this.getTimezoneOffset();
    }

    @Nullable
    public Integer getTimezoneOffset() {
        if (this._timezoneOffsetField != null) {
            return this._timezoneOffsetField;
        }
        Object __rawValue = this._map.get("timezoneOffset");
        this._timezoneOffsetField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._timezoneOffsetField;
    }

    public SlackUserInfo setTimezoneOffset(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTimezoneOffset(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTimezoneOffset();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "timezoneOffset", DataTemplateUtil.coerceIntInput(value));
                this._timezoneOffsetField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "timezoneOffset", DataTemplateUtil.coerceIntInput(value));
                this._timezoneOffsetField = value;
            }
        }
        return this;
    }

    public SlackUserInfo setTimezoneOffset(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field timezoneOffset of com.linkedin.dataplatform.slack.SlackUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "timezoneOffset", DataTemplateUtil.coerceIntInput(value));
        this._timezoneOffsetField = value;
        return this;
    }

    public SlackUserInfo setTimezoneOffset(int value) {
        CheckedUtil.putWithoutChecking(this._map, "timezoneOffset", DataTemplateUtil.coerceIntInput(value));
        this._timezoneOffsetField = value;
        return this;
    }

    public boolean hasTitle() {
        if (this._titleField != null) {
            return true;
        }
        return this._map.containsKey("title");
    }

    public void removeTitle() {
        this._map.remove("title");
    }

    @Nullable
    public String getTitle(GetMode mode) {
        return this.getTitle();
    }

    @Nullable
    public String getTitle() {
        if (this._titleField != null) {
            return this._titleField;
        }
        Object __rawValue = this._map.get("title");
        this._titleField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._titleField;
    }

    public SlackUserInfo setTitle(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTitle(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTitle();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "title", value);
                this._titleField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "title", value);
                this._titleField = value;
            }
        }
        return this;
    }

    public SlackUserInfo setTitle(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field title of com.linkedin.dataplatform.slack.SlackUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "title", value);
        this._titleField = value;
        return this;
    }

    public boolean hasPhone() {
        if (this._phoneField != null) {
            return true;
        }
        return this._map.containsKey("phone");
    }

    public void removePhone() {
        this._map.remove("phone");
    }

    @Nullable
    public String getPhone(GetMode mode) {
        return this.getPhone();
    }

    @Nullable
    public String getPhone() {
        if (this._phoneField != null) {
            return this._phoneField;
        }
        Object __rawValue = this._map.get("phone");
        this._phoneField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._phoneField;
    }

    public SlackUserInfo setPhone(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPhone(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePhone();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "phone", value);
                this._phoneField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "phone", value);
                this._phoneField = value;
            }
        }
        return this;
    }

    public SlackUserInfo setPhone(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field phone of com.linkedin.dataplatform.slack.SlackUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "phone", value);
        this._phoneField = value;
        return this;
    }

    public boolean hasProfilePictureUrl() {
        if (this._profilePictureUrlField != null) {
            return true;
        }
        return this._map.containsKey("profilePictureUrl");
    }

    public void removeProfilePictureUrl() {
        this._map.remove("profilePictureUrl");
    }

    @Nullable
    public String getProfilePictureUrl(GetMode mode) {
        return this.getProfilePictureUrl();
    }

    @Nullable
    public String getProfilePictureUrl() {
        if (this._profilePictureUrlField != null) {
            return this._profilePictureUrlField;
        }
        Object __rawValue = this._map.get("profilePictureUrl");
        this._profilePictureUrlField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._profilePictureUrlField;
    }

    public SlackUserInfo setProfilePictureUrl(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setProfilePictureUrl(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeProfilePictureUrl();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "profilePictureUrl", value);
                this._profilePictureUrlField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "profilePictureUrl", value);
                this._profilePictureUrlField = value;
            }
        }
        return this;
    }

    public SlackUserInfo setProfilePictureUrl(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field profilePictureUrl of com.linkedin.dataplatform.slack.SlackUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "profilePictureUrl", value);
        this._profilePictureUrlField = value;
        return this;
    }

    public boolean hasStatusText() {
        if (this._statusTextField != null) {
            return true;
        }
        return this._map.containsKey("statusText");
    }

    public void removeStatusText() {
        this._map.remove("statusText");
    }

    @Nullable
    public String getStatusText(GetMode mode) {
        return this.getStatusText();
    }

    @Nullable
    public String getStatusText() {
        if (this._statusTextField != null) {
            return this._statusTextField;
        }
        Object __rawValue = this._map.get("statusText");
        this._statusTextField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._statusTextField;
    }

    public SlackUserInfo setStatusText(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setStatusText(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeStatusText();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "statusText", value);
                this._statusTextField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "statusText", value);
                this._statusTextField = value;
            }
        }
        return this;
    }

    public SlackUserInfo setStatusText(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field statusText of com.linkedin.dataplatform.slack.SlackUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "statusText", value);
        this._statusTextField = value;
        return this;
    }

    public boolean hasStatusEmoji() {
        if (this._statusEmojiField != null) {
            return true;
        }
        return this._map.containsKey("statusEmoji");
    }

    public void removeStatusEmoji() {
        this._map.remove("statusEmoji");
    }

    @Nullable
    public String getStatusEmoji(GetMode mode) {
        return this.getStatusEmoji();
    }

    @Nullable
    public String getStatusEmoji() {
        if (this._statusEmojiField != null) {
            return this._statusEmojiField;
        }
        Object __rawValue = this._map.get("statusEmoji");
        this._statusEmojiField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._statusEmojiField;
    }

    public SlackUserInfo setStatusEmoji(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setStatusEmoji(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeStatusEmoji();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "statusEmoji", value);
                this._statusEmojiField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "statusEmoji", value);
                this._statusEmojiField = value;
            }
        }
        return this;
    }

    public SlackUserInfo setStatusEmoji(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field statusEmoji of com.linkedin.dataplatform.slack.SlackUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "statusEmoji", value);
        this._statusEmojiField = value;
        return this;
    }

    public boolean hasLastUpdatedSeconds() {
        if (this._lastUpdatedSecondsField != null) {
            return true;
        }
        return this._map.containsKey("lastUpdatedSeconds");
    }

    public void removeLastUpdatedSeconds() {
        this._map.remove("lastUpdatedSeconds");
    }

    @Nullable
    public Long getLastUpdatedSeconds(GetMode mode) {
        return this.getLastUpdatedSeconds();
    }

    @Nullable
    public Long getLastUpdatedSeconds() {
        if (this._lastUpdatedSecondsField != null) {
            return this._lastUpdatedSecondsField;
        }
        Object __rawValue = this._map.get("lastUpdatedSeconds");
        this._lastUpdatedSecondsField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._lastUpdatedSecondsField;
    }

    public SlackUserInfo setLastUpdatedSeconds(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastUpdatedSeconds(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastUpdatedSeconds();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastUpdatedSeconds", DataTemplateUtil.coerceLongInput(value));
                this._lastUpdatedSecondsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastUpdatedSeconds", DataTemplateUtil.coerceLongInput(value));
                this._lastUpdatedSecondsField = value;
            }
        }
        return this;
    }

    public SlackUserInfo setLastUpdatedSeconds(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastUpdatedSeconds of com.linkedin.dataplatform.slack.SlackUserInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastUpdatedSeconds", DataTemplateUtil.coerceLongInput(value));
        this._lastUpdatedSecondsField = value;
        return this;
    }

    public SlackUserInfo setLastUpdatedSeconds(long value) {
        CheckedUtil.putWithoutChecking(this._map, "lastUpdatedSeconds", DataTemplateUtil.coerceLongInput(value));
        this._lastUpdatedSecondsField = value;
        return this;
    }

    @Override
    public SlackUserInfo clone() throws CloneNotSupportedException {
        SlackUserInfo __clone = (SlackUserInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public SlackUserInfo copy() throws CloneNotSupportedException {
        SlackUserInfo __copy = (SlackUserInfo)super.copy();
        __copy._profilePictureUrlField = null;
        __copy._isBotField = null;
        __copy._slackInstanceField = null;
        __copy._displayNameField = null;
        __copy._timezoneField = null;
        __copy._isAdminField = null;
        __copy._titleField = null;
        __copy._isPrimaryOwnerField = null;
        __copy._realNameField = null;
        __copy._isDeletedField = null;
        __copy._isOwnerField = null;
        __copy._timezoneOffsetField = null;
        __copy._phoneField = null;
        __copy._teamIdField = null;
        __copy._statusTextField = null;
        __copy._nameField = null;
        __copy._lastUpdatedSecondsField = null;
        __copy._idField = null;
        __copy._statusEmojiField = null;
        __copy._emailField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final SlackUserInfo __objectRef;

        private ChangeListener(SlackUserInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "profilePictureUrl": {
                    this.__objectRef._profilePictureUrlField = null;
                    break;
                }
                case "isBot": {
                    this.__objectRef._isBotField = null;
                    break;
                }
                case "slackInstance": {
                    this.__objectRef._slackInstanceField = null;
                    break;
                }
                case "displayName": {
                    this.__objectRef._displayNameField = null;
                    break;
                }
                case "timezone": {
                    this.__objectRef._timezoneField = null;
                    break;
                }
                case "isAdmin": {
                    this.__objectRef._isAdminField = null;
                    break;
                }
                case "title": {
                    this.__objectRef._titleField = null;
                    break;
                }
                case "isPrimaryOwner": {
                    this.__objectRef._isPrimaryOwnerField = null;
                    break;
                }
                case "realName": {
                    this.__objectRef._realNameField = null;
                    break;
                }
                case "isDeleted": {
                    this.__objectRef._isDeletedField = null;
                    break;
                }
                case "isOwner": {
                    this.__objectRef._isOwnerField = null;
                    break;
                }
                case "timezoneOffset": {
                    this.__objectRef._timezoneOffsetField = null;
                    break;
                }
                case "phone": {
                    this.__objectRef._phoneField = null;
                    break;
                }
                case "teamId": {
                    this.__objectRef._teamIdField = null;
                    break;
                }
                case "statusText": {
                    this.__objectRef._statusTextField = null;
                    break;
                }
                case "name": {
                    this.__objectRef._nameField = null;
                    break;
                }
                case "lastUpdatedSeconds": {
                    this.__objectRef._lastUpdatedSecondsField = null;
                    break;
                }
                case "id": {
                    this.__objectRef._idField = null;
                    break;
                }
                case "statusEmoji": {
                    this.__objectRef._statusEmojiField = null;
                    break;
                }
                case "email": {
                    this.__objectRef._emailField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec slackInstance() {
            return new PathSpec(this.getPathComponents(), "slackInstance");
        }

        public PathSpec id() {
            return new PathSpec(this.getPathComponents(), "id");
        }

        public PathSpec name() {
            return new PathSpec(this.getPathComponents(), "name");
        }

        public PathSpec realName() {
            return new PathSpec(this.getPathComponents(), "realName");
        }

        public PathSpec displayName() {
            return new PathSpec(this.getPathComponents(), "displayName");
        }

        public PathSpec email() {
            return new PathSpec(this.getPathComponents(), "email");
        }

        public PathSpec teamId() {
            return new PathSpec(this.getPathComponents(), "teamId");
        }

        public PathSpec isDeleted() {
            return new PathSpec(this.getPathComponents(), "isDeleted");
        }

        public PathSpec isAdmin() {
            return new PathSpec(this.getPathComponents(), "isAdmin");
        }

        public PathSpec isOwner() {
            return new PathSpec(this.getPathComponents(), "isOwner");
        }

        public PathSpec isPrimaryOwner() {
            return new PathSpec(this.getPathComponents(), "isPrimaryOwner");
        }

        public PathSpec isBot() {
            return new PathSpec(this.getPathComponents(), "isBot");
        }

        public PathSpec timezone() {
            return new PathSpec(this.getPathComponents(), "timezone");
        }

        public PathSpec timezoneOffset() {
            return new PathSpec(this.getPathComponents(), "timezoneOffset");
        }

        public PathSpec title() {
            return new PathSpec(this.getPathComponents(), "title");
        }

        public PathSpec phone() {
            return new PathSpec(this.getPathComponents(), "phone");
        }

        public PathSpec profilePictureUrl() {
            return new PathSpec(this.getPathComponents(), "profilePictureUrl");
        }

        public PathSpec statusText() {
            return new PathSpec(this.getPathComponents(), "statusText");
        }

        public PathSpec statusEmoji() {
            return new PathSpec(this.getPathComponents(), "statusEmoji");
        }

        public PathSpec lastUpdatedSeconds() {
            return new PathSpec(this.getPathComponents(), "lastUpdatedSeconds");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
        }

        public ProjectionMask withSlackInstance() {
            this.getDataMap().put("slackInstance", 1);
            return this;
        }

        public ProjectionMask withId() {
            this.getDataMap().put("id", 1);
            return this;
        }

        public ProjectionMask withName() {
            this.getDataMap().put("name", 1);
            return this;
        }

        public ProjectionMask withRealName() {
            this.getDataMap().put("realName", 1);
            return this;
        }

        public ProjectionMask withDisplayName() {
            this.getDataMap().put("displayName", 1);
            return this;
        }

        public ProjectionMask withEmail() {
            this.getDataMap().put("email", 1);
            return this;
        }

        public ProjectionMask withTeamId() {
            this.getDataMap().put("teamId", 1);
            return this;
        }

        public ProjectionMask withIsDeleted() {
            this.getDataMap().put("isDeleted", 1);
            return this;
        }

        public ProjectionMask withIsAdmin() {
            this.getDataMap().put("isAdmin", 1);
            return this;
        }

        public ProjectionMask withIsOwner() {
            this.getDataMap().put("isOwner", 1);
            return this;
        }

        public ProjectionMask withIsPrimaryOwner() {
            this.getDataMap().put("isPrimaryOwner", 1);
            return this;
        }

        public ProjectionMask withIsBot() {
            this.getDataMap().put("isBot", 1);
            return this;
        }

        public ProjectionMask withTimezone() {
            this.getDataMap().put("timezone", 1);
            return this;
        }

        public ProjectionMask withTimezoneOffset() {
            this.getDataMap().put("timezoneOffset", 1);
            return this;
        }

        public ProjectionMask withTitle() {
            this.getDataMap().put("title", 1);
            return this;
        }

        public ProjectionMask withPhone() {
            this.getDataMap().put("phone", 1);
            return this;
        }

        public ProjectionMask withProfilePictureUrl() {
            this.getDataMap().put("profilePictureUrl", 1);
            return this;
        }

        public ProjectionMask withStatusText() {
            this.getDataMap().put("statusText", 1);
            return this;
        }

        public ProjectionMask withStatusEmoji() {
            this.getDataMap().put("statusEmoji", 1);
            return this;
        }

        public ProjectionMask withLastUpdatedSeconds() {
            this.getDataMap().put("lastUpdatedSeconds", 1);
            return this;
        }
    }
}

