/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.datajob.datahub;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.datajob.JobStatus;
import com.linkedin.timeseries.PartitionSpec;
import com.linkedin.timeseries.TimeWindowSize;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DatahubIngestionRunSummary
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.datajob.datahub/**Summary of a datahub ingestion run for a given platform.*/@Aspect={\"name\":\"datahubIngestionRunSummary\",\"type\":\"timeseries\"}record DatahubIngestionRunSummary includes{namespace com.linkedin.timeseries,record TimeseriesAspectBase{/**The event timestamp field as epoch at UTC in milli seconds.*/timestampMillis:long/**Granularity of the event if applicable*/eventGranularity:optional/**Defines the size of a time window.*/record TimeWindowSize{/**Interval unit such as minute/hour/day etc.*/unit:enum CalendarInterval{SECOND,MINUTE,HOUR,DAY,WEEK,MONTH,QUARTER,YEAR}/**How many units. Defaults to 1.*/multiple:int=1}/**The optional partition specification.*/partitionSpec:optional/**A reference to a specific partition in a dataset.*/record PartitionSpec{/**A unique id / value for the partition for which statistics were collected,\ngenerated by applying the key definition to a given row.*/@TimeseriesField={}partition:string/**Time window of the partition, if we are able to extract it from the partition key.*/timePartition:optional record TimeWindow{/**Start time as epoch at UTC.*/startTimeMillis:long/**The length of the window.*/length:TimeWindowSize}/**Unused!*/@deprecated,type:enum PartitionType{FULL_TABLE,QUERY,PARTITION}=\"PARTITION\"}={\"partition\":\"FULL_TABLE_SNAPSHOT\",\"type\":\"FULL_TABLE\"}/**The optional messageId, if provided serves as a custom user-defined unique identifier for an aspect value.*/messageId:optional string}}{/**The name of the pipeline that ran ingestion, a stable unique user provided identifier.\n e.g. my_snowflake1-to-datahub.*/@TimeseriesField={}pipelineName:string/**The id of the instance against which the ingestion pipeline ran.\ne.g.: Bigquery project ids, MySQL hostnames etc.*/@TimeseriesField={}platformInstanceId:string/**The runId for this pipeline instance.*/@TimeseriesField={}runId:string/**Run Status - Succeeded/Skipped/Failed etc.*/@TimeseriesField={}runStatus:{namespace com.linkedin.datajob/**Job statuses*/enum JobStatus{/**Jobs being initialized.*/STARTING/**Jobs currently running.*/IN_PROGRESS/**Jobs being stopped.*/STOPPING/**Jobs that have stopped.*/STOPPED/**Jobs with successful completion.*/COMPLETED/**Jobs that have failed.*/FAILED/**Jobs with unknown status (either unmappable or unavailable)*/UNKNOWN/**Jobs that have been skipped.*/SKIPPED}}/**The number of workunits written to sink.*/numWorkUnitsCommitted:optional long/**The number of workunits that are produced.*/numWorkUnitsCreated:optional long/**The number of events produced (MCE + MCP).*/numEvents:optional long/**The total number of entities produced (unique entity urns).*/numEntities:optional long/**The total number of aspects produced across all entities.*/numAspects:optional long/**Total number of source API calls.*/numSourceAPICalls:optional long/**Total latency across all source API calls.*/totalLatencySourceAPICalls:optional long/**Total number of sink API calls.*/numSinkAPICalls:optional long/**Total latency across all sink API calls.*/totalLatencySinkAPICalls:optional long/**Number of warnings generated.*/numWarnings:optional long/**Number of errors generated.*/numErrors:optional long/**Number of entities skipped.*/numEntitiesSkipped:optional long/**The non-sensitive key-value pairs of the yaml config used as json string.*/config:optional string/**Custom value.*/custom_summary:optional string/**The software version of this ingestion.*/@TimeseriesField={}softwareVersion:optional string/**The hostname the ingestion pipeline ran on.*/systemHostName:optional string/**The os the ingestion pipeline ran on.*/@TimeseriesField={}operatingSystemName:optional string/**The number of processors on the host the ingestion pipeline ran on.*/numProcessors:optional int/**The total amount of memory on the host the ingestion pipeline ran on.*/totalMemory:optional long/**The available memory on the host the ingestion pipeline ran on.*/availableMemory:optional long}", SchemaFormatType.PDL);
    private Long _timestampMillisField = null;
    private TimeWindowSize _eventGranularityField = null;
    private PartitionSpec _partitionSpecField = null;
    private String _messageIdField = null;
    private String _pipelineNameField = null;
    private String _platformInstanceIdField = null;
    private String _runIdField = null;
    private JobStatus _runStatusField = null;
    private Long _numWorkUnitsCommittedField = null;
    private Long _numWorkUnitsCreatedField = null;
    private Long _numEventsField = null;
    private Long _numEntitiesField = null;
    private Long _numAspectsField = null;
    private Long _numSourceAPICallsField = null;
    private Long _totalLatencySourceAPICallsField = null;
    private Long _numSinkAPICallsField = null;
    private Long _totalLatencySinkAPICallsField = null;
    private Long _numWarningsField = null;
    private Long _numErrorsField = null;
    private Long _numEntitiesSkippedField = null;
    private String _configField = null;
    private String _custom_summaryField = null;
    private String _softwareVersionField = null;
    private String _systemHostNameField = null;
    private String _operatingSystemNameField = null;
    private Integer _numProcessorsField = null;
    private Long _totalMemoryField = null;
    private Long _availableMemoryField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_TimestampMillis = SCHEMA.getField("timestampMillis");
    private static final RecordDataSchema.Field FIELD_EventGranularity = SCHEMA.getField("eventGranularity");
    private static final RecordDataSchema.Field FIELD_PartitionSpec = SCHEMA.getField("partitionSpec");
    private static final PartitionSpec DEFAULT_PartitionSpec;
    private static final RecordDataSchema.Field FIELD_MessageId;
    private static final RecordDataSchema.Field FIELD_PipelineName;
    private static final RecordDataSchema.Field FIELD_PlatformInstanceId;
    private static final RecordDataSchema.Field FIELD_RunId;
    private static final RecordDataSchema.Field FIELD_RunStatus;
    private static final RecordDataSchema.Field FIELD_NumWorkUnitsCommitted;
    private static final RecordDataSchema.Field FIELD_NumWorkUnitsCreated;
    private static final RecordDataSchema.Field FIELD_NumEvents;
    private static final RecordDataSchema.Field FIELD_NumEntities;
    private static final RecordDataSchema.Field FIELD_NumAspects;
    private static final RecordDataSchema.Field FIELD_NumSourceAPICalls;
    private static final RecordDataSchema.Field FIELD_TotalLatencySourceAPICalls;
    private static final RecordDataSchema.Field FIELD_NumSinkAPICalls;
    private static final RecordDataSchema.Field FIELD_TotalLatencySinkAPICalls;
    private static final RecordDataSchema.Field FIELD_NumWarnings;
    private static final RecordDataSchema.Field FIELD_NumErrors;
    private static final RecordDataSchema.Field FIELD_NumEntitiesSkipped;
    private static final RecordDataSchema.Field FIELD_Config;
    private static final RecordDataSchema.Field FIELD_Custom_summary;
    private static final RecordDataSchema.Field FIELD_SoftwareVersion;
    private static final RecordDataSchema.Field FIELD_SystemHostName;
    private static final RecordDataSchema.Field FIELD_OperatingSystemName;
    private static final RecordDataSchema.Field FIELD_NumProcessors;
    private static final RecordDataSchema.Field FIELD_TotalMemory;
    private static final RecordDataSchema.Field FIELD_AvailableMemory;

    public DatahubIngestionRunSummary() {
        super(new DataMap(), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public DatahubIngestionRunSummary(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasTimestampMillis() {
        if (this._timestampMillisField != null) {
            return true;
        }
        return this._map.containsKey("timestampMillis");
    }

    public void removeTimestampMillis() {
        this._map.remove("timestampMillis");
    }

    @Nullable
    public Long getTimestampMillis(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTimestampMillis();
            }
            case DEFAULT: 
            case NULL: {
                if (this._timestampMillisField != null) {
                    return this._timestampMillisField;
                }
                Object __rawValue = this._map.get("timestampMillis");
                this._timestampMillisField = DataTemplateUtil.coerceLongOutput(__rawValue);
                return this._timestampMillisField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Long getTimestampMillis() {
        if (this._timestampMillisField != null) {
            return this._timestampMillisField;
        }
        Object __rawValue = this._map.get("timestampMillis");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("timestampMillis");
        }
        this._timestampMillisField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._timestampMillisField;
    }

    public DatahubIngestionRunSummary setTimestampMillis(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTimestampMillis(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field timestampMillis of com.linkedin.datajob.datahub.DatahubIngestionRunSummary");
                }
                CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
                this._timestampMillisField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTimestampMillis();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
                this._timestampMillisField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
                this._timestampMillisField = value;
            }
        }
        return this;
    }

    public DatahubIngestionRunSummary setTimestampMillis(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field timestampMillis of com.linkedin.datajob.datahub.DatahubIngestionRunSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
        this._timestampMillisField = value;
        return this;
    }

    public DatahubIngestionRunSummary setTimestampMillis(long value) {
        CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
        this._timestampMillisField = value;
        return this;
    }

    public boolean hasEventGranularity() {
        if (this._eventGranularityField != null) {
            return true;
        }
        return this._map.containsKey("eventGranularity");
    }

    public void removeEventGranularity() {
        this._map.remove("eventGranularity");
    }

    @Nullable
    public TimeWindowSize getEventGranularity(GetMode mode) {
        return this.getEventGranularity();
    }

    @Nullable
    public TimeWindowSize getEventGranularity() {
        if (this._eventGranularityField != null) {
            return this._eventGranularityField;
        }
        Object __rawValue = this._map.get("eventGranularity");
        this._eventGranularityField = __rawValue == null ? null : new TimeWindowSize(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._eventGranularityField;
    }

    public DatahubIngestionRunSummary setEventGranularity(@Nullable TimeWindowSize value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEventGranularity(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEventGranularity();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "eventGranularity", value.data());
                this._eventGranularityField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "eventGranularity", value.data());
                this._eventGranularityField = value;
            }
        }
        return this;
    }

    public DatahubIngestionRunSummary setEventGranularity(@Nonnull TimeWindowSize value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field eventGranularity of com.linkedin.datajob.datahub.DatahubIngestionRunSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "eventGranularity", value.data());
        this._eventGranularityField = value;
        return this;
    }

    public boolean hasPartitionSpec() {
        if (this._partitionSpecField != null) {
            return true;
        }
        return this._map.containsKey("partitionSpec");
    }

    public void removePartitionSpec() {
        this._map.remove("partitionSpec");
    }

    @Nullable
    public PartitionSpec getPartitionSpec(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getPartitionSpec();
            }
            case NULL: {
                if (this._partitionSpecField != null) {
                    return this._partitionSpecField;
                }
                Object __rawValue = this._map.get("partitionSpec");
                this._partitionSpecField = __rawValue == null ? null : new PartitionSpec(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._partitionSpecField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nullable
    public PartitionSpec getPartitionSpec() {
        if (this._partitionSpecField != null) {
            return this._partitionSpecField;
        }
        Object __rawValue = this._map.get("partitionSpec");
        if (__rawValue == null) {
            return DEFAULT_PartitionSpec;
        }
        this._partitionSpecField = __rawValue == null ? null : new PartitionSpec(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._partitionSpecField;
    }

    public DatahubIngestionRunSummary setPartitionSpec(@Nullable PartitionSpec value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPartitionSpec(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePartitionSpec();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "partitionSpec", value.data());
                this._partitionSpecField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "partitionSpec", value.data());
                this._partitionSpecField = value;
            }
        }
        return this;
    }

    public DatahubIngestionRunSummary setPartitionSpec(@Nonnull PartitionSpec value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field partitionSpec of com.linkedin.datajob.datahub.DatahubIngestionRunSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "partitionSpec", value.data());
        this._partitionSpecField = value;
        return this;
    }

    public boolean hasMessageId() {
        if (this._messageIdField != null) {
            return true;
        }
        return this._map.containsKey("messageId");
    }

    public void removeMessageId() {
        this._map.remove("messageId");
    }

    @Nullable
    public String getMessageId(GetMode mode) {
        return this.getMessageId();
    }

    @Nullable
    public String getMessageId() {
        if (this._messageIdField != null) {
            return this._messageIdField;
        }
        Object __rawValue = this._map.get("messageId");
        this._messageIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._messageIdField;
    }

    public DatahubIngestionRunSummary setMessageId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMessageId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMessageId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "messageId", value);
                this._messageIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "messageId", value);
                this._messageIdField = value;
            }
        }
        return this;
    }

    public DatahubIngestionRunSummary setMessageId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field messageId of com.linkedin.datajob.datahub.DatahubIngestionRunSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "messageId", value);
        this._messageIdField = value;
        return this;
    }

    public boolean hasPipelineName() {
        if (this._pipelineNameField != null) {
            return true;
        }
        return this._map.containsKey("pipelineName");
    }

    public void removePipelineName() {
        this._map.remove("pipelineName");
    }

    @Nullable
    public String getPipelineName(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getPipelineName();
            }
            case DEFAULT: 
            case NULL: {
                if (this._pipelineNameField != null) {
                    return this._pipelineNameField;
                }
                Object __rawValue = this._map.get("pipelineName");
                this._pipelineNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._pipelineNameField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getPipelineName() {
        if (this._pipelineNameField != null) {
            return this._pipelineNameField;
        }
        Object __rawValue = this._map.get("pipelineName");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("pipelineName");
        }
        this._pipelineNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._pipelineNameField;
    }

    public DatahubIngestionRunSummary setPipelineName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPipelineName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field pipelineName of com.linkedin.datajob.datahub.DatahubIngestionRunSummary");
                }
                CheckedUtil.putWithoutChecking(this._map, "pipelineName", value);
                this._pipelineNameField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePipelineName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "pipelineName", value);
                this._pipelineNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "pipelineName", value);
                this._pipelineNameField = value;
            }
        }
        return this;
    }

    public DatahubIngestionRunSummary setPipelineName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field pipelineName of com.linkedin.datajob.datahub.DatahubIngestionRunSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "pipelineName", value);
        this._pipelineNameField = value;
        return this;
    }

    public boolean hasPlatformInstanceId() {
        if (this._platformInstanceIdField != null) {
            return true;
        }
        return this._map.containsKey("platformInstanceId");
    }

    public void removePlatformInstanceId() {
        this._map.remove("platformInstanceId");
    }

    @Nullable
    public String getPlatformInstanceId(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getPlatformInstanceId();
            }
            case DEFAULT: 
            case NULL: {
                if (this._platformInstanceIdField != null) {
                    return this._platformInstanceIdField;
                }
                Object __rawValue = this._map.get("platformInstanceId");
                this._platformInstanceIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._platformInstanceIdField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getPlatformInstanceId() {
        if (this._platformInstanceIdField != null) {
            return this._platformInstanceIdField;
        }
        Object __rawValue = this._map.get("platformInstanceId");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("platformInstanceId");
        }
        this._platformInstanceIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._platformInstanceIdField;
    }

    public DatahubIngestionRunSummary setPlatformInstanceId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPlatformInstanceId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field platformInstanceId of com.linkedin.datajob.datahub.DatahubIngestionRunSummary");
                }
                CheckedUtil.putWithoutChecking(this._map, "platformInstanceId", value);
                this._platformInstanceIdField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePlatformInstanceId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "platformInstanceId", value);
                this._platformInstanceIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "platformInstanceId", value);
                this._platformInstanceIdField = value;
            }
        }
        return this;
    }

    public DatahubIngestionRunSummary setPlatformInstanceId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field platformInstanceId of com.linkedin.datajob.datahub.DatahubIngestionRunSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "platformInstanceId", value);
        this._platformInstanceIdField = value;
        return this;
    }

    public boolean hasRunId() {
        if (this._runIdField != null) {
            return true;
        }
        return this._map.containsKey("runId");
    }

    public void removeRunId() {
        this._map.remove("runId");
    }

    @Nullable
    public String getRunId(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getRunId();
            }
            case DEFAULT: 
            case NULL: {
                if (this._runIdField != null) {
                    return this._runIdField;
                }
                Object __rawValue = this._map.get("runId");
                this._runIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._runIdField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getRunId() {
        if (this._runIdField != null) {
            return this._runIdField;
        }
        Object __rawValue = this._map.get("runId");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("runId");
        }
        this._runIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._runIdField;
    }

    public DatahubIngestionRunSummary setRunId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRunId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field runId of com.linkedin.datajob.datahub.DatahubIngestionRunSummary");
                }
                CheckedUtil.putWithoutChecking(this._map, "runId", value);
                this._runIdField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRunId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "runId", value);
                this._runIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "runId", value);
                this._runIdField = value;
            }
        }
        return this;
    }

    public DatahubIngestionRunSummary setRunId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field runId of com.linkedin.datajob.datahub.DatahubIngestionRunSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "runId", value);
        this._runIdField = value;
        return this;
    }

    public boolean hasRunStatus() {
        if (this._runStatusField != null) {
            return true;
        }
        return this._map.containsKey("runStatus");
    }

    public void removeRunStatus() {
        this._map.remove("runStatus");
    }

    @Nullable
    public JobStatus getRunStatus(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getRunStatus();
            }
            case DEFAULT: 
            case NULL: {
                if (this._runStatusField != null) {
                    return this._runStatusField;
                }
                Object __rawValue = this._map.get("runStatus");
                this._runStatusField = DataTemplateUtil.coerceEnumOutput(__rawValue, JobStatus.class, JobStatus.$UNKNOWN);
                return this._runStatusField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public JobStatus getRunStatus() {
        if (this._runStatusField != null) {
            return this._runStatusField;
        }
        Object __rawValue = this._map.get("runStatus");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("runStatus");
        }
        this._runStatusField = DataTemplateUtil.coerceEnumOutput(__rawValue, JobStatus.class, JobStatus.$UNKNOWN);
        return this._runStatusField;
    }

    public DatahubIngestionRunSummary setRunStatus(@Nullable JobStatus value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRunStatus(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field runStatus of com.linkedin.datajob.datahub.DatahubIngestionRunSummary");
                }
                CheckedUtil.putWithoutChecking(this._map, "runStatus", value.name());
                this._runStatusField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRunStatus();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "runStatus", value.name());
                this._runStatusField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "runStatus", value.name());
                this._runStatusField = value;
            }
        }
        return this;
    }

    public DatahubIngestionRunSummary setRunStatus(@Nonnull JobStatus value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field runStatus of com.linkedin.datajob.datahub.DatahubIngestionRunSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "runStatus", value.name());
        this._runStatusField = value;
        return this;
    }

    public boolean hasNumWorkUnitsCommitted() {
        if (this._numWorkUnitsCommittedField != null) {
            return true;
        }
        return this._map.containsKey("numWorkUnitsCommitted");
    }

    public void removeNumWorkUnitsCommitted() {
        this._map.remove("numWorkUnitsCommitted");
    }

    @Nullable
    public Long getNumWorkUnitsCommitted(GetMode mode) {
        return this.getNumWorkUnitsCommitted();
    }

    @Nullable
    public Long getNumWorkUnitsCommitted() {
        if (this._numWorkUnitsCommittedField != null) {
            return this._numWorkUnitsCommittedField;
        }
        Object __rawValue = this._map.get("numWorkUnitsCommitted");
        this._numWorkUnitsCommittedField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._numWorkUnitsCommittedField;
    }

    public DatahubIngestionRunSummary setNumWorkUnitsCommitted(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNumWorkUnitsCommitted(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNumWorkUnitsCommitted();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "numWorkUnitsCommitted", DataTemplateUtil.coerceLongInput(value));
                this._numWorkUnitsCommittedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "numWorkUnitsCommitted", DataTemplateUtil.coerceLongInput(value));
                this._numWorkUnitsCommittedField = value;
            }
        }
        return this;
    }

    public DatahubIngestionRunSummary setNumWorkUnitsCommitted(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field numWorkUnitsCommitted of com.linkedin.datajob.datahub.DatahubIngestionRunSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "numWorkUnitsCommitted", DataTemplateUtil.coerceLongInput(value));
        this._numWorkUnitsCommittedField = value;
        return this;
    }

    public DatahubIngestionRunSummary setNumWorkUnitsCommitted(long value) {
        CheckedUtil.putWithoutChecking(this._map, "numWorkUnitsCommitted", DataTemplateUtil.coerceLongInput(value));
        this._numWorkUnitsCommittedField = value;
        return this;
    }

    public boolean hasNumWorkUnitsCreated() {
        if (this._numWorkUnitsCreatedField != null) {
            return true;
        }
        return this._map.containsKey("numWorkUnitsCreated");
    }

    public void removeNumWorkUnitsCreated() {
        this._map.remove("numWorkUnitsCreated");
    }

    @Nullable
    public Long getNumWorkUnitsCreated(GetMode mode) {
        return this.getNumWorkUnitsCreated();
    }

    @Nullable
    public Long getNumWorkUnitsCreated() {
        if (this._numWorkUnitsCreatedField != null) {
            return this._numWorkUnitsCreatedField;
        }
        Object __rawValue = this._map.get("numWorkUnitsCreated");
        this._numWorkUnitsCreatedField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._numWorkUnitsCreatedField;
    }

    public DatahubIngestionRunSummary setNumWorkUnitsCreated(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNumWorkUnitsCreated(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNumWorkUnitsCreated();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "numWorkUnitsCreated", DataTemplateUtil.coerceLongInput(value));
                this._numWorkUnitsCreatedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "numWorkUnitsCreated", DataTemplateUtil.coerceLongInput(value));
                this._numWorkUnitsCreatedField = value;
            }
        }
        return this;
    }

    public DatahubIngestionRunSummary setNumWorkUnitsCreated(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field numWorkUnitsCreated of com.linkedin.datajob.datahub.DatahubIngestionRunSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "numWorkUnitsCreated", DataTemplateUtil.coerceLongInput(value));
        this._numWorkUnitsCreatedField = value;
        return this;
    }

    public DatahubIngestionRunSummary setNumWorkUnitsCreated(long value) {
        CheckedUtil.putWithoutChecking(this._map, "numWorkUnitsCreated", DataTemplateUtil.coerceLongInput(value));
        this._numWorkUnitsCreatedField = value;
        return this;
    }

    public boolean hasNumEvents() {
        if (this._numEventsField != null) {
            return true;
        }
        return this._map.containsKey("numEvents");
    }

    public void removeNumEvents() {
        this._map.remove("numEvents");
    }

    @Nullable
    public Long getNumEvents(GetMode mode) {
        return this.getNumEvents();
    }

    @Nullable
    public Long getNumEvents() {
        if (this._numEventsField != null) {
            return this._numEventsField;
        }
        Object __rawValue = this._map.get("numEvents");
        this._numEventsField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._numEventsField;
    }

    public DatahubIngestionRunSummary setNumEvents(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNumEvents(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNumEvents();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "numEvents", DataTemplateUtil.coerceLongInput(value));
                this._numEventsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "numEvents", DataTemplateUtil.coerceLongInput(value));
                this._numEventsField = value;
            }
        }
        return this;
    }

    public DatahubIngestionRunSummary setNumEvents(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field numEvents of com.linkedin.datajob.datahub.DatahubIngestionRunSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "numEvents", DataTemplateUtil.coerceLongInput(value));
        this._numEventsField = value;
        return this;
    }

    public DatahubIngestionRunSummary setNumEvents(long value) {
        CheckedUtil.putWithoutChecking(this._map, "numEvents", DataTemplateUtil.coerceLongInput(value));
        this._numEventsField = value;
        return this;
    }

    public boolean hasNumEntities() {
        if (this._numEntitiesField != null) {
            return true;
        }
        return this._map.containsKey("numEntities");
    }

    public void removeNumEntities() {
        this._map.remove("numEntities");
    }

    @Nullable
    public Long getNumEntities(GetMode mode) {
        return this.getNumEntities();
    }

    @Nullable
    public Long getNumEntities() {
        if (this._numEntitiesField != null) {
            return this._numEntitiesField;
        }
        Object __rawValue = this._map.get("numEntities");
        this._numEntitiesField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._numEntitiesField;
    }

    public DatahubIngestionRunSummary setNumEntities(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNumEntities(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNumEntities();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "numEntities", DataTemplateUtil.coerceLongInput(value));
                this._numEntitiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "numEntities", DataTemplateUtil.coerceLongInput(value));
                this._numEntitiesField = value;
            }
        }
        return this;
    }

    public DatahubIngestionRunSummary setNumEntities(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field numEntities of com.linkedin.datajob.datahub.DatahubIngestionRunSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "numEntities", DataTemplateUtil.coerceLongInput(value));
        this._numEntitiesField = value;
        return this;
    }

    public DatahubIngestionRunSummary setNumEntities(long value) {
        CheckedUtil.putWithoutChecking(this._map, "numEntities", DataTemplateUtil.coerceLongInput(value));
        this._numEntitiesField = value;
        return this;
    }

    public boolean hasNumAspects() {
        if (this._numAspectsField != null) {
            return true;
        }
        return this._map.containsKey("numAspects");
    }

    public void removeNumAspects() {
        this._map.remove("numAspects");
    }

    @Nullable
    public Long getNumAspects(GetMode mode) {
        return this.getNumAspects();
    }

    @Nullable
    public Long getNumAspects() {
        if (this._numAspectsField != null) {
            return this._numAspectsField;
        }
        Object __rawValue = this._map.get("numAspects");
        this._numAspectsField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._numAspectsField;
    }

    public DatahubIngestionRunSummary setNumAspects(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNumAspects(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNumAspects();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "numAspects", DataTemplateUtil.coerceLongInput(value));
                this._numAspectsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "numAspects", DataTemplateUtil.coerceLongInput(value));
                this._numAspectsField = value;
            }
        }
        return this;
    }

    public DatahubIngestionRunSummary setNumAspects(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field numAspects of com.linkedin.datajob.datahub.DatahubIngestionRunSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "numAspects", DataTemplateUtil.coerceLongInput(value));
        this._numAspectsField = value;
        return this;
    }

    public DatahubIngestionRunSummary setNumAspects(long value) {
        CheckedUtil.putWithoutChecking(this._map, "numAspects", DataTemplateUtil.coerceLongInput(value));
        this._numAspectsField = value;
        return this;
    }

    public boolean hasNumSourceAPICalls() {
        if (this._numSourceAPICallsField != null) {
            return true;
        }
        return this._map.containsKey("numSourceAPICalls");
    }

    public void removeNumSourceAPICalls() {
        this._map.remove("numSourceAPICalls");
    }

    @Nullable
    public Long getNumSourceAPICalls(GetMode mode) {
        return this.getNumSourceAPICalls();
    }

    @Nullable
    public Long getNumSourceAPICalls() {
        if (this._numSourceAPICallsField != null) {
            return this._numSourceAPICallsField;
        }
        Object __rawValue = this._map.get("numSourceAPICalls");
        this._numSourceAPICallsField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._numSourceAPICallsField;
    }

    public DatahubIngestionRunSummary setNumSourceAPICalls(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNumSourceAPICalls(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNumSourceAPICalls();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "numSourceAPICalls", DataTemplateUtil.coerceLongInput(value));
                this._numSourceAPICallsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "numSourceAPICalls", DataTemplateUtil.coerceLongInput(value));
                this._numSourceAPICallsField = value;
            }
        }
        return this;
    }

    public DatahubIngestionRunSummary setNumSourceAPICalls(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field numSourceAPICalls of com.linkedin.datajob.datahub.DatahubIngestionRunSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "numSourceAPICalls", DataTemplateUtil.coerceLongInput(value));
        this._numSourceAPICallsField = value;
        return this;
    }

    public DatahubIngestionRunSummary setNumSourceAPICalls(long value) {
        CheckedUtil.putWithoutChecking(this._map, "numSourceAPICalls", DataTemplateUtil.coerceLongInput(value));
        this._numSourceAPICallsField = value;
        return this;
    }

    public boolean hasTotalLatencySourceAPICalls() {
        if (this._totalLatencySourceAPICallsField != null) {
            return true;
        }
        return this._map.containsKey("totalLatencySourceAPICalls");
    }

    public void removeTotalLatencySourceAPICalls() {
        this._map.remove("totalLatencySourceAPICalls");
    }

    @Nullable
    public Long getTotalLatencySourceAPICalls(GetMode mode) {
        return this.getTotalLatencySourceAPICalls();
    }

    @Nullable
    public Long getTotalLatencySourceAPICalls() {
        if (this._totalLatencySourceAPICallsField != null) {
            return this._totalLatencySourceAPICallsField;
        }
        Object __rawValue = this._map.get("totalLatencySourceAPICalls");
        this._totalLatencySourceAPICallsField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._totalLatencySourceAPICallsField;
    }

    public DatahubIngestionRunSummary setTotalLatencySourceAPICalls(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTotalLatencySourceAPICalls(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTotalLatencySourceAPICalls();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "totalLatencySourceAPICalls", DataTemplateUtil.coerceLongInput(value));
                this._totalLatencySourceAPICallsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "totalLatencySourceAPICalls", DataTemplateUtil.coerceLongInput(value));
                this._totalLatencySourceAPICallsField = value;
            }
        }
        return this;
    }

    public DatahubIngestionRunSummary setTotalLatencySourceAPICalls(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field totalLatencySourceAPICalls of com.linkedin.datajob.datahub.DatahubIngestionRunSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "totalLatencySourceAPICalls", DataTemplateUtil.coerceLongInput(value));
        this._totalLatencySourceAPICallsField = value;
        return this;
    }

    public DatahubIngestionRunSummary setTotalLatencySourceAPICalls(long value) {
        CheckedUtil.putWithoutChecking(this._map, "totalLatencySourceAPICalls", DataTemplateUtil.coerceLongInput(value));
        this._totalLatencySourceAPICallsField = value;
        return this;
    }

    public boolean hasNumSinkAPICalls() {
        if (this._numSinkAPICallsField != null) {
            return true;
        }
        return this._map.containsKey("numSinkAPICalls");
    }

    public void removeNumSinkAPICalls() {
        this._map.remove("numSinkAPICalls");
    }

    @Nullable
    public Long getNumSinkAPICalls(GetMode mode) {
        return this.getNumSinkAPICalls();
    }

    @Nullable
    public Long getNumSinkAPICalls() {
        if (this._numSinkAPICallsField != null) {
            return this._numSinkAPICallsField;
        }
        Object __rawValue = this._map.get("numSinkAPICalls");
        this._numSinkAPICallsField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._numSinkAPICallsField;
    }

    public DatahubIngestionRunSummary setNumSinkAPICalls(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNumSinkAPICalls(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNumSinkAPICalls();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "numSinkAPICalls", DataTemplateUtil.coerceLongInput(value));
                this._numSinkAPICallsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "numSinkAPICalls", DataTemplateUtil.coerceLongInput(value));
                this._numSinkAPICallsField = value;
            }
        }
        return this;
    }

    public DatahubIngestionRunSummary setNumSinkAPICalls(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field numSinkAPICalls of com.linkedin.datajob.datahub.DatahubIngestionRunSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "numSinkAPICalls", DataTemplateUtil.coerceLongInput(value));
        this._numSinkAPICallsField = value;
        return this;
    }

    public DatahubIngestionRunSummary setNumSinkAPICalls(long value) {
        CheckedUtil.putWithoutChecking(this._map, "numSinkAPICalls", DataTemplateUtil.coerceLongInput(value));
        this._numSinkAPICallsField = value;
        return this;
    }

    public boolean hasTotalLatencySinkAPICalls() {
        if (this._totalLatencySinkAPICallsField != null) {
            return true;
        }
        return this._map.containsKey("totalLatencySinkAPICalls");
    }

    public void removeTotalLatencySinkAPICalls() {
        this._map.remove("totalLatencySinkAPICalls");
    }

    @Nullable
    public Long getTotalLatencySinkAPICalls(GetMode mode) {
        return this.getTotalLatencySinkAPICalls();
    }

    @Nullable
    public Long getTotalLatencySinkAPICalls() {
        if (this._totalLatencySinkAPICallsField != null) {
            return this._totalLatencySinkAPICallsField;
        }
        Object __rawValue = this._map.get("totalLatencySinkAPICalls");
        this._totalLatencySinkAPICallsField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._totalLatencySinkAPICallsField;
    }

    public DatahubIngestionRunSummary setTotalLatencySinkAPICalls(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTotalLatencySinkAPICalls(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTotalLatencySinkAPICalls();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "totalLatencySinkAPICalls", DataTemplateUtil.coerceLongInput(value));
                this._totalLatencySinkAPICallsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "totalLatencySinkAPICalls", DataTemplateUtil.coerceLongInput(value));
                this._totalLatencySinkAPICallsField = value;
            }
        }
        return this;
    }

    public DatahubIngestionRunSummary setTotalLatencySinkAPICalls(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field totalLatencySinkAPICalls of com.linkedin.datajob.datahub.DatahubIngestionRunSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "totalLatencySinkAPICalls", DataTemplateUtil.coerceLongInput(value));
        this._totalLatencySinkAPICallsField = value;
        return this;
    }

    public DatahubIngestionRunSummary setTotalLatencySinkAPICalls(long value) {
        CheckedUtil.putWithoutChecking(this._map, "totalLatencySinkAPICalls", DataTemplateUtil.coerceLongInput(value));
        this._totalLatencySinkAPICallsField = value;
        return this;
    }

    public boolean hasNumWarnings() {
        if (this._numWarningsField != null) {
            return true;
        }
        return this._map.containsKey("numWarnings");
    }

    public void removeNumWarnings() {
        this._map.remove("numWarnings");
    }

    @Nullable
    public Long getNumWarnings(GetMode mode) {
        return this.getNumWarnings();
    }

    @Nullable
    public Long getNumWarnings() {
        if (this._numWarningsField != null) {
            return this._numWarningsField;
        }
        Object __rawValue = this._map.get("numWarnings");
        this._numWarningsField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._numWarningsField;
    }

    public DatahubIngestionRunSummary setNumWarnings(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNumWarnings(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNumWarnings();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "numWarnings", DataTemplateUtil.coerceLongInput(value));
                this._numWarningsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "numWarnings", DataTemplateUtil.coerceLongInput(value));
                this._numWarningsField = value;
            }
        }
        return this;
    }

    public DatahubIngestionRunSummary setNumWarnings(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field numWarnings of com.linkedin.datajob.datahub.DatahubIngestionRunSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "numWarnings", DataTemplateUtil.coerceLongInput(value));
        this._numWarningsField = value;
        return this;
    }

    public DatahubIngestionRunSummary setNumWarnings(long value) {
        CheckedUtil.putWithoutChecking(this._map, "numWarnings", DataTemplateUtil.coerceLongInput(value));
        this._numWarningsField = value;
        return this;
    }

    public boolean hasNumErrors() {
        if (this._numErrorsField != null) {
            return true;
        }
        return this._map.containsKey("numErrors");
    }

    public void removeNumErrors() {
        this._map.remove("numErrors");
    }

    @Nullable
    public Long getNumErrors(GetMode mode) {
        return this.getNumErrors();
    }

    @Nullable
    public Long getNumErrors() {
        if (this._numErrorsField != null) {
            return this._numErrorsField;
        }
        Object __rawValue = this._map.get("numErrors");
        this._numErrorsField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._numErrorsField;
    }

    public DatahubIngestionRunSummary setNumErrors(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNumErrors(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNumErrors();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "numErrors", DataTemplateUtil.coerceLongInput(value));
                this._numErrorsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "numErrors", DataTemplateUtil.coerceLongInput(value));
                this._numErrorsField = value;
            }
        }
        return this;
    }

    public DatahubIngestionRunSummary setNumErrors(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field numErrors of com.linkedin.datajob.datahub.DatahubIngestionRunSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "numErrors", DataTemplateUtil.coerceLongInput(value));
        this._numErrorsField = value;
        return this;
    }

    public DatahubIngestionRunSummary setNumErrors(long value) {
        CheckedUtil.putWithoutChecking(this._map, "numErrors", DataTemplateUtil.coerceLongInput(value));
        this._numErrorsField = value;
        return this;
    }

    public boolean hasNumEntitiesSkipped() {
        if (this._numEntitiesSkippedField != null) {
            return true;
        }
        return this._map.containsKey("numEntitiesSkipped");
    }

    public void removeNumEntitiesSkipped() {
        this._map.remove("numEntitiesSkipped");
    }

    @Nullable
    public Long getNumEntitiesSkipped(GetMode mode) {
        return this.getNumEntitiesSkipped();
    }

    @Nullable
    public Long getNumEntitiesSkipped() {
        if (this._numEntitiesSkippedField != null) {
            return this._numEntitiesSkippedField;
        }
        Object __rawValue = this._map.get("numEntitiesSkipped");
        this._numEntitiesSkippedField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._numEntitiesSkippedField;
    }

    public DatahubIngestionRunSummary setNumEntitiesSkipped(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNumEntitiesSkipped(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNumEntitiesSkipped();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "numEntitiesSkipped", DataTemplateUtil.coerceLongInput(value));
                this._numEntitiesSkippedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "numEntitiesSkipped", DataTemplateUtil.coerceLongInput(value));
                this._numEntitiesSkippedField = value;
            }
        }
        return this;
    }

    public DatahubIngestionRunSummary setNumEntitiesSkipped(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field numEntitiesSkipped of com.linkedin.datajob.datahub.DatahubIngestionRunSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "numEntitiesSkipped", DataTemplateUtil.coerceLongInput(value));
        this._numEntitiesSkippedField = value;
        return this;
    }

    public DatahubIngestionRunSummary setNumEntitiesSkipped(long value) {
        CheckedUtil.putWithoutChecking(this._map, "numEntitiesSkipped", DataTemplateUtil.coerceLongInput(value));
        this._numEntitiesSkippedField = value;
        return this;
    }

    public boolean hasConfig() {
        if (this._configField != null) {
            return true;
        }
        return this._map.containsKey("config");
    }

    public void removeConfig() {
        this._map.remove("config");
    }

    @Nullable
    public String getConfig(GetMode mode) {
        return this.getConfig();
    }

    @Nullable
    public String getConfig() {
        if (this._configField != null) {
            return this._configField;
        }
        Object __rawValue = this._map.get("config");
        this._configField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._configField;
    }

    public DatahubIngestionRunSummary setConfig(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setConfig(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeConfig();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "config", value);
                this._configField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "config", value);
                this._configField = value;
            }
        }
        return this;
    }

    public DatahubIngestionRunSummary setConfig(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field config of com.linkedin.datajob.datahub.DatahubIngestionRunSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "config", value);
        this._configField = value;
        return this;
    }

    public boolean hasCustom_summary() {
        if (this._custom_summaryField != null) {
            return true;
        }
        return this._map.containsKey("custom_summary");
    }

    public void removeCustom_summary() {
        this._map.remove("custom_summary");
    }

    @Nullable
    public String getCustom_summary(GetMode mode) {
        return this.getCustom_summary();
    }

    @Nullable
    public String getCustom_summary() {
        if (this._custom_summaryField != null) {
            return this._custom_summaryField;
        }
        Object __rawValue = this._map.get("custom_summary");
        this._custom_summaryField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._custom_summaryField;
    }

    public DatahubIngestionRunSummary setCustom_summary(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCustom_summary(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCustom_summary();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "custom_summary", value);
                this._custom_summaryField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "custom_summary", value);
                this._custom_summaryField = value;
            }
        }
        return this;
    }

    public DatahubIngestionRunSummary setCustom_summary(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field custom_summary of com.linkedin.datajob.datahub.DatahubIngestionRunSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "custom_summary", value);
        this._custom_summaryField = value;
        return this;
    }

    public boolean hasSoftwareVersion() {
        if (this._softwareVersionField != null) {
            return true;
        }
        return this._map.containsKey("softwareVersion");
    }

    public void removeSoftwareVersion() {
        this._map.remove("softwareVersion");
    }

    @Nullable
    public String getSoftwareVersion(GetMode mode) {
        return this.getSoftwareVersion();
    }

    @Nullable
    public String getSoftwareVersion() {
        if (this._softwareVersionField != null) {
            return this._softwareVersionField;
        }
        Object __rawValue = this._map.get("softwareVersion");
        this._softwareVersionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._softwareVersionField;
    }

    public DatahubIngestionRunSummary setSoftwareVersion(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSoftwareVersion(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSoftwareVersion();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "softwareVersion", value);
                this._softwareVersionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "softwareVersion", value);
                this._softwareVersionField = value;
            }
        }
        return this;
    }

    public DatahubIngestionRunSummary setSoftwareVersion(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field softwareVersion of com.linkedin.datajob.datahub.DatahubIngestionRunSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "softwareVersion", value);
        this._softwareVersionField = value;
        return this;
    }

    public boolean hasSystemHostName() {
        if (this._systemHostNameField != null) {
            return true;
        }
        return this._map.containsKey("systemHostName");
    }

    public void removeSystemHostName() {
        this._map.remove("systemHostName");
    }

    @Nullable
    public String getSystemHostName(GetMode mode) {
        return this.getSystemHostName();
    }

    @Nullable
    public String getSystemHostName() {
        if (this._systemHostNameField != null) {
            return this._systemHostNameField;
        }
        Object __rawValue = this._map.get("systemHostName");
        this._systemHostNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._systemHostNameField;
    }

    public DatahubIngestionRunSummary setSystemHostName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSystemHostName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSystemHostName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "systemHostName", value);
                this._systemHostNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "systemHostName", value);
                this._systemHostNameField = value;
            }
        }
        return this;
    }

    public DatahubIngestionRunSummary setSystemHostName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field systemHostName of com.linkedin.datajob.datahub.DatahubIngestionRunSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "systemHostName", value);
        this._systemHostNameField = value;
        return this;
    }

    public boolean hasOperatingSystemName() {
        if (this._operatingSystemNameField != null) {
            return true;
        }
        return this._map.containsKey("operatingSystemName");
    }

    public void removeOperatingSystemName() {
        this._map.remove("operatingSystemName");
    }

    @Nullable
    public String getOperatingSystemName(GetMode mode) {
        return this.getOperatingSystemName();
    }

    @Nullable
    public String getOperatingSystemName() {
        if (this._operatingSystemNameField != null) {
            return this._operatingSystemNameField;
        }
        Object __rawValue = this._map.get("operatingSystemName");
        this._operatingSystemNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._operatingSystemNameField;
    }

    public DatahubIngestionRunSummary setOperatingSystemName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setOperatingSystemName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeOperatingSystemName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "operatingSystemName", value);
                this._operatingSystemNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "operatingSystemName", value);
                this._operatingSystemNameField = value;
            }
        }
        return this;
    }

    public DatahubIngestionRunSummary setOperatingSystemName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field operatingSystemName of com.linkedin.datajob.datahub.DatahubIngestionRunSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "operatingSystemName", value);
        this._operatingSystemNameField = value;
        return this;
    }

    public boolean hasNumProcessors() {
        if (this._numProcessorsField != null) {
            return true;
        }
        return this._map.containsKey("numProcessors");
    }

    public void removeNumProcessors() {
        this._map.remove("numProcessors");
    }

    @Nullable
    public Integer getNumProcessors(GetMode mode) {
        return this.getNumProcessors();
    }

    @Nullable
    public Integer getNumProcessors() {
        if (this._numProcessorsField != null) {
            return this._numProcessorsField;
        }
        Object __rawValue = this._map.get("numProcessors");
        this._numProcessorsField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._numProcessorsField;
    }

    public DatahubIngestionRunSummary setNumProcessors(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNumProcessors(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNumProcessors();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "numProcessors", DataTemplateUtil.coerceIntInput(value));
                this._numProcessorsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "numProcessors", DataTemplateUtil.coerceIntInput(value));
                this._numProcessorsField = value;
            }
        }
        return this;
    }

    public DatahubIngestionRunSummary setNumProcessors(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field numProcessors of com.linkedin.datajob.datahub.DatahubIngestionRunSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "numProcessors", DataTemplateUtil.coerceIntInput(value));
        this._numProcessorsField = value;
        return this;
    }

    public DatahubIngestionRunSummary setNumProcessors(int value) {
        CheckedUtil.putWithoutChecking(this._map, "numProcessors", DataTemplateUtil.coerceIntInput(value));
        this._numProcessorsField = value;
        return this;
    }

    public boolean hasTotalMemory() {
        if (this._totalMemoryField != null) {
            return true;
        }
        return this._map.containsKey("totalMemory");
    }

    public void removeTotalMemory() {
        this._map.remove("totalMemory");
    }

    @Nullable
    public Long getTotalMemory(GetMode mode) {
        return this.getTotalMemory();
    }

    @Nullable
    public Long getTotalMemory() {
        if (this._totalMemoryField != null) {
            return this._totalMemoryField;
        }
        Object __rawValue = this._map.get("totalMemory");
        this._totalMemoryField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._totalMemoryField;
    }

    public DatahubIngestionRunSummary setTotalMemory(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTotalMemory(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTotalMemory();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "totalMemory", DataTemplateUtil.coerceLongInput(value));
                this._totalMemoryField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "totalMemory", DataTemplateUtil.coerceLongInput(value));
                this._totalMemoryField = value;
            }
        }
        return this;
    }

    public DatahubIngestionRunSummary setTotalMemory(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field totalMemory of com.linkedin.datajob.datahub.DatahubIngestionRunSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "totalMemory", DataTemplateUtil.coerceLongInput(value));
        this._totalMemoryField = value;
        return this;
    }

    public DatahubIngestionRunSummary setTotalMemory(long value) {
        CheckedUtil.putWithoutChecking(this._map, "totalMemory", DataTemplateUtil.coerceLongInput(value));
        this._totalMemoryField = value;
        return this;
    }

    public boolean hasAvailableMemory() {
        if (this._availableMemoryField != null) {
            return true;
        }
        return this._map.containsKey("availableMemory");
    }

    public void removeAvailableMemory() {
        this._map.remove("availableMemory");
    }

    @Nullable
    public Long getAvailableMemory(GetMode mode) {
        return this.getAvailableMemory();
    }

    @Nullable
    public Long getAvailableMemory() {
        if (this._availableMemoryField != null) {
            return this._availableMemoryField;
        }
        Object __rawValue = this._map.get("availableMemory");
        this._availableMemoryField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._availableMemoryField;
    }

    public DatahubIngestionRunSummary setAvailableMemory(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAvailableMemory(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAvailableMemory();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "availableMemory", DataTemplateUtil.coerceLongInput(value));
                this._availableMemoryField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "availableMemory", DataTemplateUtil.coerceLongInput(value));
                this._availableMemoryField = value;
            }
        }
        return this;
    }

    public DatahubIngestionRunSummary setAvailableMemory(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field availableMemory of com.linkedin.datajob.datahub.DatahubIngestionRunSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "availableMemory", DataTemplateUtil.coerceLongInput(value));
        this._availableMemoryField = value;
        return this;
    }

    public DatahubIngestionRunSummary setAvailableMemory(long value) {
        CheckedUtil.putWithoutChecking(this._map, "availableMemory", DataTemplateUtil.coerceLongInput(value));
        this._availableMemoryField = value;
        return this;
    }

    @Override
    public DatahubIngestionRunSummary clone() throws CloneNotSupportedException {
        DatahubIngestionRunSummary __clone = (DatahubIngestionRunSummary)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DatahubIngestionRunSummary copy() throws CloneNotSupportedException {
        DatahubIngestionRunSummary __copy = (DatahubIngestionRunSummary)super.copy();
        __copy._numErrorsField = null;
        __copy._eventGranularityField = null;
        __copy._totalLatencySinkAPICallsField = null;
        __copy._platformInstanceIdField = null;
        __copy._timestampMillisField = null;
        __copy._numWorkUnitsCreatedField = null;
        __copy._runStatusField = null;
        __copy._numProcessorsField = null;
        __copy._numEntitiesField = null;
        __copy._messageIdField = null;
        __copy._systemHostNameField = null;
        __copy._partitionSpecField = null;
        __copy._pipelineNameField = null;
        __copy._numEntitiesSkippedField = null;
        __copy._totalMemoryField = null;
        __copy._numAspectsField = null;
        __copy._totalLatencySourceAPICallsField = null;
        __copy._availableMemoryField = null;
        __copy._numSourceAPICallsField = null;
        __copy._numSinkAPICallsField = null;
        __copy._numWorkUnitsCommittedField = null;
        __copy._numEventsField = null;
        __copy._runIdField = null;
        __copy._configField = null;
        __copy._operatingSystemNameField = null;
        __copy._numWarningsField = null;
        __copy._custom_summaryField = null;
        __copy._softwareVersionField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_MessageId = SCHEMA.getField("messageId");
        FIELD_PipelineName = SCHEMA.getField("pipelineName");
        FIELD_PlatformInstanceId = SCHEMA.getField("platformInstanceId");
        FIELD_RunId = SCHEMA.getField("runId");
        FIELD_RunStatus = SCHEMA.getField("runStatus");
        FIELD_NumWorkUnitsCommitted = SCHEMA.getField("numWorkUnitsCommitted");
        FIELD_NumWorkUnitsCreated = SCHEMA.getField("numWorkUnitsCreated");
        FIELD_NumEvents = SCHEMA.getField("numEvents");
        FIELD_NumEntities = SCHEMA.getField("numEntities");
        FIELD_NumAspects = SCHEMA.getField("numAspects");
        FIELD_NumSourceAPICalls = SCHEMA.getField("numSourceAPICalls");
        FIELD_TotalLatencySourceAPICalls = SCHEMA.getField("totalLatencySourceAPICalls");
        FIELD_NumSinkAPICalls = SCHEMA.getField("numSinkAPICalls");
        FIELD_TotalLatencySinkAPICalls = SCHEMA.getField("totalLatencySinkAPICalls");
        FIELD_NumWarnings = SCHEMA.getField("numWarnings");
        FIELD_NumErrors = SCHEMA.getField("numErrors");
        FIELD_NumEntitiesSkipped = SCHEMA.getField("numEntitiesSkipped");
        FIELD_Config = SCHEMA.getField("config");
        FIELD_Custom_summary = SCHEMA.getField("custom_summary");
        FIELD_SoftwareVersion = SCHEMA.getField("softwareVersion");
        FIELD_SystemHostName = SCHEMA.getField("systemHostName");
        FIELD_OperatingSystemName = SCHEMA.getField("operatingSystemName");
        FIELD_NumProcessors = SCHEMA.getField("numProcessors");
        FIELD_TotalMemory = SCHEMA.getField("totalMemory");
        FIELD_AvailableMemory = SCHEMA.getField("availableMemory");
        DEFAULT_PartitionSpec = FIELD_PartitionSpec.getDefault() == null ? null : new PartitionSpec(DataTemplateUtil.castOrThrow(FIELD_PartitionSpec.getDefault(), DataMap.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DatahubIngestionRunSummary __objectRef;

        private ChangeListener(DatahubIngestionRunSummary reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "numErrors": {
                    this.__objectRef._numErrorsField = null;
                    break;
                }
                case "eventGranularity": {
                    this.__objectRef._eventGranularityField = null;
                    break;
                }
                case "totalLatencySinkAPICalls": {
                    this.__objectRef._totalLatencySinkAPICallsField = null;
                    break;
                }
                case "platformInstanceId": {
                    this.__objectRef._platformInstanceIdField = null;
                    break;
                }
                case "timestampMillis": {
                    this.__objectRef._timestampMillisField = null;
                    break;
                }
                case "numWorkUnitsCreated": {
                    this.__objectRef._numWorkUnitsCreatedField = null;
                    break;
                }
                case "runStatus": {
                    this.__objectRef._runStatusField = null;
                    break;
                }
                case "numProcessors": {
                    this.__objectRef._numProcessorsField = null;
                    break;
                }
                case "numEntities": {
                    this.__objectRef._numEntitiesField = null;
                    break;
                }
                case "messageId": {
                    this.__objectRef._messageIdField = null;
                    break;
                }
                case "systemHostName": {
                    this.__objectRef._systemHostNameField = null;
                    break;
                }
                case "partitionSpec": {
                    this.__objectRef._partitionSpecField = null;
                    break;
                }
                case "pipelineName": {
                    this.__objectRef._pipelineNameField = null;
                    break;
                }
                case "numEntitiesSkipped": {
                    this.__objectRef._numEntitiesSkippedField = null;
                    break;
                }
                case "totalMemory": {
                    this.__objectRef._totalMemoryField = null;
                    break;
                }
                case "numAspects": {
                    this.__objectRef._numAspectsField = null;
                    break;
                }
                case "totalLatencySourceAPICalls": {
                    this.__objectRef._totalLatencySourceAPICallsField = null;
                    break;
                }
                case "availableMemory": {
                    this.__objectRef._availableMemoryField = null;
                    break;
                }
                case "numSourceAPICalls": {
                    this.__objectRef._numSourceAPICallsField = null;
                    break;
                }
                case "numSinkAPICalls": {
                    this.__objectRef._numSinkAPICallsField = null;
                    break;
                }
                case "numWorkUnitsCommitted": {
                    this.__objectRef._numWorkUnitsCommittedField = null;
                    break;
                }
                case "numEvents": {
                    this.__objectRef._numEventsField = null;
                    break;
                }
                case "runId": {
                    this.__objectRef._runIdField = null;
                    break;
                }
                case "config": {
                    this.__objectRef._configField = null;
                    break;
                }
                case "operatingSystemName": {
                    this.__objectRef._operatingSystemNameField = null;
                    break;
                }
                case "numWarnings": {
                    this.__objectRef._numWarningsField = null;
                    break;
                }
                case "custom_summary": {
                    this.__objectRef._custom_summaryField = null;
                    break;
                }
                case "softwareVersion": {
                    this.__objectRef._softwareVersionField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec timestampMillis() {
            return new PathSpec(this.getPathComponents(), "timestampMillis");
        }

        public TimeWindowSize.Fields eventGranularity() {
            return new TimeWindowSize.Fields(this.getPathComponents(), "eventGranularity");
        }

        public PartitionSpec.Fields partitionSpec() {
            return new PartitionSpec.Fields(this.getPathComponents(), "partitionSpec");
        }

        public PathSpec messageId() {
            return new PathSpec(this.getPathComponents(), "messageId");
        }

        public PathSpec pipelineName() {
            return new PathSpec(this.getPathComponents(), "pipelineName");
        }

        public PathSpec platformInstanceId() {
            return new PathSpec(this.getPathComponents(), "platformInstanceId");
        }

        public PathSpec runId() {
            return new PathSpec(this.getPathComponents(), "runId");
        }

        public PathSpec runStatus() {
            return new PathSpec(this.getPathComponents(), "runStatus");
        }

        public PathSpec numWorkUnitsCommitted() {
            return new PathSpec(this.getPathComponents(), "numWorkUnitsCommitted");
        }

        public PathSpec numWorkUnitsCreated() {
            return new PathSpec(this.getPathComponents(), "numWorkUnitsCreated");
        }

        public PathSpec numEvents() {
            return new PathSpec(this.getPathComponents(), "numEvents");
        }

        public PathSpec numEntities() {
            return new PathSpec(this.getPathComponents(), "numEntities");
        }

        public PathSpec numAspects() {
            return new PathSpec(this.getPathComponents(), "numAspects");
        }

        public PathSpec numSourceAPICalls() {
            return new PathSpec(this.getPathComponents(), "numSourceAPICalls");
        }

        public PathSpec totalLatencySourceAPICalls() {
            return new PathSpec(this.getPathComponents(), "totalLatencySourceAPICalls");
        }

        public PathSpec numSinkAPICalls() {
            return new PathSpec(this.getPathComponents(), "numSinkAPICalls");
        }

        public PathSpec totalLatencySinkAPICalls() {
            return new PathSpec(this.getPathComponents(), "totalLatencySinkAPICalls");
        }

        public PathSpec numWarnings() {
            return new PathSpec(this.getPathComponents(), "numWarnings");
        }

        public PathSpec numErrors() {
            return new PathSpec(this.getPathComponents(), "numErrors");
        }

        public PathSpec numEntitiesSkipped() {
            return new PathSpec(this.getPathComponents(), "numEntitiesSkipped");
        }

        public PathSpec config() {
            return new PathSpec(this.getPathComponents(), "config");
        }

        public PathSpec custom_summary() {
            return new PathSpec(this.getPathComponents(), "custom_summary");
        }

        public PathSpec softwareVersion() {
            return new PathSpec(this.getPathComponents(), "softwareVersion");
        }

        public PathSpec systemHostName() {
            return new PathSpec(this.getPathComponents(), "systemHostName");
        }

        public PathSpec operatingSystemName() {
            return new PathSpec(this.getPathComponents(), "operatingSystemName");
        }

        public PathSpec numProcessors() {
            return new PathSpec(this.getPathComponents(), "numProcessors");
        }

        public PathSpec totalMemory() {
            return new PathSpec(this.getPathComponents(), "totalMemory");
        }

        public PathSpec availableMemory() {
            return new PathSpec(this.getPathComponents(), "availableMemory");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private TimeWindowSize.ProjectionMask _eventGranularityMask;
        private PartitionSpec.ProjectionMask _partitionSpecMask;

        ProjectionMask() {
        }

        public ProjectionMask withTimestampMillis() {
            this.getDataMap().put("timestampMillis", 1);
            return this;
        }

        public ProjectionMask withEventGranularity(Function<TimeWindowSize.ProjectionMask, TimeWindowSize.ProjectionMask> nestedMask) {
            this._eventGranularityMask = nestedMask.apply(this._eventGranularityMask == null ? TimeWindowSize.createMask() : this._eventGranularityMask);
            this.getDataMap().put("eventGranularity", this._eventGranularityMask.getDataMap());
            return this;
        }

        public ProjectionMask withEventGranularity() {
            this._eventGranularityMask = null;
            this.getDataMap().put("eventGranularity", 1);
            return this;
        }

        public ProjectionMask withPartitionSpec(Function<PartitionSpec.ProjectionMask, PartitionSpec.ProjectionMask> nestedMask) {
            this._partitionSpecMask = nestedMask.apply(this._partitionSpecMask == null ? PartitionSpec.createMask() : this._partitionSpecMask);
            this.getDataMap().put("partitionSpec", this._partitionSpecMask.getDataMap());
            return this;
        }

        public ProjectionMask withPartitionSpec() {
            this._partitionSpecMask = null;
            this.getDataMap().put("partitionSpec", 1);
            return this;
        }

        public ProjectionMask withMessageId() {
            this.getDataMap().put("messageId", 1);
            return this;
        }

        public ProjectionMask withPipelineName() {
            this.getDataMap().put("pipelineName", 1);
            return this;
        }

        public ProjectionMask withPlatformInstanceId() {
            this.getDataMap().put("platformInstanceId", 1);
            return this;
        }

        public ProjectionMask withRunId() {
            this.getDataMap().put("runId", 1);
            return this;
        }

        public ProjectionMask withRunStatus() {
            this.getDataMap().put("runStatus", 1);
            return this;
        }

        public ProjectionMask withNumWorkUnitsCommitted() {
            this.getDataMap().put("numWorkUnitsCommitted", 1);
            return this;
        }

        public ProjectionMask withNumWorkUnitsCreated() {
            this.getDataMap().put("numWorkUnitsCreated", 1);
            return this;
        }

        public ProjectionMask withNumEvents() {
            this.getDataMap().put("numEvents", 1);
            return this;
        }

        public ProjectionMask withNumEntities() {
            this.getDataMap().put("numEntities", 1);
            return this;
        }

        public ProjectionMask withNumAspects() {
            this.getDataMap().put("numAspects", 1);
            return this;
        }

        public ProjectionMask withNumSourceAPICalls() {
            this.getDataMap().put("numSourceAPICalls", 1);
            return this;
        }

        public ProjectionMask withTotalLatencySourceAPICalls() {
            this.getDataMap().put("totalLatencySourceAPICalls", 1);
            return this;
        }

        public ProjectionMask withNumSinkAPICalls() {
            this.getDataMap().put("numSinkAPICalls", 1);
            return this;
        }

        public ProjectionMask withTotalLatencySinkAPICalls() {
            this.getDataMap().put("totalLatencySinkAPICalls", 1);
            return this;
        }

        public ProjectionMask withNumWarnings() {
            this.getDataMap().put("numWarnings", 1);
            return this;
        }

        public ProjectionMask withNumErrors() {
            this.getDataMap().put("numErrors", 1);
            return this;
        }

        public ProjectionMask withNumEntitiesSkipped() {
            this.getDataMap().put("numEntitiesSkipped", 1);
            return this;
        }

        public ProjectionMask withConfig() {
            this.getDataMap().put("config", 1);
            return this;
        }

        public ProjectionMask withCustom_summary() {
            this.getDataMap().put("custom_summary", 1);
            return this;
        }

        public ProjectionMask withSoftwareVersion() {
            this.getDataMap().put("softwareVersion", 1);
            return this;
        }

        public ProjectionMask withSystemHostName() {
            this.getDataMap().put("systemHostName", 1);
            return this;
        }

        public ProjectionMask withOperatingSystemName() {
            this.getDataMap().put("operatingSystemName", 1);
            return this;
        }

        public ProjectionMask withNumProcessors() {
            this.getDataMap().put("numProcessors", 1);
            return this;
        }

        public ProjectionMask withTotalMemory() {
            this.getDataMap().put("totalMemory", 1);
            return this;
        }

        public ProjectionMask withAvailableMemory() {
            this.getDataMap().put("availableMemory", 1);
            return this;
        }
    }
}

