/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.datajob;

import com.linkedin.common.DataJobUrnArray;
import com.linkedin.common.DatasetUrnArray;
import com.linkedin.common.EdgeArray;
import com.linkedin.common.UrnArray;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.dataset.FineGrainedLineageArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataJobInputOutput
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.datajob/**Information about the inputs and outputs of a Data processing job*/@Aspect.name=\"dataJobInputOutput\"record DataJobInputOutput{/**Input datasets consumed by the data job during processing\nDeprecated! Use inputDatasetEdges instead.*/@Relationship.`/*`={\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"name\":\"Consumes\"}@Searchable.`/*`={\"fieldName\":\"inputs\",\"fieldType\":\"URN\",\"numValuesFieldName\":\"numInputDatasets\",\"queryByDefault\":false}@deprecated,inputDatasets:array[{namespace com.linkedin.common/**Standardized dataset identifier.*/@java.class=\"com.linkedin.common.urn.DatasetUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized dataset identifier.\",\"entityType\":\"dataset\",\"fields\":[{\"doc\":\"Standardized platform urn where dataset is defined.\",\"name\":\"platform\",\"type\":\"com.linkedin.common.urn.DataPlatformUrn\"},{\"doc\":\"Dataset native name e.g. <db>.<table>, /dir/subdir/<name>, or <name>\",\"maxLength\":210,\"name\":\"datasetName\",\"type\":\"string\"},{\"doc\":\"Fabric type where dataset belongs to or where it was generated.\",\"name\":\"origin\",\"type\":\"com.linkedin.common.FabricType\"}],\"maxLength\":284,\"name\":\"Dataset\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DatasetUrn=string}]/**Input datasets consumed by the data job during processing*/@Relationship.`/*/destinationUrn`={\"createdActor\":\"inputDatasetEdges/*/created/actor\",\"createdOn\":\"inputDatasetEdges/*/created/time\",\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"name\":\"Consumes\",\"properties\":\"inputDatasetEdges/*/properties\",\"updatedActor\":\"inputDatasetEdges/*/lastModified/actor\",\"updatedOn\":\"inputDatasetEdges/*/lastModified/time\"}@Searchable.`/*/destinationUrn`={\"fieldName\":\"inputDatasetEdges\",\"fieldType\":\"URN\",\"numValuesFieldName\":\"numInputDatasets\",\"queryByDefault\":false}inputDatasetEdges:optional array[{namespace com.linkedin.common/**A common structure to represent all edges to entities when used inside aspects as collections\nThis ensures that all edges have common structure around audit-stamps and will support PATCH, time-travel automatically.\n*/record Edge{/**Urn of the source of this relationship edge.\nIf not specified, assumed to be the entity that this aspect belongs to.*/sourceUrn:optional@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**Urn of the destination of this relationship edge.*/destinationUrn:Urn/**Audit stamp containing who created this relationship edge and when*/created:optional/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}/**Audit stamp containing who last modified this relationship edge and when*/lastModified:optional AuditStamp/**A generic properties bag that allows us to store specific information on this graph edge.*/properties:optional map[string,string]}}]/**Output datasets produced by the data job during processing\nDeprecated! Use outputDatasetEdges instead.*/@Relationship.`/*`={\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"isUpstream\":false,\"name\":\"Produces\"}@Searchable.`/*`={\"fieldName\":\"outputs\",\"fieldType\":\"URN\",\"numValuesFieldName\":\"numOutputDatasets\",\"queryByDefault\":false}@deprecated,outputDatasets:array[com.linkedin.common.DatasetUrn]/**Output datasets produced by the data job during processing*/@Relationship.`/*/destinationUrn`={\"createdActor\":\"outputDatasetEdges/*/created/actor\",\"createdOn\":\"outputDatasetEdges/*/created/time\",\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"isUpstream\":false,\"name\":\"Produces\",\"properties\":\"outputDatasetEdges/*/properties\",\"updatedActor\":\"outputDatasetEdges/*/lastModified/actor\",\"updatedOn\":\"outputDatasetEdges/*/lastModified/time\"}@Searchable.`/*/destinationUrn`={\"fieldName\":\"outputDatasetEdges\",\"fieldType\":\"URN\",\"numValuesFieldName\":\"numOutputDatasets\",\"queryByDefault\":false}outputDatasetEdges:optional array[com.linkedin.common.Edge]/**Input datajobs that this data job depends on\nDeprecated! Use inputDatajobEdges instead.*/@Relationship.`/*`={\"entityTypes\":[\"dataJob\"],\"isLineage\":true,\"name\":\"DownstreamOf\"}@deprecated,inputDatajobs:optional array[{namespace com.linkedin.common/**Standardized data processing job identifier.*/@java.class=\"com.linkedin.common.urn.DataJobUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized data processing job identifier.\",\"entityType\":\"dataJob\",\"fields\":[{\"doc\":\"Standardized data processing flow urn representing the flow for the job\",\"name\":\"flow\",\"type\":\"com.linkedin.common.urn.DataFlowUrn\"},{\"doc\":\"Unique identifier of the data job\",\"maxLength\":200,\"name\":\"jobID\",\"type\":\"string\"}],\"maxLength\":594,\"name\":\"DataJob\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DataJobUrn=string}]/**Input datajobs that this data job depends on*/@Relationship.`/*/destinationUrn`={\"createdActor\":\"inputDatajobEdges/*/created/actor\",\"createdOn\":\"inputDatajobEdges/*/created/time\",\"entityTypes\":[\"dataJob\"],\"isLineage\":true,\"name\":\"DownstreamOf\",\"properties\":\"inputDatajobEdges/*/properties\",\"updatedActor\":\"inputDatajobEdges/*/lastModified/actor\",\"updatedOn\":\"inputDatajobEdges/*/lastModified/time\"}inputDatajobEdges:optional array[com.linkedin.common.Edge]/**Fields of the input datasets used by this job*/@Relationship.`/*`={\"entityTypes\":[\"schemaField\"],\"name\":\"Consumes\"}@Searchable.`/*`={\"fieldName\":\"inputFields\",\"fieldType\":\"URN\",\"numValuesFieldName\":\"numInputFields\",\"queryByDefault\":false}inputDatasetFields:optional array[com.linkedin.common.Urn]/**Fields of the output datasets this job writes to*/@Relationship.`/*`={\"entityTypes\":[\"schemaField\"],\"name\":\"Produces\"}@Searchable.`/*`={\"fieldName\":\"outputFields\",\"fieldType\":\"URN\",\"numValuesFieldName\":\"numOutputFields\",\"queryByDefault\":false}outputDatasetFields:optional array[com.linkedin.common.Urn]/**Fine-grained column-level lineages\nNot currently supported in the UI\nUse UpstreamLineage aspect for datasets to express Column Level Lineage for the UI*/fineGrainedLineages:optional array[{namespace com.linkedin.dataset/**A fine-grained lineage from upstream fields/datasets to downstream field(s)*/record FineGrainedLineage{/**The type of upstream entity*/upstreamType:/**The type of upstream entity in a fine-grained lineage*/enum FineGrainedLineageUpstreamType{/** Indicates that this lineage is originating from upstream field(s)*/FIELD_SET/** Indicates that this lineage is originating from upstream dataset(s)*/DATASET/** Indicates that there is no upstream lineage i.e. the downstream field is not a derived field*/NONE}/**Upstream entities in the lineage*/@Searchable.`/*`={\"fieldName\":\"fineGrainedUpstreams\",\"fieldType\":\"URN\",\"hasValuesFieldName\":\"hasFineGrainedUpstreams\",\"queryByDefault\":false}upstreams:optional array[com.linkedin.common.Urn]/**The type of downstream field(s)*/downstreamType:/**The type of downstream field(s) in a fine-grained lineage*/enum FineGrainedLineageDownstreamType{/** Indicates that the lineage is for a single, specific, downstream field*/FIELD/** Indicates that the lineage is for a set of downstream fields*/FIELD_SET}/**Downstream fields in the lineage*/downstreams:optional array[com.linkedin.common.Urn]/**The transform operation applied to the upstream entities to produce the downstream field(s)*/transformOperation:optional string/**The confidence in this lineage between 0 (low confidence) and 1 (high confidence)*/confidenceScore:float=1.0/**The query that was used to generate this lineage. \nPresent only if the lineage was generated from a detected query.*/query:optional com.linkedin.common.Urn}}]}", SchemaFormatType.PDL);
    private DatasetUrnArray _inputDatasetsField = null;
    private EdgeArray _inputDatasetEdgesField = null;
    private DatasetUrnArray _outputDatasetsField = null;
    private EdgeArray _outputDatasetEdgesField = null;
    private DataJobUrnArray _inputDatajobsField = null;
    private EdgeArray _inputDatajobEdgesField = null;
    private UrnArray _inputDatasetFieldsField = null;
    private UrnArray _outputDatasetFieldsField = null;
    private FineGrainedLineageArray _fineGrainedLineagesField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_InputDatasets = SCHEMA.getField("inputDatasets");
    private static final RecordDataSchema.Field FIELD_InputDatasetEdges = SCHEMA.getField("inputDatasetEdges");
    private static final RecordDataSchema.Field FIELD_OutputDatasets = SCHEMA.getField("outputDatasets");
    private static final RecordDataSchema.Field FIELD_OutputDatasetEdges = SCHEMA.getField("outputDatasetEdges");
    private static final RecordDataSchema.Field FIELD_InputDatajobs = SCHEMA.getField("inputDatajobs");
    private static final RecordDataSchema.Field FIELD_InputDatajobEdges = SCHEMA.getField("inputDatajobEdges");
    private static final RecordDataSchema.Field FIELD_InputDatasetFields = SCHEMA.getField("inputDatasetFields");
    private static final RecordDataSchema.Field FIELD_OutputDatasetFields = SCHEMA.getField("outputDatasetFields");
    private static final RecordDataSchema.Field FIELD_FineGrainedLineages = SCHEMA.getField("fineGrainedLineages");

    public DataJobInputOutput() {
        super(new DataMap(12, 0.75f), SCHEMA, 12);
        this.addChangeListener(this.__changeListener);
    }

    public DataJobInputOutput(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    @Deprecated
    public boolean hasInputDatasets() {
        if (this._inputDatasetsField != null) {
            return true;
        }
        return this._map.containsKey("inputDatasets");
    }

    @Deprecated
    public void removeInputDatasets() {
        this._map.remove("inputDatasets");
    }

    @Deprecated
    @Nullable
    public DatasetUrnArray getInputDatasets(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getInputDatasets();
            }
            case DEFAULT: 
            case NULL: {
                if (this._inputDatasetsField != null) {
                    return this._inputDatasetsField;
                }
                Object __rawValue = this._map.get("inputDatasets");
                this._inputDatasetsField = __rawValue == null ? null : new DatasetUrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._inputDatasetsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Deprecated
    @Nonnull
    public DatasetUrnArray getInputDatasets() {
        if (this._inputDatasetsField != null) {
            return this._inputDatasetsField;
        }
        Object __rawValue = this._map.get("inputDatasets");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("inputDatasets");
        }
        this._inputDatasetsField = __rawValue == null ? null : new DatasetUrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._inputDatasetsField;
    }

    @Deprecated
    public DataJobInputOutput setInputDatasets(@Nullable DatasetUrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setInputDatasets(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field inputDatasets of com.linkedin.datajob.DataJobInputOutput");
                }
                CheckedUtil.putWithoutChecking(this._map, "inputDatasets", value.data());
                this._inputDatasetsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeInputDatasets();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "inputDatasets", value.data());
                this._inputDatasetsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "inputDatasets", value.data());
                this._inputDatasetsField = value;
            }
        }
        return this;
    }

    @Deprecated
    public DataJobInputOutput setInputDatasets(@Nonnull DatasetUrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field inputDatasets of com.linkedin.datajob.DataJobInputOutput to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "inputDatasets", value.data());
        this._inputDatasetsField = value;
        return this;
    }

    public boolean hasInputDatasetEdges() {
        if (this._inputDatasetEdgesField != null) {
            return true;
        }
        return this._map.containsKey("inputDatasetEdges");
    }

    public void removeInputDatasetEdges() {
        this._map.remove("inputDatasetEdges");
    }

    @Nullable
    public EdgeArray getInputDatasetEdges(GetMode mode) {
        return this.getInputDatasetEdges();
    }

    @Nullable
    public EdgeArray getInputDatasetEdges() {
        if (this._inputDatasetEdgesField != null) {
            return this._inputDatasetEdgesField;
        }
        Object __rawValue = this._map.get("inputDatasetEdges");
        this._inputDatasetEdgesField = __rawValue == null ? null : new EdgeArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._inputDatasetEdgesField;
    }

    public DataJobInputOutput setInputDatasetEdges(@Nullable EdgeArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setInputDatasetEdges(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeInputDatasetEdges();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "inputDatasetEdges", value.data());
                this._inputDatasetEdgesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "inputDatasetEdges", value.data());
                this._inputDatasetEdgesField = value;
            }
        }
        return this;
    }

    public DataJobInputOutput setInputDatasetEdges(@Nonnull EdgeArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field inputDatasetEdges of com.linkedin.datajob.DataJobInputOutput to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "inputDatasetEdges", value.data());
        this._inputDatasetEdgesField = value;
        return this;
    }

    @Deprecated
    public boolean hasOutputDatasets() {
        if (this._outputDatasetsField != null) {
            return true;
        }
        return this._map.containsKey("outputDatasets");
    }

    @Deprecated
    public void removeOutputDatasets() {
        this._map.remove("outputDatasets");
    }

    @Deprecated
    @Nullable
    public DatasetUrnArray getOutputDatasets(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getOutputDatasets();
            }
            case DEFAULT: 
            case NULL: {
                if (this._outputDatasetsField != null) {
                    return this._outputDatasetsField;
                }
                Object __rawValue = this._map.get("outputDatasets");
                this._outputDatasetsField = __rawValue == null ? null : new DatasetUrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._outputDatasetsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Deprecated
    @Nonnull
    public DatasetUrnArray getOutputDatasets() {
        if (this._outputDatasetsField != null) {
            return this._outputDatasetsField;
        }
        Object __rawValue = this._map.get("outputDatasets");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("outputDatasets");
        }
        this._outputDatasetsField = __rawValue == null ? null : new DatasetUrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._outputDatasetsField;
    }

    @Deprecated
    public DataJobInputOutput setOutputDatasets(@Nullable DatasetUrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setOutputDatasets(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field outputDatasets of com.linkedin.datajob.DataJobInputOutput");
                }
                CheckedUtil.putWithoutChecking(this._map, "outputDatasets", value.data());
                this._outputDatasetsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeOutputDatasets();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "outputDatasets", value.data());
                this._outputDatasetsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "outputDatasets", value.data());
                this._outputDatasetsField = value;
            }
        }
        return this;
    }

    @Deprecated
    public DataJobInputOutput setOutputDatasets(@Nonnull DatasetUrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field outputDatasets of com.linkedin.datajob.DataJobInputOutput to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "outputDatasets", value.data());
        this._outputDatasetsField = value;
        return this;
    }

    public boolean hasOutputDatasetEdges() {
        if (this._outputDatasetEdgesField != null) {
            return true;
        }
        return this._map.containsKey("outputDatasetEdges");
    }

    public void removeOutputDatasetEdges() {
        this._map.remove("outputDatasetEdges");
    }

    @Nullable
    public EdgeArray getOutputDatasetEdges(GetMode mode) {
        return this.getOutputDatasetEdges();
    }

    @Nullable
    public EdgeArray getOutputDatasetEdges() {
        if (this._outputDatasetEdgesField != null) {
            return this._outputDatasetEdgesField;
        }
        Object __rawValue = this._map.get("outputDatasetEdges");
        this._outputDatasetEdgesField = __rawValue == null ? null : new EdgeArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._outputDatasetEdgesField;
    }

    public DataJobInputOutput setOutputDatasetEdges(@Nullable EdgeArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setOutputDatasetEdges(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeOutputDatasetEdges();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "outputDatasetEdges", value.data());
                this._outputDatasetEdgesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "outputDatasetEdges", value.data());
                this._outputDatasetEdgesField = value;
            }
        }
        return this;
    }

    public DataJobInputOutput setOutputDatasetEdges(@Nonnull EdgeArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field outputDatasetEdges of com.linkedin.datajob.DataJobInputOutput to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "outputDatasetEdges", value.data());
        this._outputDatasetEdgesField = value;
        return this;
    }

    @Deprecated
    public boolean hasInputDatajobs() {
        if (this._inputDatajobsField != null) {
            return true;
        }
        return this._map.containsKey("inputDatajobs");
    }

    @Deprecated
    public void removeInputDatajobs() {
        this._map.remove("inputDatajobs");
    }

    @Deprecated
    @Nullable
    public DataJobUrnArray getInputDatajobs(GetMode mode) {
        return this.getInputDatajobs();
    }

    @Deprecated
    @Nullable
    public DataJobUrnArray getInputDatajobs() {
        if (this._inputDatajobsField != null) {
            return this._inputDatajobsField;
        }
        Object __rawValue = this._map.get("inputDatajobs");
        this._inputDatajobsField = __rawValue == null ? null : new DataJobUrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._inputDatajobsField;
    }

    @Deprecated
    public DataJobInputOutput setInputDatajobs(@Nullable DataJobUrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setInputDatajobs(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeInputDatajobs();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "inputDatajobs", value.data());
                this._inputDatajobsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "inputDatajobs", value.data());
                this._inputDatajobsField = value;
            }
        }
        return this;
    }

    @Deprecated
    public DataJobInputOutput setInputDatajobs(@Nonnull DataJobUrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field inputDatajobs of com.linkedin.datajob.DataJobInputOutput to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "inputDatajobs", value.data());
        this._inputDatajobsField = value;
        return this;
    }

    public boolean hasInputDatajobEdges() {
        if (this._inputDatajobEdgesField != null) {
            return true;
        }
        return this._map.containsKey("inputDatajobEdges");
    }

    public void removeInputDatajobEdges() {
        this._map.remove("inputDatajobEdges");
    }

    @Nullable
    public EdgeArray getInputDatajobEdges(GetMode mode) {
        return this.getInputDatajobEdges();
    }

    @Nullable
    public EdgeArray getInputDatajobEdges() {
        if (this._inputDatajobEdgesField != null) {
            return this._inputDatajobEdgesField;
        }
        Object __rawValue = this._map.get("inputDatajobEdges");
        this._inputDatajobEdgesField = __rawValue == null ? null : new EdgeArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._inputDatajobEdgesField;
    }

    public DataJobInputOutput setInputDatajobEdges(@Nullable EdgeArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setInputDatajobEdges(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeInputDatajobEdges();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "inputDatajobEdges", value.data());
                this._inputDatajobEdgesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "inputDatajobEdges", value.data());
                this._inputDatajobEdgesField = value;
            }
        }
        return this;
    }

    public DataJobInputOutput setInputDatajobEdges(@Nonnull EdgeArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field inputDatajobEdges of com.linkedin.datajob.DataJobInputOutput to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "inputDatajobEdges", value.data());
        this._inputDatajobEdgesField = value;
        return this;
    }

    public boolean hasInputDatasetFields() {
        if (this._inputDatasetFieldsField != null) {
            return true;
        }
        return this._map.containsKey("inputDatasetFields");
    }

    public void removeInputDatasetFields() {
        this._map.remove("inputDatasetFields");
    }

    @Nullable
    public UrnArray getInputDatasetFields(GetMode mode) {
        return this.getInputDatasetFields();
    }

    @Nullable
    public UrnArray getInputDatasetFields() {
        if (this._inputDatasetFieldsField != null) {
            return this._inputDatasetFieldsField;
        }
        Object __rawValue = this._map.get("inputDatasetFields");
        this._inputDatasetFieldsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._inputDatasetFieldsField;
    }

    public DataJobInputOutput setInputDatasetFields(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setInputDatasetFields(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeInputDatasetFields();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "inputDatasetFields", value.data());
                this._inputDatasetFieldsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "inputDatasetFields", value.data());
                this._inputDatasetFieldsField = value;
            }
        }
        return this;
    }

    public DataJobInputOutput setInputDatasetFields(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field inputDatasetFields of com.linkedin.datajob.DataJobInputOutput to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "inputDatasetFields", value.data());
        this._inputDatasetFieldsField = value;
        return this;
    }

    public boolean hasOutputDatasetFields() {
        if (this._outputDatasetFieldsField != null) {
            return true;
        }
        return this._map.containsKey("outputDatasetFields");
    }

    public void removeOutputDatasetFields() {
        this._map.remove("outputDatasetFields");
    }

    @Nullable
    public UrnArray getOutputDatasetFields(GetMode mode) {
        return this.getOutputDatasetFields();
    }

    @Nullable
    public UrnArray getOutputDatasetFields() {
        if (this._outputDatasetFieldsField != null) {
            return this._outputDatasetFieldsField;
        }
        Object __rawValue = this._map.get("outputDatasetFields");
        this._outputDatasetFieldsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._outputDatasetFieldsField;
    }

    public DataJobInputOutput setOutputDatasetFields(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setOutputDatasetFields(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeOutputDatasetFields();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "outputDatasetFields", value.data());
                this._outputDatasetFieldsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "outputDatasetFields", value.data());
                this._outputDatasetFieldsField = value;
            }
        }
        return this;
    }

    public DataJobInputOutput setOutputDatasetFields(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field outputDatasetFields of com.linkedin.datajob.DataJobInputOutput to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "outputDatasetFields", value.data());
        this._outputDatasetFieldsField = value;
        return this;
    }

    public boolean hasFineGrainedLineages() {
        if (this._fineGrainedLineagesField != null) {
            return true;
        }
        return this._map.containsKey("fineGrainedLineages");
    }

    public void removeFineGrainedLineages() {
        this._map.remove("fineGrainedLineages");
    }

    @Nullable
    public FineGrainedLineageArray getFineGrainedLineages(GetMode mode) {
        return this.getFineGrainedLineages();
    }

    @Nullable
    public FineGrainedLineageArray getFineGrainedLineages() {
        if (this._fineGrainedLineagesField != null) {
            return this._fineGrainedLineagesField;
        }
        Object __rawValue = this._map.get("fineGrainedLineages");
        this._fineGrainedLineagesField = __rawValue == null ? null : new FineGrainedLineageArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._fineGrainedLineagesField;
    }

    public DataJobInputOutput setFineGrainedLineages(@Nullable FineGrainedLineageArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFineGrainedLineages(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFineGrainedLineages();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "fineGrainedLineages", value.data());
                this._fineGrainedLineagesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "fineGrainedLineages", value.data());
                this._fineGrainedLineagesField = value;
            }
        }
        return this;
    }

    public DataJobInputOutput setFineGrainedLineages(@Nonnull FineGrainedLineageArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field fineGrainedLineages of com.linkedin.datajob.DataJobInputOutput to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "fineGrainedLineages", value.data());
        this._fineGrainedLineagesField = value;
        return this;
    }

    @Override
    public DataJobInputOutput clone() throws CloneNotSupportedException {
        DataJobInputOutput __clone = (DataJobInputOutput)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataJobInputOutput copy() throws CloneNotSupportedException {
        DataJobInputOutput __copy = (DataJobInputOutput)super.copy();
        __copy._inputDatajobsField = null;
        __copy._outputDatasetFieldsField = null;
        __copy._inputDatasetEdgesField = null;
        __copy._outputDatasetEdgesField = null;
        __copy._inputDatasetFieldsField = null;
        __copy._inputDatasetsField = null;
        __copy._inputDatajobEdgesField = null;
        __copy._outputDatasetsField = null;
        __copy._fineGrainedLineagesField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataJobInputOutput __objectRef;

        private ChangeListener(DataJobInputOutput reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "inputDatajobs": {
                    this.__objectRef._inputDatajobsField = null;
                    break;
                }
                case "outputDatasetFields": {
                    this.__objectRef._outputDatasetFieldsField = null;
                    break;
                }
                case "inputDatasetEdges": {
                    this.__objectRef._inputDatasetEdgesField = null;
                    break;
                }
                case "outputDatasetEdges": {
                    this.__objectRef._outputDatasetEdgesField = null;
                    break;
                }
                case "inputDatasetFields": {
                    this.__objectRef._inputDatasetFieldsField = null;
                    break;
                }
                case "inputDatasets": {
                    this.__objectRef._inputDatasetsField = null;
                    break;
                }
                case "inputDatajobEdges": {
                    this.__objectRef._inputDatajobEdgesField = null;
                    break;
                }
                case "outputDatasets": {
                    this.__objectRef._outputDatasetsField = null;
                    break;
                }
                case "fineGrainedLineages": {
                    this.__objectRef._fineGrainedLineagesField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        @Deprecated
        public PathSpec inputDatasets() {
            return new PathSpec(this.getPathComponents(), "inputDatasets");
        }

        @Deprecated
        public PathSpec inputDatasets(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "inputDatasets");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public EdgeArray.Fields inputDatasetEdges() {
            return new EdgeArray.Fields(this.getPathComponents(), "inputDatasetEdges");
        }

        public PathSpec inputDatasetEdges(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "inputDatasetEdges");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        @Deprecated
        public PathSpec outputDatasets() {
            return new PathSpec(this.getPathComponents(), "outputDatasets");
        }

        @Deprecated
        public PathSpec outputDatasets(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "outputDatasets");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public EdgeArray.Fields outputDatasetEdges() {
            return new EdgeArray.Fields(this.getPathComponents(), "outputDatasetEdges");
        }

        public PathSpec outputDatasetEdges(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "outputDatasetEdges");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        @Deprecated
        public PathSpec inputDatajobs() {
            return new PathSpec(this.getPathComponents(), "inputDatajobs");
        }

        @Deprecated
        public PathSpec inputDatajobs(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "inputDatajobs");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public EdgeArray.Fields inputDatajobEdges() {
            return new EdgeArray.Fields(this.getPathComponents(), "inputDatajobEdges");
        }

        public PathSpec inputDatajobEdges(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "inputDatajobEdges");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec inputDatasetFields() {
            return new PathSpec(this.getPathComponents(), "inputDatasetFields");
        }

        public PathSpec inputDatasetFields(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "inputDatasetFields");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec outputDatasetFields() {
            return new PathSpec(this.getPathComponents(), "outputDatasetFields");
        }

        public PathSpec outputDatasetFields(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "outputDatasetFields");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public FineGrainedLineageArray.Fields fineGrainedLineages() {
            return new FineGrainedLineageArray.Fields(this.getPathComponents(), "fineGrainedLineages");
        }

        public PathSpec fineGrainedLineages(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "fineGrainedLineages");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private EdgeArray.ProjectionMask _inputDatasetEdgesMask;
        private EdgeArray.ProjectionMask _outputDatasetEdgesMask;
        private EdgeArray.ProjectionMask _inputDatajobEdgesMask;
        private FineGrainedLineageArray.ProjectionMask _fineGrainedLineagesMask;

        ProjectionMask() {
            super(12);
        }

        @Deprecated
        public ProjectionMask withInputDatasets() {
            this.getDataMap().put("inputDatasets", 1);
            return this;
        }

        @Deprecated
        public ProjectionMask withInputDatasets(Integer start, Integer count) {
            this.getDataMap().put("inputDatasets", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("inputDatasets").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("inputDatasets").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withInputDatasetEdges(Function<EdgeArray.ProjectionMask, EdgeArray.ProjectionMask> nestedMask) {
            this._inputDatasetEdgesMask = nestedMask.apply(this._inputDatasetEdgesMask == null ? EdgeArray.createMask() : this._inputDatasetEdgesMask);
            this.getDataMap().put("inputDatasetEdges", this._inputDatasetEdgesMask.getDataMap());
            return this;
        }

        public ProjectionMask withInputDatasetEdges() {
            this._inputDatasetEdgesMask = null;
            this.getDataMap().put("inputDatasetEdges", 1);
            return this;
        }

        public ProjectionMask withInputDatasetEdges(Function<EdgeArray.ProjectionMask, EdgeArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._inputDatasetEdgesMask = nestedMask.apply(this._inputDatasetEdgesMask == null ? EdgeArray.createMask() : this._inputDatasetEdgesMask);
            this.getDataMap().put("inputDatasetEdges", this._inputDatasetEdgesMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("inputDatasetEdges").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("inputDatasetEdges").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withInputDatasetEdges(Integer start, Integer count) {
            this._inputDatasetEdgesMask = null;
            this.getDataMap().put("inputDatasetEdges", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("inputDatasetEdges").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("inputDatasetEdges").put("$count", count);
            }
            return this;
        }

        @Deprecated
        public ProjectionMask withOutputDatasets() {
            this.getDataMap().put("outputDatasets", 1);
            return this;
        }

        @Deprecated
        public ProjectionMask withOutputDatasets(Integer start, Integer count) {
            this.getDataMap().put("outputDatasets", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("outputDatasets").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("outputDatasets").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withOutputDatasetEdges(Function<EdgeArray.ProjectionMask, EdgeArray.ProjectionMask> nestedMask) {
            this._outputDatasetEdgesMask = nestedMask.apply(this._outputDatasetEdgesMask == null ? EdgeArray.createMask() : this._outputDatasetEdgesMask);
            this.getDataMap().put("outputDatasetEdges", this._outputDatasetEdgesMask.getDataMap());
            return this;
        }

        public ProjectionMask withOutputDatasetEdges() {
            this._outputDatasetEdgesMask = null;
            this.getDataMap().put("outputDatasetEdges", 1);
            return this;
        }

        public ProjectionMask withOutputDatasetEdges(Function<EdgeArray.ProjectionMask, EdgeArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._outputDatasetEdgesMask = nestedMask.apply(this._outputDatasetEdgesMask == null ? EdgeArray.createMask() : this._outputDatasetEdgesMask);
            this.getDataMap().put("outputDatasetEdges", this._outputDatasetEdgesMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("outputDatasetEdges").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("outputDatasetEdges").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withOutputDatasetEdges(Integer start, Integer count) {
            this._outputDatasetEdgesMask = null;
            this.getDataMap().put("outputDatasetEdges", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("outputDatasetEdges").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("outputDatasetEdges").put("$count", count);
            }
            return this;
        }

        @Deprecated
        public ProjectionMask withInputDatajobs() {
            this.getDataMap().put("inputDatajobs", 1);
            return this;
        }

        @Deprecated
        public ProjectionMask withInputDatajobs(Integer start, Integer count) {
            this.getDataMap().put("inputDatajobs", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("inputDatajobs").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("inputDatajobs").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withInputDatajobEdges(Function<EdgeArray.ProjectionMask, EdgeArray.ProjectionMask> nestedMask) {
            this._inputDatajobEdgesMask = nestedMask.apply(this._inputDatajobEdgesMask == null ? EdgeArray.createMask() : this._inputDatajobEdgesMask);
            this.getDataMap().put("inputDatajobEdges", this._inputDatajobEdgesMask.getDataMap());
            return this;
        }

        public ProjectionMask withInputDatajobEdges() {
            this._inputDatajobEdgesMask = null;
            this.getDataMap().put("inputDatajobEdges", 1);
            return this;
        }

        public ProjectionMask withInputDatajobEdges(Function<EdgeArray.ProjectionMask, EdgeArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._inputDatajobEdgesMask = nestedMask.apply(this._inputDatajobEdgesMask == null ? EdgeArray.createMask() : this._inputDatajobEdgesMask);
            this.getDataMap().put("inputDatajobEdges", this._inputDatajobEdgesMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("inputDatajobEdges").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("inputDatajobEdges").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withInputDatajobEdges(Integer start, Integer count) {
            this._inputDatajobEdgesMask = null;
            this.getDataMap().put("inputDatajobEdges", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("inputDatajobEdges").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("inputDatajobEdges").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withInputDatasetFields() {
            this.getDataMap().put("inputDatasetFields", 1);
            return this;
        }

        public ProjectionMask withInputDatasetFields(Integer start, Integer count) {
            this.getDataMap().put("inputDatasetFields", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("inputDatasetFields").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("inputDatasetFields").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withOutputDatasetFields() {
            this.getDataMap().put("outputDatasetFields", 1);
            return this;
        }

        public ProjectionMask withOutputDatasetFields(Integer start, Integer count) {
            this.getDataMap().put("outputDatasetFields", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("outputDatasetFields").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("outputDatasetFields").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withFineGrainedLineages(Function<FineGrainedLineageArray.ProjectionMask, FineGrainedLineageArray.ProjectionMask> nestedMask) {
            this._fineGrainedLineagesMask = nestedMask.apply(this._fineGrainedLineagesMask == null ? FineGrainedLineageArray.createMask() : this._fineGrainedLineagesMask);
            this.getDataMap().put("fineGrainedLineages", this._fineGrainedLineagesMask.getDataMap());
            return this;
        }

        public ProjectionMask withFineGrainedLineages() {
            this._fineGrainedLineagesMask = null;
            this.getDataMap().put("fineGrainedLineages", 1);
            return this;
        }

        public ProjectionMask withFineGrainedLineages(Function<FineGrainedLineageArray.ProjectionMask, FineGrainedLineageArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._fineGrainedLineagesMask = nestedMask.apply(this._fineGrainedLineagesMask == null ? FineGrainedLineageArray.createMask() : this._fineGrainedLineagesMask);
            this.getDataMap().put("fineGrainedLineages", this._fineGrainedLineagesMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("fineGrainedLineages").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("fineGrainedLineages").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withFineGrainedLineages(Integer start, Integer count) {
            this._fineGrainedLineagesMask = null;
            this.getDataMap().put("fineGrainedLineages", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("fineGrainedLineages").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("fineGrainedLineages").put("$count", count);
            }
            return this;
        }
    }
}

