/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.datajob;

import com.linkedin.common.FabricType;
import com.linkedin.common.TimeStamp;
import com.linkedin.common.url.Url;
import com.linkedin.common.url.UrlCoercer;
import com.linkedin.common.urn.DataFlowUrn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import com.linkedin.data.template.UnionTemplate;
import com.linkedin.datajob.JobStatus;
import com.linkedin.datajob.azkaban.AzkabanJobType;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataJobInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.datajob/**Information about a Data processing job*/@Aspect.name=\"dataJobInfo\"record DataJobInfo includes{namespace com.linkedin.common/**Misc. properties about an entity.*/record CustomProperties{/**Custom property bag.*/@Searchable.`/*`={\"fieldType\":\"TEXT\",\"queryByDefault\":true}customProperties:map[string,string]={}}}{namespace com.linkedin.common/**A reference to an external platform.*/record ExternalReference{/**URL where the reference exist*/@Searchable.fieldType=\"KEYWORD\"externalUrl:optional@java={\"class\":\"com.linkedin.common.url.Url\",\"coercerClass\":\"com.linkedin.common.url.UrlCoercer\"}typeref Url=string}}{/**Job name*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\",\"searchLabel\":\"entityName\",\"searchTier\":1}name:string/**Job description*/@Searchable={\"fieldType\":\"TEXT\",\"hasValuesFieldName\":\"hasDescription\",\"searchTier\":2}description:optional string/**Datajob type\n**NOTE**: AzkabanJobType is deprecated. Please use strings instead.*/type:union[{namespace com.linkedin.datajob.azkaban/**The various types of support azkaban jobs*/enum AzkabanJobType{/**The command job type is one of the basic built-in types. It runs multiple UNIX commands using java processbuilder.\nUpon execution, Azkaban spawns off a process to run the command.*/COMMAND/**Runs a java program with ability to access Hadoop cluster.\nhttps://azkaban.readthedocs.io/en/latest/jobTypes.html#java-job-type*/HADOOP_JAVA/**In large part, this is the same Command type. The difference is its ability to talk to a Hadoop cluster\nsecurely, via Hadoop tokens.*/HADOOP_SHELL/**Hive type is for running Hive jobs.*/HIVE/**Pig type is for running Pig jobs.*/PIG/**SQL is for running Presto, mysql queries etc*/SQL/**Glue type is for running AWS Glue job transforms.*/GLUE}}string]/**DataFlow urn that this job is part of*/flowUrn:optional{namespace com.linkedin.common/**Standardized data processing flow identifier.*/@java.class=\"com.linkedin.common.urn.DataFlowUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized data processing flow identifier.\",\"entityType\":\"dataFlow\",\"fields\":[{\"doc\":\"Workflow manager like azkaban, airflow which orchestrates the flow\",\"maxLength\":50,\"name\":\"orchestrator\",\"type\":\"string\"},{\"doc\":\"Unique Identifier of the data flow\",\"maxLength\":200,\"name\":\"flowId\",\"type\":\"string\"},{\"doc\":\"Cluster where the flow is executed\",\"maxLength\":100,\"name\":\"cluster\",\"type\":\"string\"}],\"maxLength\":373,\"name\":\"DataFlow\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DataFlowUrn=string}/**A timestamp documenting when the asset was created in the source Data Platform (not on DataHub)*/@Searchable.`/time`={\"fieldName\":\"createdAt\",\"fieldType\":\"DATETIME\",\"searchLabel\":\"createdAt\"}created:optional{namespace com.linkedin.common/**A standard event timestamp*/record TimeStamp{/**When did the event occur*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**Optional: The actor urn involved in the event.*/actor:optional@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}}/**A timestamp documenting when the asset was last modified in the source Data Platform (not on DataHub)*/@Searchable.`/time`={\"fieldName\":\"lastModifiedAt\",\"fieldType\":\"DATETIME\",\"searchLabel\":\"lastModifiedAt\"}lastModified:optional com.linkedin.common.TimeStamp/**Status of the job - Deprecated for Data Process Instance model.*/@deprecated=\"Use Data Process Instance model, instead\"status:optional/**Job statuses*/enum JobStatus{/**Jobs being initialized.*/STARTING/**Jobs currently running.*/IN_PROGRESS/**Jobs being stopped.*/STOPPING/**Jobs that have stopped.*/STOPPED/**Jobs with successful completion.*/COMPLETED/**Jobs that have failed.*/FAILED/**Jobs with unknown status (either unmappable or unavailable)*/UNKNOWN/**Jobs that have been skipped.*/SKIPPED}/**Environment for this job*/@Searchable={\"addToFilters\":true,\"fieldType\":\"KEYWORD\",\"filterNameOverride\":\"Environment\",\"queryByDefault\":false}env:optional{namespace com.linkedin.common/**Fabric group type*/enum FabricType{/**Designates development fabrics*/DEV/**Designates testing fabrics*/TEST/**Designates quality assurance fabrics*/QA/**Designates user acceptance testing fabrics*/UAT/**Designates early-integration fabrics*/EI/**Designates pre-production fabrics*/PRE/**Designates staging fabrics*/STG/**Designates non-production fabrics*/NON_PROD/**Designates production fabrics*/PROD/**Designates corporation fabrics*/CORP/**Designates review fabrics*/RVW/**Alternative Prod spelling*/PRD/**Alternative Test spelling*/TST/**System Integration Testing*/SIT/**Alternative spelling for sandbox*/SBX/**Designates sandbox fabrics*/SANDBOX}}}", SchemaFormatType.PDL);
    private StringMap _customPropertiesField = null;
    private Url _externalUrlField = null;
    private String _nameField = null;
    private String _descriptionField = null;
    private Type _typeField = null;
    private DataFlowUrn _flowUrnField = null;
    private TimeStamp _createdField = null;
    private TimeStamp _lastModifiedField = null;
    private JobStatus _statusField = null;
    private FabricType _envField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_CustomProperties = SCHEMA.getField("customProperties");
    private static final StringMap DEFAULT_CustomProperties;
    private static final RecordDataSchema.Field FIELD_ExternalUrl;
    private static final RecordDataSchema.Field FIELD_Name;
    private static final RecordDataSchema.Field FIELD_Description;
    private static final RecordDataSchema.Field FIELD_Type;
    private static final RecordDataSchema.Field FIELD_FlowUrn;
    private static final RecordDataSchema.Field FIELD_Created;
    private static final RecordDataSchema.Field FIELD_LastModified;
    private static final RecordDataSchema.Field FIELD_Status;
    private static final RecordDataSchema.Field FIELD_Env;

    public DataJobInfo() {
        super(new DataMap(14, 0.75f), SCHEMA, 6);
        this.addChangeListener(this.__changeListener);
    }

    public DataJobInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasCustomProperties() {
        if (this._customPropertiesField != null) {
            return true;
        }
        return this._map.containsKey("customProperties");
    }

    public void removeCustomProperties() {
        this._map.remove("customProperties");
    }

    @Nullable
    public StringMap getCustomProperties(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getCustomProperties();
            }
            case NULL: {
                if (this._customPropertiesField != null) {
                    return this._customPropertiesField;
                }
                Object __rawValue = this._map.get("customProperties");
                this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._customPropertiesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringMap getCustomProperties() {
        if (this._customPropertiesField != null) {
            return this._customPropertiesField;
        }
        Object __rawValue = this._map.get("customProperties");
        if (__rawValue == null) {
            return DEFAULT_CustomProperties;
        }
        this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._customPropertiesField;
    }

    public DataJobInfo setCustomProperties(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCustomProperties(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field customProperties of com.linkedin.datajob.DataJobInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCustomProperties();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
            }
        }
        return this;
    }

    public DataJobInfo setCustomProperties(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field customProperties of com.linkedin.datajob.DataJobInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
        this._customPropertiesField = value;
        return this;
    }

    public boolean hasExternalUrl() {
        if (this._externalUrlField != null) {
            return true;
        }
        return this._map.containsKey("externalUrl");
    }

    public void removeExternalUrl() {
        this._map.remove("externalUrl");
    }

    @Nullable
    public Url getExternalUrl(GetMode mode) {
        return this.getExternalUrl();
    }

    @Nullable
    public Url getExternalUrl() {
        if (this._externalUrlField != null) {
            return this._externalUrlField;
        }
        Object __rawValue = this._map.get("externalUrl");
        this._externalUrlField = DataTemplateUtil.coerceCustomOutput(__rawValue, Url.class);
        return this._externalUrlField;
    }

    public DataJobInfo setExternalUrl(@Nullable Url value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setExternalUrl(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeExternalUrl();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "externalUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._externalUrlField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "externalUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._externalUrlField = value;
            }
        }
        return this;
    }

    public DataJobInfo setExternalUrl(@Nonnull Url value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field externalUrl of com.linkedin.datajob.DataJobInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "externalUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
        this._externalUrlField = value;
        return this;
    }

    public boolean hasName() {
        if (this._nameField != null) {
            return true;
        }
        return this._map.containsKey("name");
    }

    public void removeName() {
        this._map.remove("name");
    }

    @Nullable
    public String getName(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getName();
            }
            case DEFAULT: 
            case NULL: {
                if (this._nameField != null) {
                    return this._nameField;
                }
                Object __rawValue = this._map.get("name");
                this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._nameField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getName() {
        if (this._nameField != null) {
            return this._nameField;
        }
        Object __rawValue = this._map.get("name");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("name");
        }
        this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._nameField;
    }

    public DataJobInfo setName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field name of com.linkedin.datajob.DataJobInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
            }
        }
        return this;
    }

    public DataJobInfo setName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field name of com.linkedin.datajob.DataJobInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "name", value);
        this._nameField = value;
        return this;
    }

    public boolean hasDescription() {
        if (this._descriptionField != null) {
            return true;
        }
        return this._map.containsKey("description");
    }

    public void removeDescription() {
        this._map.remove("description");
    }

    @Nullable
    public String getDescription(GetMode mode) {
        return this.getDescription();
    }

    @Nullable
    public String getDescription() {
        if (this._descriptionField != null) {
            return this._descriptionField;
        }
        Object __rawValue = this._map.get("description");
        this._descriptionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._descriptionField;
    }

    public DataJobInfo setDescription(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDescription(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDescription();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
            }
        }
        return this;
    }

    public DataJobInfo setDescription(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field description of com.linkedin.datajob.DataJobInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "description", value);
        this._descriptionField = value;
        return this;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public Type getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = __rawValue == null ? null : new Type(__rawValue);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Type getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = __rawValue == null ? null : new Type(__rawValue);
        return this._typeField;
    }

    public DataJobInfo setType(@Nullable Type value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.datajob.DataJobInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.data());
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.data());
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value.data());
                this._typeField = value;
            }
        }
        return this;
    }

    public DataJobInfo setType(@Nonnull Type value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.datajob.DataJobInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value.data());
        this._typeField = value;
        return this;
    }

    public boolean hasFlowUrn() {
        if (this._flowUrnField != null) {
            return true;
        }
        return this._map.containsKey("flowUrn");
    }

    public void removeFlowUrn() {
        this._map.remove("flowUrn");
    }

    @Nullable
    public DataFlowUrn getFlowUrn(GetMode mode) {
        return this.getFlowUrn();
    }

    @Nullable
    public DataFlowUrn getFlowUrn() {
        if (this._flowUrnField != null) {
            return this._flowUrnField;
        }
        Object __rawValue = this._map.get("flowUrn");
        this._flowUrnField = DataTemplateUtil.coerceCustomOutput(__rawValue, DataFlowUrn.class);
        return this._flowUrnField;
    }

    public DataJobInfo setFlowUrn(@Nullable DataFlowUrn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFlowUrn(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFlowUrn();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "flowUrn", DataTemplateUtil.coerceCustomInput(value, DataFlowUrn.class));
                this._flowUrnField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "flowUrn", DataTemplateUtil.coerceCustomInput(value, DataFlowUrn.class));
                this._flowUrnField = value;
            }
        }
        return this;
    }

    public DataJobInfo setFlowUrn(@Nonnull DataFlowUrn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field flowUrn of com.linkedin.datajob.DataJobInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "flowUrn", DataTemplateUtil.coerceCustomInput(value, DataFlowUrn.class));
        this._flowUrnField = value;
        return this;
    }

    public boolean hasCreated() {
        if (this._createdField != null) {
            return true;
        }
        return this._map.containsKey("created");
    }

    public void removeCreated() {
        this._map.remove("created");
    }

    @Nullable
    public TimeStamp getCreated(GetMode mode) {
        return this.getCreated();
    }

    @Nullable
    public TimeStamp getCreated() {
        if (this._createdField != null) {
            return this._createdField;
        }
        Object __rawValue = this._map.get("created");
        this._createdField = __rawValue == null ? null : new TimeStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._createdField;
    }

    public DataJobInfo setCreated(@Nullable TimeStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreated(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreated();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
            }
        }
        return this;
    }

    public DataJobInfo setCreated(@Nonnull TimeStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field created of com.linkedin.datajob.DataJobInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "created", value.data());
        this._createdField = value;
        return this;
    }

    public boolean hasLastModified() {
        if (this._lastModifiedField != null) {
            return true;
        }
        return this._map.containsKey("lastModified");
    }

    public void removeLastModified() {
        this._map.remove("lastModified");
    }

    @Nullable
    public TimeStamp getLastModified(GetMode mode) {
        return this.getLastModified();
    }

    @Nullable
    public TimeStamp getLastModified() {
        if (this._lastModifiedField != null) {
            return this._lastModifiedField;
        }
        Object __rawValue = this._map.get("lastModified");
        this._lastModifiedField = __rawValue == null ? null : new TimeStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._lastModifiedField;
    }

    public DataJobInfo setLastModified(@Nullable TimeStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastModified(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastModified();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
            }
        }
        return this;
    }

    public DataJobInfo setLastModified(@Nonnull TimeStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastModified of com.linkedin.datajob.DataJobInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
        this._lastModifiedField = value;
        return this;
    }

    @Deprecated
    public boolean hasStatus() {
        if (this._statusField != null) {
            return true;
        }
        return this._map.containsKey("status");
    }

    @Deprecated
    public void removeStatus() {
        this._map.remove("status");
    }

    @Deprecated
    @Nullable
    public JobStatus getStatus(GetMode mode) {
        return this.getStatus();
    }

    @Deprecated
    @Nullable
    public JobStatus getStatus() {
        if (this._statusField != null) {
            return this._statusField;
        }
        Object __rawValue = this._map.get("status");
        this._statusField = DataTemplateUtil.coerceEnumOutput(__rawValue, JobStatus.class, JobStatus.$UNKNOWN);
        return this._statusField;
    }

    @Deprecated
    public DataJobInfo setStatus(@Nullable JobStatus value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setStatus(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeStatus();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "status", value.name());
                this._statusField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "status", value.name());
                this._statusField = value;
            }
        }
        return this;
    }

    @Deprecated
    public DataJobInfo setStatus(@Nonnull JobStatus value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field status of com.linkedin.datajob.DataJobInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "status", value.name());
        this._statusField = value;
        return this;
    }

    public boolean hasEnv() {
        if (this._envField != null) {
            return true;
        }
        return this._map.containsKey("env");
    }

    public void removeEnv() {
        this._map.remove("env");
    }

    @Nullable
    public FabricType getEnv(GetMode mode) {
        return this.getEnv();
    }

    @Nullable
    public FabricType getEnv() {
        if (this._envField != null) {
            return this._envField;
        }
        Object __rawValue = this._map.get("env");
        this._envField = DataTemplateUtil.coerceEnumOutput(__rawValue, FabricType.class, FabricType.$UNKNOWN);
        return this._envField;
    }

    public DataJobInfo setEnv(@Nullable FabricType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEnv(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEnv();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "env", value.name());
                this._envField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "env", value.name());
                this._envField = value;
            }
        }
        return this;
    }

    public DataJobInfo setEnv(@Nonnull FabricType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field env of com.linkedin.datajob.DataJobInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "env", value.name());
        this._envField = value;
        return this;
    }

    @Override
    public DataJobInfo clone() throws CloneNotSupportedException {
        DataJobInfo __clone = (DataJobInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataJobInfo copy() throws CloneNotSupportedException {
        DataJobInfo __copy = (DataJobInfo)super.copy();
        __copy._externalUrlField = null;
        __copy._customPropertiesField = null;
        __copy._createdField = null;
        __copy._nameField = null;
        __copy._descriptionField = null;
        __copy._flowUrnField = null;
        __copy._lastModifiedField = null;
        __copy._typeField = null;
        __copy._envField = null;
        __copy._statusField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_ExternalUrl = SCHEMA.getField("externalUrl");
        FIELD_Name = SCHEMA.getField("name");
        FIELD_Description = SCHEMA.getField("description");
        FIELD_Type = SCHEMA.getField("type");
        FIELD_FlowUrn = SCHEMA.getField("flowUrn");
        FIELD_Created = SCHEMA.getField("created");
        FIELD_LastModified = SCHEMA.getField("lastModified");
        FIELD_Status = SCHEMA.getField("status");
        FIELD_Env = SCHEMA.getField("env");
        Custom.initializeCustomClass(Url.class);
        Custom.initializeCoercerClass(UrlCoercer.class);
        Custom.initializeCustomClass(DataFlowUrn.class);
        DEFAULT_CustomProperties = FIELD_CustomProperties.getDefault() == null ? null : new StringMap(DataTemplateUtil.castOrThrow(FIELD_CustomProperties.getDefault(), DataMap.class));
    }

    public static class Type
    extends UnionTemplate {
        private static final UnionDataSchema SCHEMA = (UnionDataSchema)DataTemplateUtil.parseSchema("union[{namespace com.linkedin.datajob.azkaban/**The various types of support azkaban jobs*/enum AzkabanJobType{/**The command job type is one of the basic built-in types. It runs multiple UNIX commands using java processbuilder.\nUpon execution, Azkaban spawns off a process to run the command.*/COMMAND/**Runs a java program with ability to access Hadoop cluster.\nhttps://azkaban.readthedocs.io/en/latest/jobTypes.html#java-job-type*/HADOOP_JAVA/**In large part, this is the same Command type. The difference is its ability to talk to a Hadoop cluster\nsecurely, via Hadoop tokens.*/HADOOP_SHELL/**Hive type is for running Hive jobs.*/HIVE/**Pig type is for running Pig jobs.*/PIG/**SQL is for running Presto, mysql queries etc*/SQL/**Glue type is for running AWS Glue job transforms.*/GLUE}}string]", SchemaFormatType.PDL);
        private AzkabanJobType _azkabanJobTypeMember = null;
        private String _stringMember = null;
        private ChangeListener __changeListener = new ChangeListener(this);
        private static final DataSchema MEMBER_AzkabanJobType = SCHEMA.getTypeByMemberKey("com.linkedin.datajob.azkaban.AzkabanJobType");
        public static final String MEMBERKEY_AzkabanJobType = "com.linkedin.datajob.azkaban.AzkabanJobType";
        private static final DataSchema MEMBER_String = SCHEMA.getTypeByMemberKey("string");
        public static final String MEMBERKEY_String = "string";

        public Type() {
            super(new DataMap(2, 0.75f), SCHEMA);
            this.addChangeListener(this.__changeListener);
        }

        public Type(Object data) {
            super(data, SCHEMA);
            this.addChangeListener(this.__changeListener);
        }

        public static UnionDataSchema dataSchema() {
            return SCHEMA;
        }

        public static Type create(AzkabanJobType value) {
            Type newUnion = new Type();
            newUnion.setAzkabanJobType(value);
            return newUnion;
        }

        public boolean isAzkabanJobType() {
            return this.memberIs(MEMBERKEY_AzkabanJobType);
        }

        public AzkabanJobType getAzkabanJobType() {
            this.checkNotNull();
            if (this._azkabanJobTypeMember != null) {
                return this._azkabanJobTypeMember;
            }
            Object __rawValue = this._map.get(MEMBERKEY_AzkabanJobType);
            this._azkabanJobTypeMember = DataTemplateUtil.coerceEnumOutput(__rawValue, AzkabanJobType.class, AzkabanJobType.$UNKNOWN);
            return this._azkabanJobTypeMember;
        }

        public void setAzkabanJobType(AzkabanJobType value) {
            this.checkNotNull();
            this._map.clear();
            this._azkabanJobTypeMember = value;
            CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_AzkabanJobType, value.name());
        }

        public static Type create(String value) {
            Type newUnion = new Type();
            newUnion.setString(value);
            return newUnion;
        }

        public boolean isString() {
            return this.memberIs(MEMBERKEY_String);
        }

        public String getString() {
            this.checkNotNull();
            if (this._stringMember != null) {
                return this._stringMember;
            }
            Object __rawValue = this._map.get(MEMBERKEY_String);
            this._stringMember = DataTemplateUtil.coerceStringOutput(__rawValue);
            return this._stringMember;
        }

        public void setString(String value) {
            this.checkNotNull();
            this._map.clear();
            this._stringMember = value;
            CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_String, value);
        }

        public static ProjectionMask createMask() {
            return new ProjectionMask();
        }

        @Override
        public Type clone() throws CloneNotSupportedException {
            Type __clone = (Type)super.clone();
            __clone.__changeListener = new ChangeListener(__clone);
            __clone.addChangeListener(__clone.__changeListener);
            return __clone;
        }

        @Override
        public Type copy() throws CloneNotSupportedException {
            Type __copy = (Type)super.copy();
            __copy._stringMember = null;
            __copy._azkabanJobTypeMember = null;
            __copy.__changeListener = new ChangeListener(__copy);
            __copy.addChangeListener(__copy.__changeListener);
            return __copy;
        }

        private static class ChangeListener
        implements CheckedMap.ChangeListener<String, Object> {
            private final Type __objectRef;

            private ChangeListener(Type reference) {
                this.__objectRef = reference;
            }

            @Override
            public void onUnderlyingMapChanged(String key, Object value) {
                switch (key) {
                    case "string": {
                        this.__objectRef._stringMember = null;
                        break;
                    }
                    case "com.linkedin.datajob.azkaban.AzkabanJobType": {
                        this.__objectRef._azkabanJobTypeMember = null;
                    }
                }
            }
        }

        public static class ProjectionMask
        extends MaskMap {
            ProjectionMask() {
                super(3);
            }

            public ProjectionMask withAzkabanJobType() {
                this.getDataMap().put(Type.MEMBERKEY_AzkabanJobType, 1);
                return this;
            }

            public ProjectionMask withString() {
                this.getDataMap().put(Type.MEMBERKEY_String, 1);
                return this;
            }
        }

        public static class Fields
        extends PathSpec {
            public Fields(List<String> path, String name) {
                super(path, name);
            }

            public Fields() {
            }

            public PathSpec AzkabanJobType() {
                return new PathSpec(this.getPathComponents(), Type.MEMBERKEY_AzkabanJobType);
            }

            public PathSpec String() {
                return new PathSpec(this.getPathComponents(), Type.MEMBERKEY_String);
            }
        }
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataJobInfo __objectRef;

        private ChangeListener(DataJobInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "externalUrl": {
                    this.__objectRef._externalUrlField = null;
                    break;
                }
                case "customProperties": {
                    this.__objectRef._customPropertiesField = null;
                    break;
                }
                case "created": {
                    this.__objectRef._createdField = null;
                    break;
                }
                case "name": {
                    this.__objectRef._nameField = null;
                    break;
                }
                case "description": {
                    this.__objectRef._descriptionField = null;
                    break;
                }
                case "flowUrn": {
                    this.__objectRef._flowUrnField = null;
                    break;
                }
                case "lastModified": {
                    this.__objectRef._lastModifiedField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                    break;
                }
                case "env": {
                    this.__objectRef._envField = null;
                    break;
                }
                case "status": {
                    this.__objectRef._statusField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec customProperties() {
            return new PathSpec(this.getPathComponents(), "customProperties");
        }

        public PathSpec externalUrl() {
            return new PathSpec(this.getPathComponents(), "externalUrl");
        }

        public PathSpec name() {
            return new PathSpec(this.getPathComponents(), "name");
        }

        public PathSpec description() {
            return new PathSpec(this.getPathComponents(), "description");
        }

        public Type.Fields type() {
            return new Type.Fields(this.getPathComponents(), "type");
        }

        public PathSpec flowUrn() {
            return new PathSpec(this.getPathComponents(), "flowUrn");
        }

        public TimeStamp.Fields created() {
            return new TimeStamp.Fields(this.getPathComponents(), "created");
        }

        public TimeStamp.Fields lastModified() {
            return new TimeStamp.Fields(this.getPathComponents(), "lastModified");
        }

        @Deprecated
        public PathSpec status() {
            return new PathSpec(this.getPathComponents(), "status");
        }

        public PathSpec env() {
            return new PathSpec(this.getPathComponents(), "env");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private Type.ProjectionMask _typeMask;
        private TimeStamp.ProjectionMask _createdMask;
        private TimeStamp.ProjectionMask _lastModifiedMask;

        ProjectionMask() {
            super(14);
        }

        public ProjectionMask withCustomProperties() {
            this.getDataMap().put("customProperties", 1);
            return this;
        }

        public ProjectionMask withExternalUrl() {
            this.getDataMap().put("externalUrl", 1);
            return this;
        }

        public ProjectionMask withName() {
            this.getDataMap().put("name", 1);
            return this;
        }

        public ProjectionMask withDescription() {
            this.getDataMap().put("description", 1);
            return this;
        }

        public ProjectionMask withType(Function<Type.ProjectionMask, Type.ProjectionMask> nestedMask) {
            this._typeMask = nestedMask.apply(this._typeMask == null ? Type.createMask() : this._typeMask);
            this.getDataMap().put("type", this._typeMask.getDataMap());
            return this;
        }

        public ProjectionMask withType() {
            this._typeMask = null;
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withFlowUrn() {
            this.getDataMap().put("flowUrn", 1);
            return this;
        }

        public ProjectionMask withCreated(Function<TimeStamp.ProjectionMask, TimeStamp.ProjectionMask> nestedMask) {
            this._createdMask = nestedMask.apply(this._createdMask == null ? TimeStamp.createMask() : this._createdMask);
            this.getDataMap().put("created", this._createdMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated(MaskMap nestedMask) {
            this.getDataMap().put("created", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated() {
            this._createdMask = null;
            this.getDataMap().put("created", 1);
            return this;
        }

        public ProjectionMask withLastModified(Function<TimeStamp.ProjectionMask, TimeStamp.ProjectionMask> nestedMask) {
            this._lastModifiedMask = nestedMask.apply(this._lastModifiedMask == null ? TimeStamp.createMask() : this._lastModifiedMask);
            this.getDataMap().put("lastModified", this._lastModifiedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified(MaskMap nestedMask) {
            this.getDataMap().put("lastModified", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified() {
            this._lastModifiedMask = null;
            this.getDataMap().put("lastModified", 1);
            return this;
        }

        @Deprecated
        public ProjectionMask withStatus() {
            this.getDataMap().put("status", 1);
            return this;
        }

        public ProjectionMask withEnv() {
            this.getDataMap().put("env", 1);
            return this;
        }
    }
}

