/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.template;

import com.linkedin.data.ByteString;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.DataSchemaUtil;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.PegasusSchemaParser;
import com.linkedin.data.schema.PrimitiveDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.schema.validation.CoercionMode;
import com.linkedin.data.schema.validation.RequiredMode;
import com.linkedin.data.schema.validation.UnrecognizedFieldMode;
import com.linkedin.data.schema.validation.ValidateDataAgainstSchema;
import com.linkedin.data.schema.validation.ValidationOptions;
import com.linkedin.data.schema.validation.ValidationResult;
import com.linkedin.data.template.AbstractArrayTemplate;
import com.linkedin.data.template.AbstractMapTemplate;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DirectCoercer;
import com.linkedin.data.template.FixedTemplate;
import com.linkedin.data.template.HasTyperefInfo;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.TemplateRuntimeException;
import com.linkedin.data.template.TyperefInfo;
import com.linkedin.data.template.UnionTemplate;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class DataTemplateUtil {
    public static final String SCHEMA_FIELD_NAME = "SCHEMA";
    public static final String TYPEREFINFO_FIELD_NAME = "TYPEREFINFO";
    public static final String UNKNOWN_ENUM = "$UNKNOWN";
    public static final PrintStream out = new PrintStream(new FileOutputStream(FileDescriptor.out));
    private static final boolean debug = false;
    private static final Map<Class<?>, DataSchema> _classToSchemaMap = new ConcurrentHashMap();
    private static final Object _classToCoercerMutex = new Object();
    private static Map<Class<?>, DirectCoercer<?>> _classToCoercerMap;
    private static final DirectCoercer<Integer> INTEGER_COERCER;
    private static final DirectCoercer<Long> LONG_COERCER;
    private static final DirectCoercer<Float> FLOAT_COERCER;
    private static final DirectCoercer<Double> DOUBLE_COERCER;
    private static final DirectCoercer<ByteString> BYTES_COERCER;
    private static final BooleanCoercer BOOLEAN_COERCER;
    private static final StringCoercer STRING_COERCER;

    private DataTemplateUtil() {
    }

    public static <E> E castOrThrow(Object value, Class<E> klass) {
        try {
            return value == null ? null : (E)klass.cast(value);
        }
        catch (ClassCastException e) {
            throw new TemplateOutputCastException("Cannot coerce " + value + " to desired class " + klass, e);
        }
    }

    public static <T extends DataTemplate<?>> Constructor<T> templateConstructor(Class<T> templateClass) throws TemplateOutputCastException {
        Class classArg = DataMap.class;
        try {
            if (RecordTemplate.class.isAssignableFrom(templateClass) || AbstractMapTemplate.class.isAssignableFrom(templateClass)) {
                return templateClass.getConstructor(DataMap.class);
            }
            if (AbstractArrayTemplate.class.isAssignableFrom(templateClass)) {
                classArg = DataList.class;
                return templateClass.getConstructor(DataList.class);
            }
            if (FixedTemplate.class.isAssignableFrom(templateClass) || UnionTemplate.class.isAssignableFrom(templateClass)) {
                classArg = Object.class;
                return templateClass.getConstructor(Object.class);
            }
            throw new TemplateOutputCastException("Could not get constructor: " + templateClass.getName() + " does not match any DataTemplate classes");
        }
        catch (SecurityException e) {
            throw new TemplateOutputCastException("getConstructor failed for class " + templateClass.getName() + " with argument " + classArg.getName() + ": the security manager denies access to the constructor, or the caller's class loader differs from the class loader for the current class and the security manager denies access to the package of this class.", e);
        }
        catch (NoSuchMethodException e) {
            throw new TemplateOutputCastException("getConstructor failed for class " + templateClass.getName() + " with argument " + classArg.getName() + ": no matching method was found.", e);
        }
    }

    public static <T extends DataTemplate<?>> T wrap(Object object, Class<T> wrapperClass) throws TemplateOutputCastException {
        try {
            return (T)((DataTemplate)DataTemplateUtil.templateConstructor(wrapperClass).newInstance(object));
        }
        catch (IllegalArgumentException e) {
            throw new TemplateOutputCastException("Could not create new instance of " + wrapperClass.getName() + " with argument " + object, e);
        }
        catch (InstantiationException e) {
            throw new TemplateOutputCastException("Could not create new instance of " + wrapperClass.getName() + ": cannot initialize an abstract class", e);
        }
        catch (IllegalAccessException e) {
            throw new TemplateOutputCastException("Could not create new instance of " + wrapperClass.getName() + ": access control denies access to constructor", e);
        }
        catch (InvocationTargetException e) {
            throw new TemplateOutputCastException("Could not create new instance of " + wrapperClass.getName() + ": constructor throws an exception", e);
        }
        catch (ClassCastException e) {
            throw new TemplateOutputCastException("Could not create new instance of " + wrapperClass.getName() + " with argument " + object, e);
        }
    }

    public static <T extends DataTemplate<?>> Constructor<T> templateConstructor(Class<T> templateClass, DataSchema schema) throws TemplateOutputCastException {
        Class classArg = DataMap.class;
        try {
            switch (schema.getDereferencedType()) {
                case MAP: 
                case RECORD: {
                    return templateClass.getConstructor(DataMap.class);
                }
                case ARRAY: {
                    classArg = DataList.class;
                    return templateClass.getConstructor(DataList.class);
                }
                case FIXED: 
                case UNION: {
                    classArg = Object.class;
                    return templateClass.getConstructor(Object.class);
                }
            }
            throw new TemplateOutputCastException("Could not get constructor for schema: " + schema.getDereferencedType().name() + " does not match any DataTemplate classes");
        }
        catch (SecurityException e) {
            throw new TemplateOutputCastException("getConstructor failed for class " + templateClass.getName() + " with argument " + classArg.getName() + ": the security manager denies access to the constructor, or the caller's class loader differs from the class loader for the current class and the security manager denies access to the package of this class.", e);
        }
        catch (NoSuchMethodException e) {
            throw new TemplateOutputCastException("getConstructor failed for class " + templateClass.getName() + " with argument " + classArg.getName() + ": no matching method was found.", e);
        }
    }

    public static <T extends DataTemplate<?>> T wrap(Object object, DataSchema schema, Class<T> wrapperClass) throws TemplateOutputCastException {
        try {
            return (T)((DataTemplate)DataTemplateUtil.templateConstructor(wrapperClass, schema).newInstance(object));
        }
        catch (IllegalArgumentException e) {
            throw new TemplateOutputCastException("Could not create new instance of " + wrapperClass.getName() + " with argument " + object, e);
        }
        catch (InstantiationException e) {
            throw new TemplateOutputCastException("Could not create new instance of " + wrapperClass.getName() + ": cannot initialize an abstract class", e);
        }
        catch (IllegalAccessException e) {
            throw new TemplateOutputCastException("Could not create new instance of " + wrapperClass.getName() + ": access control denies access to constructor", e);
        }
        catch (InvocationTargetException e) {
            throw new TemplateOutputCastException("Could not create new instance of " + wrapperClass.getName() + ": constructor throws an exception", e);
        }
        catch (ClassCastException e) {
            throw new TemplateOutputCastException("Could not create new instance of " + wrapperClass.getName() + " with argument " + object, e);
        }
    }

    public static <T extends DataTemplate<?>> T wrap(Object object, Constructor<T> constructor) {
        try {
            return (T)((DataTemplate)constructor.newInstance(object));
        }
        catch (IllegalArgumentException e) {
            throw new TemplateOutputCastException("Could not create new instance of " + constructor.getClass().getName() + " using constructor " + constructor.getName() + " with argument " + object, e);
        }
        catch (InstantiationException e) {
            throw new TemplateOutputCastException("Could not create new instance of " + constructor.getClass().getName() + " using constructor " + constructor.getName() + ": cannot initialize an abstract class", e);
        }
        catch (IllegalAccessException e) {
            throw new TemplateOutputCastException("Could not create new instance of " + constructor.getClass().getName() + " using constructor " + constructor.getName() + ": access control denies access to constructor", e);
        }
        catch (InvocationTargetException e) {
            throw new TemplateOutputCastException("Could not create new instance of " + constructor.getClass().getName() + " using constructor " + constructor.getName() + ": constructor throws an exception", e);
        }
        catch (ClassCastException e) {
            throw new TemplateOutputCastException("Could not create new instance of " + constructor.getClass().getName() + " using constructor " + constructor.getName() + " with argument " + object, e);
        }
    }

    public static DataSchema parseSchema(String schemaText) throws IllegalArgumentException {
        return DataTemplateUtil.parseSchema(schemaText, null, SchemaFormatType.PDSC);
    }

    @Deprecated
    public static DataSchema parseSchema(String schemaText, DataSchemaResolver schemaResolver) throws IllegalArgumentException {
        return DataTemplateUtil.parseSchema(schemaText, schemaResolver, SchemaFormatType.PDSC);
    }

    public static DataSchema parseSchema(String schemaText, SchemaFormatType schemaFormatType) throws IllegalArgumentException {
        return DataTemplateUtil.parseSchema(schemaText, null, schemaFormatType);
    }

    public static DataSchema parseSchema(String schemaText, DataSchemaResolver schemaResolver, SchemaFormatType schemaFormatType) throws IllegalArgumentException {
        PegasusSchemaParser parser = schemaFormatType.getSchemaParserFactory().create(schemaResolver);
        parser.parse(schemaText);
        if (parser.hasError()) {
            throw new IllegalArgumentException(parser.errorMessage());
        }
        if (parser.topLevelDataSchemas().size() != 1) {
            throw new IllegalArgumentException("More than one top level schema");
        }
        return parser.topLevelDataSchemas().get(0);
    }

    public static TyperefInfo getTyperefInfo(Class<? extends DataTemplate> type) {
        TyperefInfo typerefInfo;
        if (HasTyperefInfo.class.isAssignableFrom(type)) {
            try {
                Field typerefInfoField = type.getDeclaredField(TYPEREFINFO_FIELD_NAME);
                typerefInfoField.setAccessible(true);
                typerefInfo = (TyperefInfo)typerefInfoField.get(null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error evaluating TyperefInfo for class: " + type.getName(), e);
            }
            catch (NoSuchFieldException e) {
                typerefInfo = null;
            }
        } else {
            typerefInfo = null;
        }
        return typerefInfo;
    }

    public static Class<?> getDataClass(DataSchema schema) {
        DataSchema.Type type = Optional.ofNullable(schema.getDereferencedType()).orElse(DataSchema.Type.NULL);
        switch (type) {
            case ENUM: 
            case STRING: {
                return String.class;
            }
            case MAP: 
            case RECORD: 
            case UNION: {
                return DataMap.class;
            }
            case ARRAY: {
                return DataList.class;
            }
            case FIXED: 
            case BYTES: {
                return ByteString.class;
            }
            case INT: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case BOOLEAN: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    public static DataSchema getSchema(Class<?> type) throws TemplateRuntimeException {
        PrimitiveDataSchema primitiveSchema = DataSchemaUtil.classToPrimitiveDataSchema(type);
        if (primitiveSchema != null) {
            return primitiveSchema;
        }
        DataSchema typeSchema = _classToSchemaMap.get(type);
        return typeSchema != null ? typeSchema : _classToSchemaMap.computeIfAbsent(type, key -> {
            try {
                Field schemaField = type.getDeclaredField(SCHEMA_FIELD_NAME);
                schemaField.setAccessible(true);
                DataSchema schema = (DataSchema)schemaField.get(null);
                if (schema == null) {
                    throw new TemplateRuntimeException("Schema field is not set in class: " + type.getName());
                }
                return schema;
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new TemplateRuntimeException("Error accessing schema field in class: " + type.getName(), e);
            }
        });
    }

    public static String getSchemaName(Class<?> type) {
        DataSchema schema = DataTemplateUtil.getSchema(type);
        if (!(schema instanceof NamedDataSchema)) {
            throw new TemplateRuntimeException("Schema is unnamed in class: " + type.getName());
        }
        return ((NamedDataSchema)schema).getFullName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> void registerCoercer(Class<T> targetClass, DirectCoercer<T> coercer) throws IllegalArgumentException {
        Object object = _classToCoercerMutex;
        synchronized (object) {
            DirectCoercer<?> existingCoercer;
            if (_classToCoercerMap.containsKey(targetClass) && ((existingCoercer = _classToCoercerMap.get(targetClass)) == null || !existingCoercer.getClass().getName().equals(coercer.getClass().getName()))) {
                throw new IllegalArgumentException(targetClass.getName() + " already has a coercer");
            }
            IdentityHashMap newMap = new IdentityHashMap(_classToCoercerMap);
            newMap.put(targetClass, coercer);
            _classToCoercerMap = Collections.unmodifiableMap(newMap);
        }
    }

    public static boolean hasCoercer(Class<?> klass) {
        return _classToCoercerMap.containsKey(klass);
    }

    public static <T> Object coerceInput(T object, Class<T> fromClass, Class<?> toClass) throws ClassCastException {
        if (object.getClass() == fromClass) {
            if (fromClass == toClass) {
                return object;
            }
            if (fromClass.isEnum()) {
                return object.toString();
            }
        }
        return DataTemplateUtil.coerceCustomInput(object, fromClass);
    }

    public static Object coerceIntInput(Integer value) {
        return value;
    }

    public static Object coerceLongInput(Long value) {
        return value;
    }

    public static Object coerceFloatInput(Float value) {
        return value;
    }

    public static Object coerceDoubleInput(Double value) {
        return value;
    }

    public static <C> Object coerceCustomInput(C value, Class<C> customClass) {
        if (value == null) {
            return null;
        }
        DirectCoercer<?> coercer = _classToCoercerMap.get(customClass);
        if (coercer == null) {
            throw new ClassCastException("Input " + value + " has type " + value.getClass().getName() + ", but does not have a registered coercer");
        }
        return coercer.coerceInput(value);
    }

    public static String stringify(Object object) {
        return DataTemplateUtil.stringify(object, object.getClass());
    }

    public static String stringify(Object object, Class<?> fromClass) {
        if (fromClass == null) {
            fromClass = object.getClass();
        }
        if (object instanceof ByteString) {
            return ((ByteString)object).asAvroString();
        }
        if (DataTemplateUtil.hasCoercer(fromClass)) {
            Class<?> clazz = fromClass;
            Object coerced = DataTemplateUtil.coerceInput(object, clazz, Object.class);
            if (coerced instanceof ByteString) {
                return ((ByteString)coerced).asAvroString();
            }
            return coerced.toString();
        }
        return object.toString();
    }

    private static final Object stringToEnum(Class targetClass, String value) throws TemplateOutputCastException {
        try {
            return Enum.valueOf(targetClass, value);
        }
        catch (IllegalArgumentException ignored) {
            try {
                return Enum.valueOf(targetClass, UNKNOWN_ENUM);
            }
            catch (IllegalArgumentException exc) {
                throw new TemplateOutputCastException("Enum " + targetClass.getName() + " does not have a member with the name " + value, exc);
            }
        }
    }

    public static <T> T coerceOutput(Object object, Class<T> targetClass) throws TemplateOutputCastException {
        Class<?> objectClass = object.getClass();
        if (objectClass == targetClass) {
            return (T)object;
        }
        if (targetClass.isEnum()) {
            if (objectClass == String.class) {
                return (T)DataTemplateUtil.stringToEnum(targetClass, (String)object);
            }
            throw new TemplateOutputCastException("Output " + object + " has type " + object.getClass().getName() + ", and cannot be coerced to enum type " + targetClass.getName());
        }
        return DataTemplateUtil.coerceCustomOutput(object, targetClass);
    }

    public static Integer coerceIntOutput(Object value) {
        return value == null ? null : INTEGER_COERCER.coerceOutput(value);
    }

    public static Long coerceLongOutput(Object value) {
        return value == null ? null : LONG_COERCER.coerceOutput(value);
    }

    public static Float coerceFloatOutput(Object value) {
        return value == null ? null : FLOAT_COERCER.coerceOutput(value);
    }

    public static Double coerceDoubleOutput(Object value) {
        return value == null ? null : DOUBLE_COERCER.coerceOutput(value);
    }

    public static ByteString coerceBytesOutput(Object value) {
        return value == null ? null : BYTES_COERCER.coerceOutput(value);
    }

    public static Boolean coerceBooleanOutput(Object value) {
        return value == null ? null : BOOLEAN_COERCER.coerceOutput(value);
    }

    public static String coerceStringOutput(Object value) {
        return value == null ? null : STRING_COERCER.coerceOutput(value);
    }

    public static <E extends Enum<E>> E coerceEnumOutput(Object value, Class<E> targetClass, E fallback) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            try {
                return Enum.valueOf(targetClass, (String)value);
            }
            catch (IllegalArgumentException e) {
                return fallback;
            }
        }
        throw new TemplateOutputCastException("Output " + value + " has type " + value.getClass().getName() + ", and cannot be coerced to enum type " + targetClass.getName());
    }

    public static <C> C coerceCustomOutput(Object value, Class<C> customClass) {
        if (value == null) {
            return null;
        }
        DirectCoercer<?> coercer = _classToCoercerMap.get(customClass);
        if (coercer == null) {
            throw new TemplateOutputCastException("Output " + value + " has type " + value.getClass().getName() + ", but does not have a registered coercer and cannot be coerced to type " + customClass.getName());
        }
        return (C)coercer.coerceOutput(value);
    }

    public static Object convertDataListToArray(DataList list, Class<?> arrayItemType) {
        Object result = Array.newInstance(arrayItemType, list.size());
        for (int i = 0; i < list.size(); ++i) {
            Object arrayItem;
            Object valueItem = list.get(i);
            if (arrayItemType.isArray()) {
                Class<?> componentType = arrayItemType.getComponentType();
                if (!(valueItem instanceof DataList)) {
                    throw new TemplateOutputCastException("Cannot coerce item " + valueItem + " with type " + valueItem.getClass().getName() + " to array of " + componentType.getName() + ": Expected type is " + DataList.class.getName());
                }
                arrayItem = DataTemplateUtil.convertDataListToArray((DataList)valueItem, componentType);
            } else {
                arrayItem = DataTemplate.class.isAssignableFrom(arrayItemType) ? DataTemplateUtil.wrap(valueItem, arrayItemType.asSubclass(DataTemplate.class)) : DataTemplateUtil.coerceOutput(valueItem, arrayItemType);
            }
            Array.set(result, i, arrayItem);
        }
        return result;
    }

    static void initializeClass(Class<?> clazz) {
        try {
            Class.forName(clazz.getName(), true, clazz.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            ClassNotFoundException exc = e;
            throw new IllegalArgumentException(clazz + " cannot be initialized", exc);
        }
    }

    public static <T extends DataTemplate<?>> boolean areEqual(T data1, T data2) {
        return DataTemplateUtil.areEqual(data1, data2, false);
    }

    public static <T extends DataTemplate<?>> boolean areEqual(T data1, T data2, boolean ignoreUnrecognizedField) {
        ValidationOptions validationOption = new ValidationOptions(RequiredMode.FIXUP_ABSENT_WITH_DEFAULT, CoercionMode.NORMAL, ignoreUnrecognizedField ? UnrecognizedFieldMode.TRIM : UnrecognizedFieldMode.IGNORE);
        return DataTemplateUtil.areEqual(data1, data2, validationOption);
    }

    private static <T extends DataTemplate<?>> boolean areEqual(T data1, T data2, ValidationOptions validationOption) {
        if (data1 == null || data2 == null) {
            return data1 == data2;
        }
        if (data1.equals(data2)) {
            return true;
        }
        try {
            DataTemplate<?> data1Copy = data1.copy();
            DataTemplate<?> data2Copy = data2.copy();
            ValidationResult validateResult1 = ValidateDataAgainstSchema.validate(data1Copy, validationOption);
            ValidationResult validateResult2 = ValidateDataAgainstSchema.validate(data2Copy, validationOption);
            if (validateResult1.hasFix() || validateResult2.hasFix()) {
                return data1Copy.equals(data2Copy);
            }
            return false;
        }
        catch (CloneNotSupportedException e) {
            return false;
        }
    }

    static {
        INTEGER_COERCER = new IntegerCoercer();
        LONG_COERCER = new LongCoercer();
        FLOAT_COERCER = new FloatCoercer();
        DOUBLE_COERCER = new DoubleCoercer();
        BYTES_COERCER = new BytesCoercer();
        BOOLEAN_COERCER = new BooleanCoercer();
        STRING_COERCER = new StringCoercer();
        IdentityHashMap<Class<Object>, DirectCoercer<Object>> map = new IdentityHashMap<Class<Object>, DirectCoercer<Object>>();
        map.put(Integer.TYPE, INTEGER_COERCER);
        map.put(Integer.class, INTEGER_COERCER);
        map.put(Long.TYPE, LONG_COERCER);
        map.put(Long.class, LONG_COERCER);
        map.put(Float.TYPE, FLOAT_COERCER);
        map.put(Float.class, FLOAT_COERCER);
        map.put(Double.TYPE, DOUBLE_COERCER);
        map.put(Double.class, DOUBLE_COERCER);
        map.put(ByteString.class, BYTES_COERCER);
        map.put(Boolean.TYPE, BOOLEAN_COERCER);
        map.put(Enum.class, STRING_COERCER);
        _classToCoercerMap = Collections.unmodifiableMap(map);
    }

    private static class DoubleCoercer
    extends NumberCoercer<Double> {
        DoubleCoercer() {
            super(Double.class);
        }

        @Override
        protected Double coerce(Object object) {
            return ((Number)object).doubleValue();
        }

        @Override
        protected Double coerceString(String object) {
            if (this.isNonNumericFloat(object).booleanValue()) {
                return Double.valueOf(object);
            }
            throw this.generateExceptionForInvalidString(object);
        }

        @Override
        protected boolean isStringAllowed() {
            return true;
        }
    }

    private static class FloatCoercer
    extends NumberCoercer<Float> {
        FloatCoercer() {
            super(Float.class);
        }

        @Override
        protected Float coerce(Object object) {
            return Float.valueOf(((Number)object).floatValue());
        }

        @Override
        protected Float coerceString(String object) {
            if (this.isNonNumericFloat(object).booleanValue()) {
                return Float.valueOf(object);
            }
            throw this.generateExceptionForInvalidString(object);
        }

        @Override
        protected boolean isStringAllowed() {
            return true;
        }
    }

    private static class LongCoercer
    extends NumberCoercer<Long> {
        LongCoercer() {
            super(Long.class);
        }

        @Override
        protected Long coerce(Object object) {
            return ((Number)object).longValue();
        }
    }

    private static class IntegerCoercer
    extends NumberCoercer<Integer> {
        IntegerCoercer() {
            super(Integer.class);
        }

        @Override
        protected Integer coerce(Object object) {
            return ((Number)object).intValue();
        }
    }

    private static class BytesCoercer
    extends NativeCoercer<ByteString> {
        BytesCoercer() {
            super(ByteString.class);
        }

        @Override
        public ByteString coerceOutput(Object object) throws TemplateOutputCastException {
            if (object instanceof ByteString) {
                return (ByteString)object;
            }
            if (object.getClass() == String.class) {
                String input = (String)object;
                ByteString bytes = ByteString.copyAvroString(input, true);
                if (bytes == null) {
                    throw new TemplateOutputCastException("Output " + object + " is not a valid string encoding of bytes");
                }
                return bytes;
            }
            throw new TemplateOutputCastException("Output " + object + " has type " + object.getClass().getName() + ", but expected type is " + String.class.getName());
        }
    }

    private static class StringCoercer
    extends NativeCoercer<String> {
        StringCoercer() {
            super(String.class);
        }

        @Override
        public Object coerceInput(String object) throws ClassCastException {
            return object;
        }

        @Override
        public String coerceOutput(Object object) throws TemplateOutputCastException {
            if (object instanceof String) {
                return (String)object;
            }
            throw new TemplateOutputCastException("Output " + object + " has type " + object.getClass().getName() + ", but expected type is " + String.class.getName());
        }
    }

    private static class BooleanCoercer
    extends NativeCoercer<Boolean> {
        BooleanCoercer() {
            super(Boolean.class);
        }

        @Override
        public Boolean coerceOutput(Object object) throws TemplateOutputCastException {
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            throw new TemplateOutputCastException("Output " + object + " has type " + object.getClass().getName() + ", but expected type is " + Boolean.class.getName());
        }
    }

    private static abstract class NumberCoercer<T extends Number>
    implements DirectCoercer<T> {
        protected Class<T> _targetClass;

        NumberCoercer(Class<T> targetClass) {
            this._targetClass = targetClass;
        }

        @Override
        public Object coerceInput(T object) throws ClassCastException {
            if (object.getClass() == this._targetClass) {
                return object;
            }
            if (object instanceof Number) {
                return this.coerce(object);
            }
            throw new ClassCastException("Input " + object + " has type " + object.getClass().getName() + ", but expected type is " + Number.class.getName());
        }

        @Override
        public T coerceOutput(Object object) throws TemplateOutputCastException {
            if (object.getClass() == this._targetClass) {
                return (T)((Number)object);
            }
            if (object instanceof Number) {
                return this.coerce(object);
            }
            if (object instanceof String && this.isStringAllowed()) {
                return this.coerceString((String)object);
            }
            throw new TemplateOutputCastException("Output " + object + " has type " + object.getClass().getName() + ", but expected type is " + this._targetClass.getName());
        }

        protected boolean isStringAllowed() {
            return false;
        }

        protected Boolean isNonNumericFloat(String object) {
            return object.equals(String.valueOf(Float.NaN)) || object.equals(String.valueOf(Float.POSITIVE_INFINITY)) || object.equals(String.valueOf(Float.NEGATIVE_INFINITY));
        }

        protected TemplateOutputCastException generateExceptionForInvalidString(String object) {
            return new TemplateOutputCastException("Cannot coerce String value : " + object + " to type : " + this._targetClass.getName());
        }

        protected T coerceString(String object) {
            throw new UnsupportedOperationException("Only supported for floating-point number coercers");
        }

        protected abstract T coerce(Object var1);
    }

    private static abstract class NativeCoercer<T>
    implements DirectCoercer<T> {
        protected Class<T> _targetClass;

        protected NativeCoercer(Class<T> targetClass) {
            this._targetClass = targetClass;
        }

        @Override
        public Object coerceInput(T object) throws ClassCastException {
            throw new ClassCastException("Input " + object + " has type " + object.getClass().getName() + " but expected type is " + this._targetClass.getName());
        }
    }
}

