/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.AbstractSchemaEncoder;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.CompactPdlBuilder;
import com.linkedin.data.schema.ComplexDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.EnumDataSchema;
import com.linkedin.data.schema.FixedDataSchema;
import com.linkedin.data.schema.IndentedPdlBuilder;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.Name;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.PdlBuilder;
import com.linkedin.data.schema.PrimitiveDataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.schema.grammar.PdlSchemaParser;
import com.linkedin.util.LineColumnNumberWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class SchemaToPdlEncoder
extends AbstractSchemaEncoder {
    private static final int UNION_MULTILINE_THRESHOLD = 5;
    private final Writer _writer;
    private EncodingStyle _encodingStyle;
    private PdlBuilder _builder;
    private Map<String, Name> _importsByLocalName;
    private String _namespace = "";
    private String _package = "";
    private final boolean _trackWriteLocations;
    private final Map<Object, PdlSchemaParser.ParseLocation> _writeLocations;

    public static String schemaToPdl(DataSchema schema, EncodingStyle encodingStyle) {
        StringWriter writer = new StringWriter();
        SchemaToPdlEncoder encoder = new SchemaToPdlEncoder(writer);
        encoder.setEncodingStyle(encodingStyle);
        try {
            encoder.encode(schema);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return writer.toString();
    }

    public SchemaToPdlEncoder(Writer out) {
        this(out, false);
    }

    public SchemaToPdlEncoder(Writer out, boolean returnContextLocations) {
        if (returnContextLocations) {
            this._writeLocations = new IdentityHashMap<Object, PdlSchemaParser.ParseLocation>();
            this._writer = new LineColumnNumberWriter(out);
        } else {
            this._writer = out;
            this._writeLocations = Collections.emptyMap();
        }
        this.setEncodingStyle(EncodingStyle.INDENTED);
        this._trackWriteLocations = returnContextLocations;
    }

    public void setEncodingStyle(EncodingStyle encodingStyle) {
        this._encodingStyle = encodingStyle;
        if (this._writer instanceof LineColumnNumberWriter) {
            if (this._encodingStyle == EncodingStyle.COMPACT) {
                ((LineColumnNumberWriter)this._writer).setIsWhitespaceFunction(c -> Character.isWhitespace(c.charValue()) || c.charValue() == ',');
            } else {
                ((LineColumnNumberWriter)this._writer).setIsWhitespaceFunction(Character::isWhitespace);
            }
        }
    }

    @Override
    public void encode(DataSchema schema) throws IOException {
        this._builder = this._encodingStyle.newBuilderInstance(this._writer);
        if (schema instanceof NamedDataSchema) {
            NamedDataSchema namedSchema = (NamedDataSchema)schema;
            boolean hasNamespace = StringUtils.isNotBlank(namedSchema.getNamespace());
            boolean hasPackage = StringUtils.isNotBlank(namedSchema.getPackage());
            if (hasNamespace || hasPackage) {
                if (hasNamespace) {
                    this.markSchemaElementStartLocation();
                    this._builder.write("namespace").writeSpace().writeIdentifier(namedSchema.getNamespace()).newline();
                    this.recordSchemaElementLocation(namedSchema.getNamespace());
                    this._namespace = namedSchema.getNamespace();
                }
                if (hasPackage) {
                    this._builder.write("package").writeSpace().writeIdentifier(namedSchema.getPackage()).newline();
                    this._package = namedSchema.getPackage();
                }
                this._builder.newline();
            }
        }
        this._importsByLocalName = this._typeReferenceFormat != AbstractSchemaEncoder.TypeReferenceFormat.DENORMALIZE ? this.computeImports(schema, this._namespace) : Collections.emptyMap();
        if (this._importsByLocalName.size() > 0) {
            for (Name importName : new TreeSet<Name>(this._importsByLocalName.values())) {
                this._builder.write("import").writeSpace().writeIdentifier(importName.getFullName()).newline();
            }
            this._builder.newline();
        }
        this.writeInlineSchema(schema);
    }

    private void writeInlineSchema(DataSchema schema) throws IOException {
        boolean hasNamespaceOverride = false;
        boolean hasPackageOverride = false;
        String surroundingNamespace = this._namespace;
        String surroundingPackage = this._package;
        if (schema instanceof NamedDataSchema) {
            this.markEncountered(schema);
            NamedDataSchema namedSchema = (NamedDataSchema)schema;
            hasNamespaceOverride = !StringUtils.isEmpty(namedSchema.getNamespace()) && !namedSchema.getNamespace().equals(surroundingNamespace);
            boolean bl = hasPackageOverride = !StringUtils.isEmpty(namedSchema.getPackage()) && !namedSchema.getPackage().equals(surroundingPackage);
            if (hasNamespaceOverride || hasPackageOverride) {
                this._builder.indent().write("{").newline().increaseIndent();
                if (hasNamespaceOverride) {
                    this.markSchemaElementStartLocation();
                    this._builder.indent().write("namespace").writeSpace().writeIdentifier(namedSchema.getNamespace()).newline();
                    this.recordSchemaElementLocation(namedSchema.getNamespace());
                    this._namespace = namedSchema.getNamespace();
                }
                if (hasPackageOverride) {
                    this._builder.indent().write("package").writeSpace().writeIdentifier(namedSchema.getPackage()).newline();
                    this._package = namedSchema.getPackage();
                }
            }
        }
        switch (schema.getType()) {
            case RECORD: {
                this.writeRecord((RecordDataSchema)schema);
                break;
            }
            case ENUM: {
                this.writeEnum((EnumDataSchema)schema);
                break;
            }
            case FIXED: {
                this.writeFixed((FixedDataSchema)schema);
                break;
            }
            case TYPEREF: {
                this.writeTyperef((TyperefDataSchema)schema);
                break;
            }
            case ARRAY: {
                this.writeArray((ArrayDataSchema)schema);
                break;
            }
            case MAP: {
                this.writeMap((MapDataSchema)schema);
                break;
            }
            case UNION: {
                this.writeUnion((UnionDataSchema)schema);
                break;
            }
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case BYTES: {
                this.writePrimitive((PrimitiveDataSchema)schema);
                break;
            }
            case NULL: {
                this._builder.write("null");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized schema type " + schema.getClass());
            }
        }
        if (hasNamespaceOverride || hasPackageOverride) {
            this._builder.decreaseIndent().newline().indent().write("}");
            this._namespace = surroundingNamespace;
            this._package = surroundingPackage;
        }
    }

    public Map<Object, PdlSchemaParser.ParseLocation> getWriteLocations() {
        return this._writeLocations;
    }

    private void writeRecord(RecordDataSchema schema) throws IOException {
        this.markSchemaElementStartLocation();
        this.writeDocAndProperties(schema);
        this._builder.write("record").writeSpace().writeIdentifier(schema.getName());
        List<NamedDataSchema> includes = schema.getInclude();
        if (includes.size() > 0 && !schema.isFieldsBeforeIncludes()) {
            this.writeIncludes(schema, includes);
        }
        this._builder.writeSpace().write("{");
        List<RecordDataSchema.Field> fields = schema.getFields();
        if (!fields.isEmpty()) {
            this._builder.newline().increaseIndent();
            for (RecordDataSchema.Field field : fields) {
                if (!field.getRecord().equals(schema)) continue;
                this.writeField(field);
            }
            this._builder.decreaseIndent().indent();
        }
        this._builder.write("}");
        if (includes.size() > 0 && schema.isFieldsBeforeIncludes()) {
            this.writeIncludes(schema, includes);
        }
        this.recordSchemaElementLocation(schema);
    }

    private void writeField(RecordDataSchema.Field field) throws IOException {
        this.markSchemaElementStartLocation();
        this.writeDocAndProperties(field);
        this._builder.indent().writeIdentifier(field.getName()).write(":").writeSpace();
        if (field.getOptional()) {
            this._builder.write("optional").writeSpace();
        }
        this.writeReferenceOrInline(field.getType(), field.isDeclaredInline());
        if (field.getDefault() != null) {
            this._builder.writeSpace().write("=").writeSpace().writeJson(field.getDefault(), field.getType());
        }
        this.recordSchemaElementLocation(field);
        this._builder.newline();
    }

    private void writeIncludes(RecordDataSchema schema, List<NamedDataSchema> includes) throws IOException {
        this._builder.writeSpace().write("includes").writeSpace();
        Iterator<NamedDataSchema> iter = includes.iterator();
        while (iter.hasNext()) {
            NamedDataSchema include = iter.next();
            this.writeReferenceOrInline(include, schema.isIncludeDeclaredInline(include));
            if (!iter.hasNext()) continue;
            this._builder.writeComma().writeSpace();
        }
    }

    private void writeEnum(EnumDataSchema schema) throws IOException {
        Map<String, Object> properties = schema.getProperties();
        DataMap propertiesMap = new DataMap(this.coercePropertyToDataMapOrFail(schema, "symbolProperties", properties.get("symbolProperties")));
        DataMap deprecatedMap = this.coercePropertyToDataMapOrFail(schema, "deprecatedSymbols", properties.get("deprecatedSymbols"));
        this.markSchemaElementStartLocation();
        this.writeDocAndProperties(schema);
        this._builder.write("enum").writeSpace().writeIdentifier(schema.getName()).writeSpace().write("{").newline().increaseIndent();
        Map<String, String> docs = schema.getSymbolDocs();
        for (String symbol : schema.getSymbols()) {
            this.markSchemaElementStartLocation();
            String docString = docs.get(symbol);
            DataMap symbolProperties = this.coercePropertyToDataMapOrFail(schema, "symbolProperties." + symbol, propertiesMap.get(symbol));
            Object deprecated = deprecatedMap.get(symbol);
            if (deprecated != null) {
                symbolProperties.put("deprecated", deprecated);
            }
            if (StringUtils.isNotBlank(docString) || !symbolProperties.isEmpty()) {
                this._builder.newline();
            }
            this.writeDocAndProperties(docString, symbolProperties);
            this._builder.indent().writeIdentifier(symbol).newline();
            this.recordSchemaElementLocation(symbol);
        }
        this._builder.decreaseIndent().indent().write("}");
        this.recordSchemaElementLocation(schema);
    }

    private void writeFixed(FixedDataSchema schema) throws IOException {
        this.markSchemaElementStartLocation();
        this.writeDocAndProperties(schema);
        this._builder.write("fixed").writeSpace().writeIdentifier(schema.getName()).writeSpace().write(String.valueOf(schema.getSize()));
        this.recordSchemaElementLocation(schema);
    }

    private void writeTyperef(TyperefDataSchema schema) throws IOException {
        this.markSchemaElementStartLocation();
        this.writeDocAndProperties(schema);
        this._builder.write("typeref").writeSpace().writeIdentifier(schema.getName()).writeSpace().write("=").writeSpace();
        DataSchema ref = schema.getRef();
        this.writeReferenceOrInline(ref, schema.isRefDeclaredInline());
        this.recordSchemaElementLocation(schema);
    }

    private void writeMap(MapDataSchema schema) throws IOException {
        this.markSchemaElementStartLocation();
        this.writeProperties(schema.getProperties());
        this._builder.write("map[string").writeComma().writeSpace();
        this.writeReferenceOrInline(schema.getValues(), schema.isValuesDeclaredInline());
        this._builder.write("]");
        this.recordSchemaElementLocation(schema);
    }

    private void writeArray(ArrayDataSchema schema) throws IOException {
        this.markSchemaElementStartLocation();
        this.writeProperties(schema.getProperties());
        this._builder.write("array[");
        this.writeReferenceOrInline(schema.getItems(), schema.isItemsDeclaredInline());
        this._builder.write("]");
        this.recordSchemaElementLocation(schema);
    }

    private void writeUnion(UnionDataSchema schema) throws IOException {
        boolean useMultilineFormat;
        this.markSchemaElementStartLocation();
        this.writeProperties(schema.getProperties());
        this._builder.write("union[");
        boolean bl = useMultilineFormat = schema.areMembersAliased() || schema.getMembers().size() >= 5;
        if (useMultilineFormat) {
            this._builder.newline().increaseIndent();
        }
        Iterator<UnionDataSchema.Member> iter = schema.getMembers().iterator();
        while (iter.hasNext()) {
            this.writeUnionMember(iter.next(), useMultilineFormat);
            if (!iter.hasNext()) continue;
            if (useMultilineFormat) {
                this._builder.writeComma().newline();
                continue;
            }
            this._builder.writeComma().writeSpace();
        }
        if (useMultilineFormat) {
            this._builder.decreaseIndent().newline().indent();
        }
        this._builder.write("]");
        this.recordSchemaElementLocation(schema);
    }

    private void writeUnionMember(UnionDataSchema.Member member, boolean useMultilineFormat) throws IOException {
        this.markSchemaElementStartLocation();
        if (member.hasAlias()) {
            if (StringUtils.isNotBlank(member.getDoc()) || !member.getProperties().isEmpty() || member.isDeclaredInline()) {
                this._builder.newline();
            }
            this.writeDocAndProperties(member.getDoc(), member.getProperties());
            this._builder.indent().writeIdentifier(member.getAlias()).write(":").writeSpace();
        } else if (useMultilineFormat) {
            this._builder.indent();
        }
        this.writeReferenceOrInline(member.getType(), member.isDeclaredInline());
        this.recordSchemaElementLocation(member);
    }

    private void writePrimitive(PrimitiveDataSchema schema) throws IOException {
        this._builder.write(schema.getUnionMemberKey());
    }

    private DataMap coercePropertyToDataMapOrFail(NamedDataSchema schema, String name, Object value) {
        if (value == null) {
            return new DataMap();
        }
        if (!(value instanceof DataMap)) {
            throw new IllegalArgumentException("'" + name + "' in " + schema.getFullName() + " must be of type DataMap, but is: " + value.getClass());
        }
        return (DataMap)value;
    }

    private void writeReferenceOrInline(DataSchema dataSchema, boolean originallyInlined) throws IOException {
        AbstractSchemaEncoder.TypeRepresentation representation = this.selectTypeRepresentation(dataSchema, originallyInlined);
        this.encodeNamedInnerSchema(dataSchema, representation);
    }

    protected void encodeNamedInnerSchema(DataSchema dataSchema, AbstractSchemaEncoder.TypeRepresentation representation) throws IOException {
        if (representation == AbstractSchemaEncoder.TypeRepresentation.DECLARED_INLINE) {
            boolean requiresNewlineLayout = this.requiresNewlineLayout(dataSchema);
            if (requiresNewlineLayout) {
                this._builder.newline().increaseIndent();
            }
            this.writeInlineSchema(dataSchema);
            if (requiresNewlineLayout) {
                this._builder.decreaseIndent();
            }
        } else if (dataSchema instanceof NamedDataSchema) {
            this.markEncountered(dataSchema);
            this.writeReference((NamedDataSchema)dataSchema);
        } else {
            throw new IllegalArgumentException("Unnamed not marked as inline: " + dataSchema);
        }
    }

    private boolean requiresNewlineLayout(DataSchema dataSchema) {
        if (dataSchema instanceof NamedDataSchema) {
            NamedDataSchema named = (NamedDataSchema)dataSchema;
            return StringUtils.isNotBlank(named.getDoc()) || !named.getProperties().isEmpty() || !named.getAliases().isEmpty();
        }
        if (dataSchema instanceof ComplexDataSchema) {
            return !dataSchema.getProperties().isEmpty();
        }
        return false;
    }

    private boolean writeProperties(Map<String, Object> properties) throws IOException {
        this._builder.writeProperties(Collections.emptyList(), properties);
        return !properties.isEmpty();
    }

    private boolean writeDocAndProperties(String doc, Map<String, Object> properties) throws IOException {
        boolean hasDoc = this._builder.writeDoc(doc);
        boolean hasProperties = this.writeProperties(properties);
        return hasDoc || hasProperties;
    }

    private void writeDocAndProperties(NamedDataSchema schema) throws IOException {
        boolean hasDocOrProperties;
        List<Name> aliases;
        DataMap properties = new DataMap((Map<? extends String, ? extends Object>)schema.getProperties());
        if (schema instanceof EnumDataSchema) {
            properties.remove("deprecatedSymbols");
            properties.remove("symbolProperties");
        }
        if ((aliases = schema.getAliases()) != null && aliases.size() > 0) {
            List aliasStrings = aliases.stream().map(Name::getFullName).collect(Collectors.toList());
            properties.put("aliases", new DataList(aliasStrings));
        }
        if (hasDocOrProperties = this.writeDocAndProperties(schema.getDoc(), properties)) {
            this._builder.indent();
        }
    }

    private void writeDocAndProperties(RecordDataSchema.Field field) throws IOException {
        DataMap properties = new DataMap((Map<? extends String, ? extends Object>)field.getProperties());
        List<String> aliases = field.getAliases();
        if (aliases != null && !aliases.isEmpty()) {
            properties.put("aliases", new DataList((List<? extends Object>)aliases));
        }
        if (field.getOrder() != null && !field.getOrder().equals((Object)RecordDataSchema.Field.Order.ASCENDING)) {
            properties.put("order", field.getOrder().name());
        }
        if (StringUtils.isNotBlank(field.getDoc()) || !properties.isEmpty() || field.isDeclaredInline()) {
            this._builder.newline();
        }
        this.writeDocAndProperties(field.getDoc(), properties);
    }

    private Map<String, Name> computeImports(DataSchema schema, String rootNamespace) {
        HashSet<Name> encounteredTypes = new HashSet<Name>();
        HashSet<String> nonImportableTypeNames = new HashSet<String>();
        this.gatherTypes(schema, true, encounteredTypes, nonImportableTypeNames, rootNamespace);
        return encounteredTypes.stream().filter(name -> !name.getNamespace().equals(rootNamespace) && !nonImportableTypeNames.contains(name.getName())).collect(Collectors.toMap(Name::getName, Function.identity(), (nameA, nameB) -> nameA.compareTo((Name)nameB) < 0 ? nameA : nameB));
    }

    private void gatherTypes(DataSchema schema, boolean isDeclaredInline, Set<Name> encounteredTypes, Set<String> nonImportableTypeNames, String currentNamespace) {
        if (schema instanceof NamedDataSchema) {
            NamedDataSchema namedSchema = (NamedDataSchema)schema;
            encounteredTypes.add(new Name(namedSchema.getFullName()));
            if (isDeclaredInline || currentNamespace.equals(namedSchema.getNamespace())) {
                nonImportableTypeNames.add(namedSchema.getName());
            }
        }
        if (isDeclaredInline) {
            if (schema instanceof RecordDataSchema) {
                RecordDataSchema recordSchema = (RecordDataSchema)schema;
                for (RecordDataSchema.Field field : recordSchema.getFields()) {
                    if (!field.getRecord().equals(schema)) continue;
                    this.gatherTypes(field.getType(), field.isDeclaredInline(), encounteredTypes, nonImportableTypeNames, recordSchema.getNamespace());
                }
                for (NamedDataSchema include : recordSchema.getInclude()) {
                    this.gatherTypes(include, recordSchema.isIncludeDeclaredInline(include), encounteredTypes, nonImportableTypeNames, recordSchema.getNamespace());
                }
            } else if (schema instanceof TyperefDataSchema) {
                TyperefDataSchema typerefSchema = (TyperefDataSchema)schema;
                this.gatherTypes(typerefSchema.getRef(), typerefSchema.isRefDeclaredInline(), encounteredTypes, nonImportableTypeNames, typerefSchema.getNamespace());
            } else if (schema instanceof UnionDataSchema) {
                UnionDataSchema unionSchema = (UnionDataSchema)schema;
                for (UnionDataSchema.Member member : unionSchema.getMembers()) {
                    this.gatherTypes(member.getType(), member.isDeclaredInline(), encounteredTypes, nonImportableTypeNames, currentNamespace);
                }
            } else if (schema instanceof MapDataSchema) {
                MapDataSchema mapSchema = (MapDataSchema)schema;
                this.gatherTypes(mapSchema.getValues(), mapSchema.isValuesDeclaredInline(), encounteredTypes, nonImportableTypeNames, currentNamespace);
            } else if (schema instanceof ArrayDataSchema) {
                ArrayDataSchema arraySchema = (ArrayDataSchema)schema;
                this.gatherTypes(arraySchema.getItems(), arraySchema.isItemsDeclaredInline(), encounteredTypes, nonImportableTypeNames, currentNamespace);
            }
        }
    }

    private void writeReference(NamedDataSchema schema) throws IOException {
        if (this._importsByLocalName.containsKey(schema.getName()) && this._importsByLocalName.get(schema.getName()).getNamespace().equals(schema.getNamespace())) {
            this._builder.writeIdentifier(schema.getName());
        } else if (this._namespace.equals(schema.getNamespace()) && !this._importsByLocalName.containsKey(schema.getName())) {
            this._builder.writeIdentifier(schema.getName());
        } else {
            this._builder.writeIdentifier(schema.getFullName());
        }
    }

    void markSchemaElementStartLocation() {
        if (this._trackWriteLocations) {
            ((LineColumnNumberWriter)this._writer).saveCurrentPosition();
        }
    }

    private void recordSchemaElementLocation(Object schemaElement) {
        if (this._trackWriteLocations) {
            LineColumnNumberWriter.CharacterPosition startPosition = ((LineColumnNumberWriter)this._writer).popSavedPosition();
            LineColumnNumberWriter.CharacterPosition endPosition = ((LineColumnNumberWriter)this._writer).getLastNonWhitespacePosition();
            this._writeLocations.put(schemaElement, new PdlSchemaParser.ParseLocation(startPosition.getLine(), startPosition.getColumn(), endPosition.getLine(), endPosition.getColumn()));
        }
    }

    public static enum EncodingStyle {
        COMPACT(new CompactPdlBuilder.Provider()),
        INDENTED(new IndentedPdlBuilder.Provider());

        PdlBuilder.Provider _pdlBuilderProvider;

        private EncodingStyle(PdlBuilder.Provider pdlBuilderProvider) {
            this._pdlBuilderProvider = pdlBuilderProvider;
        }

        PdlBuilder newBuilderInstance(Writer writer) {
            return this._pdlBuilderProvider.newInstance(writer);
        }
    }
}

