/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema;

import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class DataSchemaTraverse {
    private final IdentityHashMap<DataSchema, Boolean> _seen = new IdentityHashMap();
    private final ArrayList<String> _path = new ArrayList();
    private final Order _order;
    private Map<Order, Callback> _callbacks = new HashMap<Order, Callback>();

    public DataSchemaTraverse() {
        this(Order.PRE_ORDER);
    }

    public DataSchemaTraverse(Order order) {
        this._order = order;
    }

    public void traverse(DataSchema schema, Callback callback) {
        this.traverse(schema, Collections.singletonMap(this._order, callback));
    }

    public void traverse(DataSchema schema, Map<Order, Callback> callbacks) {
        this._seen.clear();
        this._path.clear();
        this._callbacks.clear();
        this._callbacks.putAll(callbacks);
        this._seen.put(schema, Boolean.TRUE);
        this.traverseRecurse(schema);
        assert (this._path.isEmpty());
    }

    private void traverseRecurse(DataSchema schema) {
        if (schema instanceof NamedDataSchema) {
            this._path.add(((NamedDataSchema)schema).getFullName());
        } else {
            this._path.add(schema.getUnionMemberKey());
        }
        if (this._callbacks.containsKey((Object)Order.PRE_ORDER)) {
            this._callbacks.get((Object)Order.PRE_ORDER).callback(this._path, schema);
        }
        switch (schema.getType()) {
            case TYPEREF: {
                TyperefDataSchema typerefDataSchema = (TyperefDataSchema)schema;
                this.traverseChild("ref", typerefDataSchema.getRef());
                break;
            }
            case MAP: {
                MapDataSchema mapDataSchema = (MapDataSchema)schema;
                this.traverseChild("values", mapDataSchema.getValues());
                break;
            }
            case ARRAY: {
                ArrayDataSchema arrayDataSchema = (ArrayDataSchema)schema;
                this.traverseChild("items", arrayDataSchema.getItems());
                break;
            }
            case RECORD: {
                RecordDataSchema recordDataSchema = (RecordDataSchema)schema;
                for (RecordDataSchema.Field field : recordDataSchema.getFields()) {
                    this.traverseChild(field.getName(), field.getType());
                }
                break;
            }
            case UNION: {
                UnionDataSchema unionDataSchema = (UnionDataSchema)schema;
                for (UnionDataSchema.Member member : unionDataSchema.getMembers()) {
                    this.traverseChild(member.getUnionMemberKey(), member.getType());
                }
                break;
            }
            case FIXED: {
                break;
            }
            case ENUM: {
                break;
            }
            default: {
                assert (schema.isPrimitive());
                break;
            }
        }
        if (this._callbacks.containsKey((Object)Order.POST_ORDER)) {
            this._callbacks.get((Object)Order.POST_ORDER).callback(this._path, schema);
        }
        this._path.remove(this._path.size() - 1);
    }

    private void traverseChild(String childKey, DataSchema childSchema) {
        if (!this._seen.containsKey(childSchema)) {
            this._seen.put(childSchema, Boolean.TRUE);
            this._path.add(childKey);
            this.traverseRecurse(childSchema);
            this._path.remove(this._path.size() - 1);
        }
    }

    public static interface Callback {
        public void callback(List<String> var1, DataSchema var2);
    }

    public static enum Order {
        PRE_ORDER,
        POST_ORDER;

    }
}

