/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.it;

import com.linkedin.data.element.DataElement;
import com.linkedin.data.element.SimpleDataElement;
import com.linkedin.data.it.AndPredicate;
import com.linkedin.data.it.Counter;
import com.linkedin.data.it.DataIterator;
import com.linkedin.data.it.FilterIterator;
import com.linkedin.data.it.IterationOrder;
import com.linkedin.data.it.ObjectIterator;
import com.linkedin.data.it.Predicate;
import com.linkedin.data.it.Remover;
import com.linkedin.data.it.Transformer;
import com.linkedin.data.it.ValueAccumulator;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.transforms.Transform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Builder {
    private List<Predicate> _predicates = new ArrayList<Predicate>();
    private DataElement _element;
    private IterationOrder _order;

    private static Builder create(Object object, DataSchema schema) {
        return Builder.create(object, schema, IterationOrder.PRE_ORDER);
    }

    public static Builder create(Object object, DataSchema schema, IterationOrder order) {
        return new Builder(new SimpleDataElement(object, schema), order);
    }

    private static Builder create(DataElement element) {
        return Builder.create(element, IterationOrder.PRE_ORDER);
    }

    public static Builder create(DataElement element, IterationOrder order) {
        return new Builder(element, order);
    }

    private static Builder create(DataTemplate<? extends Object> template) {
        return Builder.create(template.data(), template.schema(), IterationOrder.PRE_ORDER);
    }

    public static Builder create(DataTemplate<? extends Object> template, IterationOrder order) {
        return Builder.create(template.data(), template.schema(), order);
    }

    protected Builder(DataElement element, IterationOrder order) {
        this._element = element;
        this._order = order;
    }

    public Builder filterBy(Predicate predicate) {
        this._predicates.add(predicate);
        return this;
    }

    public Collection<Object> accumulateValues(Collection<Object> accumulator) {
        return ValueAccumulator.accumulateValues(this.dataIterator(), accumulator);
    }

    public Collection<Object> accumulateValues() {
        return ValueAccumulator.accumulateValues(this.dataIterator());
    }

    public int count() {
        return Counter.count(this.dataIterator());
    }

    public Object remove() {
        return Remover.remove(this._element.getValue(), this.dataIterator());
    }

    public Object transform(Transform<Object, Object> transform) {
        return Transformer.transform(this._element.getValue(), this.dataIterator(), transform);
    }

    public Object replace(Object value) {
        return Transformer.replace(this._element.getValue(), this.dataIterator(), value);
    }

    public DataIterator dataIterator() {
        ObjectIterator it = new ObjectIterator(this._element, this._order);
        return this._predicates.isEmpty() ? it : new FilterIterator(it, new AndPredicate(this._predicates));
    }

    public void iterate(Callback callback) {
        DataElement element;
        DataIterator it = this.dataIterator();
        while ((element = it.next()) != null) {
            callback.callback(element);
        }
    }

    public static interface Callback {
        public void callback(DataElement var1);
    }
}

