/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common.urn;

import com.linkedin.common.urn.TupleKey;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DirectCoercer;
import com.linkedin.data.template.TemplateOutputCastException;
import java.net.URISyntaxException;

public final class MLFeatureUrn
extends Urn {
    public static final String ENTITY_TYPE = "mlFeature";
    private final String _mlFeatureNamespace;
    private final String _mlFeatureName;

    public MLFeatureUrn(String mlFeatureNamespace, String mlFeatureName) {
        super(ENTITY_TYPE, TupleKey.create(mlFeatureNamespace, mlFeatureName));
        this._mlFeatureNamespace = mlFeatureNamespace;
        this._mlFeatureName = mlFeatureName;
    }

    public String getMlFeatureNameEntity() {
        return this._mlFeatureName;
    }

    public String getMlFeatureNamespaceEntity() {
        return this._mlFeatureNamespace;
    }

    public static MLFeatureUrn createFromString(String rawUrn) throws URISyntaxException {
        return MLFeatureUrn.createFromUrn(Urn.createFromString(rawUrn));
    }

    public static MLFeatureUrn createFromUrn(Urn urn) throws URISyntaxException {
        if (!"li".equals(urn.getNamespace())) {
            throw new URISyntaxException(urn.toString(), "Urn namespace type should be 'li'.");
        }
        if (!ENTITY_TYPE.equals(urn.getEntityType())) {
            throw new URISyntaxException(urn.toString(), "Urn entity type should be 'mlFeature'.");
        }
        TupleKey key = urn.getEntityKey();
        if (key.size() != 2) {
            throw new URISyntaxException(urn.toString(), "Invalid number of keys.");
        }
        try {
            return new MLFeatureUrn(key.getAs(0, String.class), key.getAs(1, String.class));
        }
        catch (Exception e) {
            throw new URISyntaxException(urn.toString(), "Invalid URN Parameter: '" + e.getMessage());
        }
    }

    static {
        Custom.registerCoercer(new DirectCoercer<MLFeatureUrn>(){

            @Override
            public Object coerceInput(MLFeatureUrn object) throws ClassCastException {
                return object.toString();
            }

            @Override
            public MLFeatureUrn coerceOutput(Object object) throws TemplateOutputCastException {
                try {
                    return MLFeatureUrn.createFromString((String)object);
                }
                catch (URISyntaxException e) {
                    throw new TemplateOutputCastException("Invalid URN syntax: " + e.getMessage(), e);
                }
            }
        }, MLFeatureUrn.class);
    }
}

