/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common.urn;

import com.linkedin.common.urn.AzkabanFlowUrn;
import com.linkedin.common.urn.TupleKey;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DirectCoercer;
import com.linkedin.data.template.TemplateOutputCastException;
import java.net.URISyntaxException;

public final class AzkabanJobUrn
extends Urn {
    public static final String ENTITY_TYPE = "azkabanJob";
    private final AzkabanFlowUrn _flow;
    private final String _jobId;

    public AzkabanJobUrn(AzkabanFlowUrn flow, String jobId) {
        super(ENTITY_TYPE, TupleKey.create(flow, jobId));
        this._flow = flow;
        this._jobId = jobId;
    }

    public AzkabanFlowUrn getFlowEntity() {
        return this._flow;
    }

    public String getJobIdEntity() {
        return this._jobId;
    }

    public static AzkabanJobUrn createFromString(String rawUrn) throws URISyntaxException {
        return AzkabanJobUrn.createFromUrn(Urn.createFromString(rawUrn));
    }

    public static AzkabanJobUrn createFromUrn(Urn urn) throws URISyntaxException {
        if (!"li".equals(urn.getNamespace())) {
            throw new URISyntaxException(urn.toString(), "Urn namespace type should be 'li'.");
        }
        if (!ENTITY_TYPE.equals(urn.getEntityType())) {
            throw new URISyntaxException(urn.toString(), "Urn entity type should be 'azkabanJob'.");
        }
        TupleKey key = urn.getEntityKey();
        if (key.size() != 2) {
            throw new URISyntaxException(urn.toString(), "Invalid number of keys.");
        }
        try {
            return new AzkabanJobUrn(key.getAs(0, AzkabanFlowUrn.class), key.getAs(1, String.class));
        }
        catch (Exception e) {
            throw new URISyntaxException(urn.toString(), "Invalid URN Parameter: '" + e.getMessage());
        }
    }

    public static AzkabanJobUrn deserialize(String rawUrn) throws URISyntaxException {
        return AzkabanJobUrn.createFromString(rawUrn);
    }

    static {
        Custom.initializeCustomClass(AzkabanFlowUrn.class);
        Custom.registerCoercer(new DirectCoercer<AzkabanJobUrn>(){

            @Override
            public Object coerceInput(AzkabanJobUrn object) throws ClassCastException {
                return object.toString();
            }

            @Override
            public AzkabanJobUrn coerceOutput(Object object) throws TemplateOutputCastException {
                try {
                    return AzkabanJobUrn.createFromString((String)object);
                }
                catch (URISyntaxException e) {
                    throw new TemplateOutputCastException("Invalid URN syntax: " + e.getMessage(), e);
                }
            }
        }, AzkabanJobUrn.class);
    }
}

