/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common.stats;

import com.linkedin.common.stats.LongStats;
import com.linkedin.common.stats.LongTracker;

public class SimpleLongTracking
implements LongTracker {
    private int _count;
    private long _min;
    private long _max;
    private long _sum;
    private long _sumOfSquares;

    @Override
    public void addValue(long value) {
        if (this._count == 0) {
            this._min = this._max = value;
        } else if (value < this._min) {
            this._min = value;
        } else if (value > this._max) {
            this._max = value;
        }
        this._sum += value;
        this._sumOfSquares += value * value;
        ++this._count;
    }

    @Override
    public LongStats getStats() {
        return new LongStats(this.getCount(), this.getAverage(), this.getStandardDeviation(), this.getMinimum(), this.getMaximum(), -1L, -1L, -1L, -1L);
    }

    @Override
    public void reset() {
        this._count = 0;
        this._min = 0L;
        this._max = 0L;
        this._sum = 0L;
        this._sumOfSquares = 0L;
    }

    protected int getCount() {
        return this._count;
    }

    protected double getAverage() {
        return SimpleLongTracking.safeDivide(this._sum, this._count);
    }

    protected double getStandardDeviation() {
        double variation = SimpleLongTracking.safeDivide((double)this._sumOfSquares - (double)this._sum * this.getAverage(), this.getCount());
        return Math.sqrt(variation);
    }

    protected long getMinimum() {
        return this._min;
    }

    protected long getMaximum() {
        return this._max;
    }

    private static double safeDivide(double numerator, double denominator) {
        return denominator != 0.0 ? numerator / denominator : 0.0;
    }
}

