/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common.fieldtransformer;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UDFTransformer
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common.fieldtransformer/**Field transformation expressed in UDF*/record UDFTransformer{/**A UDF mentioning how the source fields got transformed to destination field. This is the FQCN(Fully Qualified Class Name) of the udf.*/udf:string}", SchemaFormatType.PDL);
    private String _udfField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Udf = SCHEMA.getField("udf");

    public UDFTransformer() {
        super(new DataMap(2, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public UDFTransformer(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasUdf() {
        if (this._udfField != null) {
            return true;
        }
        return this._map.containsKey("udf");
    }

    public void removeUdf() {
        this._map.remove("udf");
    }

    @Nullable
    public String getUdf(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getUdf();
            }
            case DEFAULT: 
            case NULL: {
                if (this._udfField != null) {
                    return this._udfField;
                }
                Object __rawValue = this._map.get("udf");
                this._udfField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._udfField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getUdf() {
        if (this._udfField != null) {
            return this._udfField;
        }
        Object __rawValue = this._map.get("udf");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("udf");
        }
        this._udfField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._udfField;
    }

    public UDFTransformer setUdf(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUdf(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field udf of com.linkedin.common.fieldtransformer.UDFTransformer");
                }
                CheckedUtil.putWithoutChecking(this._map, "udf", value);
                this._udfField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUdf();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "udf", value);
                this._udfField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "udf", value);
                this._udfField = value;
            }
        }
        return this;
    }

    public UDFTransformer setUdf(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field udf of com.linkedin.common.fieldtransformer.UDFTransformer to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "udf", value);
        this._udfField = value;
        return this;
    }

    @Override
    public UDFTransformer clone() throws CloneNotSupportedException {
        UDFTransformer __clone = (UDFTransformer)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public UDFTransformer copy() throws CloneNotSupportedException {
        UDFTransformer __copy = (UDFTransformer)super.copy();
        __copy._udfField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final UDFTransformer __objectRef;

        private ChangeListener(UDFTransformer reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "udf": {
                    this.__objectRef._udfField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec udf() {
            return new PathSpec(this.getPathComponents(), "udf");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withUdf() {
            this.getDataMap().put("udf", 1);
            return this;
        }
    }
}

