/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Deprecation
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**Deprecation status of an entity*/@Aspect.name=\"deprecation\"record Deprecation{/**Whether the entity is deprecated.*/@Searchable={\"addToFilters\":true,\"fieldType\":\"BOOLEAN\",\"filterNameOverride\":\"Deprecated\",\"weightsPerFieldValue\":{\"true\":0.5}}deprecated:boolean/**The time user plan to decommission this entity.*/decommissionTime:optional/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**Additional information about the entity deprecation plan, such as the wiki, doc, RB.*/note:string/**The user URN which will be credited for modifying this deprecation content.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string,replacement:optional Urn}", SchemaFormatType.PDL);
    private Boolean _deprecatedField = null;
    private Long _decommissionTimeField = null;
    private String _noteField = null;
    private Urn _actorField = null;
    private Urn _replacementField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Deprecated = SCHEMA.getField("deprecated");
    private static final RecordDataSchema.Field FIELD_DecommissionTime = SCHEMA.getField("decommissionTime");
    private static final RecordDataSchema.Field FIELD_Note = SCHEMA.getField("note");
    private static final RecordDataSchema.Field FIELD_Actor = SCHEMA.getField("actor");
    private static final RecordDataSchema.Field FIELD_Replacement = SCHEMA.getField("replacement");

    public Deprecation() {
        super(new DataMap(7, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public Deprecation(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasDeprecated() {
        if (this._deprecatedField != null) {
            return true;
        }
        return this._map.containsKey("deprecated");
    }

    public void removeDeprecated() {
        this._map.remove("deprecated");
    }

    @Nullable
    public Boolean isDeprecated(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.isDeprecated();
            }
            case DEFAULT: 
            case NULL: {
                if (this._deprecatedField != null) {
                    return this._deprecatedField;
                }
                Object __rawValue = this._map.get("deprecated");
                this._deprecatedField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._deprecatedField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isDeprecated() {
        if (this._deprecatedField != null) {
            return this._deprecatedField;
        }
        Object __rawValue = this._map.get("deprecated");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("deprecated");
        }
        this._deprecatedField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._deprecatedField;
    }

    public Deprecation setDeprecated(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDeprecated(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field deprecated of com.linkedin.common.Deprecation");
                }
                CheckedUtil.putWithoutChecking(this._map, "deprecated", value);
                this._deprecatedField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDeprecated();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "deprecated", value);
                this._deprecatedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "deprecated", value);
                this._deprecatedField = value;
            }
        }
        return this;
    }

    public Deprecation setDeprecated(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field deprecated of com.linkedin.common.Deprecation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "deprecated", value);
        this._deprecatedField = value;
        return this;
    }

    public Deprecation setDeprecated(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "deprecated", value);
        this._deprecatedField = value;
        return this;
    }

    public boolean hasDecommissionTime() {
        if (this._decommissionTimeField != null) {
            return true;
        }
        return this._map.containsKey("decommissionTime");
    }

    public void removeDecommissionTime() {
        this._map.remove("decommissionTime");
    }

    @Nullable
    public Long getDecommissionTime(GetMode mode) {
        return this.getDecommissionTime();
    }

    @Nullable
    public Long getDecommissionTime() {
        if (this._decommissionTimeField != null) {
            return this._decommissionTimeField;
        }
        Object __rawValue = this._map.get("decommissionTime");
        this._decommissionTimeField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._decommissionTimeField;
    }

    public Deprecation setDecommissionTime(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDecommissionTime(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDecommissionTime();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "decommissionTime", DataTemplateUtil.coerceLongInput(value));
                this._decommissionTimeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "decommissionTime", DataTemplateUtil.coerceLongInput(value));
                this._decommissionTimeField = value;
            }
        }
        return this;
    }

    public Deprecation setDecommissionTime(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field decommissionTime of com.linkedin.common.Deprecation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "decommissionTime", DataTemplateUtil.coerceLongInput(value));
        this._decommissionTimeField = value;
        return this;
    }

    public Deprecation setDecommissionTime(long value) {
        CheckedUtil.putWithoutChecking(this._map, "decommissionTime", DataTemplateUtil.coerceLongInput(value));
        this._decommissionTimeField = value;
        return this;
    }

    public boolean hasNote() {
        if (this._noteField != null) {
            return true;
        }
        return this._map.containsKey("note");
    }

    public void removeNote() {
        this._map.remove("note");
    }

    @Nullable
    public String getNote(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getNote();
            }
            case DEFAULT: 
            case NULL: {
                if (this._noteField != null) {
                    return this._noteField;
                }
                Object __rawValue = this._map.get("note");
                this._noteField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._noteField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getNote() {
        if (this._noteField != null) {
            return this._noteField;
        }
        Object __rawValue = this._map.get("note");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("note");
        }
        this._noteField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._noteField;
    }

    public Deprecation setNote(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNote(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field note of com.linkedin.common.Deprecation");
                }
                CheckedUtil.putWithoutChecking(this._map, "note", value);
                this._noteField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNote();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "note", value);
                this._noteField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "note", value);
                this._noteField = value;
            }
        }
        return this;
    }

    public Deprecation setNote(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field note of com.linkedin.common.Deprecation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "note", value);
        this._noteField = value;
        return this;
    }

    public boolean hasActor() {
        if (this._actorField != null) {
            return true;
        }
        return this._map.containsKey("actor");
    }

    public void removeActor() {
        this._map.remove("actor");
    }

    @Nullable
    public Urn getActor(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getActor();
            }
            case DEFAULT: 
            case NULL: {
                if (this._actorField != null) {
                    return this._actorField;
                }
                Object __rawValue = this._map.get("actor");
                this._actorField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._actorField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getActor() {
        if (this._actorField != null) {
            return this._actorField;
        }
        Object __rawValue = this._map.get("actor");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("actor");
        }
        this._actorField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._actorField;
    }

    public Deprecation setActor(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setActor(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field actor of com.linkedin.common.Deprecation");
                }
                CheckedUtil.putWithoutChecking(this._map, "actor", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._actorField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeActor();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "actor", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._actorField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "actor", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._actorField = value;
            }
        }
        return this;
    }

    public Deprecation setActor(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field actor of com.linkedin.common.Deprecation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "actor", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._actorField = value;
        return this;
    }

    public boolean hasReplacement() {
        if (this._replacementField != null) {
            return true;
        }
        return this._map.containsKey("replacement");
    }

    public void removeReplacement() {
        this._map.remove("replacement");
    }

    @Nullable
    public Urn getReplacement(GetMode mode) {
        return this.getReplacement();
    }

    @Nullable
    public Urn getReplacement() {
        if (this._replacementField != null) {
            return this._replacementField;
        }
        Object __rawValue = this._map.get("replacement");
        this._replacementField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._replacementField;
    }

    public Deprecation setReplacement(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setReplacement(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeReplacement();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "replacement", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._replacementField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "replacement", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._replacementField = value;
            }
        }
        return this;
    }

    public Deprecation setReplacement(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field replacement of com.linkedin.common.Deprecation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "replacement", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._replacementField = value;
        return this;
    }

    @Override
    public Deprecation clone() throws CloneNotSupportedException {
        Deprecation __clone = (Deprecation)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public Deprecation copy() throws CloneNotSupportedException {
        Deprecation __copy = (Deprecation)super.copy();
        __copy._actorField = null;
        __copy._noteField = null;
        __copy._deprecatedField = null;
        __copy._replacementField = null;
        __copy._decommissionTimeField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final Deprecation __objectRef;

        private ChangeListener(Deprecation reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "actor": {
                    this.__objectRef._actorField = null;
                    break;
                }
                case "note": {
                    this.__objectRef._noteField = null;
                    break;
                }
                case "deprecated": {
                    this.__objectRef._deprecatedField = null;
                    break;
                }
                case "replacement": {
                    this.__objectRef._replacementField = null;
                    break;
                }
                case "decommissionTime": {
                    this.__objectRef._decommissionTimeField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec deprecated() {
            return new PathSpec(this.getPathComponents(), "deprecated");
        }

        public PathSpec decommissionTime() {
            return new PathSpec(this.getPathComponents(), "decommissionTime");
        }

        public PathSpec note() {
            return new PathSpec(this.getPathComponents(), "note");
        }

        public PathSpec actor() {
            return new PathSpec(this.getPathComponents(), "actor");
        }

        public PathSpec replacement() {
            return new PathSpec(this.getPathComponents(), "replacement");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(7);
        }

        public ProjectionMask withDeprecated() {
            this.getDataMap().put("deprecated", 1);
            return this;
        }

        public ProjectionMask withDecommissionTime() {
            this.getDataMap().put("decommissionTime", 1);
            return this;
        }

        public ProjectionMask withNote() {
            this.getDataMap().put("note", 1);
            return this;
        }

        public ProjectionMask withActor() {
            this.getDataMap().put("actor", 1);
            return this;
        }

        public ProjectionMask withReplacement() {
            this.getDataMap().put("replacement", 1);
            return this;
        }
    }
}

