/*
 * Decompiled with CFR 0.152.
 */
package com.datahub.util.validator;

import com.datahub.util.validator.ValidationUtils;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.template.UnionTemplate;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

public final class AspectValidator {
    private static final Set<Class<? extends UnionTemplate>> VALIDATED = ConcurrentHashMap.newKeySet();

    private AspectValidator() {
    }

    public static void validateAspectUnionSchema(@Nonnull UnionDataSchema schema, @Nonnull String aspectClassName) {
        if (!ValidationUtils.isUnionWithOnlyComplexMembers(schema)) {
            ValidationUtils.invalidSchema("Aspect '%s' must be a union containing only record type members", aspectClassName);
        }
    }

    public static void validateAspectUnionSchema(@Nonnull Class<? extends UnionTemplate> clazz) {
        if (VALIDATED.contains(clazz)) {
            return;
        }
        AspectValidator.validateAspectUnionSchema(ValidationUtils.getUnionSchema(clazz), clazz.getCanonicalName());
        VALIDATED.add(clazz);
    }

    private static boolean isValidMetadataField(RecordDataSchema.Field field) {
        return field.getName().equals("metadata") && !field.getOptional() && field.getType().getType() == DataSchema.Type.UNION && ValidationUtils.isUnionWithOnlyComplexMembers((UnionDataSchema)field.getType());
    }
}

