/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.policy;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import com.linkedin.policy.DataHubActorFilter;
import com.linkedin.policy.DataHubResourceFilter;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataHubPolicyInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.policy/**Information about a DataHub (UI) access policy.*/@Aspect.name=\"dataHubPolicyInfo\"record DataHubPolicyInfo{/**Display name of the Policy*/@Searchable.fieldType=\"TEXT_PARTIAL\"displayName:string/**Description of the Policy*/@Searchable.fieldType=\"TEXT\"description:string/**The type of policy*/@Searchable.fieldType=\"KEYWORD\"type:string/**The state of policy, ACTIVE or INACTIVE*/@Searchable.fieldType=\"KEYWORD\"state:string/**The resource that the policy applies to. Not required for some 'Platform' privileges.*/resources:optional/**Information used to filter DataHub resource.*/record DataHubResourceFilter{/**The type of resource that the policy applies to. This will most often be a data asset entity name, for\nexample 'dataset'. It is not strictly required because in the future we will want to support filtering a resource\nby domain, as well.*/@deprecated,type:optional string/**A specific set of resources to apply the policy to, e.g. asset urns*/@deprecated,resources:optional array[string]/**Whether the policy should be applied to all assets matching the filter.*/@deprecated,allResources:boolean=false/**Filter to apply privileges to*/filter:optional/**The filter for specifying the resource or actor to apply privileges to*/record PolicyMatchFilter{/**A list of criteria to apply conjunctively (so all criteria must pass)*/criteria:array[/**A criterion for matching a field with given value*/record PolicyMatchCriterion{/**The name of the field that the criterion refers to*/field:string/**Values. Matches criterion if any one of the values matches condition (OR-relationship)*/values:array[string]/**The condition for the criterion*/condition:/**The matching condition in a filter criterion*/enum PolicyMatchCondition{/**Whether the field matches the value*/EQUALS/**Whether the field value starts with the value*/STARTS_WITH/**Whether the field does not match the value*/NOT_EQUALS}=\"EQUALS\"}]}/**Constraints around what sub-resources operations are allowed to modify, i.e. NOT_EQUALS - cannot modify a particular defined tag, EQUALS - can only modify a particular defined tag, STARTS_WITH - can only modify a tag starting with xyz*/privilegeConstraints:optional PolicyMatchFilter}/**The privileges that the policy grants.*/@Searchable.`/*`={\"addToFilters\":true,\"fieldType\":\"KEYWORD\"}privileges:array[string]/**The actors that the policy applies to.*/actors:/**Information used to filter DataHub actors.*/record DataHubActorFilter{/**A specific set of users to apply the policy to (disjunctive)*/@Searchable.`/*`.fieldType=\"URN\"users:optional array[{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}]/**A specific set of groups to apply the policy to (disjunctive)*/@Searchable.`/*`.fieldType=\"URN\"groups:optional array[com.linkedin.common.Urn]/**Whether the filter should return true for owners of a particular resource.\nOnly applies to policies of type 'Metadata', which have a resource associated with them.*/resourceOwners:boolean=false/**Define type of ownership for the policy*/resourceOwnersTypes:optional array[com.linkedin.common.Urn]/**Whether the filter should apply to all users.*/@Searchable.fieldType=\"BOOLEAN\"allUsers:boolean=false/**Whether the filter should apply to all groups.*/@Searchable.fieldType=\"BOOLEAN\"allGroups:boolean=false/**A specific set of roles to apply the policy to (disjunctive).*/@Relationship.`/*`={\"entityTypes\":[\"dataHubRole\"],\"name\":\"IsAssociatedWithRole\"}@Searchable.`/*`.fieldType=\"URN\"roles:optional array[com.linkedin.common.Urn]}/**Whether the policy should be editable via the UI*/@Searchable.fieldType=\"BOOLEAN\"editable:boolean=true/**Timestamp when the policy was last updated*/@Searchable.fieldType=\"DATETIME\"lastUpdatedTimestamp:optional long}", SchemaFormatType.PDL);
    private String _displayNameField = null;
    private String _descriptionField = null;
    private String _typeField = null;
    private String _stateField = null;
    private DataHubResourceFilter _resourcesField = null;
    private StringArray _privilegesField = null;
    private DataHubActorFilter _actorsField = null;
    private Boolean _editableField = null;
    private Long _lastUpdatedTimestampField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_DisplayName = SCHEMA.getField("displayName");
    private static final RecordDataSchema.Field FIELD_Description = SCHEMA.getField("description");
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");
    private static final RecordDataSchema.Field FIELD_State = SCHEMA.getField("state");
    private static final RecordDataSchema.Field FIELD_Resources = SCHEMA.getField("resources");
    private static final RecordDataSchema.Field FIELD_Privileges = SCHEMA.getField("privileges");
    private static final RecordDataSchema.Field FIELD_Actors = SCHEMA.getField("actors");
    private static final RecordDataSchema.Field FIELD_Editable = SCHEMA.getField("editable");
    private static final Boolean DEFAULT_Editable;
    private static final RecordDataSchema.Field FIELD_LastUpdatedTimestamp;

    public DataHubPolicyInfo() {
        super(new DataMap(12, 0.75f), SCHEMA, 4);
        this.addChangeListener(this.__changeListener);
    }

    public DataHubPolicyInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasDisplayName() {
        if (this._displayNameField != null) {
            return true;
        }
        return this._map.containsKey("displayName");
    }

    public void removeDisplayName() {
        this._map.remove("displayName");
    }

    @Nullable
    public String getDisplayName(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getDisplayName();
            }
            case DEFAULT: 
            case NULL: {
                if (this._displayNameField != null) {
                    return this._displayNameField;
                }
                Object __rawValue = this._map.get("displayName");
                this._displayNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._displayNameField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getDisplayName() {
        if (this._displayNameField != null) {
            return this._displayNameField;
        }
        Object __rawValue = this._map.get("displayName");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("displayName");
        }
        this._displayNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._displayNameField;
    }

    public DataHubPolicyInfo setDisplayName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDisplayName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field displayName of com.linkedin.policy.DataHubPolicyInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "displayName", value);
                this._displayNameField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDisplayName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "displayName", value);
                this._displayNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "displayName", value);
                this._displayNameField = value;
            }
        }
        return this;
    }

    public DataHubPolicyInfo setDisplayName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field displayName of com.linkedin.policy.DataHubPolicyInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "displayName", value);
        this._displayNameField = value;
        return this;
    }

    public boolean hasDescription() {
        if (this._descriptionField != null) {
            return true;
        }
        return this._map.containsKey("description");
    }

    public void removeDescription() {
        this._map.remove("description");
    }

    @Nullable
    public String getDescription(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getDescription();
            }
            case DEFAULT: 
            case NULL: {
                if (this._descriptionField != null) {
                    return this._descriptionField;
                }
                Object __rawValue = this._map.get("description");
                this._descriptionField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._descriptionField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getDescription() {
        if (this._descriptionField != null) {
            return this._descriptionField;
        }
        Object __rawValue = this._map.get("description");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("description");
        }
        this._descriptionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._descriptionField;
    }

    public DataHubPolicyInfo setDescription(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDescription(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field description of com.linkedin.policy.DataHubPolicyInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDescription();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
            }
        }
        return this;
    }

    public DataHubPolicyInfo setDescription(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field description of com.linkedin.policy.DataHubPolicyInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "description", value);
        this._descriptionField = value;
        return this;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public String getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._typeField;
    }

    public DataHubPolicyInfo setType(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.policy.DataHubPolicyInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value);
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value);
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value);
                this._typeField = value;
            }
        }
        return this;
    }

    public DataHubPolicyInfo setType(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.policy.DataHubPolicyInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value);
        this._typeField = value;
        return this;
    }

    public boolean hasState() {
        if (this._stateField != null) {
            return true;
        }
        return this._map.containsKey("state");
    }

    public void removeState() {
        this._map.remove("state");
    }

    @Nullable
    public String getState(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getState();
            }
            case DEFAULT: 
            case NULL: {
                if (this._stateField != null) {
                    return this._stateField;
                }
                Object __rawValue = this._map.get("state");
                this._stateField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._stateField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getState() {
        if (this._stateField != null) {
            return this._stateField;
        }
        Object __rawValue = this._map.get("state");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("state");
        }
        this._stateField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._stateField;
    }

    public DataHubPolicyInfo setState(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setState(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field state of com.linkedin.policy.DataHubPolicyInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "state", value);
                this._stateField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeState();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "state", value);
                this._stateField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "state", value);
                this._stateField = value;
            }
        }
        return this;
    }

    public DataHubPolicyInfo setState(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field state of com.linkedin.policy.DataHubPolicyInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "state", value);
        this._stateField = value;
        return this;
    }

    public boolean hasResources() {
        if (this._resourcesField != null) {
            return true;
        }
        return this._map.containsKey("resources");
    }

    public void removeResources() {
        this._map.remove("resources");
    }

    @Nullable
    public DataHubResourceFilter getResources(GetMode mode) {
        return this.getResources();
    }

    @Nullable
    public DataHubResourceFilter getResources() {
        if (this._resourcesField != null) {
            return this._resourcesField;
        }
        Object __rawValue = this._map.get("resources");
        this._resourcesField = __rawValue == null ? null : new DataHubResourceFilter(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._resourcesField;
    }

    public DataHubPolicyInfo setResources(@Nullable DataHubResourceFilter value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setResources(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeResources();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "resources", value.data());
                this._resourcesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "resources", value.data());
                this._resourcesField = value;
            }
        }
        return this;
    }

    public DataHubPolicyInfo setResources(@Nonnull DataHubResourceFilter value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field resources of com.linkedin.policy.DataHubPolicyInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "resources", value.data());
        this._resourcesField = value;
        return this;
    }

    public boolean hasPrivileges() {
        if (this._privilegesField != null) {
            return true;
        }
        return this._map.containsKey("privileges");
    }

    public void removePrivileges() {
        this._map.remove("privileges");
    }

    @Nullable
    public StringArray getPrivileges(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getPrivileges();
            }
            case DEFAULT: 
            case NULL: {
                if (this._privilegesField != null) {
                    return this._privilegesField;
                }
                Object __rawValue = this._map.get("privileges");
                this._privilegesField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._privilegesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringArray getPrivileges() {
        if (this._privilegesField != null) {
            return this._privilegesField;
        }
        Object __rawValue = this._map.get("privileges");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("privileges");
        }
        this._privilegesField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._privilegesField;
    }

    public DataHubPolicyInfo setPrivileges(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPrivileges(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field privileges of com.linkedin.policy.DataHubPolicyInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "privileges", value.data());
                this._privilegesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePrivileges();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "privileges", value.data());
                this._privilegesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "privileges", value.data());
                this._privilegesField = value;
            }
        }
        return this;
    }

    public DataHubPolicyInfo setPrivileges(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field privileges of com.linkedin.policy.DataHubPolicyInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "privileges", value.data());
        this._privilegesField = value;
        return this;
    }

    public boolean hasActors() {
        if (this._actorsField != null) {
            return true;
        }
        return this._map.containsKey("actors");
    }

    public void removeActors() {
        this._map.remove("actors");
    }

    @Nullable
    public DataHubActorFilter getActors(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getActors();
            }
            case DEFAULT: 
            case NULL: {
                if (this._actorsField != null) {
                    return this._actorsField;
                }
                Object __rawValue = this._map.get("actors");
                this._actorsField = __rawValue == null ? null : new DataHubActorFilter(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._actorsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public DataHubActorFilter getActors() {
        if (this._actorsField != null) {
            return this._actorsField;
        }
        Object __rawValue = this._map.get("actors");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("actors");
        }
        this._actorsField = __rawValue == null ? null : new DataHubActorFilter(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._actorsField;
    }

    public DataHubPolicyInfo setActors(@Nullable DataHubActorFilter value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setActors(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field actors of com.linkedin.policy.DataHubPolicyInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "actors", value.data());
                this._actorsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeActors();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "actors", value.data());
                this._actorsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "actors", value.data());
                this._actorsField = value;
            }
        }
        return this;
    }

    public DataHubPolicyInfo setActors(@Nonnull DataHubActorFilter value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field actors of com.linkedin.policy.DataHubPolicyInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "actors", value.data());
        this._actorsField = value;
        return this;
    }

    public boolean hasEditable() {
        if (this._editableField != null) {
            return true;
        }
        return this._map.containsKey("editable");
    }

    public void removeEditable() {
        this._map.remove("editable");
    }

    @Nullable
    public Boolean isEditable(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isEditable();
            }
            case NULL: {
                if (this._editableField != null) {
                    return this._editableField;
                }
                Object __rawValue = this._map.get("editable");
                this._editableField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._editableField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isEditable() {
        if (this._editableField != null) {
            return this._editableField;
        }
        Object __rawValue = this._map.get("editable");
        if (__rawValue == null) {
            return DEFAULT_Editable;
        }
        this._editableField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._editableField;
    }

    public DataHubPolicyInfo setEditable(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEditable(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field editable of com.linkedin.policy.DataHubPolicyInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "editable", value);
                this._editableField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEditable();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "editable", value);
                this._editableField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "editable", value);
                this._editableField = value;
            }
        }
        return this;
    }

    public DataHubPolicyInfo setEditable(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field editable of com.linkedin.policy.DataHubPolicyInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "editable", value);
        this._editableField = value;
        return this;
    }

    public DataHubPolicyInfo setEditable(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "editable", value);
        this._editableField = value;
        return this;
    }

    public boolean hasLastUpdatedTimestamp() {
        if (this._lastUpdatedTimestampField != null) {
            return true;
        }
        return this._map.containsKey("lastUpdatedTimestamp");
    }

    public void removeLastUpdatedTimestamp() {
        this._map.remove("lastUpdatedTimestamp");
    }

    @Nullable
    public Long getLastUpdatedTimestamp(GetMode mode) {
        return this.getLastUpdatedTimestamp();
    }

    @Nullable
    public Long getLastUpdatedTimestamp() {
        if (this._lastUpdatedTimestampField != null) {
            return this._lastUpdatedTimestampField;
        }
        Object __rawValue = this._map.get("lastUpdatedTimestamp");
        this._lastUpdatedTimestampField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._lastUpdatedTimestampField;
    }

    public DataHubPolicyInfo setLastUpdatedTimestamp(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastUpdatedTimestamp(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastUpdatedTimestamp();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastUpdatedTimestamp", DataTemplateUtil.coerceLongInput(value));
                this._lastUpdatedTimestampField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastUpdatedTimestamp", DataTemplateUtil.coerceLongInput(value));
                this._lastUpdatedTimestampField = value;
            }
        }
        return this;
    }

    public DataHubPolicyInfo setLastUpdatedTimestamp(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastUpdatedTimestamp of com.linkedin.policy.DataHubPolicyInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastUpdatedTimestamp", DataTemplateUtil.coerceLongInput(value));
        this._lastUpdatedTimestampField = value;
        return this;
    }

    public DataHubPolicyInfo setLastUpdatedTimestamp(long value) {
        CheckedUtil.putWithoutChecking(this._map, "lastUpdatedTimestamp", DataTemplateUtil.coerceLongInput(value));
        this._lastUpdatedTimestampField = value;
        return this;
    }

    @Override
    public DataHubPolicyInfo clone() throws CloneNotSupportedException {
        DataHubPolicyInfo __clone = (DataHubPolicyInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataHubPolicyInfo copy() throws CloneNotSupportedException {
        DataHubPolicyInfo __copy = (DataHubPolicyInfo)super.copy();
        __copy._privilegesField = null;
        __copy._actorsField = null;
        __copy._lastUpdatedTimestampField = null;
        __copy._displayNameField = null;
        __copy._editableField = null;
        __copy._descriptionField = null;
        __copy._resourcesField = null;
        __copy._stateField = null;
        __copy._typeField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_LastUpdatedTimestamp = SCHEMA.getField("lastUpdatedTimestamp");
        DEFAULT_Editable = DataTemplateUtil.coerceBooleanOutput(FIELD_Editable.getDefault());
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataHubPolicyInfo __objectRef;

        private ChangeListener(DataHubPolicyInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "privileges": {
                    this.__objectRef._privilegesField = null;
                    break;
                }
                case "actors": {
                    this.__objectRef._actorsField = null;
                    break;
                }
                case "lastUpdatedTimestamp": {
                    this.__objectRef._lastUpdatedTimestampField = null;
                    break;
                }
                case "displayName": {
                    this.__objectRef._displayNameField = null;
                    break;
                }
                case "editable": {
                    this.__objectRef._editableField = null;
                    break;
                }
                case "description": {
                    this.__objectRef._descriptionField = null;
                    break;
                }
                case "resources": {
                    this.__objectRef._resourcesField = null;
                    break;
                }
                case "state": {
                    this.__objectRef._stateField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec displayName() {
            return new PathSpec(this.getPathComponents(), "displayName");
        }

        public PathSpec description() {
            return new PathSpec(this.getPathComponents(), "description");
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        public PathSpec state() {
            return new PathSpec(this.getPathComponents(), "state");
        }

        public DataHubResourceFilter.Fields resources() {
            return new DataHubResourceFilter.Fields(this.getPathComponents(), "resources");
        }

        public PathSpec privileges() {
            return new PathSpec(this.getPathComponents(), "privileges");
        }

        public PathSpec privileges(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "privileges");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public DataHubActorFilter.Fields actors() {
            return new DataHubActorFilter.Fields(this.getPathComponents(), "actors");
        }

        public PathSpec editable() {
            return new PathSpec(this.getPathComponents(), "editable");
        }

        public PathSpec lastUpdatedTimestamp() {
            return new PathSpec(this.getPathComponents(), "lastUpdatedTimestamp");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private DataHubResourceFilter.ProjectionMask _resourcesMask;
        private DataHubActorFilter.ProjectionMask _actorsMask;

        ProjectionMask() {
            super(12);
        }

        public ProjectionMask withDisplayName() {
            this.getDataMap().put("displayName", 1);
            return this;
        }

        public ProjectionMask withDescription() {
            this.getDataMap().put("description", 1);
            return this;
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withState() {
            this.getDataMap().put("state", 1);
            return this;
        }

        public ProjectionMask withResources(Function<DataHubResourceFilter.ProjectionMask, DataHubResourceFilter.ProjectionMask> nestedMask) {
            this._resourcesMask = nestedMask.apply(this._resourcesMask == null ? DataHubResourceFilter.createMask() : this._resourcesMask);
            this.getDataMap().put("resources", this._resourcesMask.getDataMap());
            return this;
        }

        public ProjectionMask withResources() {
            this._resourcesMask = null;
            this.getDataMap().put("resources", 1);
            return this;
        }

        public ProjectionMask withPrivileges() {
            this.getDataMap().put("privileges", 1);
            return this;
        }

        public ProjectionMask withPrivileges(Integer start, Integer count) {
            this.getDataMap().put("privileges", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("privileges").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("privileges").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withActors(Function<DataHubActorFilter.ProjectionMask, DataHubActorFilter.ProjectionMask> nestedMask) {
            this._actorsMask = nestedMask.apply(this._actorsMask == null ? DataHubActorFilter.createMask() : this._actorsMask);
            this.getDataMap().put("actors", this._actorsMask.getDataMap());
            return this;
        }

        public ProjectionMask withActors() {
            this._actorsMask = null;
            this.getDataMap().put("actors", 1);
            return this;
        }

        public ProjectionMask withEditable() {
            this.getDataMap().put("editable", 1);
            return this;
        }

        public ProjectionMask withLastUpdatedTimestamp() {
            this.getDataMap().put("lastUpdatedTimestamp", 1);
            return this;
        }
    }
}

