/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.operations;

import com.linkedin.common.WindowDuration;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.operations.OperationsAggregationsResult;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OperationsAggregation
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.operations/**Operations data for a given resource, rolled up into a bucket.*/record OperationsAggregation{/** Bucket start time in milliseconds */bucket:long/** Bucket duration */duration:{namespace com.linkedin.common/**Enum to define the length of a bucket when doing aggregations*/enum WindowDuration{YEAR,MONTH,WEEK,DAY,HOUR}}/** Resource associated with these usage stats */resource:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/** Aggregations associated with this bucket */aggregations:/**Aggregation results for operations query*/record OperationsAggregationsResult{/** Total number of operations in the bucket */totalOperations:optional int/** Total number of inserts in the bucket */totalInserts:optional int/** Total number of updates in the bucket */totalUpdates:optional int/** Total number of deletes in the bucket */totalDeletes:optional int/** Total number of creates in the bucket */totalCreates:optional int/** Total number of alters in the bucket */totalAlters:optional int/** Total number of drops in the bucket */totalDrops:optional int/** Total number of custom types in the bucket */totalCustoms:optional int/** A map from each custom operation type to the total count for that type*/customOperationsMap:optional map[string,int]}}", SchemaFormatType.PDL);
    private Long _bucketField = null;
    private WindowDuration _durationField = null;
    private Urn _resourceField = null;
    private OperationsAggregationsResult _aggregationsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Bucket = SCHEMA.getField("bucket");
    private static final RecordDataSchema.Field FIELD_Duration = SCHEMA.getField("duration");
    private static final RecordDataSchema.Field FIELD_Resource = SCHEMA.getField("resource");
    private static final RecordDataSchema.Field FIELD_Aggregations = SCHEMA.getField("aggregations");

    public OperationsAggregation() {
        super(new DataMap(6, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public OperationsAggregation(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasBucket() {
        if (this._bucketField != null) {
            return true;
        }
        return this._map.containsKey("bucket");
    }

    public void removeBucket() {
        this._map.remove("bucket");
    }

    @Nullable
    public Long getBucket(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getBucket();
            }
            case DEFAULT: 
            case NULL: {
                if (this._bucketField != null) {
                    return this._bucketField;
                }
                Object __rawValue = this._map.get("bucket");
                this._bucketField = DataTemplateUtil.coerceLongOutput(__rawValue);
                return this._bucketField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Long getBucket() {
        if (this._bucketField != null) {
            return this._bucketField;
        }
        Object __rawValue = this._map.get("bucket");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("bucket");
        }
        this._bucketField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._bucketField;
    }

    public OperationsAggregation setBucket(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setBucket(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field bucket of com.linkedin.operations.OperationsAggregation");
                }
                CheckedUtil.putWithoutChecking(this._map, "bucket", DataTemplateUtil.coerceLongInput(value));
                this._bucketField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeBucket();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "bucket", DataTemplateUtil.coerceLongInput(value));
                this._bucketField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "bucket", DataTemplateUtil.coerceLongInput(value));
                this._bucketField = value;
            }
        }
        return this;
    }

    public OperationsAggregation setBucket(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field bucket of com.linkedin.operations.OperationsAggregation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "bucket", DataTemplateUtil.coerceLongInput(value));
        this._bucketField = value;
        return this;
    }

    public OperationsAggregation setBucket(long value) {
        CheckedUtil.putWithoutChecking(this._map, "bucket", DataTemplateUtil.coerceLongInput(value));
        this._bucketField = value;
        return this;
    }

    public boolean hasDuration() {
        if (this._durationField != null) {
            return true;
        }
        return this._map.containsKey("duration");
    }

    public void removeDuration() {
        this._map.remove("duration");
    }

    @Nullable
    public WindowDuration getDuration(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getDuration();
            }
            case DEFAULT: 
            case NULL: {
                if (this._durationField != null) {
                    return this._durationField;
                }
                Object __rawValue = this._map.get("duration");
                this._durationField = DataTemplateUtil.coerceEnumOutput(__rawValue, WindowDuration.class, WindowDuration.$UNKNOWN);
                return this._durationField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public WindowDuration getDuration() {
        if (this._durationField != null) {
            return this._durationField;
        }
        Object __rawValue = this._map.get("duration");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("duration");
        }
        this._durationField = DataTemplateUtil.coerceEnumOutput(__rawValue, WindowDuration.class, WindowDuration.$UNKNOWN);
        return this._durationField;
    }

    public OperationsAggregation setDuration(@Nullable WindowDuration value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDuration(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field duration of com.linkedin.operations.OperationsAggregation");
                }
                CheckedUtil.putWithoutChecking(this._map, "duration", value.name());
                this._durationField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDuration();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "duration", value.name());
                this._durationField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "duration", value.name());
                this._durationField = value;
            }
        }
        return this;
    }

    public OperationsAggregation setDuration(@Nonnull WindowDuration value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field duration of com.linkedin.operations.OperationsAggregation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "duration", value.name());
        this._durationField = value;
        return this;
    }

    public boolean hasResource() {
        if (this._resourceField != null) {
            return true;
        }
        return this._map.containsKey("resource");
    }

    public void removeResource() {
        this._map.remove("resource");
    }

    @Nullable
    public Urn getResource(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getResource();
            }
            case DEFAULT: 
            case NULL: {
                if (this._resourceField != null) {
                    return this._resourceField;
                }
                Object __rawValue = this._map.get("resource");
                this._resourceField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._resourceField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getResource() {
        if (this._resourceField != null) {
            return this._resourceField;
        }
        Object __rawValue = this._map.get("resource");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("resource");
        }
        this._resourceField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._resourceField;
    }

    public OperationsAggregation setResource(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setResource(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field resource of com.linkedin.operations.OperationsAggregation");
                }
                CheckedUtil.putWithoutChecking(this._map, "resource", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._resourceField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeResource();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "resource", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._resourceField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "resource", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._resourceField = value;
            }
        }
        return this;
    }

    public OperationsAggregation setResource(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field resource of com.linkedin.operations.OperationsAggregation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "resource", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._resourceField = value;
        return this;
    }

    public boolean hasAggregations() {
        if (this._aggregationsField != null) {
            return true;
        }
        return this._map.containsKey("aggregations");
    }

    public void removeAggregations() {
        this._map.remove("aggregations");
    }

    @Nullable
    public OperationsAggregationsResult getAggregations(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getAggregations();
            }
            case DEFAULT: 
            case NULL: {
                if (this._aggregationsField != null) {
                    return this._aggregationsField;
                }
                Object __rawValue = this._map.get("aggregations");
                this._aggregationsField = __rawValue == null ? null : new OperationsAggregationsResult(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._aggregationsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public OperationsAggregationsResult getAggregations() {
        if (this._aggregationsField != null) {
            return this._aggregationsField;
        }
        Object __rawValue = this._map.get("aggregations");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("aggregations");
        }
        this._aggregationsField = __rawValue == null ? null : new OperationsAggregationsResult(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._aggregationsField;
    }

    public OperationsAggregation setAggregations(@Nullable OperationsAggregationsResult value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAggregations(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field aggregations of com.linkedin.operations.OperationsAggregation");
                }
                CheckedUtil.putWithoutChecking(this._map, "aggregations", value.data());
                this._aggregationsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAggregations();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "aggregations", value.data());
                this._aggregationsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "aggregations", value.data());
                this._aggregationsField = value;
            }
        }
        return this;
    }

    public OperationsAggregation setAggregations(@Nonnull OperationsAggregationsResult value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field aggregations of com.linkedin.operations.OperationsAggregation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "aggregations", value.data());
        this._aggregationsField = value;
        return this;
    }

    @Override
    public OperationsAggregation clone() throws CloneNotSupportedException {
        OperationsAggregation __clone = (OperationsAggregation)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public OperationsAggregation copy() throws CloneNotSupportedException {
        OperationsAggregation __copy = (OperationsAggregation)super.copy();
        __copy._bucketField = null;
        __copy._durationField = null;
        __copy._resourceField = null;
        __copy._aggregationsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final OperationsAggregation __objectRef;

        private ChangeListener(OperationsAggregation reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "bucket": {
                    this.__objectRef._bucketField = null;
                    break;
                }
                case "duration": {
                    this.__objectRef._durationField = null;
                    break;
                }
                case "resource": {
                    this.__objectRef._resourceField = null;
                    break;
                }
                case "aggregations": {
                    this.__objectRef._aggregationsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec bucket() {
            return new PathSpec(this.getPathComponents(), "bucket");
        }

        public PathSpec duration() {
            return new PathSpec(this.getPathComponents(), "duration");
        }

        public PathSpec resource() {
            return new PathSpec(this.getPathComponents(), "resource");
        }

        public OperationsAggregationsResult.Fields aggregations() {
            return new OperationsAggregationsResult.Fields(this.getPathComponents(), "aggregations");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private OperationsAggregationsResult.ProjectionMask _aggregationsMask;

        ProjectionMask() {
            super(6);
        }

        public ProjectionMask withBucket() {
            this.getDataMap().put("bucket", 1);
            return this;
        }

        public ProjectionMask withDuration() {
            this.getDataMap().put("duration", 1);
            return this;
        }

        public ProjectionMask withResource() {
            this.getDataMap().put("resource", 1);
            return this;
        }

        public ProjectionMask withAggregations(Function<OperationsAggregationsResult.ProjectionMask, OperationsAggregationsResult.ProjectionMask> nestedMask) {
            this._aggregationsMask = nestedMask.apply(this._aggregationsMask == null ? OperationsAggregationsResult.createMask() : this._aggregationsMask);
            this.getDataMap().put("aggregations", this._aggregationsMask.getDataMap());
            return this;
        }

        public ProjectionMask withAggregations() {
            this._aggregationsMask = null;
            this.getDataMap().put("aggregations", 1);
            return this;
        }
    }
}

