/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.notebook;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.notebook.ChartCell;
import com.linkedin.notebook.NotebookCellType;
import com.linkedin.notebook.QueryCell;
import com.linkedin.notebook.TextCell;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NotebookCell
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.notebook/**A record of all supported cells for a Notebook. Only one type of cell will be non-null.*/record NotebookCell{/**The text cell content. The will be non-null only when all other cell field is null.*/textCell:optional/**Text cell in a Notebook, which will present content in text format*/record TextCell includes/**Common attributes for a cell in a Notebook*/record CommonCellAttributes{/**Title of the cell*/cellTitle:optional string/**Unique id for the cell. This id should be globally unique for a Notebook tool even when there are multiple deployments of it. As an example, Notebook URL could be used here for QueryBook such as 'querybook.com/notebook/773/?cellId=1234'*/cellId:string/**Captures information about who created/last modified/deleted this Notebook cell and when*/changeAuditStamps:{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into various lifecycle stages, and who acted to move it into those lifecycle stages. The recommended best practice is to include this record in your record schema, and annotate its fields as @readOnly in your resource. See https://github.com/linkedin/rest.li/wiki/Validation-in-Rest.li#restli-validation-annotations*/record ChangeAuditStamps{/**An AuditStamp corresponding to the creation of this resource/association/sub-resource. A value of 0 for time indicates missing data.*/created:/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}/**An AuditStamp corresponding to the last modification of this resource/association/sub-resource. If no modification has happened since creation, lastModified should be the same as created. A value of 0 for time indicates missing data.*/lastModified:AuditStamp={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}/**An AuditStamp corresponding to the deletion of this resource/association/sub-resource. Logically, deleted MUST have a later timestamp than creation. It may or may not have the same time as lastModified depending upon the resource/association/sub-resource semantics.*/deleted:optional AuditStamp}}}{/**The actual text in a TextCell in a Notebook*/text:string}/**The query cell content. The will be non-null only when all other cell field is null.*/queryCell:optional/**Query cell in a Notebook, which will present content in query format*/record QueryCell includes CommonCellAttributes{/**Raw query to explain some specific logic in a Notebook*/rawQuery:string/**Captures information about who last executed this query cell and when*/lastExecuted:optional com.linkedin.common.AuditStamp}/**The chart cell content. The will be non-null only when all other cell field is null.*/chartCell:optional/**Chart cell in a notebook, which will present content in chart format*/record ChartCell includes CommonCellAttributes{}/**The type of this Notebook cell*/type:/**Type of Notebook Cell*/enum NotebookCellType{/**TEXT Notebook cell type. The cell context is text only.*/TEXT_CELL/**QUERY Notebook cell type. The cell context is query only.*/QUERY_CELL/**CHART Notebook cell type. The cell content is chart only.*/CHART_CELL}}", SchemaFormatType.PDL);
    private TextCell _textCellField = null;
    private QueryCell _queryCellField = null;
    private ChartCell _chartCellField = null;
    private NotebookCellType _typeField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_TextCell = SCHEMA.getField("textCell");
    private static final RecordDataSchema.Field FIELD_QueryCell = SCHEMA.getField("queryCell");
    private static final RecordDataSchema.Field FIELD_ChartCell = SCHEMA.getField("chartCell");
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");

    public NotebookCell() {
        super(new DataMap(6, 0.75f), SCHEMA, 4);
        this.addChangeListener(this.__changeListener);
    }

    public NotebookCell(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasTextCell() {
        if (this._textCellField != null) {
            return true;
        }
        return this._map.containsKey("textCell");
    }

    public void removeTextCell() {
        this._map.remove("textCell");
    }

    @Nullable
    public TextCell getTextCell(GetMode mode) {
        return this.getTextCell();
    }

    @Nullable
    public TextCell getTextCell() {
        if (this._textCellField != null) {
            return this._textCellField;
        }
        Object __rawValue = this._map.get("textCell");
        this._textCellField = __rawValue == null ? null : new TextCell(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._textCellField;
    }

    public NotebookCell setTextCell(@Nullable TextCell value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTextCell(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTextCell();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "textCell", value.data());
                this._textCellField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "textCell", value.data());
                this._textCellField = value;
            }
        }
        return this;
    }

    public NotebookCell setTextCell(@Nonnull TextCell value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field textCell of com.linkedin.notebook.NotebookCell to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "textCell", value.data());
        this._textCellField = value;
        return this;
    }

    public boolean hasQueryCell() {
        if (this._queryCellField != null) {
            return true;
        }
        return this._map.containsKey("queryCell");
    }

    public void removeQueryCell() {
        this._map.remove("queryCell");
    }

    @Nullable
    public QueryCell getQueryCell(GetMode mode) {
        return this.getQueryCell();
    }

    @Nullable
    public QueryCell getQueryCell() {
        if (this._queryCellField != null) {
            return this._queryCellField;
        }
        Object __rawValue = this._map.get("queryCell");
        this._queryCellField = __rawValue == null ? null : new QueryCell(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._queryCellField;
    }

    public NotebookCell setQueryCell(@Nullable QueryCell value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setQueryCell(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeQueryCell();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "queryCell", value.data());
                this._queryCellField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "queryCell", value.data());
                this._queryCellField = value;
            }
        }
        return this;
    }

    public NotebookCell setQueryCell(@Nonnull QueryCell value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field queryCell of com.linkedin.notebook.NotebookCell to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "queryCell", value.data());
        this._queryCellField = value;
        return this;
    }

    public boolean hasChartCell() {
        if (this._chartCellField != null) {
            return true;
        }
        return this._map.containsKey("chartCell");
    }

    public void removeChartCell() {
        this._map.remove("chartCell");
    }

    @Nullable
    public ChartCell getChartCell(GetMode mode) {
        return this.getChartCell();
    }

    @Nullable
    public ChartCell getChartCell() {
        if (this._chartCellField != null) {
            return this._chartCellField;
        }
        Object __rawValue = this._map.get("chartCell");
        this._chartCellField = __rawValue == null ? null : new ChartCell(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._chartCellField;
    }

    public NotebookCell setChartCell(@Nullable ChartCell value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setChartCell(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeChartCell();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "chartCell", value.data());
                this._chartCellField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "chartCell", value.data());
                this._chartCellField = value;
            }
        }
        return this;
    }

    public NotebookCell setChartCell(@Nonnull ChartCell value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field chartCell of com.linkedin.notebook.NotebookCell to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "chartCell", value.data());
        this._chartCellField = value;
        return this;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public NotebookCellType getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, NotebookCellType.class, NotebookCellType.$UNKNOWN);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public NotebookCellType getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, NotebookCellType.class, NotebookCellType.$UNKNOWN);
        return this._typeField;
    }

    public NotebookCell setType(@Nullable NotebookCellType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.notebook.NotebookCell");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
            }
        }
        return this;
    }

    public NotebookCell setType(@Nonnull NotebookCellType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.notebook.NotebookCell to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value.name());
        this._typeField = value;
        return this;
    }

    @Override
    public NotebookCell clone() throws CloneNotSupportedException {
        NotebookCell __clone = (NotebookCell)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public NotebookCell copy() throws CloneNotSupportedException {
        NotebookCell __copy = (NotebookCell)super.copy();
        __copy._chartCellField = null;
        __copy._textCellField = null;
        __copy._typeField = null;
        __copy._queryCellField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final NotebookCell __objectRef;

        private ChangeListener(NotebookCell reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "chartCell": {
                    this.__objectRef._chartCellField = null;
                    break;
                }
                case "textCell": {
                    this.__objectRef._textCellField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                    break;
                }
                case "queryCell": {
                    this.__objectRef._queryCellField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public TextCell.Fields textCell() {
            return new TextCell.Fields(this.getPathComponents(), "textCell");
        }

        public QueryCell.Fields queryCell() {
            return new QueryCell.Fields(this.getPathComponents(), "queryCell");
        }

        public ChartCell.Fields chartCell() {
            return new ChartCell.Fields(this.getPathComponents(), "chartCell");
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private TextCell.ProjectionMask _textCellMask;
        private QueryCell.ProjectionMask _queryCellMask;
        private ChartCell.ProjectionMask _chartCellMask;

        ProjectionMask() {
            super(6);
        }

        public ProjectionMask withTextCell(Function<TextCell.ProjectionMask, TextCell.ProjectionMask> nestedMask) {
            this._textCellMask = nestedMask.apply(this._textCellMask == null ? TextCell.createMask() : this._textCellMask);
            this.getDataMap().put("textCell", this._textCellMask.getDataMap());
            return this;
        }

        public ProjectionMask withTextCell() {
            this._textCellMask = null;
            this.getDataMap().put("textCell", 1);
            return this;
        }

        public ProjectionMask withQueryCell(Function<QueryCell.ProjectionMask, QueryCell.ProjectionMask> nestedMask) {
            this._queryCellMask = nestedMask.apply(this._queryCellMask == null ? QueryCell.createMask() : this._queryCellMask);
            this.getDataMap().put("queryCell", this._queryCellMask.getDataMap());
            return this;
        }

        public ProjectionMask withQueryCell() {
            this._queryCellMask = null;
            this.getDataMap().put("queryCell", 1);
            return this;
        }

        public ProjectionMask withChartCell(Function<ChartCell.ProjectionMask, ChartCell.ProjectionMask> nestedMask) {
            this._chartCellMask = nestedMask.apply(this._chartCellMask == null ? ChartCell.createMask() : this._chartCellMask);
            this.getDataMap().put("chartCell", this._chartCellMask.getDataMap());
            return this;
        }

        public ProjectionMask withChartCell() {
            this._chartCellMask = null;
            this.getDataMap().put("chartCell", 1);
            return this;
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }
    }
}

