/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.utils.metrics;

import com.github.benmanes.caffeine.cache.Cache;
import com.hazelcast.map.IMap;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.cache.CaffeineCacheMetrics;
import io.micrometer.core.instrument.binder.cache.HazelcastCacheMetrics;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicrometerMetricsRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MicrometerMetricsRegistry.class);
    static final Set<String> GLOBALLY_REGISTERED_CACHES = ConcurrentHashMap.newKeySet();
    static final Set<String> GLOBALLY_REGISTERED_EXECUTOR_SERVICE = ConcurrentHashMap.newKeySet();

    private MicrometerMetricsRegistry() {
    }

    public static synchronized boolean registerCacheMetrics(@Nonnull String cacheName, @Nonnull Object nativeCache, @Nonnull MeterRegistry meterRegistry) {
        if (!GLOBALLY_REGISTERED_CACHES.add(cacheName)) {
            return false;
        }
        try {
            if (nativeCache instanceof Cache) {
                Cache caffeineCache = (Cache)nativeCache;
                CaffeineCacheMetrics.monitor((MeterRegistry)meterRegistry, (Cache)caffeineCache, (String)cacheName, (String[])new String[]{"name", cacheName});
                log.debug("Registered Caffeine cache metrics for: {}", (Object)cacheName);
            } else if (nativeCache instanceof IMap) {
                IMap hazelcastMap = (IMap)nativeCache;
                HazelcastCacheMetrics.monitor((MeterRegistry)meterRegistry, (Object)hazelcastMap, (String[])new String[]{"name", cacheName});
                log.debug("Registered Hazelcast cache metrics for: {}", (Object)cacheName);
            }
            return true;
        }
        catch (Exception e) {
            GLOBALLY_REGISTERED_CACHES.remove(cacheName);
            log.error("Failed to register metrics for cache: {}. Error: {}", cacheName, e.getMessage(), e);
            return false;
        }
    }

    public static synchronized boolean registerExecutorMetrics(@Nonnull String executorName, @Nonnull ExecutorService executorService, @Nullable MeterRegistry meterRegistry) {
        if (executorName == null || executorService == null || meterRegistry == null) {
            return false;
        }
        if (!GLOBALLY_REGISTERED_EXECUTOR_SERVICE.add(executorName)) {
            return false;
        }
        try {
            ExecutorServiceMetrics.monitor((MeterRegistry)meterRegistry, (ExecutorService)executorService, (String)executorName, (Tag[])new Tag[0]);
            return true;
        }
        catch (Exception e) {
            GLOBALLY_REGISTERED_EXECUTOR_SERVICE.remove(executorName);
            log.error("Failed to register metrics for executor: {}. Error: {}", executorName, e.getMessage(), e);
            return false;
        }
    }
}

