/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.utils.elasticsearch.responses;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.common.settings.Settings;

public class GetIndexResponse {
    private final String[] indices;
    private final Map<String, MappingMetadata> mappings;
    private final Map<String, List<AliasMetadata>> aliases;
    private final Map<String, Settings> settings;
    private final Map<String, Settings> defaultSettings;
    private final Map<String, String> dataStreams;

    public String getSetting(String index, String setting) {
        Settings indexSettings = this.settings.get(index);
        String settingValue = null;
        if (setting != null) {
            if (indexSettings != null) {
                settingValue = indexSettings.get(setting);
            }
            if (settingValue == null) {
                Settings defaultIndexSettings = this.defaultSettings.get(index);
                settingValue = defaultIndexSettings != null ? defaultIndexSettings.get(setting) : null;
            }
        }
        return settingValue;
    }

    @Generated
    public GetIndexResponse(String[] indices, Map<String, MappingMetadata> mappings, Map<String, List<AliasMetadata>> aliases, Map<String, Settings> settings, Map<String, Settings> defaultSettings, Map<String, String> dataStreams) {
        this.indices = indices;
        this.mappings = mappings;
        this.aliases = aliases;
        this.settings = settings;
        this.defaultSettings = defaultSettings;
        this.dataStreams = dataStreams;
    }

    @Generated
    public String[] getIndices() {
        return this.indices;
    }

    @Generated
    public Map<String, MappingMetadata> getMappings() {
        return this.mappings;
    }

    @Generated
    public Map<String, List<AliasMetadata>> getAliases() {
        return this.aliases;
    }

    @Generated
    public Map<String, Settings> getSettings() {
        return this.settings;
    }

    @Generated
    public Map<String, Settings> getDefaultSettings() {
        return this.defaultSettings;
    }

    @Generated
    public Map<String, String> getDataStreams() {
        return this.dataStreams;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetIndexResponse)) {
            return false;
        }
        GetIndexResponse other = (GetIndexResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getIndices(), other.getIndices())) {
            return false;
        }
        Map<String, MappingMetadata> this$mappings = this.getMappings();
        Map<String, MappingMetadata> other$mappings = other.getMappings();
        if (this$mappings == null ? other$mappings != null : !((Object)this$mappings).equals(other$mappings)) {
            return false;
        }
        Map<String, List<AliasMetadata>> this$aliases = this.getAliases();
        Map<String, List<AliasMetadata>> other$aliases = other.getAliases();
        if (this$aliases == null ? other$aliases != null : !((Object)this$aliases).equals(other$aliases)) {
            return false;
        }
        Map<String, Settings> this$settings = this.getSettings();
        Map<String, Settings> other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !((Object)this$settings).equals(other$settings)) {
            return false;
        }
        Map<String, Settings> this$defaultSettings = this.getDefaultSettings();
        Map<String, Settings> other$defaultSettings = other.getDefaultSettings();
        if (this$defaultSettings == null ? other$defaultSettings != null : !((Object)this$defaultSettings).equals(other$defaultSettings)) {
            return false;
        }
        Map<String, String> this$dataStreams = this.getDataStreams();
        Map<String, String> other$dataStreams = other.getDataStreams();
        return !(this$dataStreams == null ? other$dataStreams != null : !((Object)this$dataStreams).equals(other$dataStreams));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GetIndexResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getIndices());
        Map<String, MappingMetadata> $mappings = this.getMappings();
        result = result * 59 + ($mappings == null ? 43 : ((Object)$mappings).hashCode());
        Map<String, List<AliasMetadata>> $aliases = this.getAliases();
        result = result * 59 + ($aliases == null ? 43 : ((Object)$aliases).hashCode());
        Map<String, Settings> $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : ((Object)$settings).hashCode());
        Map<String, Settings> $defaultSettings = this.getDefaultSettings();
        result = result * 59 + ($defaultSettings == null ? 43 : ((Object)$defaultSettings).hashCode());
        Map<String, String> $dataStreams = this.getDataStreams();
        result = result * 59 + ($dataStreams == null ? 43 : ((Object)$dataStreams).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GetIndexResponse(indices=" + Arrays.deepToString(this.getIndices()) + ", mappings=" + String.valueOf(this.getMappings()) + ", aliases=" + String.valueOf(this.getAliases()) + ", settings=" + String.valueOf(this.getSettings()) + ", defaultSettings=" + String.valueOf(this.getDefaultSettings()) + ", dataStreams=" + String.valueOf(this.getDataStreams()) + ")";
    }
}

