/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.utils.aws;

import java.net.URI;
import java.time.Duration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;
import software.amazon.awssdk.services.s3.presigner.model.GetObjectPresignRequest;
import software.amazon.awssdk.services.s3.presigner.model.PresignedGetObjectRequest;
import software.amazon.awssdk.services.s3.presigner.model.PresignedPutObjectRequest;
import software.amazon.awssdk.services.s3.presigner.model.PutObjectPresignRequest;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleResponse;
import software.amazon.awssdk.services.sts.model.Credentials;

public class S3Util {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(S3Util.class);
    private final S3Client s3Client;
    @Nonnull
    private final S3Presigner s3Presigner;

    public S3Util(@Nonnull S3Client s3Client) {
        this(s3Client, null);
    }

    public S3Util(@Nonnull S3Client s3Client, @Nullable S3Presigner s3Presigner) {
        this.s3Client = s3Client;
        this.s3Presigner = s3Presigner != null ? s3Presigner : this.createPresigner();
    }

    public S3Util(@Nonnull StsClient stsClient, @Nonnull String roleArn) {
        this(stsClient, roleArn, null);
    }

    public S3Util(@Nonnull StsClient stsClient, @Nonnull String roleArn, @Nullable S3Presigner s3Presigner) {
        this.s3Client = S3Util.createS3Client(stsClient, roleArn);
        this.s3Presigner = s3Presigner != null ? s3Presigner : this.createPresigner();
    }

    private static S3Client createS3Client(@Nonnull StsClient stsClient, @Nonnull String roleArn) {
        try {
            log.info("Creating S3Client for role: {}", (Object)roleArn);
            StsAssumeRoleCredentialsProvider credentialsProvider = ((StsAssumeRoleCredentialsProvider.Builder)((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(stsClient)).refreshRequest(r -> r.roleArn(roleArn).roleSessionName("s3-session")).asyncCredentialUpdateEnabled(Boolean.valueOf(true))).build();
            S3ClientBuilder clientBuilder = (S3ClientBuilder)S3Client.builder().credentialsProvider((AwsCredentialsProvider)credentialsProvider);
            String endpointUrl = System.getenv("AWS_ENDPOINT_URL");
            if (endpointUrl != null && !endpointUrl.isEmpty()) {
                log.info("Configuring S3Client with custom endpoint: {}", (Object)endpointUrl);
                clientBuilder.endpointOverride(URI.create(endpointUrl));
                clientBuilder.forcePathStyle(Boolean.valueOf(true));
            }
            S3Client client = (S3Client)clientBuilder.build();
            log.info("Successfully created S3Client for role: {}", (Object)roleArn);
            return client;
        }
        catch (Exception e) {
            log.error("Failed to create S3 client: roleArn={}", (Object)roleArn, (Object)e);
            throw new RuntimeException("Failed to create S3 clien: " + e.getMessage(), e);
        }
    }

    public static Credentials assumeRole(@Nonnull StsClient stsClient, @Nonnull String roleArn, @Nonnull String sessionName) {
        try {
            AssumeRoleRequest roleRequest = (AssumeRoleRequest)AssumeRoleRequest.builder().roleArn(roleArn).roleSessionName(sessionName).build();
            AssumeRoleResponse roleResponse = stsClient.assumeRole(roleRequest);
            return roleResponse.credentials();
        }
        catch (Exception e) {
            log.error("Failed to assume role: roleArn={}, sessionName={}", roleArn, sessionName, e);
            throw new RuntimeException("Failed to assume AWS role: " + e.getMessage(), e);
        }
    }

    private S3Presigner createPresigner() {
        S3Presigner.Builder presignerBuilder = S3Presigner.builder().credentialsProvider(this.s3Client.serviceClientConfiguration().credentialsProvider()).region(this.s3Client.serviceClientConfiguration().region());
        String endpointUrl = System.getenv("AWS_ENDPOINT_URL");
        if (endpointUrl != null && !endpointUrl.isEmpty()) {
            presignerBuilder.endpointOverride(URI.create(endpointUrl));
            presignerBuilder.serviceConfiguration((S3Configuration)S3Configuration.builder().pathStyleAccessEnabled(Boolean.valueOf(true)).build());
        }
        return presignerBuilder.build();
    }

    public String generatePresignedDownloadUrl(@Nonnull String bucket, @Nonnull String key, int expirationSeconds) {
        try {
            GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(bucket).key(key).build();
            GetObjectPresignRequest presignRequest = GetObjectPresignRequest.builder().signatureDuration(Duration.ofSeconds(expirationSeconds)).getObjectRequest(getObjectRequest).build();
            PresignedGetObjectRequest presignedRequest = this.s3Presigner.presignGetObject(presignRequest);
            return presignedRequest.url().toString();
        }
        catch (Exception e) {
            log.error("Failed to generate presigned URL for bucket: {}, key: {}", bucket, key, e);
            throw new RuntimeException("Failed to generate presigned URL: " + e.getMessage(), e);
        }
    }

    public String generatePresignedUploadUrl(@Nonnull String bucket, @Nonnull String key, int expirationSeconds, @Nullable String contentType) {
        try {
            PutObjectRequest putObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(bucket).contentType(contentType).key(key).build();
            PutObjectPresignRequest presignRequest = PutObjectPresignRequest.builder().signatureDuration(Duration.ofSeconds(expirationSeconds)).putObjectRequest(putObjectRequest).build();
            PresignedPutObjectRequest presignedRequest = this.s3Presigner.presignPutObject(presignRequest);
            return presignedRequest.url().toString();
        }
        catch (Exception e) {
            log.error("Failed to generate presigned upload URL for bucket: {}, key: {}", bucket, key, e);
            throw new RuntimeException("Failed to generate presigned upload URL: " + e.getMessage(), e);
        }
    }
}

