/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.utils;

import com.datahub.util.RecordUtils;
import com.datahub.util.exception.ModelConversionException;
import com.linkedin.common.AuditStamp;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.events.metadata.ChangeType;
import com.linkedin.metadata.models.annotation.AspectAnnotation;
import com.linkedin.metadata.models.annotation.EntityAnnotation;
import com.linkedin.metadata.utils.GenericRecordUtils;
import com.linkedin.metadata.utils.SystemMetadataUtils;
import com.linkedin.mxe.MetadataChangeLog;
import com.linkedin.mxe.MetadataChangeProposal;
import com.linkedin.mxe.SystemMetadata;
import java.util.Objects;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PegasusUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PegasusUtils.class);

    private PegasusUtils() {
    }

    public static String getEntityNameFromSchema(RecordDataSchema entitySnapshotSchema) {
        Object entityAnnotationObj = entitySnapshotSchema.getProperties().get("Entity");
        if (entityAnnotationObj != null) {
            return EntityAnnotation.fromSchemaProperty(entityAnnotationObj, entitySnapshotSchema.getFullName()).getName();
        }
        log.error(String.format("Failed to extract entity name from provided schema %s", entitySnapshotSchema.getName()));
        throw new IllegalArgumentException(String.format("Failed to extract entity name from provided schema %s", entitySnapshotSchema.getName()));
    }

    public static String getAspectNameFromFullyQualifiedName(String fullyQualifiedRecordTemplateName) {
        RecordTemplate template = RecordUtils.toRecordTemplate(fullyQualifiedRecordTemplateName, new DataMap());
        RecordDataSchema aspectSchema = template.schema();
        return PegasusUtils.getAspectNameFromSchema(aspectSchema);
    }

    public static String getAspectNameFromSchema(RecordDataSchema aspectSchema) {
        Object aspectAnnotationObj = aspectSchema.getProperties().get("Aspect");
        if (aspectAnnotationObj != null) {
            return AspectAnnotation.fromSchemaProperty(aspectAnnotationObj, aspectSchema.getFullName()).getName();
        }
        log.error(String.format("Failed to extract aspect name from provided schema %s", aspectSchema.getName()));
        throw new IllegalArgumentException(String.format("Failed to extract aspect name from provided schema %s", aspectSchema.getName()));
    }

    public static <T> Class<? extends T> getDataTemplateClassFromSchema(NamedDataSchema schema, Class<T> clazz) {
        try {
            return Class.forName(schema.getFullName()).asSubclass(clazz);
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to find class for RecordDataSchema named " + schema.getFullName() + " " + e.getMessage());
            throw new ModelConversionException("Unable to find class for RecordDataSchema named " + schema.getFullName(), e);
        }
    }

    public static String urnToEntityName(Urn urn) {
        return urn.getEntityType();
    }

    public static MetadataChangeLog constructMCL(@Nullable MetadataChangeProposal base, String entityName, Urn urn, ChangeType changeType, String aspectName, AuditStamp auditStamp, RecordTemplate newAspectValue, SystemMetadata newSystemMetadata, RecordTemplate oldAspectValue, SystemMetadata oldSystemMetadata) {
        MetadataChangeLog metadataChangeLog = base != null ? new MetadataChangeLog(new DataMap(base.data())) : new MetadataChangeLog();
        metadataChangeLog.setEntityType(entityName);
        metadataChangeLog.setEntityUrn(urn);
        metadataChangeLog.setChangeType(changeType);
        metadataChangeLog.setAspectName(aspectName);
        metadataChangeLog.setCreated(auditStamp);
        if (newAspectValue != null) {
            metadataChangeLog.setAspect(GenericRecordUtils.serializeAspect(newAspectValue));
        }
        if (newSystemMetadata != null) {
            metadataChangeLog.setSystemMetadata(newSystemMetadata);
        }
        if (oldAspectValue != null) {
            metadataChangeLog.setPreviousAspectValue(GenericRecordUtils.serializeAspect(oldAspectValue));
        }
        if (oldSystemMetadata != null) {
            metadataChangeLog.setPreviousSystemMetadata(oldSystemMetadata);
        }
        return metadataChangeLog;
    }

    public static MetadataChangeLog constructMCL(@Nullable MetadataChangeProposal base, String entityName, Urn urn, String aspectName, AuditStamp auditStamp, RecordTemplate newAspectValue, SystemMetadata newSystemMetadata, RecordTemplate oldAspectValue, SystemMetadata oldSystemMetadata) {
        return PegasusUtils.constructMCL(base, entityName, urn, SystemMetadataUtils.isNoOp(newSystemMetadata) || Objects.equals(oldAspectValue, newAspectValue) ? ChangeType.RESTATE : (newAspectValue != null ? ChangeType.UPSERT : ChangeType.DELETE), aspectName, auditStamp, newAspectValue, newSystemMetadata, oldAspectValue, oldSystemMetadata);
    }
}

