/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.utils;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.message.Message;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.validator.Validator;
import com.linkedin.data.schema.validator.ValidatorContext;
import com.linkedin.metadata.models.EntitySpec;
import com.linkedin.metadata.models.RelationshipFieldSpec;
import com.linkedin.metadata.models.registry.EntityRegistry;
import com.linkedin.metadata.utils.EntityKeyUtils;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class EntityRegistryUrnValidator
implements Validator {
    private final EntityRegistry _entityRegistry;
    private EntitySpec currentEntitySpec = null;

    public EntityRegistryUrnValidator(EntityRegistry entityRegistry) {
        this._entityRegistry = entityRegistry;
    }

    @Override
    public void validate(ValidatorContext context) {
        if (this.currentEntitySpec == null) {
            throw new IllegalStateException("Current entity spec must be set");
        }
        this.validateUrnField(context);
    }

    protected void validateUrnField(ValidatorContext context) {
        if (DataSchema.Type.TYPEREF.equals((Object)context.dataElement().getSchema().getType()) && ((NamedDataSchema)context.dataElement().getSchema()).getName().endsWith("Urn")) {
            try {
                String urnStr = (String)context.dataElement().getValue();
                Urn urn = Urn.createFromString(urnStr);
                EntitySpec entitySpec = this._entityRegistry.getEntitySpec(urn.getEntityType());
                if (entitySpec == null) {
                    throw new IllegalArgumentException(String.format("Entity type %s is missing from entity registry", urn.getEntityType()));
                }
                EntityKeyUtils.convertUrnToEntityKey(urn, entitySpec.getKeyAspectSpec());
                NamedDataSchema namedDataSchema = (NamedDataSchema)context.dataElement().getSchema();
                try {
                    String schemaName = (String)((Map)namedDataSchema.getProperties().get("java")).get("class");
                    Class<?> urnClass = Class.forName(schemaName);
                    urnClass.getDeclaredMethod("createFromString", String.class).invoke(null, urnStr);
                }
                catch (ClassCastException | ClassNotFoundException | NoSuchMethodException e) {
                    throw new IllegalArgumentException("Unrecognized Urn class: " + namedDataSchema.getName(), e);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalArgumentException("Unable to instantiate urn type: " + namedDataSchema.getName() + " with urn: " + urnStr, e);
                }
                PathSpec fieldPath = context.dataElement().getSchemaPathSpec();
                List relationshipSpecs = this.currentEntitySpec.getRelationshipFieldSpecs().stream().filter(relationshipFieldSpec -> relationshipFieldSpec.getPath().equals(fieldPath)).collect(Collectors.toList());
                if (!relationshipSpecs.isEmpty()) {
                    for (RelationshipFieldSpec relationshipFieldSpec2 : relationshipSpecs) {
                        boolean isValidDestination = relationshipFieldSpec2.getValidDestinationTypes().stream().anyMatch(destinationType -> destinationType.equals(urn.getEntityType()));
                        if (isValidDestination) continue;
                        throw new IllegalArgumentException("Entity type for urn: " + String.valueOf(urn) + " is not a valid destination for field path: " + String.valueOf(fieldPath));
                    }
                }
            }
            catch (IllegalArgumentException | URISyntaxException e) {
                context.addResult(new Message(context.dataElement().path(), "\"Provided urn %s\" is invalid: %s", context.dataElement().getValue(), e.getMessage()));
                context.setHasFix(false);
            }
        }
    }

    @Generated
    public void setCurrentEntitySpec(EntitySpec currentEntitySpec) {
        this.currentEntitySpec = currentEntitySpec;
    }
}

