/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.search;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.DoubleMap;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import com.linkedin.data.template.StringMap;
import com.linkedin.metadata.search.MatchedFieldArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SearchEntity
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.search/**The model for each entity returned by the search query*/record SearchEntity{/**Urn of the entity being returned*/entity:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**Matched field name and values*/matchedFields:array[record MatchedField{/**Matched field name*/name:string/**Matched field value*/value:string}]=[]features:optional map[string,double]score:optional double/**A list of the the restricted aspects on the entity.\nIf the key aspect is present, assume ALL aspects should be restricted including the entity's Urn.*/restrictedAspects:optional array[string]/**Extra fields from the search document based on what is requested in the search request*/extraFields:optional map[string,string]}", SchemaFormatType.PDL);
    private Urn _entityField = null;
    private MatchedFieldArray _matchedFieldsField = null;
    private DoubleMap _featuresField = null;
    private Double _scoreField = null;
    private StringArray _restrictedAspectsField = null;
    private StringMap _extraFieldsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Entity = SCHEMA.getField("entity");
    private static final RecordDataSchema.Field FIELD_MatchedFields = SCHEMA.getField("matchedFields");
    private static final MatchedFieldArray DEFAULT_MatchedFields;
    private static final RecordDataSchema.Field FIELD_Features;
    private static final RecordDataSchema.Field FIELD_Score;
    private static final RecordDataSchema.Field FIELD_RestrictedAspects;
    private static final RecordDataSchema.Field FIELD_ExtraFields;

    public SearchEntity() {
        super(new DataMap(8, 0.75f), SCHEMA, 6);
        this.addChangeListener(this.__changeListener);
    }

    public SearchEntity(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasEntity() {
        if (this._entityField != null) {
            return true;
        }
        return this._map.containsKey("entity");
    }

    public void removeEntity() {
        this._map.remove("entity");
    }

    @Nullable
    public Urn getEntity(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getEntity();
            }
            case DEFAULT: 
            case NULL: {
                if (this._entityField != null) {
                    return this._entityField;
                }
                Object __rawValue = this._map.get("entity");
                this._entityField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._entityField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getEntity() {
        if (this._entityField != null) {
            return this._entityField;
        }
        Object __rawValue = this._map.get("entity");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("entity");
        }
        this._entityField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._entityField;
    }

    public SearchEntity setEntity(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEntity(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field entity of com.linkedin.metadata.search.SearchEntity");
                }
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEntity();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
            }
        }
        return this;
    }

    public SearchEntity setEntity(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field entity of com.linkedin.metadata.search.SearchEntity to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._entityField = value;
        return this;
    }

    public boolean hasMatchedFields() {
        if (this._matchedFieldsField != null) {
            return true;
        }
        return this._map.containsKey("matchedFields");
    }

    public void removeMatchedFields() {
        this._map.remove("matchedFields");
    }

    @Nullable
    public MatchedFieldArray getMatchedFields(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getMatchedFields();
            }
            case NULL: {
                if (this._matchedFieldsField != null) {
                    return this._matchedFieldsField;
                }
                Object __rawValue = this._map.get("matchedFields");
                this._matchedFieldsField = __rawValue == null ? null : new MatchedFieldArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._matchedFieldsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public MatchedFieldArray getMatchedFields() {
        if (this._matchedFieldsField != null) {
            return this._matchedFieldsField;
        }
        Object __rawValue = this._map.get("matchedFields");
        if (__rawValue == null) {
            return DEFAULT_MatchedFields;
        }
        this._matchedFieldsField = __rawValue == null ? null : new MatchedFieldArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._matchedFieldsField;
    }

    public SearchEntity setMatchedFields(@Nullable MatchedFieldArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMatchedFields(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field matchedFields of com.linkedin.metadata.search.SearchEntity");
                }
                CheckedUtil.putWithoutChecking(this._map, "matchedFields", value.data());
                this._matchedFieldsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMatchedFields();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "matchedFields", value.data());
                this._matchedFieldsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "matchedFields", value.data());
                this._matchedFieldsField = value;
            }
        }
        return this;
    }

    public SearchEntity setMatchedFields(@Nonnull MatchedFieldArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field matchedFields of com.linkedin.metadata.search.SearchEntity to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "matchedFields", value.data());
        this._matchedFieldsField = value;
        return this;
    }

    public boolean hasFeatures() {
        if (this._featuresField != null) {
            return true;
        }
        return this._map.containsKey("features");
    }

    public void removeFeatures() {
        this._map.remove("features");
    }

    @Nullable
    public DoubleMap getFeatures(GetMode mode) {
        return this.getFeatures();
    }

    @Nullable
    public DoubleMap getFeatures() {
        if (this._featuresField != null) {
            return this._featuresField;
        }
        Object __rawValue = this._map.get("features");
        this._featuresField = __rawValue == null ? null : new DoubleMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._featuresField;
    }

    public SearchEntity setFeatures(@Nullable DoubleMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFeatures(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFeatures();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "features", value.data());
                this._featuresField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "features", value.data());
                this._featuresField = value;
            }
        }
        return this;
    }

    public SearchEntity setFeatures(@Nonnull DoubleMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field features of com.linkedin.metadata.search.SearchEntity to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "features", value.data());
        this._featuresField = value;
        return this;
    }

    public boolean hasScore() {
        if (this._scoreField != null) {
            return true;
        }
        return this._map.containsKey("score");
    }

    public void removeScore() {
        this._map.remove("score");
    }

    @Nullable
    public Double getScore(GetMode mode) {
        return this.getScore();
    }

    @Nullable
    public Double getScore() {
        if (this._scoreField != null) {
            return this._scoreField;
        }
        Object __rawValue = this._map.get("score");
        this._scoreField = DataTemplateUtil.coerceDoubleOutput(__rawValue);
        return this._scoreField;
    }

    public SearchEntity setScore(@Nullable Double value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setScore(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeScore();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "score", DataTemplateUtil.coerceDoubleInput(value));
                this._scoreField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "score", DataTemplateUtil.coerceDoubleInput(value));
                this._scoreField = value;
            }
        }
        return this;
    }

    public SearchEntity setScore(@Nonnull Double value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field score of com.linkedin.metadata.search.SearchEntity to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "score", DataTemplateUtil.coerceDoubleInput(value));
        this._scoreField = value;
        return this;
    }

    public SearchEntity setScore(double value) {
        CheckedUtil.putWithoutChecking(this._map, "score", DataTemplateUtil.coerceDoubleInput(value));
        this._scoreField = value;
        return this;
    }

    public boolean hasRestrictedAspects() {
        if (this._restrictedAspectsField != null) {
            return true;
        }
        return this._map.containsKey("restrictedAspects");
    }

    public void removeRestrictedAspects() {
        this._map.remove("restrictedAspects");
    }

    @Nullable
    public StringArray getRestrictedAspects(GetMode mode) {
        return this.getRestrictedAspects();
    }

    @Nullable
    public StringArray getRestrictedAspects() {
        if (this._restrictedAspectsField != null) {
            return this._restrictedAspectsField;
        }
        Object __rawValue = this._map.get("restrictedAspects");
        this._restrictedAspectsField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._restrictedAspectsField;
    }

    public SearchEntity setRestrictedAspects(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRestrictedAspects(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRestrictedAspects();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "restrictedAspects", value.data());
                this._restrictedAspectsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "restrictedAspects", value.data());
                this._restrictedAspectsField = value;
            }
        }
        return this;
    }

    public SearchEntity setRestrictedAspects(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field restrictedAspects of com.linkedin.metadata.search.SearchEntity to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "restrictedAspects", value.data());
        this._restrictedAspectsField = value;
        return this;
    }

    public boolean hasExtraFields() {
        if (this._extraFieldsField != null) {
            return true;
        }
        return this._map.containsKey("extraFields");
    }

    public void removeExtraFields() {
        this._map.remove("extraFields");
    }

    @Nullable
    public StringMap getExtraFields(GetMode mode) {
        return this.getExtraFields();
    }

    @Nullable
    public StringMap getExtraFields() {
        if (this._extraFieldsField != null) {
            return this._extraFieldsField;
        }
        Object __rawValue = this._map.get("extraFields");
        this._extraFieldsField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._extraFieldsField;
    }

    public SearchEntity setExtraFields(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setExtraFields(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeExtraFields();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "extraFields", value.data());
                this._extraFieldsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "extraFields", value.data());
                this._extraFieldsField = value;
            }
        }
        return this;
    }

    public SearchEntity setExtraFields(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field extraFields of com.linkedin.metadata.search.SearchEntity to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "extraFields", value.data());
        this._extraFieldsField = value;
        return this;
    }

    @Override
    public SearchEntity clone() throws CloneNotSupportedException {
        SearchEntity __clone = (SearchEntity)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public SearchEntity copy() throws CloneNotSupportedException {
        SearchEntity __copy = (SearchEntity)super.copy();
        __copy._restrictedAspectsField = null;
        __copy._featuresField = null;
        __copy._scoreField = null;
        __copy._matchedFieldsField = null;
        __copy._entityField = null;
        __copy._extraFieldsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_Features = SCHEMA.getField("features");
        FIELD_Score = SCHEMA.getField("score");
        FIELD_RestrictedAspects = SCHEMA.getField("restrictedAspects");
        FIELD_ExtraFields = SCHEMA.getField("extraFields");
        Custom.initializeCustomClass(Urn.class);
        DEFAULT_MatchedFields = FIELD_MatchedFields.getDefault() == null ? null : new MatchedFieldArray(DataTemplateUtil.castOrThrow(FIELD_MatchedFields.getDefault(), DataList.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final SearchEntity __objectRef;

        private ChangeListener(SearchEntity reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "restrictedAspects": {
                    this.__objectRef._restrictedAspectsField = null;
                    break;
                }
                case "features": {
                    this.__objectRef._featuresField = null;
                    break;
                }
                case "score": {
                    this.__objectRef._scoreField = null;
                    break;
                }
                case "matchedFields": {
                    this.__objectRef._matchedFieldsField = null;
                    break;
                }
                case "entity": {
                    this.__objectRef._entityField = null;
                    break;
                }
                case "extraFields": {
                    this.__objectRef._extraFieldsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec entity() {
            return new PathSpec(this.getPathComponents(), "entity");
        }

        public MatchedFieldArray.Fields matchedFields() {
            return new MatchedFieldArray.Fields(this.getPathComponents(), "matchedFields");
        }

        public PathSpec matchedFields(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "matchedFields");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec features() {
            return new PathSpec(this.getPathComponents(), "features");
        }

        public PathSpec score() {
            return new PathSpec(this.getPathComponents(), "score");
        }

        public PathSpec restrictedAspects() {
            return new PathSpec(this.getPathComponents(), "restrictedAspects");
        }

        public PathSpec restrictedAspects(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "restrictedAspects");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec extraFields() {
            return new PathSpec(this.getPathComponents(), "extraFields");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private MatchedFieldArray.ProjectionMask _matchedFieldsMask;

        ProjectionMask() {
            super(8);
        }

        public ProjectionMask withEntity() {
            this.getDataMap().put("entity", 1);
            return this;
        }

        public ProjectionMask withMatchedFields(Function<MatchedFieldArray.ProjectionMask, MatchedFieldArray.ProjectionMask> nestedMask) {
            this._matchedFieldsMask = nestedMask.apply(this._matchedFieldsMask == null ? MatchedFieldArray.createMask() : this._matchedFieldsMask);
            this.getDataMap().put("matchedFields", this._matchedFieldsMask.getDataMap());
            return this;
        }

        public ProjectionMask withMatchedFields() {
            this._matchedFieldsMask = null;
            this.getDataMap().put("matchedFields", 1);
            return this;
        }

        public ProjectionMask withMatchedFields(Function<MatchedFieldArray.ProjectionMask, MatchedFieldArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._matchedFieldsMask = nestedMask.apply(this._matchedFieldsMask == null ? MatchedFieldArray.createMask() : this._matchedFieldsMask);
            this.getDataMap().put("matchedFields", this._matchedFieldsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("matchedFields").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("matchedFields").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withMatchedFields(Integer start, Integer count) {
            this._matchedFieldsMask = null;
            this.getDataMap().put("matchedFields", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("matchedFields").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("matchedFields").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withFeatures() {
            this.getDataMap().put("features", 1);
            return this;
        }

        public ProjectionMask withScore() {
            this.getDataMap().put("score", 1);
            return this;
        }

        public ProjectionMask withRestrictedAspects() {
            this.getDataMap().put("restrictedAspects", 1);
            return this;
        }

        public ProjectionMask withRestrictedAspects(Integer start, Integer count) {
            this.getDataMap().put("restrictedAspects", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("restrictedAspects").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("restrictedAspects").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withExtraFields() {
            this.getDataMap().put("extraFields", 1);
            return this;
        }
    }
}

