/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.search;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.WrappingArrayTemplate;
import com.linkedin.metadata.search.FilterValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class FilterValueArray
extends WrappingArrayTemplate<FilterValue> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("array[{namespace com.linkedin.metadata.search,record FilterValue{value:string,entity:optional{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}facetCount:long,filtered:optional boolean}}]", SchemaFormatType.PDL);

    public FilterValueArray() {
        this(new DataList());
    }

    public FilterValueArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public FilterValueArray(Collection<FilterValue> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public FilterValueArray(DataList data) {
        super(data, SCHEMA, FilterValue.class);
    }

    public FilterValueArray(FilterValue first, FilterValue ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    public static ArrayDataSchema dataSchema() {
        return SCHEMA;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public FilterValueArray clone() throws CloneNotSupportedException {
        FilterValueArray __clone = (FilterValueArray)super.clone();
        return __clone;
    }

    @Override
    public FilterValueArray copy() throws CloneNotSupportedException {
        FilterValueArray __copy = (FilterValueArray)super.copy();
        return __copy;
    }

    @Override
    protected FilterValue coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return object == null ? null : new FilterValue(DataTemplateUtil.castOrThrow(object, DataMap.class));
    }

    public static class ProjectionMask
    extends MaskMap {
        private FilterValue.ProjectionMask _itemsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withItems(Function<FilterValue.ProjectionMask, FilterValue.ProjectionMask> nestedMask) {
            this._itemsMask = nestedMask.apply(this._itemsMask == null ? FilterValue.createMask() : this._itemsMask);
            this.getDataMap().put("$*", this._itemsMask.getDataMap());
            return this;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public FilterValue.Fields items() {
            return new FilterValue.Fields(this.getPathComponents(), PathSpec.WILDCARD);
        }
    }
}

