/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models.annotation;

import com.linkedin.metadata.models.ModelValidationException;
import com.linkedin.metadata.models.annotation.AnnotationUtils;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.Generated;

public final class EntityAnnotation {
    public static final String ANNOTATION_NAME = "Entity";
    public static final String DEFAULT_SEARCH_GROUP = "default";
    private static final String NAME_FIELD = "name";
    private static final String KEY_ASPECT_FIELD = "keyAspect";
    private static final String SEARCH_GROUP_FIELD = "searchGroup";
    private final String name;
    private final String keyAspect;
    private final String searchGroup;

    public EntityAnnotation(String name, String keyAspect) {
        this(name, keyAspect, DEFAULT_SEARCH_GROUP);
    }

    public EntityAnnotation(String name, String keyAspect, String searchGroup) {
        this.name = name;
        this.keyAspect = keyAspect;
        this.searchGroup = searchGroup;
    }

    @Nonnull
    public static EntityAnnotation fromSchemaProperty(@Nonnull Object annotationObj, @Nonnull String context) {
        if (!Map.class.isAssignableFrom(annotationObj.getClass())) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation declared at %s: Invalid value type provided (Expected Map)", ANNOTATION_NAME, context));
        }
        Map map = (Map)annotationObj;
        Optional<String> name = AnnotationUtils.getField(map, NAME_FIELD, String.class);
        Optional<String> keyAspect = AnnotationUtils.getField(map, KEY_ASPECT_FIELD, String.class);
        if (!name.isPresent()) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation declared at %s: Invalid field '%s'. Expected type String", ANNOTATION_NAME, context, NAME_FIELD));
        }
        if (!keyAspect.isPresent()) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation declared at %s: Invalid field '%s'. Expected type String", ANNOTATION_NAME, context, KEY_ASPECT_FIELD));
        }
        String searchGroup = AnnotationUtils.getField(map, SEARCH_GROUP_FIELD, String.class).orElse(DEFAULT_SEARCH_GROUP);
        EntityAnnotation.validateElasticsearchIndexName(searchGroup, context);
        return new EntityAnnotation(name.get(), keyAspect.get(), searchGroup);
    }

    private static void validateElasticsearchIndexName(String indexName, String context) {
        if (indexName == null || indexName.trim().isEmpty()) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation declared at %s: searchGroup cannot be null or empty", ANNOTATION_NAME, context));
        }
        if (indexName.length() > 255) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation declared at %s: searchGroup cannot be longer than 255 characters, but was %d characters: '%s'", ANNOTATION_NAME, context, indexName.length(), indexName));
        }
        if (".".equals(indexName) || "..".equals(indexName)) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation declared at %s: searchGroup cannot be '.' or '..', but was '%s'", ANNOTATION_NAME, context, indexName));
        }
        if (indexName.startsWith("-") || indexName.startsWith("_") || indexName.startsWith("+")) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation declared at %s: searchGroup cannot start with '-', '_', or '+', but was '%s'", ANNOTATION_NAME, context, indexName));
        }
        if (!indexName.equals(indexName.toLowerCase())) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation declared at %s: searchGroup must be lowercase, but was '%s'", ANNOTATION_NAME, context, indexName));
        }
        String invalidChars = "\\/*?\"<>| ,#";
        for (char c : invalidChars.toCharArray()) {
            if (indexName.indexOf(c) == -1) continue;
            throw new ModelValidationException(String.format("Failed to validate @%s annotation declared at %s: searchGroup cannot contain '%c', but was '%s'", ANNOTATION_NAME, context, Character.valueOf(c), indexName));
        }
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getKeyAspect() {
        return this.keyAspect;
    }

    @Generated
    public String getSearchGroup() {
        return this.searchGroup;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityAnnotation)) {
            return false;
        }
        EntityAnnotation other = (EntityAnnotation)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$keyAspect = this.getKeyAspect();
        String other$keyAspect = other.getKeyAspect();
        if (this$keyAspect == null ? other$keyAspect != null : !this$keyAspect.equals(other$keyAspect)) {
            return false;
        }
        String this$searchGroup = this.getSearchGroup();
        String other$searchGroup = other.getSearchGroup();
        return !(this$searchGroup == null ? other$searchGroup != null : !this$searchGroup.equals(other$searchGroup));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $keyAspect = this.getKeyAspect();
        result = result * 59 + ($keyAspect == null ? 43 : $keyAspect.hashCode());
        String $searchGroup = this.getSearchGroup();
        result = result * 59 + ($searchGroup == null ? 43 : $searchGroup.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EntityAnnotation(name=" + this.getName() + ", keyAspect=" + this.getKeyAspect() + ", searchGroup=" + this.getSearchGroup() + ")";
    }
}

