/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.key;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataFlowKey
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.key/**Key for a Data Flow*/@Aspect.name=\"dataFlowKey\"record DataFlowKey{/**Workflow manager like azkaban, airflow which orchestrates the flow*/@Searchable.fieldType=\"TEXT_PARTIAL\"orchestrator:string/**Unique Identifier of the data flow*/@Searchable={\"enableAutocomplete\":true,\"fieldType\":\"WORD_GRAM\"}flowId:string/**Cluster where the flow is executed*/@Searchable.fieldType=\"TEXT_PARTIAL\"cluster:string}", SchemaFormatType.PDL);
    private String _orchestratorField = null;
    private String _flowIdField = null;
    private String _clusterField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Orchestrator = SCHEMA.getField("orchestrator");
    private static final RecordDataSchema.Field FIELD_FlowId = SCHEMA.getField("flowId");
    private static final RecordDataSchema.Field FIELD_Cluster = SCHEMA.getField("cluster");

    public DataFlowKey() {
        super(new DataMap(4, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public DataFlowKey(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasOrchestrator() {
        if (this._orchestratorField != null) {
            return true;
        }
        return this._map.containsKey("orchestrator");
    }

    public void removeOrchestrator() {
        this._map.remove("orchestrator");
    }

    @Nullable
    public String getOrchestrator(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getOrchestrator();
            }
            case DEFAULT: 
            case NULL: {
                if (this._orchestratorField != null) {
                    return this._orchestratorField;
                }
                Object __rawValue = this._map.get("orchestrator");
                this._orchestratorField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._orchestratorField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getOrchestrator() {
        if (this._orchestratorField != null) {
            return this._orchestratorField;
        }
        Object __rawValue = this._map.get("orchestrator");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("orchestrator");
        }
        this._orchestratorField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._orchestratorField;
    }

    public DataFlowKey setOrchestrator(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setOrchestrator(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field orchestrator of com.linkedin.metadata.key.DataFlowKey");
                }
                CheckedUtil.putWithoutChecking(this._map, "orchestrator", value);
                this._orchestratorField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeOrchestrator();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "orchestrator", value);
                this._orchestratorField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "orchestrator", value);
                this._orchestratorField = value;
            }
        }
        return this;
    }

    public DataFlowKey setOrchestrator(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field orchestrator of com.linkedin.metadata.key.DataFlowKey to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "orchestrator", value);
        this._orchestratorField = value;
        return this;
    }

    public boolean hasFlowId() {
        if (this._flowIdField != null) {
            return true;
        }
        return this._map.containsKey("flowId");
    }

    public void removeFlowId() {
        this._map.remove("flowId");
    }

    @Nullable
    public String getFlowId(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getFlowId();
            }
            case DEFAULT: 
            case NULL: {
                if (this._flowIdField != null) {
                    return this._flowIdField;
                }
                Object __rawValue = this._map.get("flowId");
                this._flowIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._flowIdField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getFlowId() {
        if (this._flowIdField != null) {
            return this._flowIdField;
        }
        Object __rawValue = this._map.get("flowId");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("flowId");
        }
        this._flowIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._flowIdField;
    }

    public DataFlowKey setFlowId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFlowId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field flowId of com.linkedin.metadata.key.DataFlowKey");
                }
                CheckedUtil.putWithoutChecking(this._map, "flowId", value);
                this._flowIdField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFlowId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "flowId", value);
                this._flowIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "flowId", value);
                this._flowIdField = value;
            }
        }
        return this;
    }

    public DataFlowKey setFlowId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field flowId of com.linkedin.metadata.key.DataFlowKey to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "flowId", value);
        this._flowIdField = value;
        return this;
    }

    public boolean hasCluster() {
        if (this._clusterField != null) {
            return true;
        }
        return this._map.containsKey("cluster");
    }

    public void removeCluster() {
        this._map.remove("cluster");
    }

    @Nullable
    public String getCluster(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getCluster();
            }
            case DEFAULT: 
            case NULL: {
                if (this._clusterField != null) {
                    return this._clusterField;
                }
                Object __rawValue = this._map.get("cluster");
                this._clusterField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._clusterField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getCluster() {
        if (this._clusterField != null) {
            return this._clusterField;
        }
        Object __rawValue = this._map.get("cluster");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("cluster");
        }
        this._clusterField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._clusterField;
    }

    public DataFlowKey setCluster(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCluster(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field cluster of com.linkedin.metadata.key.DataFlowKey");
                }
                CheckedUtil.putWithoutChecking(this._map, "cluster", value);
                this._clusterField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCluster();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "cluster", value);
                this._clusterField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "cluster", value);
                this._clusterField = value;
            }
        }
        return this;
    }

    public DataFlowKey setCluster(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field cluster of com.linkedin.metadata.key.DataFlowKey to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "cluster", value);
        this._clusterField = value;
        return this;
    }

    @Override
    public DataFlowKey clone() throws CloneNotSupportedException {
        DataFlowKey __clone = (DataFlowKey)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataFlowKey copy() throws CloneNotSupportedException {
        DataFlowKey __copy = (DataFlowKey)super.copy();
        __copy._orchestratorField = null;
        __copy._clusterField = null;
        __copy._flowIdField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataFlowKey __objectRef;

        private ChangeListener(DataFlowKey reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "orchestrator": {
                    this.__objectRef._orchestratorField = null;
                    break;
                }
                case "cluster": {
                    this.__objectRef._clusterField = null;
                    break;
                }
                case "flowId": {
                    this.__objectRef._flowIdField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec orchestrator() {
            return new PathSpec(this.getPathComponents(), "orchestrator");
        }

        public PathSpec flowId() {
            return new PathSpec(this.getPathComponents(), "flowId");
        }

        public PathSpec cluster() {
            return new PathSpec(this.getPathComponents(), "cluster");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withOrchestrator() {
            this.getDataMap().put("orchestrator", 1);
            return this;
        }

        public ProjectionMask withFlowId() {
            this.getDataMap().put("flowId", 1);
            return this;
        }

        public ProjectionMask withCluster() {
            this.getDataMap().put("cluster", 1);
            return this;
        }
    }
}

