/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.graph;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.metadata.graph.LineageRelationshipArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EntityLineageResult
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.graph/**A list of lineage information associated with a source Entity*/record EntityLineageResult{/**Start offset of the result set*/start:int/**Number of results in the returned result set*/count:int/**Total number of results in the result set*/total:int/**The number of results that were filtered out of the page (soft-deleted or non-existent)*/filtered:optional int=0/**Indicates whether the results are partial due to reaching the maxRelations limit*/partial:optional boolean/**Relationships in the result set*/relationships:array[/**Metadata about a lineage relationship between two entities*/record LineageRelationship{/**The type of the relationship*/type:string/**Entity that is related via lineage*/entity:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**Optional list of entities between the source and destination node.\nThere can be multiple paths from the source to the destination.*/paths:array[array[com.linkedin.common.Urn]]=[]/**Optional list of entities between the source and destination node*/@deprecated,path:array[com.linkedin.common.Urn]=[]/**Degree of relationship (number of hops to get to entity)\nDeprecated by degrees. degree field is populated by min(degrees) for backward compatibility.*/@deprecated,degree:int=1/**Timestamp for when this lineage relationship was created. Could be null.*/createdOn:optional long/**Urn of the actor that created this lineage relationship. Could be null.*/createdActor:optional com.linkedin.common.Urn/**Timestamp for when this lineage relationship was last updated. Could be null.*/updatedOn:optional long/**Urn of the actor that last updated this lineage relationship. Could be null.*/updatedActor:optional com.linkedin.common.Urn/**Whether this lineage edge is a manual edge.*/isManual:optional boolean/**The different depths at which this entity is discovered in the lineage graph.\nMarked as optional to maintain backward compatibility, but is filled out by implementations. \nReplaces the deprecated field \"degree\".\n*/degrees:optional array[int]/**Marks this relationship as explored during the graph walk*/explored:optional boolean/**Indicates this destination node has additional unexplored child relationships*/truncatedChildren:optional boolean/**Whether this relationship was ignored as a hop while performing the graph walk*/ignoredAsHop:optional boolean}]}", SchemaFormatType.PDL);
    private Integer _startField = null;
    private Integer _countField = null;
    private Integer _totalField = null;
    private Integer _filteredField = null;
    private Boolean _partialField = null;
    private LineageRelationshipArray _relationshipsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Start = SCHEMA.getField("start");
    private static final RecordDataSchema.Field FIELD_Count = SCHEMA.getField("count");
    private static final RecordDataSchema.Field FIELD_Total = SCHEMA.getField("total");
    private static final RecordDataSchema.Field FIELD_Filtered = SCHEMA.getField("filtered");
    private static final Integer DEFAULT_Filtered;
    private static final RecordDataSchema.Field FIELD_Partial;
    private static final RecordDataSchema.Field FIELD_Relationships;

    public EntityLineageResult() {
        super(new DataMap(8, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public EntityLineageResult(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasStart() {
        if (this._startField != null) {
            return true;
        }
        return this._map.containsKey("start");
    }

    public void removeStart() {
        this._map.remove("start");
    }

    @Nullable
    public Integer getStart(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getStart();
            }
            case DEFAULT: 
            case NULL: {
                if (this._startField != null) {
                    return this._startField;
                }
                Object __rawValue = this._map.get("start");
                this._startField = DataTemplateUtil.coerceIntOutput(__rawValue);
                return this._startField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Integer getStart() {
        if (this._startField != null) {
            return this._startField;
        }
        Object __rawValue = this._map.get("start");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("start");
        }
        this._startField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._startField;
    }

    public EntityLineageResult setStart(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setStart(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field start of com.linkedin.metadata.graph.EntityLineageResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "start", DataTemplateUtil.coerceIntInput(value));
                this._startField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeStart();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "start", DataTemplateUtil.coerceIntInput(value));
                this._startField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "start", DataTemplateUtil.coerceIntInput(value));
                this._startField = value;
            }
        }
        return this;
    }

    public EntityLineageResult setStart(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field start of com.linkedin.metadata.graph.EntityLineageResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "start", DataTemplateUtil.coerceIntInput(value));
        this._startField = value;
        return this;
    }

    public EntityLineageResult setStart(int value) {
        CheckedUtil.putWithoutChecking(this._map, "start", DataTemplateUtil.coerceIntInput(value));
        this._startField = value;
        return this;
    }

    public boolean hasCount() {
        if (this._countField != null) {
            return true;
        }
        return this._map.containsKey("count");
    }

    public void removeCount() {
        this._map.remove("count");
    }

    @Nullable
    public Integer getCount(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getCount();
            }
            case DEFAULT: 
            case NULL: {
                if (this._countField != null) {
                    return this._countField;
                }
                Object __rawValue = this._map.get("count");
                this._countField = DataTemplateUtil.coerceIntOutput(__rawValue);
                return this._countField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Integer getCount() {
        if (this._countField != null) {
            return this._countField;
        }
        Object __rawValue = this._map.get("count");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("count");
        }
        this._countField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._countField;
    }

    public EntityLineageResult setCount(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCount(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field count of com.linkedin.metadata.graph.EntityLineageResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "count", DataTemplateUtil.coerceIntInput(value));
                this._countField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCount();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "count", DataTemplateUtil.coerceIntInput(value));
                this._countField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "count", DataTemplateUtil.coerceIntInput(value));
                this._countField = value;
            }
        }
        return this;
    }

    public EntityLineageResult setCount(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field count of com.linkedin.metadata.graph.EntityLineageResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "count", DataTemplateUtil.coerceIntInput(value));
        this._countField = value;
        return this;
    }

    public EntityLineageResult setCount(int value) {
        CheckedUtil.putWithoutChecking(this._map, "count", DataTemplateUtil.coerceIntInput(value));
        this._countField = value;
        return this;
    }

    public boolean hasTotal() {
        if (this._totalField != null) {
            return true;
        }
        return this._map.containsKey("total");
    }

    public void removeTotal() {
        this._map.remove("total");
    }

    @Nullable
    public Integer getTotal(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTotal();
            }
            case DEFAULT: 
            case NULL: {
                if (this._totalField != null) {
                    return this._totalField;
                }
                Object __rawValue = this._map.get("total");
                this._totalField = DataTemplateUtil.coerceIntOutput(__rawValue);
                return this._totalField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Integer getTotal() {
        if (this._totalField != null) {
            return this._totalField;
        }
        Object __rawValue = this._map.get("total");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("total");
        }
        this._totalField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._totalField;
    }

    public EntityLineageResult setTotal(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTotal(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field total of com.linkedin.metadata.graph.EntityLineageResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "total", DataTemplateUtil.coerceIntInput(value));
                this._totalField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTotal();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "total", DataTemplateUtil.coerceIntInput(value));
                this._totalField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "total", DataTemplateUtil.coerceIntInput(value));
                this._totalField = value;
            }
        }
        return this;
    }

    public EntityLineageResult setTotal(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field total of com.linkedin.metadata.graph.EntityLineageResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "total", DataTemplateUtil.coerceIntInput(value));
        this._totalField = value;
        return this;
    }

    public EntityLineageResult setTotal(int value) {
        CheckedUtil.putWithoutChecking(this._map, "total", DataTemplateUtil.coerceIntInput(value));
        this._totalField = value;
        return this;
    }

    public boolean hasFiltered() {
        if (this._filteredField != null) {
            return true;
        }
        return this._map.containsKey("filtered");
    }

    public void removeFiltered() {
        this._map.remove("filtered");
    }

    @Nullable
    public Integer getFiltered(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getFiltered();
            }
            case NULL: {
                if (this._filteredField != null) {
                    return this._filteredField;
                }
                Object __rawValue = this._map.get("filtered");
                this._filteredField = DataTemplateUtil.coerceIntOutput(__rawValue);
                return this._filteredField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nullable
    public Integer getFiltered() {
        if (this._filteredField != null) {
            return this._filteredField;
        }
        Object __rawValue = this._map.get("filtered");
        if (__rawValue == null) {
            return DEFAULT_Filtered;
        }
        this._filteredField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._filteredField;
    }

    public EntityLineageResult setFiltered(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFiltered(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFiltered();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "filtered", DataTemplateUtil.coerceIntInput(value));
                this._filteredField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "filtered", DataTemplateUtil.coerceIntInput(value));
                this._filteredField = value;
            }
        }
        return this;
    }

    public EntityLineageResult setFiltered(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field filtered of com.linkedin.metadata.graph.EntityLineageResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "filtered", DataTemplateUtil.coerceIntInput(value));
        this._filteredField = value;
        return this;
    }

    public EntityLineageResult setFiltered(int value) {
        CheckedUtil.putWithoutChecking(this._map, "filtered", DataTemplateUtil.coerceIntInput(value));
        this._filteredField = value;
        return this;
    }

    public boolean hasPartial() {
        if (this._partialField != null) {
            return true;
        }
        return this._map.containsKey("partial");
    }

    public void removePartial() {
        this._map.remove("partial");
    }

    @Nullable
    public Boolean isPartial(GetMode mode) {
        return this.isPartial();
    }

    @Nullable
    public Boolean isPartial() {
        if (this._partialField != null) {
            return this._partialField;
        }
        Object __rawValue = this._map.get("partial");
        this._partialField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._partialField;
    }

    public EntityLineageResult setPartial(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPartial(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePartial();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "partial", value);
                this._partialField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "partial", value);
                this._partialField = value;
            }
        }
        return this;
    }

    public EntityLineageResult setPartial(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field partial of com.linkedin.metadata.graph.EntityLineageResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "partial", value);
        this._partialField = value;
        return this;
    }

    public EntityLineageResult setPartial(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "partial", value);
        this._partialField = value;
        return this;
    }

    public boolean hasRelationships() {
        if (this._relationshipsField != null) {
            return true;
        }
        return this._map.containsKey("relationships");
    }

    public void removeRelationships() {
        this._map.remove("relationships");
    }

    @Nullable
    public LineageRelationshipArray getRelationships(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getRelationships();
            }
            case DEFAULT: 
            case NULL: {
                if (this._relationshipsField != null) {
                    return this._relationshipsField;
                }
                Object __rawValue = this._map.get("relationships");
                this._relationshipsField = __rawValue == null ? null : new LineageRelationshipArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._relationshipsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public LineageRelationshipArray getRelationships() {
        if (this._relationshipsField != null) {
            return this._relationshipsField;
        }
        Object __rawValue = this._map.get("relationships");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("relationships");
        }
        this._relationshipsField = __rawValue == null ? null : new LineageRelationshipArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._relationshipsField;
    }

    public EntityLineageResult setRelationships(@Nullable LineageRelationshipArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRelationships(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field relationships of com.linkedin.metadata.graph.EntityLineageResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "relationships", value.data());
                this._relationshipsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRelationships();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "relationships", value.data());
                this._relationshipsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "relationships", value.data());
                this._relationshipsField = value;
            }
        }
        return this;
    }

    public EntityLineageResult setRelationships(@Nonnull LineageRelationshipArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field relationships of com.linkedin.metadata.graph.EntityLineageResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "relationships", value.data());
        this._relationshipsField = value;
        return this;
    }

    @Override
    public EntityLineageResult clone() throws CloneNotSupportedException {
        EntityLineageResult __clone = (EntityLineageResult)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public EntityLineageResult copy() throws CloneNotSupportedException {
        EntityLineageResult __copy = (EntityLineageResult)super.copy();
        __copy._relationshipsField = null;
        __copy._totalField = null;
        __copy._filteredField = null;
        __copy._startField = null;
        __copy._countField = null;
        __copy._partialField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_Partial = SCHEMA.getField("partial");
        FIELD_Relationships = SCHEMA.getField("relationships");
        DEFAULT_Filtered = DataTemplateUtil.coerceIntOutput(FIELD_Filtered.getDefault());
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final EntityLineageResult __objectRef;

        private ChangeListener(EntityLineageResult reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "relationships": {
                    this.__objectRef._relationshipsField = null;
                    break;
                }
                case "total": {
                    this.__objectRef._totalField = null;
                    break;
                }
                case "filtered": {
                    this.__objectRef._filteredField = null;
                    break;
                }
                case "start": {
                    this.__objectRef._startField = null;
                    break;
                }
                case "count": {
                    this.__objectRef._countField = null;
                    break;
                }
                case "partial": {
                    this.__objectRef._partialField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec start() {
            return new PathSpec(this.getPathComponents(), "start");
        }

        public PathSpec count() {
            return new PathSpec(this.getPathComponents(), "count");
        }

        public PathSpec total() {
            return new PathSpec(this.getPathComponents(), "total");
        }

        public PathSpec filtered() {
            return new PathSpec(this.getPathComponents(), "filtered");
        }

        public PathSpec partial() {
            return new PathSpec(this.getPathComponents(), "partial");
        }

        public LineageRelationshipArray.Fields relationships() {
            return new LineageRelationshipArray.Fields(this.getPathComponents(), "relationships");
        }

        public PathSpec relationships(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "relationships");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private LineageRelationshipArray.ProjectionMask _relationshipsMask;

        ProjectionMask() {
            super(8);
        }

        public ProjectionMask withStart() {
            this.getDataMap().put("start", 1);
            return this;
        }

        public ProjectionMask withCount() {
            this.getDataMap().put("count", 1);
            return this;
        }

        public ProjectionMask withTotal() {
            this.getDataMap().put("total", 1);
            return this;
        }

        public ProjectionMask withFiltered() {
            this.getDataMap().put("filtered", 1);
            return this;
        }

        public ProjectionMask withPartial() {
            this.getDataMap().put("partial", 1);
            return this;
        }

        public ProjectionMask withRelationships(Function<LineageRelationshipArray.ProjectionMask, LineageRelationshipArray.ProjectionMask> nestedMask) {
            this._relationshipsMask = nestedMask.apply(this._relationshipsMask == null ? LineageRelationshipArray.createMask() : this._relationshipsMask);
            this.getDataMap().put("relationships", this._relationshipsMask.getDataMap());
            return this;
        }

        public ProjectionMask withRelationships() {
            this._relationshipsMask = null;
            this.getDataMap().put("relationships", 1);
            return this;
        }

        public ProjectionMask withRelationships(Function<LineageRelationshipArray.ProjectionMask, LineageRelationshipArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._relationshipsMask = nestedMask.apply(this._relationshipsMask == null ? LineageRelationshipArray.createMask() : this._relationshipsMask);
            this.getDataMap().put("relationships", this._relationshipsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("relationships").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("relationships").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withRelationships(Integer start, Integer count) {
            this._relationshipsMask = null;
            this.getDataMap().put("relationships", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("relationships").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("relationships").put("$count", count);
            }
            return this;
        }
    }
}

