/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.validation;

import com.google.common.collect.ImmutableSet;
import com.linkedin.common.urn.Urn;
import com.linkedin.entity.Aspect;
import com.linkedin.events.metadata.ChangeType;
import com.linkedin.metadata.Constants;
import com.linkedin.metadata.aspect.RetrieverContext;
import com.linkedin.metadata.aspect.batch.BatchItem;
import com.linkedin.metadata.aspect.batch.ChangeMCP;
import com.linkedin.metadata.aspect.plugins.config.AspectPluginConfig;
import com.linkedin.metadata.aspect.plugins.validation.AspectPayloadValidator;
import com.linkedin.metadata.aspect.plugins.validation.AspectValidationException;
import com.linkedin.metadata.aspect.plugins.validation.ValidationExceptionCollection;
import com.linkedin.policy.DataHubPolicyInfo;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemPolicyValidator
extends AspectPayloadValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SystemPolicyValidator.class);
    @Nonnull
    private AspectPluginConfig config;
    @Nullable
    private Set<Urn> systemPolicyUrns;
    private Set<ChangeType> MODIFY_CHANGE_TYPES = ImmutableSet.of(ChangeType.PATCH, ChangeType.UPDATE, ChangeType.UPSERT);

    @Override
    protected Stream<AspectValidationException> validateProposedAspects(@Nonnull Collection<? extends BatchItem> mcpItems, @Nonnull RetrieverContext retrieverContext) {
        ValidationExceptionCollection exceptions = ValidationExceptionCollection.newCollection();
        mcpItems.forEach(i -> {
            DataHubPolicyInfo dataHubPolicyInfo;
            Aspect aspect;
            Urn entityUrn = i.getUrn();
            if (this.isSystemPolicy(entityUrn) && ChangeType.DELETE.equals((Object)i.getChangeType())) {
                exceptions.addException(AspectValidationException.forItem(i, "System policies can not be deleted."));
            } else if (!(!this.MODIFY_CHANGE_TYPES.contains((Object)i.getChangeType()) || i.getAuditStamp() != null && "urn:li:corpuser:__datahub_system".equals(i.getAuditStamp().getActor().toString()) || (aspect = retrieverContext.getAspectRetriever().getLatestAspectObject(entityUrn, "dataHubPolicyInfo")) == null || (dataHubPolicyInfo = new DataHubPolicyInfo(aspect.data())).isEditable().booleanValue())) {
                exceptions.addException(AspectValidationException.forItem(i, "Attempting to edit not editable policy."));
            }
        });
        return exceptions.streamAllExceptions();
    }

    private boolean isSystemPolicy(Urn entityUrn) {
        return Constants.SYSTEM_POLICY_ZERO.equals(entityUrn) || Constants.SYSTEM_POLICY_ONE.equals(entityUrn) || this.systemPolicyUrns != null && this.systemPolicyUrns.contains(entityUrn);
    }

    @Override
    protected Stream<AspectValidationException> validatePreCommitAspects(@Nonnull Collection<ChangeMCP> changeMCPs, @Nonnull RetrieverContext retrieverContext) {
        return Stream.empty();
    }

    @Override
    @Generated
    public SystemPolicyValidator setConfig(@Nonnull AspectPluginConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
        return this;
    }

    @Generated
    public SystemPolicyValidator setSystemPolicyUrns(@Nullable Set<Urn> systemPolicyUrns) {
        this.systemPolicyUrns = systemPolicyUrns;
        return this;
    }

    @Generated
    public SystemPolicyValidator setMODIFY_CHANGE_TYPES(Set<ChangeType> MODIFY_CHANGE_TYPES) {
        this.MODIFY_CHANGE_TYPES = MODIFY_CHANGE_TYPES;
        return this;
    }

    @Override
    @Nonnull
    @Generated
    public AspectPluginConfig getConfig() {
        return this.config;
    }

    @Nullable
    @Generated
    public Set<Urn> getSystemPolicyUrns() {
        return this.systemPolicyUrns;
    }

    @Generated
    public Set<ChangeType> getMODIFY_CHANGE_TYPES() {
        return this.MODIFY_CHANGE_TYPES;
    }
}

