/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.patch.template.dataset;

import com.linkedin.common.AuditStamp;
import com.linkedin.common.urn.UrnUtils;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.metadata.aspect.patch.template.CompoundKeyTemplate;
import com.linkedin.metadata.aspect.patch.template.common.GlobalTagsTemplate;
import com.linkedin.metadata.aspect.patch.template.common.GlossaryTermsTemplate;
import com.linkedin.schema.EditableSchemaFieldInfoArray;
import com.linkedin.schema.EditableSchemaMetadata;
import datahub.shaded.jackson.databind.JsonNode;
import datahub.shaded.jackson.databind.node.ObjectNode;
import java.util.Collections;
import javax.annotation.Nonnull;

public class EditableSchemaMetadataTemplate
extends CompoundKeyTemplate<EditableSchemaMetadata> {
    private static final String EDITABLE_SCHEMA_FIELD_INFO_FIELD_NAME = "editableSchemaFieldInfo";
    private static final String FIELDPATH_FIELD_NAME = "fieldPath";
    private static final String GLOBAL_TAGS_FIELD_NAME = "globalTags";
    private static final String GLOSSARY_TERMS_FIELD_NAME = "glossaryTerms";

    @Override
    public EditableSchemaMetadata getSubtype(RecordTemplate recordTemplate) throws ClassCastException {
        if (recordTemplate instanceof EditableSchemaMetadata) {
            return (EditableSchemaMetadata)recordTemplate;
        }
        throw new ClassCastException("Unable to cast RecordTemplate to EditableSchemaMetadata");
    }

    @Override
    public Class<EditableSchemaMetadata> getTemplateType() {
        return EditableSchemaMetadata.class;
    }

    @Override
    @Nonnull
    public EditableSchemaMetadata getDefault() {
        AuditStamp auditStamp = new AuditStamp().setActor(UrnUtils.getUrn("urn:li:corpuser:__datahub_system")).setTime(System.currentTimeMillis());
        return new EditableSchemaMetadata().setCreated(auditStamp).setLastModified(auditStamp).setEditableSchemaFieldInfo(new EditableSchemaFieldInfoArray());
    }

    @Override
    @Nonnull
    public JsonNode transformFields(JsonNode baseNode) {
        JsonNode transformedNode = this.arrayFieldToMap(baseNode, EDITABLE_SCHEMA_FIELD_INFO_FIELD_NAME, Collections.singletonList(FIELDPATH_FIELD_NAME));
        GlobalTagsTemplate globalTagsTemplate = new GlobalTagsTemplate();
        GlossaryTermsTemplate glossaryTermsTemplate = new GlossaryTermsTemplate();
        transformedNode.get(EDITABLE_SCHEMA_FIELD_INFO_FIELD_NAME).elements().forEachRemaining(node -> {
            JsonNode globalTags = node.get(GLOBAL_TAGS_FIELD_NAME);
            JsonNode glossaryTerms = node.get(GLOSSARY_TERMS_FIELD_NAME);
            if (globalTags != null) {
                ((ObjectNode)node).set(GLOBAL_TAGS_FIELD_NAME, globalTagsTemplate.transformFields(node.get(GLOBAL_TAGS_FIELD_NAME)));
            }
            if (glossaryTerms != null) {
                ((ObjectNode)node).set(GLOSSARY_TERMS_FIELD_NAME, glossaryTermsTemplate.transformFields(node.get(GLOSSARY_TERMS_FIELD_NAME)));
            }
        });
        return transformedNode;
    }

    @Override
    @Nonnull
    public JsonNode rebaseFields(JsonNode patched) {
        JsonNode rebasedNode = this.transformedMapToArray(patched, EDITABLE_SCHEMA_FIELD_INFO_FIELD_NAME, Collections.singletonList(FIELDPATH_FIELD_NAME));
        GlobalTagsTemplate globalTagsTemplate = new GlobalTagsTemplate();
        GlossaryTermsTemplate glossaryTermsTemplate = new GlossaryTermsTemplate();
        rebasedNode.get(EDITABLE_SCHEMA_FIELD_INFO_FIELD_NAME).elements().forEachRemaining(node -> {
            JsonNode globalTags = node.get(GLOBAL_TAGS_FIELD_NAME);
            JsonNode glossaryTerms = node.get(GLOSSARY_TERMS_FIELD_NAME);
            if (globalTags != null) {
                ((ObjectNode)node).set(GLOBAL_TAGS_FIELD_NAME, globalTagsTemplate.rebaseFields(globalTags));
            }
            if (glossaryTerms != null) {
                ((ObjectNode)node).set(GLOSSARY_TERMS_FIELD_NAME, glossaryTermsTemplate.rebaseFields(glossaryTerms));
            }
        });
        return rebasedNode;
    }
}

