/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.patch.builder;

import com.linkedin.common.TimeStamp;
import com.linkedin.metadata.aspect.patch.PatchOperationType;
import com.linkedin.metadata.aspect.patch.builder.AbstractMultiFieldPatchBuilder;
import com.linkedin.metadata.aspect.patch.builder.CustomPropertiesPatchBuilder;
import com.linkedin.metadata.aspect.patch.builder.subtypesupport.CustomPropertiesPatchBuilderSupport;
import datahub.shaded.jackson.databind.node.JsonNodeFactory;
import datahub.shaded.jackson.databind.node.ObjectNode;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public class DataFlowInfoPatchBuilder
extends AbstractMultiFieldPatchBuilder<DataFlowInfoPatchBuilder>
implements CustomPropertiesPatchBuilderSupport<DataFlowInfoPatchBuilder> {
    public static final String BASE_PATH = "/";
    public static final String NAME_KEY = "name";
    public static final String DESCRIPTION_KEY = "description";
    public static final String PROJECT_KEY = "project";
    public static final String CREATED_KEY = "created";
    public static final String LAST_MODIFIED_KEY = "lastModified";
    public static final String TIME_KEY = "time";
    public static final String ACTOR_KEY = "actor";
    private CustomPropertiesPatchBuilder<DataFlowInfoPatchBuilder> customPropertiesPatchBuilder = new CustomPropertiesPatchBuilder<DataFlowInfoPatchBuilder>(this);

    public DataFlowInfoPatchBuilder setName(@Nonnull String name) {
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/name", JsonNodeFactory.instance.textNode(name)));
        return this;
    }

    public DataFlowInfoPatchBuilder setDescription(@Nullable String description) {
        if (description == null) {
            this.pathValues.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), "/description", null));
        } else {
            this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/description", JsonNodeFactory.instance.textNode(description)));
        }
        return this;
    }

    public DataFlowInfoPatchBuilder setProject(@Nullable String project) {
        if (project == null) {
            this.pathValues.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), "/project", null));
        } else {
            this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/project", JsonNodeFactory.instance.textNode(project)));
        }
        return this;
    }

    public DataFlowInfoPatchBuilder setCreated(@Nullable TimeStamp created) {
        if (created == null) {
            this.pathValues.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), "/created", null));
        } else {
            ObjectNode createdNode = JsonNodeFactory.instance.objectNode();
            createdNode.put(TIME_KEY, created.getTime());
            if (created.getActor() != null) {
                createdNode.put(ACTOR_KEY, created.getActor().toString());
            }
            this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/created", createdNode));
        }
        return this;
    }

    public DataFlowInfoPatchBuilder setLastModified(@Nullable TimeStamp lastModified) {
        ObjectNode lastModifiedNode = JsonNodeFactory.instance.objectNode();
        if (lastModified == null) {
            this.pathValues.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), "/lastModified", null));
        } else {
            lastModifiedNode.put(TIME_KEY, lastModified.getTime());
            if (lastModified.getActor() != null) {
                lastModifiedNode.put(ACTOR_KEY, lastModified.getActor().toString());
            }
            this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/lastModified", lastModifiedNode));
        }
        return this;
    }

    @Override
    protected String getAspectName() {
        return "dataFlowInfo";
    }

    @Override
    protected String getEntityType() {
        return "dataFlow";
    }

    @Override
    public DataFlowInfoPatchBuilder addCustomProperty(@Nonnull String key, @Nonnull String value) {
        this.customPropertiesPatchBuilder.addProperty(key, value);
        return this;
    }

    @Override
    public DataFlowInfoPatchBuilder removeCustomProperty(@Nonnull String key) {
        this.customPropertiesPatchBuilder.removeProperty(key);
        return this;
    }

    @Override
    public DataFlowInfoPatchBuilder setCustomProperties(Map<String, String> properties) {
        this.customPropertiesPatchBuilder.setProperties(properties);
        return this;
    }
}

