/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect;

import com.linkedin.common.Ownership;
import com.linkedin.common.Status;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.HasTyperefInfo;
import com.linkedin.data.template.TyperefInfo;
import com.linkedin.data.template.UnionTemplate;
import com.linkedin.metadata.key.TagKey;
import com.linkedin.tag.TagProperties;
import java.util.List;
import java.util.function.Function;

public class TagAspect
extends UnionTemplate
implements HasTyperefInfo {
    private static final UnionDataSchema SCHEMA = (UnionDataSchema)DataTemplateUtil.parseSchema("union[{namespace com.linkedin.metadata.key/**Key for a Tag*/@Aspect.name=\"tagKey\"record TagKey{/**The tag name, which serves as a unique id*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldName\":\"id\",\"fieldType\":\"WORD_GRAM\"}name:string}}{namespace com.linkedin.common/**Ownership information of an entity.*/@Aspect.name=\"ownership\"record Ownership{/**List of owners of the entity.*/owners:array[/**Ownership information*/record Owner{/**Owner URN, e.g. urn:li:corpuser:ldap, urn:li:corpGroup:group_name, and urn:li:multiProduct:mp_name\n(Caveat: only corpuser is currently supported in the frontend.)*/@Relationship={\"entityTypes\":[\"corpuser\",\"corpGroup\"],\"name\":\"OwnedBy\"}@Searchable={\"addToFilters\":true,\"fieldName\":\"owners\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Owned By\",\"hasValuesFieldName\":\"hasOwners\",\"queryByDefault\":false,\"searchTier\":2}owner:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The type of the ownership*/@deprecated,type:/**Asset owner types*/enum OwnershipType{/**Set when ownership type is unknown or a when new one is specified as an ownership type entity for which we have no\nenum value for. This is used for backwards compatibility*/CUSTOM/**person or group who is responsible for technical aspects of the asset.*/TECHNICAL_OWNER/**A person or group who is responsible for logical, or business related, aspects of the asset.*/BUSINESS_OWNER/**A steward, expert, or delegate responsible for the asset.*/DATA_STEWARD/**No specific type associated to the owner.*/NONE/**A person or group that is in charge of developing the code\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DEVELOPER/**A person or group that is owning the data\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DATAOWNER/**A person or a group that overseas the operation, e.g. a DBA or SRE.\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DELEGATE/**A person, group, or service that produces/generates the data\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,PRODUCER/**A person, group, or service that consumes the data\nDeprecated! Use TECHNICAL_OWNER or BUSINESS_OWNER instead.*/@deprecated,CONSUMER/**A person or a group that has direct business interest\nDeprecated! Use TECHNICAL_OWNER, BUSINESS_OWNER, or STEWARD instead.*/@deprecated,STAKEHOLDER}/**The type of the ownership\nUrn of type O*/@Relationship={\"entityTypes\":[\"ownershipType\"],\"name\":\"ownershipType\"}typeUrn:optional Urn/**Source information for the ownership*/source:optional/**Source/provider of the ownership information*/record OwnershipSource{/**The type of the source*/type:enum OwnershipSourceType{/**Auditing system or audit logs*/AUDIT/**Database, e.g. GRANTS table*/DATABASE/**File system, e.g. file/directory owner*/FILE_SYSTEM/**Issue tracking system, e.g. Jira*/ISSUE_TRACKING_SYSTEM/**Manually provided by a user*/MANUAL/**Other ownership-like service, e.g. Nuage, ACL service etc*/SERVICE/**SCM system, e.g. GIT, SVN*/SOURCE_CONTROL/**Other sources*/OTHER}/**A reference URL for the source*/url:optional string}/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"ownerAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"ownerAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"ownerAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional/**Information about who, why, and how this metadata was applied*/record MetadataAttribution{/**When this metadata was updated.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) responsible for applying the assocated metadata. This can\neither be a user (in case of UI edits) or the datahub system for automation.*/actor:Urn/**The DataHub source responsible for applying the associated metadata. This will only be filled out\nwhen a DataHub source is responsible. This includes the specific metadata test urn, the automation urn.*/source:optional Urn/**The details associated with why this metadata was applied. For example, this could include\nthe actual regex rule, sql statement, ingestion pipeline ID, etc.*/sourceDetail:map[string,string]={}}}]/**Ownership type to Owners map, populated via mutation hook.*/@Searchable.`/$key`={\"fieldType\":\"MAP_ARRAY\",\"queryByDefault\":false}ownerTypes:optional map[string,array[Urn]]={}/**Audit stamp containing who last modified the record and when. A value of 0 in the time field indicates missing data.*/lastModified:/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:Time/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}}}{namespace com.linkedin.tag/**Properties associated with a Tag*/@Aspect.name=\"tagProperties\"record TagProperties{/**Display name of the tag*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\",\"searchLabel\":\"entityName\",\"searchTier\":1}name:string/**Documentation of the tag*/@Searchable={}description:optional string/**The color associated with the Tag in Hex. For example #FFFFFF.*/colorHex:optional string}}{namespace com.linkedin.common/**The lifecycle status metadata of an entity, e.g. dataset, metric, feature, etc.\nThis aspect is used to represent soft deletes conventionally.*/@Aspect.name=\"status\"record Status{/**Whether the entity has been removed (soft-deleted).*/@Searchable.fieldType=\"BOOLEAN\"removed:boolean=false}}]", SchemaFormatType.PDL);
    private TagKey _tagKeyMember = null;
    private Ownership _ownershipMember = null;
    private TagProperties _tagPropertiesMember = null;
    private Status _statusMember = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final DataSchema MEMBER_TagKey = SCHEMA.getTypeByMemberKey("com.linkedin.metadata.key.TagKey");
    public static final String MEMBERKEY_TagKey = "com.linkedin.metadata.key.TagKey";
    private static final DataSchema MEMBER_Ownership = SCHEMA.getTypeByMemberKey("com.linkedin.common.Ownership");
    public static final String MEMBERKEY_Ownership = "com.linkedin.common.Ownership";
    private static final DataSchema MEMBER_TagProperties = SCHEMA.getTypeByMemberKey("com.linkedin.tag.TagProperties");
    public static final String MEMBERKEY_TagProperties = "com.linkedin.tag.TagProperties";
    private static final DataSchema MEMBER_Status = SCHEMA.getTypeByMemberKey("com.linkedin.common.Status");
    public static final String MEMBERKEY_Status = "com.linkedin.common.Status";
    private static final TyperefInfo TYPEREFINFO = new UnionTyperefInfo();

    public TagAspect() {
        super(new DataMap(2, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public TagAspect(Object data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static UnionDataSchema dataSchema() {
        return SCHEMA;
    }

    public static TagAspect create(TagKey value) {
        TagAspect newUnion = new TagAspect();
        newUnion.setTagKey(value);
        return newUnion;
    }

    public boolean isTagKey() {
        return this.memberIs(MEMBERKEY_TagKey);
    }

    public TagKey getTagKey() {
        this.checkNotNull();
        if (this._tagKeyMember != null) {
            return this._tagKeyMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_TagKey);
        this._tagKeyMember = __rawValue == null ? null : new TagKey(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._tagKeyMember;
    }

    public void setTagKey(TagKey value) {
        this.checkNotNull();
        this._map.clear();
        this._tagKeyMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_TagKey, value.data());
    }

    public static TagAspect create(Ownership value) {
        TagAspect newUnion = new TagAspect();
        newUnion.setOwnership(value);
        return newUnion;
    }

    public boolean isOwnership() {
        return this.memberIs(MEMBERKEY_Ownership);
    }

    public Ownership getOwnership() {
        this.checkNotNull();
        if (this._ownershipMember != null) {
            return this._ownershipMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_Ownership);
        this._ownershipMember = __rawValue == null ? null : new Ownership(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._ownershipMember;
    }

    public void setOwnership(Ownership value) {
        this.checkNotNull();
        this._map.clear();
        this._ownershipMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_Ownership, value.data());
    }

    public static TagAspect create(TagProperties value) {
        TagAspect newUnion = new TagAspect();
        newUnion.setTagProperties(value);
        return newUnion;
    }

    public boolean isTagProperties() {
        return this.memberIs(MEMBERKEY_TagProperties);
    }

    public TagProperties getTagProperties() {
        this.checkNotNull();
        if (this._tagPropertiesMember != null) {
            return this._tagPropertiesMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_TagProperties);
        this._tagPropertiesMember = __rawValue == null ? null : new TagProperties(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._tagPropertiesMember;
    }

    public void setTagProperties(TagProperties value) {
        this.checkNotNull();
        this._map.clear();
        this._tagPropertiesMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_TagProperties, value.data());
    }

    public static TagAspect create(Status value) {
        TagAspect newUnion = new TagAspect();
        newUnion.setStatus(value);
        return newUnion;
    }

    public boolean isStatus() {
        return this.memberIs(MEMBERKEY_Status);
    }

    public Status getStatus() {
        this.checkNotNull();
        if (this._statusMember != null) {
            return this._statusMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_Status);
        this._statusMember = __rawValue == null ? null : new Status(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._statusMember;
    }

    public void setStatus(Status value) {
        this.checkNotNull();
        this._map.clear();
        this._statusMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_Status, value.data());
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public TagAspect clone() throws CloneNotSupportedException {
        TagAspect __clone = (TagAspect)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public TagAspect copy() throws CloneNotSupportedException {
        TagAspect __copy = (TagAspect)super.copy();
        __copy._tagKeyMember = null;
        __copy._ownershipMember = null;
        __copy._tagPropertiesMember = null;
        __copy._statusMember = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    @Override
    public TyperefInfo typerefInfo() {
        return TYPEREFINFO;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final TagAspect __objectRef;

        private ChangeListener(TagAspect reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "com.linkedin.metadata.key.TagKey": {
                    this.__objectRef._tagKeyMember = null;
                    break;
                }
                case "com.linkedin.common.Ownership": {
                    this.__objectRef._ownershipMember = null;
                    break;
                }
                case "com.linkedin.tag.TagProperties": {
                    this.__objectRef._tagPropertiesMember = null;
                    break;
                }
                case "com.linkedin.common.Status": {
                    this.__objectRef._statusMember = null;
                }
            }
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private TagKey.ProjectionMask _TagKeyMask;
        private Ownership.ProjectionMask _OwnershipMask;
        private TagProperties.ProjectionMask _TagPropertiesMask;
        private Status.ProjectionMask _StatusMask;

        ProjectionMask() {
            super(6);
        }

        public ProjectionMask withTagKey(Function<TagKey.ProjectionMask, TagKey.ProjectionMask> nestedMask) {
            this._TagKeyMask = nestedMask.apply(this._TagKeyMask == null ? TagKey.createMask() : this._TagKeyMask);
            this.getDataMap().put(TagAspect.MEMBERKEY_TagKey, this._TagKeyMask.getDataMap());
            return this;
        }

        public ProjectionMask withOwnership(Function<Ownership.ProjectionMask, Ownership.ProjectionMask> nestedMask) {
            this._OwnershipMask = nestedMask.apply(this._OwnershipMask == null ? Ownership.createMask() : this._OwnershipMask);
            this.getDataMap().put(TagAspect.MEMBERKEY_Ownership, this._OwnershipMask.getDataMap());
            return this;
        }

        public ProjectionMask withTagProperties(Function<TagProperties.ProjectionMask, TagProperties.ProjectionMask> nestedMask) {
            this._TagPropertiesMask = nestedMask.apply(this._TagPropertiesMask == null ? TagProperties.createMask() : this._TagPropertiesMask);
            this.getDataMap().put(TagAspect.MEMBERKEY_TagProperties, this._TagPropertiesMask.getDataMap());
            return this;
        }

        public ProjectionMask withStatus(Function<Status.ProjectionMask, Status.ProjectionMask> nestedMask) {
            this._StatusMask = nestedMask.apply(this._StatusMask == null ? Status.createMask() : this._StatusMask);
            this.getDataMap().put(TagAspect.MEMBERKEY_Status, this._StatusMask.getDataMap());
            return this;
        }
    }

    private static final class UnionTyperefInfo
    extends TyperefInfo {
        private static final TyperefDataSchema SCHEMA = (TyperefDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.aspect/**A union of all supported metadata aspects for a tag*/typeref TagAspect=union[{namespace com.linkedin.metadata.key/**Key for a Tag*/@Aspect.name=\"tagKey\"record TagKey{/**The tag name, which serves as a unique id*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldName\":\"id\",\"fieldType\":\"WORD_GRAM\"}name:string}}{namespace com.linkedin.common/**Ownership information of an entity.*/@Aspect.name=\"ownership\"record Ownership{/**List of owners of the entity.*/owners:array[/**Ownership information*/record Owner{/**Owner URN, e.g. urn:li:corpuser:ldap, urn:li:corpGroup:group_name, and urn:li:multiProduct:mp_name\n(Caveat: only corpuser is currently supported in the frontend.)*/@Relationship={\"entityTypes\":[\"corpuser\",\"corpGroup\"],\"name\":\"OwnedBy\"}@Searchable={\"addToFilters\":true,\"fieldName\":\"owners\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Owned By\",\"hasValuesFieldName\":\"hasOwners\",\"queryByDefault\":false,\"searchTier\":2}owner:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The type of the ownership*/@deprecated,type:/**Asset owner types*/enum OwnershipType{/**Set when ownership type is unknown or a when new one is specified as an ownership type entity for which we have no\nenum value for. This is used for backwards compatibility*/CUSTOM/**person or group who is responsible for technical aspects of the asset.*/TECHNICAL_OWNER/**A person or group who is responsible for logical, or business related, aspects of the asset.*/BUSINESS_OWNER/**A steward, expert, or delegate responsible for the asset.*/DATA_STEWARD/**No specific type associated to the owner.*/NONE/**A person or group that is in charge of developing the code\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DEVELOPER/**A person or group that is owning the data\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DATAOWNER/**A person or a group that overseas the operation, e.g. a DBA or SRE.\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DELEGATE/**A person, group, or service that produces/generates the data\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,PRODUCER/**A person, group, or service that consumes the data\nDeprecated! Use TECHNICAL_OWNER or BUSINESS_OWNER instead.*/@deprecated,CONSUMER/**A person or a group that has direct business interest\nDeprecated! Use TECHNICAL_OWNER, BUSINESS_OWNER, or STEWARD instead.*/@deprecated,STAKEHOLDER}/**The type of the ownership\nUrn of type O*/@Relationship={\"entityTypes\":[\"ownershipType\"],\"name\":\"ownershipType\"}typeUrn:optional Urn/**Source information for the ownership*/source:optional/**Source/provider of the ownership information*/record OwnershipSource{/**The type of the source*/type:enum OwnershipSourceType{/**Auditing system or audit logs*/AUDIT/**Database, e.g. GRANTS table*/DATABASE/**File system, e.g. file/directory owner*/FILE_SYSTEM/**Issue tracking system, e.g. Jira*/ISSUE_TRACKING_SYSTEM/**Manually provided by a user*/MANUAL/**Other ownership-like service, e.g. Nuage, ACL service etc*/SERVICE/**SCM system, e.g. GIT, SVN*/SOURCE_CONTROL/**Other sources*/OTHER}/**A reference URL for the source*/url:optional string}/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"ownerAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"ownerAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"ownerAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional/**Information about who, why, and how this metadata was applied*/record MetadataAttribution{/**When this metadata was updated.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) responsible for applying the assocated metadata. This can\neither be a user (in case of UI edits) or the datahub system for automation.*/actor:Urn/**The DataHub source responsible for applying the associated metadata. This will only be filled out\nwhen a DataHub source is responsible. This includes the specific metadata test urn, the automation urn.*/source:optional Urn/**The details associated with why this metadata was applied. For example, this could include\nthe actual regex rule, sql statement, ingestion pipeline ID, etc.*/sourceDetail:map[string,string]={}}}]/**Ownership type to Owners map, populated via mutation hook.*/@Searchable.`/$key`={\"fieldType\":\"MAP_ARRAY\",\"queryByDefault\":false}ownerTypes:optional map[string,array[Urn]]={}/**Audit stamp containing who last modified the record and when. A value of 0 in the time field indicates missing data.*/lastModified:/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:Time/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}}}{namespace com.linkedin.tag/**Properties associated with a Tag*/@Aspect.name=\"tagProperties\"record TagProperties{/**Display name of the tag*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\",\"searchLabel\":\"entityName\",\"searchTier\":1}name:string/**Documentation of the tag*/@Searchable={}description:optional string/**The color associated with the Tag in Hex. For example #FFFFFF.*/colorHex:optional string}}{namespace com.linkedin.common/**The lifecycle status metadata of an entity, e.g. dataset, metric, feature, etc.\nThis aspect is used to represent soft deletes conventionally.*/@Aspect.name=\"status\"record Status{/**Whether the entity has been removed (soft-deleted).*/@Searchable.fieldType=\"BOOLEAN\"removed:boolean=false}}]", SchemaFormatType.PDL);

        public UnionTyperefInfo() {
            super(SCHEMA);
        }

        public static TyperefDataSchema dataSchema() {
            return SCHEMA;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public TagKey.Fields TagKey() {
            return new TagKey.Fields(this.getPathComponents(), TagAspect.MEMBERKEY_TagKey);
        }

        public Ownership.Fields Ownership() {
            return new Ownership.Fields(this.getPathComponents(), TagAspect.MEMBERKEY_Ownership);
        }

        public TagProperties.Fields TagProperties() {
            return new TagProperties.Fields(this.getPathComponents(), TagAspect.MEMBERKEY_TagProperties);
        }

        public Status.Fields Status() {
            return new Status.Fields(this.getPathComponents(), TagAspect.MEMBERKEY_Status);
        }
    }
}

