/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.knowledge;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.WrappingArrayTemplate;
import com.linkedin.knowledge.RelatedDocument;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class RelatedDocumentArray
extends WrappingArrayTemplate<RelatedDocument> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("array[{namespace com.linkedin.knowledge/**An document referenced by or related to another document\nNote that this does NOT include child documents. */record RelatedDocument{/**The document referenced by or related to the document. */@Relationship={\"entityTypes\":[\"document\"],\"name\":\"RelatedDocument\"}@Searchable.fieldName=\"relatedDocuments\"document:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}}}]", SchemaFormatType.PDL);

    public RelatedDocumentArray() {
        this(new DataList());
    }

    public RelatedDocumentArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public RelatedDocumentArray(Collection<RelatedDocument> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public RelatedDocumentArray(DataList data) {
        super(data, SCHEMA, RelatedDocument.class);
    }

    public RelatedDocumentArray(RelatedDocument first, RelatedDocument ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    public static ArrayDataSchema dataSchema() {
        return SCHEMA;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public RelatedDocumentArray clone() throws CloneNotSupportedException {
        RelatedDocumentArray __clone = (RelatedDocumentArray)super.clone();
        return __clone;
    }

    @Override
    public RelatedDocumentArray copy() throws CloneNotSupportedException {
        RelatedDocumentArray __copy = (RelatedDocumentArray)super.copy();
        return __copy;
    }

    @Override
    protected RelatedDocument coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return object == null ? null : new RelatedDocument(DataTemplateUtil.castOrThrow(object, DataMap.class));
    }

    public static class ProjectionMask
    extends MaskMap {
        private RelatedDocument.ProjectionMask _itemsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withItems(Function<RelatedDocument.ProjectionMask, RelatedDocument.ProjectionMask> nestedMask) {
            this._itemsMask = nestedMask.apply(this._itemsMask == null ? RelatedDocument.createMask() : this._itemsMask);
            this.getDataMap().put("$*", this._itemsMask.getDataMap());
            return this;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public RelatedDocument.Fields items() {
            return new RelatedDocument.Fields(this.getPathComponents(), PathSpec.WILDCARD);
        }
    }
}

