/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.knowledge;

import com.linkedin.common.AuditStamp;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import com.linkedin.knowledge.DocumentContents;
import com.linkedin.knowledge.DocumentSource;
import com.linkedin.knowledge.DocumentStatus;
import com.linkedin.knowledge.DraftOf;
import com.linkedin.knowledge.ParentDocument;
import com.linkedin.knowledge.RelatedAssetArray;
import com.linkedin.knowledge.RelatedDocumentArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DocumentInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.knowledge/**Information about a document*/@Aspect.name=\"documentInfo\"record DocumentInfo includes{namespace com.linkedin.common/**Misc. properties about an entity.*/record CustomProperties{/**Custom property bag.*/@Searchable.`/*`={\"fieldType\":\"TEXT\",\"queryByDefault\":true}customProperties:map[string,string]={}}}{/**Optional title for the document. */@Searchable={}title:optional string/**Information about the external source of this document. \nOnly populated for third-party documents ingested from external systems.*/source:optional/**Information about the source of a document, especially for externally sourced documents.\nThis record is embedded within DocumentInfo to track whether a document is first-party \n(created in DataHub) or third-party (ingested from external sources like Slack, Notion, etc.)*/record DocumentSource{/**The type of the source (e.g., \"Confluence\", \"Notion\", \"Google Docs\", \"SharePoint\", \"Slack\")*/@Searchable.queryByDefault=false,sourceType:enum DocumentSourceType{/**Created via the DataHub UI or API*/NATIVE/**External - The document was ingested from an external source. */EXTERNAL}/**URL to the external source where this document originated*/@Searchable.queryByDefault=false,externalUrl:optional string/**Unique identifier in the external system. Searchable in case we need to find ingested docs via filtering.*/@Searchable.queryByDefault=false,externalId:optional string}/**Visibility status of the document (published, unpublished.)*/status:/**Visibility status information for a document*/record DocumentStatus{/**The current visibility state of the document*/@Searchable.queryByDefault=false,state:/**The state of a document*/enum DocumentState{/**Document is published and visible to users*/PUBLISHED/**Document is not published publically. */UNPUBLISHED}}/**Content of the document*/contents:/**The contents of a document*/record DocumentContents{/**The text contents of the document.\nThis needs to be added to semantic search! */@Searchable.fieldType=\"TEXT\"text:string}/**The time and actor who created the document*/@Searchable={\"/actor\":{\"fieldName\":\"creator\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"createdAt\",\"fieldType\":\"DATETIME\"}}created:{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}/**The time and actor who last modified the document (any field)*/@Searchable={\"/actor\":{\"fieldName\":\"lastModifiedBy\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"lastModifiedAt\",\"fieldType\":\"DATETIME\"}}lastModified:com.linkedin.common.AuditStamp/**Assets referenced by or related to this document. */relatedAssets:optional array[/**A data asset referenced by a document.*/record RelatedAsset{/**The asset referenced by or related to the document. */@Relationship={\"entityTypes\":[\"container\",\"dataset\",\"dataJob\",\"dataFlow\",\"dashboard\",\"chart\",\"application\",\"dataPlatform\",\"mlModel\",\"mlModelGroup\",\"mlPrimaryKey\",\"mlFeatureTable\",\"corpuser\",\"corpGroup\",\"dataProduct\",\"domain\",\"glossaryTerm\",\"glossaryNode\",\"tag\",\"structuredProperty\"],\"name\":\"RelatedAsset\"}@Searchable.fieldName=\"relatedAssets\"asset:com.linkedin.common.Urn}]/**Documents referenced by or related to this document. */relatedDocuments:optional array[/**An document referenced by or related to another document\nNote that this does NOT include child documents. */record RelatedDocument{/**The document referenced by or related to the document. */@Relationship={\"entityTypes\":[\"document\"],\"name\":\"RelatedDocument\"}@Searchable.fieldName=\"relatedDocuments\"document:com.linkedin.common.Urn}]/**Parent article for this asset. */parentDocument:optional/**The parent document of the document. */record ParentDocument{/**The hierarchical parent document for this document. */@Relationship={\"entityTypes\":[\"document\"],\"name\":\"IsChildOf\"}@Searchable={\"fieldName\":\"parentDocument\",\"fieldType\":\"URN\"}document:com.linkedin.common.Urn}/**If this document is a draft, the document it is a draft of.\nWhen set, this document should be hidden from normal knowledge base browsing and search.\nOnly the published document (draftOf target) should be visible to end users.*/draftOf:optional/**Indicates this document is a draft of another document.\nUsed to separate draft/versioning relationships from hierarchical parent/child relationships.*/record DraftOf{/**The document that this document is a draft of.\nWhen set, this document is a draft/proposed version of the referenced document.\nDraft documents should have UNPUBLISHED status and not appear in normal knowledge base browsing.*/@Relationship={\"entityTypes\":[\"document\"],\"name\":\"IsDraftOf\"}@Searchable={\"fieldName\":\"draftOf\",\"fieldType\":\"URN\",\"queryByDefault\":false}document:com.linkedin.common.Urn}}", SchemaFormatType.PDL);
    private StringMap _customPropertiesField = null;
    private String _titleField = null;
    private DocumentSource _sourceField = null;
    private DocumentStatus _statusField = null;
    private DocumentContents _contentsField = null;
    private AuditStamp _createdField = null;
    private AuditStamp _lastModifiedField = null;
    private RelatedAssetArray _relatedAssetsField = null;
    private RelatedDocumentArray _relatedDocumentsField = null;
    private ParentDocument _parentDocumentField = null;
    private DraftOf _draftOfField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_CustomProperties = SCHEMA.getField("customProperties");
    private static final StringMap DEFAULT_CustomProperties;
    private static final RecordDataSchema.Field FIELD_Title;
    private static final RecordDataSchema.Field FIELD_Source;
    private static final RecordDataSchema.Field FIELD_Status;
    private static final RecordDataSchema.Field FIELD_Contents;
    private static final RecordDataSchema.Field FIELD_Created;
    private static final RecordDataSchema.Field FIELD_LastModified;
    private static final RecordDataSchema.Field FIELD_RelatedAssets;
    private static final RecordDataSchema.Field FIELD_RelatedDocuments;
    private static final RecordDataSchema.Field FIELD_ParentDocument;
    private static final RecordDataSchema.Field FIELD_DraftOf;

    public DocumentInfo() {
        super(new DataMap(15, 0.75f), SCHEMA, 14);
        this.addChangeListener(this.__changeListener);
    }

    public DocumentInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasCustomProperties() {
        if (this._customPropertiesField != null) {
            return true;
        }
        return this._map.containsKey("customProperties");
    }

    public void removeCustomProperties() {
        this._map.remove("customProperties");
    }

    @Nullable
    public StringMap getCustomProperties(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getCustomProperties();
            }
            case NULL: {
                if (this._customPropertiesField != null) {
                    return this._customPropertiesField;
                }
                Object __rawValue = this._map.get("customProperties");
                this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._customPropertiesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringMap getCustomProperties() {
        if (this._customPropertiesField != null) {
            return this._customPropertiesField;
        }
        Object __rawValue = this._map.get("customProperties");
        if (__rawValue == null) {
            return DEFAULT_CustomProperties;
        }
        this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._customPropertiesField;
    }

    public DocumentInfo setCustomProperties(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCustomProperties(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field customProperties of com.linkedin.knowledge.DocumentInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCustomProperties();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
            }
        }
        return this;
    }

    public DocumentInfo setCustomProperties(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field customProperties of com.linkedin.knowledge.DocumentInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
        this._customPropertiesField = value;
        return this;
    }

    public boolean hasTitle() {
        if (this._titleField != null) {
            return true;
        }
        return this._map.containsKey("title");
    }

    public void removeTitle() {
        this._map.remove("title");
    }

    @Nullable
    public String getTitle(GetMode mode) {
        return this.getTitle();
    }

    @Nullable
    public String getTitle() {
        if (this._titleField != null) {
            return this._titleField;
        }
        Object __rawValue = this._map.get("title");
        this._titleField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._titleField;
    }

    public DocumentInfo setTitle(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTitle(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTitle();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "title", value);
                this._titleField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "title", value);
                this._titleField = value;
            }
        }
        return this;
    }

    public DocumentInfo setTitle(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field title of com.linkedin.knowledge.DocumentInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "title", value);
        this._titleField = value;
        return this;
    }

    public boolean hasSource() {
        if (this._sourceField != null) {
            return true;
        }
        return this._map.containsKey("source");
    }

    public void removeSource() {
        this._map.remove("source");
    }

    @Nullable
    public DocumentSource getSource(GetMode mode) {
        return this.getSource();
    }

    @Nullable
    public DocumentSource getSource() {
        if (this._sourceField != null) {
            return this._sourceField;
        }
        Object __rawValue = this._map.get("source");
        this._sourceField = __rawValue == null ? null : new DocumentSource(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._sourceField;
    }

    public DocumentInfo setSource(@Nullable DocumentSource value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSource(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSource();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "source", value.data());
                this._sourceField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "source", value.data());
                this._sourceField = value;
            }
        }
        return this;
    }

    public DocumentInfo setSource(@Nonnull DocumentSource value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field source of com.linkedin.knowledge.DocumentInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "source", value.data());
        this._sourceField = value;
        return this;
    }

    public boolean hasStatus() {
        if (this._statusField != null) {
            return true;
        }
        return this._map.containsKey("status");
    }

    public void removeStatus() {
        this._map.remove("status");
    }

    @Nullable
    public DocumentStatus getStatus(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getStatus();
            }
            case DEFAULT: 
            case NULL: {
                if (this._statusField != null) {
                    return this._statusField;
                }
                Object __rawValue = this._map.get("status");
                this._statusField = __rawValue == null ? null : new DocumentStatus(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._statusField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public DocumentStatus getStatus() {
        if (this._statusField != null) {
            return this._statusField;
        }
        Object __rawValue = this._map.get("status");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("status");
        }
        this._statusField = __rawValue == null ? null : new DocumentStatus(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._statusField;
    }

    public DocumentInfo setStatus(@Nullable DocumentStatus value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setStatus(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field status of com.linkedin.knowledge.DocumentInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "status", value.data());
                this._statusField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeStatus();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "status", value.data());
                this._statusField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "status", value.data());
                this._statusField = value;
            }
        }
        return this;
    }

    public DocumentInfo setStatus(@Nonnull DocumentStatus value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field status of com.linkedin.knowledge.DocumentInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "status", value.data());
        this._statusField = value;
        return this;
    }

    public boolean hasContents() {
        if (this._contentsField != null) {
            return true;
        }
        return this._map.containsKey("contents");
    }

    public void removeContents() {
        this._map.remove("contents");
    }

    @Nullable
    public DocumentContents getContents(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getContents();
            }
            case DEFAULT: 
            case NULL: {
                if (this._contentsField != null) {
                    return this._contentsField;
                }
                Object __rawValue = this._map.get("contents");
                this._contentsField = __rawValue == null ? null : new DocumentContents(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._contentsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public DocumentContents getContents() {
        if (this._contentsField != null) {
            return this._contentsField;
        }
        Object __rawValue = this._map.get("contents");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("contents");
        }
        this._contentsField = __rawValue == null ? null : new DocumentContents(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._contentsField;
    }

    public DocumentInfo setContents(@Nullable DocumentContents value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setContents(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field contents of com.linkedin.knowledge.DocumentInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "contents", value.data());
                this._contentsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeContents();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "contents", value.data());
                this._contentsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "contents", value.data());
                this._contentsField = value;
            }
        }
        return this;
    }

    public DocumentInfo setContents(@Nonnull DocumentContents value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field contents of com.linkedin.knowledge.DocumentInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "contents", value.data());
        this._contentsField = value;
        return this;
    }

    public boolean hasCreated() {
        if (this._createdField != null) {
            return true;
        }
        return this._map.containsKey("created");
    }

    public void removeCreated() {
        this._map.remove("created");
    }

    @Nullable
    public AuditStamp getCreated(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getCreated();
            }
            case DEFAULT: 
            case NULL: {
                if (this._createdField != null) {
                    return this._createdField;
                }
                Object __rawValue = this._map.get("created");
                this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._createdField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AuditStamp getCreated() {
        if (this._createdField != null) {
            return this._createdField;
        }
        Object __rawValue = this._map.get("created");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("created");
        }
        this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._createdField;
    }

    public DocumentInfo setCreated(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreated(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field created of com.linkedin.knowledge.DocumentInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreated();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
            }
        }
        return this;
    }

    public DocumentInfo setCreated(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field created of com.linkedin.knowledge.DocumentInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "created", value.data());
        this._createdField = value;
        return this;
    }

    public boolean hasLastModified() {
        if (this._lastModifiedField != null) {
            return true;
        }
        return this._map.containsKey("lastModified");
    }

    public void removeLastModified() {
        this._map.remove("lastModified");
    }

    @Nullable
    public AuditStamp getLastModified(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getLastModified();
            }
            case DEFAULT: 
            case NULL: {
                if (this._lastModifiedField != null) {
                    return this._lastModifiedField;
                }
                Object __rawValue = this._map.get("lastModified");
                this._lastModifiedField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._lastModifiedField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AuditStamp getLastModified() {
        if (this._lastModifiedField != null) {
            return this._lastModifiedField;
        }
        Object __rawValue = this._map.get("lastModified");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("lastModified");
        }
        this._lastModifiedField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._lastModifiedField;
    }

    public DocumentInfo setLastModified(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastModified(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field lastModified of com.linkedin.knowledge.DocumentInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastModified();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
            }
        }
        return this;
    }

    public DocumentInfo setLastModified(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastModified of com.linkedin.knowledge.DocumentInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
        this._lastModifiedField = value;
        return this;
    }

    public boolean hasRelatedAssets() {
        if (this._relatedAssetsField != null) {
            return true;
        }
        return this._map.containsKey("relatedAssets");
    }

    public void removeRelatedAssets() {
        this._map.remove("relatedAssets");
    }

    @Nullable
    public RelatedAssetArray getRelatedAssets(GetMode mode) {
        return this.getRelatedAssets();
    }

    @Nullable
    public RelatedAssetArray getRelatedAssets() {
        if (this._relatedAssetsField != null) {
            return this._relatedAssetsField;
        }
        Object __rawValue = this._map.get("relatedAssets");
        this._relatedAssetsField = __rawValue == null ? null : new RelatedAssetArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._relatedAssetsField;
    }

    public DocumentInfo setRelatedAssets(@Nullable RelatedAssetArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRelatedAssets(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRelatedAssets();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "relatedAssets", value.data());
                this._relatedAssetsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "relatedAssets", value.data());
                this._relatedAssetsField = value;
            }
        }
        return this;
    }

    public DocumentInfo setRelatedAssets(@Nonnull RelatedAssetArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field relatedAssets of com.linkedin.knowledge.DocumentInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "relatedAssets", value.data());
        this._relatedAssetsField = value;
        return this;
    }

    public boolean hasRelatedDocuments() {
        if (this._relatedDocumentsField != null) {
            return true;
        }
        return this._map.containsKey("relatedDocuments");
    }

    public void removeRelatedDocuments() {
        this._map.remove("relatedDocuments");
    }

    @Nullable
    public RelatedDocumentArray getRelatedDocuments(GetMode mode) {
        return this.getRelatedDocuments();
    }

    @Nullable
    public RelatedDocumentArray getRelatedDocuments() {
        if (this._relatedDocumentsField != null) {
            return this._relatedDocumentsField;
        }
        Object __rawValue = this._map.get("relatedDocuments");
        this._relatedDocumentsField = __rawValue == null ? null : new RelatedDocumentArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._relatedDocumentsField;
    }

    public DocumentInfo setRelatedDocuments(@Nullable RelatedDocumentArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRelatedDocuments(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRelatedDocuments();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "relatedDocuments", value.data());
                this._relatedDocumentsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "relatedDocuments", value.data());
                this._relatedDocumentsField = value;
            }
        }
        return this;
    }

    public DocumentInfo setRelatedDocuments(@Nonnull RelatedDocumentArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field relatedDocuments of com.linkedin.knowledge.DocumentInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "relatedDocuments", value.data());
        this._relatedDocumentsField = value;
        return this;
    }

    public boolean hasParentDocument() {
        if (this._parentDocumentField != null) {
            return true;
        }
        return this._map.containsKey("parentDocument");
    }

    public void removeParentDocument() {
        this._map.remove("parentDocument");
    }

    @Nullable
    public ParentDocument getParentDocument(GetMode mode) {
        return this.getParentDocument();
    }

    @Nullable
    public ParentDocument getParentDocument() {
        if (this._parentDocumentField != null) {
            return this._parentDocumentField;
        }
        Object __rawValue = this._map.get("parentDocument");
        this._parentDocumentField = __rawValue == null ? null : new ParentDocument(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._parentDocumentField;
    }

    public DocumentInfo setParentDocument(@Nullable ParentDocument value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setParentDocument(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeParentDocument();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "parentDocument", value.data());
                this._parentDocumentField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "parentDocument", value.data());
                this._parentDocumentField = value;
            }
        }
        return this;
    }

    public DocumentInfo setParentDocument(@Nonnull ParentDocument value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field parentDocument of com.linkedin.knowledge.DocumentInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "parentDocument", value.data());
        this._parentDocumentField = value;
        return this;
    }

    public boolean hasDraftOf() {
        if (this._draftOfField != null) {
            return true;
        }
        return this._map.containsKey("draftOf");
    }

    public void removeDraftOf() {
        this._map.remove("draftOf");
    }

    @Nullable
    public DraftOf getDraftOf(GetMode mode) {
        return this.getDraftOf();
    }

    @Nullable
    public DraftOf getDraftOf() {
        if (this._draftOfField != null) {
            return this._draftOfField;
        }
        Object __rawValue = this._map.get("draftOf");
        this._draftOfField = __rawValue == null ? null : new DraftOf(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._draftOfField;
    }

    public DocumentInfo setDraftOf(@Nullable DraftOf value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDraftOf(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDraftOf();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "draftOf", value.data());
                this._draftOfField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "draftOf", value.data());
                this._draftOfField = value;
            }
        }
        return this;
    }

    public DocumentInfo setDraftOf(@Nonnull DraftOf value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field draftOf of com.linkedin.knowledge.DocumentInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "draftOf", value.data());
        this._draftOfField = value;
        return this;
    }

    @Override
    public DocumentInfo clone() throws CloneNotSupportedException {
        DocumentInfo __clone = (DocumentInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DocumentInfo copy() throws CloneNotSupportedException {
        DocumentInfo __copy = (DocumentInfo)super.copy();
        __copy._customPropertiesField = null;
        __copy._contentsField = null;
        __copy._relatedAssetsField = null;
        __copy._createdField = null;
        __copy._draftOfField = null;
        __copy._relatedDocumentsField = null;
        __copy._sourceField = null;
        __copy._lastModifiedField = null;
        __copy._titleField = null;
        __copy._parentDocumentField = null;
        __copy._statusField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_Title = SCHEMA.getField("title");
        FIELD_Source = SCHEMA.getField("source");
        FIELD_Status = SCHEMA.getField("status");
        FIELD_Contents = SCHEMA.getField("contents");
        FIELD_Created = SCHEMA.getField("created");
        FIELD_LastModified = SCHEMA.getField("lastModified");
        FIELD_RelatedAssets = SCHEMA.getField("relatedAssets");
        FIELD_RelatedDocuments = SCHEMA.getField("relatedDocuments");
        FIELD_ParentDocument = SCHEMA.getField("parentDocument");
        FIELD_DraftOf = SCHEMA.getField("draftOf");
        DEFAULT_CustomProperties = FIELD_CustomProperties.getDefault() == null ? null : new StringMap(DataTemplateUtil.castOrThrow(FIELD_CustomProperties.getDefault(), DataMap.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DocumentInfo __objectRef;

        private ChangeListener(DocumentInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "customProperties": {
                    this.__objectRef._customPropertiesField = null;
                    break;
                }
                case "contents": {
                    this.__objectRef._contentsField = null;
                    break;
                }
                case "relatedAssets": {
                    this.__objectRef._relatedAssetsField = null;
                    break;
                }
                case "created": {
                    this.__objectRef._createdField = null;
                    break;
                }
                case "draftOf": {
                    this.__objectRef._draftOfField = null;
                    break;
                }
                case "relatedDocuments": {
                    this.__objectRef._relatedDocumentsField = null;
                    break;
                }
                case "source": {
                    this.__objectRef._sourceField = null;
                    break;
                }
                case "lastModified": {
                    this.__objectRef._lastModifiedField = null;
                    break;
                }
                case "title": {
                    this.__objectRef._titleField = null;
                    break;
                }
                case "parentDocument": {
                    this.__objectRef._parentDocumentField = null;
                    break;
                }
                case "status": {
                    this.__objectRef._statusField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec customProperties() {
            return new PathSpec(this.getPathComponents(), "customProperties");
        }

        public PathSpec title() {
            return new PathSpec(this.getPathComponents(), "title");
        }

        public DocumentSource.Fields source() {
            return new DocumentSource.Fields(this.getPathComponents(), "source");
        }

        public DocumentStatus.Fields status() {
            return new DocumentStatus.Fields(this.getPathComponents(), "status");
        }

        public DocumentContents.Fields contents() {
            return new DocumentContents.Fields(this.getPathComponents(), "contents");
        }

        public AuditStamp.Fields created() {
            return new AuditStamp.Fields(this.getPathComponents(), "created");
        }

        public AuditStamp.Fields lastModified() {
            return new AuditStamp.Fields(this.getPathComponents(), "lastModified");
        }

        public RelatedAssetArray.Fields relatedAssets() {
            return new RelatedAssetArray.Fields(this.getPathComponents(), "relatedAssets");
        }

        public PathSpec relatedAssets(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "relatedAssets");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public RelatedDocumentArray.Fields relatedDocuments() {
            return new RelatedDocumentArray.Fields(this.getPathComponents(), "relatedDocuments");
        }

        public PathSpec relatedDocuments(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "relatedDocuments");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public ParentDocument.Fields parentDocument() {
            return new ParentDocument.Fields(this.getPathComponents(), "parentDocument");
        }

        public DraftOf.Fields draftOf() {
            return new DraftOf.Fields(this.getPathComponents(), "draftOf");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private DocumentSource.ProjectionMask _sourceMask;
        private DocumentStatus.ProjectionMask _statusMask;
        private DocumentContents.ProjectionMask _contentsMask;
        private AuditStamp.ProjectionMask _createdMask;
        private AuditStamp.ProjectionMask _lastModifiedMask;
        private RelatedAssetArray.ProjectionMask _relatedAssetsMask;
        private RelatedDocumentArray.ProjectionMask _relatedDocumentsMask;
        private ParentDocument.ProjectionMask _parentDocumentMask;
        private DraftOf.ProjectionMask _draftOfMask;

        ProjectionMask() {
            super(15);
        }

        public ProjectionMask withCustomProperties() {
            this.getDataMap().put("customProperties", 1);
            return this;
        }

        public ProjectionMask withTitle() {
            this.getDataMap().put("title", 1);
            return this;
        }

        public ProjectionMask withSource(Function<DocumentSource.ProjectionMask, DocumentSource.ProjectionMask> nestedMask) {
            this._sourceMask = nestedMask.apply(this._sourceMask == null ? DocumentSource.createMask() : this._sourceMask);
            this.getDataMap().put("source", this._sourceMask.getDataMap());
            return this;
        }

        public ProjectionMask withSource() {
            this._sourceMask = null;
            this.getDataMap().put("source", 1);
            return this;
        }

        public ProjectionMask withStatus(Function<DocumentStatus.ProjectionMask, DocumentStatus.ProjectionMask> nestedMask) {
            this._statusMask = nestedMask.apply(this._statusMask == null ? DocumentStatus.createMask() : this._statusMask);
            this.getDataMap().put("status", this._statusMask.getDataMap());
            return this;
        }

        public ProjectionMask withStatus() {
            this._statusMask = null;
            this.getDataMap().put("status", 1);
            return this;
        }

        public ProjectionMask withContents(Function<DocumentContents.ProjectionMask, DocumentContents.ProjectionMask> nestedMask) {
            this._contentsMask = nestedMask.apply(this._contentsMask == null ? DocumentContents.createMask() : this._contentsMask);
            this.getDataMap().put("contents", this._contentsMask.getDataMap());
            return this;
        }

        public ProjectionMask withContents() {
            this._contentsMask = null;
            this.getDataMap().put("contents", 1);
            return this;
        }

        public ProjectionMask withCreated(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._createdMask = nestedMask.apply(this._createdMask == null ? AuditStamp.createMask() : this._createdMask);
            this.getDataMap().put("created", this._createdMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated(MaskMap nestedMask) {
            this.getDataMap().put("created", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated() {
            this._createdMask = null;
            this.getDataMap().put("created", 1);
            return this;
        }

        public ProjectionMask withLastModified(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._lastModifiedMask = nestedMask.apply(this._lastModifiedMask == null ? AuditStamp.createMask() : this._lastModifiedMask);
            this.getDataMap().put("lastModified", this._lastModifiedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified(MaskMap nestedMask) {
            this.getDataMap().put("lastModified", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified() {
            this._lastModifiedMask = null;
            this.getDataMap().put("lastModified", 1);
            return this;
        }

        public ProjectionMask withRelatedAssets(Function<RelatedAssetArray.ProjectionMask, RelatedAssetArray.ProjectionMask> nestedMask) {
            this._relatedAssetsMask = nestedMask.apply(this._relatedAssetsMask == null ? RelatedAssetArray.createMask() : this._relatedAssetsMask);
            this.getDataMap().put("relatedAssets", this._relatedAssetsMask.getDataMap());
            return this;
        }

        public ProjectionMask withRelatedAssets() {
            this._relatedAssetsMask = null;
            this.getDataMap().put("relatedAssets", 1);
            return this;
        }

        public ProjectionMask withRelatedAssets(Function<RelatedAssetArray.ProjectionMask, RelatedAssetArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._relatedAssetsMask = nestedMask.apply(this._relatedAssetsMask == null ? RelatedAssetArray.createMask() : this._relatedAssetsMask);
            this.getDataMap().put("relatedAssets", this._relatedAssetsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("relatedAssets").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("relatedAssets").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withRelatedAssets(Integer start, Integer count) {
            this._relatedAssetsMask = null;
            this.getDataMap().put("relatedAssets", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("relatedAssets").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("relatedAssets").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withRelatedDocuments(Function<RelatedDocumentArray.ProjectionMask, RelatedDocumentArray.ProjectionMask> nestedMask) {
            this._relatedDocumentsMask = nestedMask.apply(this._relatedDocumentsMask == null ? RelatedDocumentArray.createMask() : this._relatedDocumentsMask);
            this.getDataMap().put("relatedDocuments", this._relatedDocumentsMask.getDataMap());
            return this;
        }

        public ProjectionMask withRelatedDocuments() {
            this._relatedDocumentsMask = null;
            this.getDataMap().put("relatedDocuments", 1);
            return this;
        }

        public ProjectionMask withRelatedDocuments(Function<RelatedDocumentArray.ProjectionMask, RelatedDocumentArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._relatedDocumentsMask = nestedMask.apply(this._relatedDocumentsMask == null ? RelatedDocumentArray.createMask() : this._relatedDocumentsMask);
            this.getDataMap().put("relatedDocuments", this._relatedDocumentsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("relatedDocuments").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("relatedDocuments").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withRelatedDocuments(Integer start, Integer count) {
            this._relatedDocumentsMask = null;
            this.getDataMap().put("relatedDocuments", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("relatedDocuments").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("relatedDocuments").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withParentDocument(Function<ParentDocument.ProjectionMask, ParentDocument.ProjectionMask> nestedMask) {
            this._parentDocumentMask = nestedMask.apply(this._parentDocumentMask == null ? ParentDocument.createMask() : this._parentDocumentMask);
            this.getDataMap().put("parentDocument", this._parentDocumentMask.getDataMap());
            return this;
        }

        public ProjectionMask withParentDocument() {
            this._parentDocumentMask = null;
            this.getDataMap().put("parentDocument", 1);
            return this;
        }

        public ProjectionMask withDraftOf(Function<DraftOf.ProjectionMask, DraftOf.ProjectionMask> nestedMask) {
            this._draftOfMask = nestedMask.apply(this._draftOfMask == null ? DraftOf.createMask() : this._draftOfMask);
            this.getDataMap().put("draftOf", this._draftOfMask.getDataMap());
            return this;
        }

        public ProjectionMask withDraftOf() {
            this._draftOfMask = null;
            this.getDataMap().put("draftOf", 1);
            return this;
        }
    }
}

